/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import com.ibm.icu.util.GregorianCalendar;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.expression.InvalidExpression;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ScriptEvalTest
extends TestCase {
    private Scriptable scope;
    private ScriptContext scontext;

    protected void setUp() throws Exception {
        this.scontext = new ScriptContext();
        this.scope = Context.enter().initStandardObjects();
    }

    protected void tearDown() throws Exception {
        Context.exit();
        this.scontext.close();
    }

    public void testJSRE() throws Exception {
        String test = "/^Mini/.test(\"Minia\")";
        Object result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)test, (String)"", (int)0);
        this.assertResult(result, true);
    }

    public void testDataType() throws Exception {
        String script = "1 + 2 ";
        Object result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertTrue((boolean)(result instanceof Integer));
        ScriptEvalTest.assertEquals((Object)result, (Object)new Integer(3));
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertEquals((Object)result, (Object)new Integer(3));
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertEquals((Object)result, (Object)new Integer(3));
        script = "new Number(123)";
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertTrue((boolean)(result instanceof Double));
        ScriptEvalTest.assertEquals((Object)result, (Object)new Double(123.0));
        script = "new Date(2005, 1, 1)";
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertTrue((boolean)(result instanceof Date));
        script = "true";
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertTrue((boolean)(result instanceof Boolean));
        ScriptEvalTest.assertEquals((Object)result, (Object)new Boolean(true));
        script = "new Boolean(true)";
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertTrue((boolean)(result instanceof Boolean));
        ScriptEvalTest.assertEquals((Object)result, (Object)new Boolean(true));
        script = "\"abc\"";
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertTrue((boolean)(result instanceof String));
        ScriptEvalTest.assertEquals((Object)result, (Object)"abc");
        script = "new String(\"abc\")";
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertTrue((boolean)(result instanceof String));
        ScriptEvalTest.assertEquals((Object)result, (Object)"abc");
        script = "java.lang.Long.decode(\"24\")";
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertTrue((boolean)(result instanceof Long));
        ScriptEvalTest.assertEquals((Object)result, (Object)new Long("24"));
        script = "1";
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        result = ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)script, (String)"", (int)0);
        ScriptEvalTest.assertEquals((Object)result, (Object)new Double(1.0));
    }

    public void testErrHandling() throws Exception {
        this.handleErrorTest("var x=", true);
        this.handleErrorTest("var x=", true);
        this.handleErrorTest("var x=", true);
        this.handleErrorTest("var x=\"missing end quote", true);
        this.handleErrorTest("x.y", false);
        this.handleErrorTest("x.y", false);
        this.handleErrorTest("x.y", false);
        this.handleErrorTest("x.y", false);
        this.handleErrorTest("x.y", false);
        this.handleErrorTest("x.y", false);
        this.handleErrorTest("x.y", false);
    }

    private void handleErrorTest(String errScript, boolean compileError) throws Exception {
        String source = "TestSource" + new Random().nextInt(1000);
        try {
            ScriptEvalUtil.evaluateJSAsExpr((ScriptContext)this.scontext, (Scriptable)this.scope, (String)errScript, (String)source, (int)365);
            ScriptEvalTest.fail((String)"Exception expected");
        }
        catch (Exception e) {
            e.getLocalizedMessage();
        }
        ExpressionCompiler c = new ExpressionCompiler();
        try {
            CompiledExpression exp = c.compile(errScript, null, this.scontext);
            if (compileError) {
                ScriptEvalTest.assertTrue((boolean)(exp instanceof InvalidExpression));
            } else {
                exp.evaluate(this.scontext, this.scope);
                ScriptEvalTest.fail((String)"Exception expected in evaluate");
            }
        }
        catch (DataException dataException) {}
    }

    public void test_BOTTOM_PERCENT() {
        try {
            ScriptEvalUtil.evalConditionalExpr((Object)"aaaaab", (int)17, (Object)"a*b", null);
            ScriptEvalTest.fail((String)"Exception expected in compare");
        }
        catch (DataException dataException) {}
    }

    public void test_TOP_PERCENT() {
        try {
            ScriptEvalUtil.evalConditionalExpr((Object)"aaaaab", (int)16, (Object)"a*b", null);
            ScriptEvalTest.fail((String)"Exception expected in compare");
        }
        catch (DataException dataException) {}
    }

    public void test_BOTTOM_N() {
        try {
            ScriptEvalUtil.evalConditionalExpr((Object)"aaaaab", (int)15, (Object)"a*b", null);
            ScriptEvalTest.fail((String)"Exception expected in compare");
        }
        catch (DataException dataException) {}
    }

    public void test_TOP_N() {
        try {
            ScriptEvalUtil.evalConditionalExpr((Object)"aaaaab", (int)14, (Object)"a*b", null);
            ScriptEvalTest.fail((String)"Exception expected in compare");
        }
        catch (DataException dataException) {}
    }

    public void test_LIKE() throws DataException {
        Object[] objectArray = new Object[19];
        objectArray[0] = new Object[]{"anything", "", Boolean.FALSE};
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "anything";
        objectArray2[2] = Boolean.FALSE;
        objectArray[1] = objectArray2;
        Object[] objectArray3 = new Object[3];
        objectArray3[1] = "something";
        objectArray3[2] = Boolean.FALSE;
        objectArray[2] = objectArray3;
        Object[] objectArray4 = new Object[3];
        objectArray4[1] = "";
        objectArray4[2] = Boolean.TRUE;
        objectArray[3] = objectArray4;
        Object[] objectArray5 = new Object[3];
        objectArray5[0] = "";
        objectArray5[2] = Boolean.TRUE;
        objectArray[4] = objectArray5;
        objectArray[5] = new Object[]{"", "", Boolean.TRUE};
        objectArray[6] = new Object[]{"aaab", "a%b", Boolean.TRUE};
        objectArray[7] = new Object[]{"aaab", "a*b", Boolean.FALSE};
        objectArray[8] = new Object[]{"aaab", "a.*b", Boolean.FALSE};
        objectArray[9] = new Object[]{"aaab", "a\\%b", Boolean.FALSE};
        objectArray[10] = new Object[]{"aaab", "aa_b", Boolean.TRUE};
        objectArray[11] = new Object[]{"aaab", "aa\\_b", Boolean.FALSE};
        objectArray[12] = new Object[]{"aaab", "a_b", Boolean.FALSE};
        objectArray[13] = new Object[]{"aaab", "aa.b", Boolean.FALSE};
        objectArray[14] = new Object[]{"a%b", "a\\%b", Boolean.TRUE};
        objectArray[15] = new Object[]{"a%b", "a\\\\%b", Boolean.FALSE};
        objectArray[16] = new Object[]{"aaab", "aaab\\", Boolean.FALSE};
        objectArray[17] = new Object[]{"aaab", "aa[a]b", Boolean.FALSE};
        objectArray[18] = new Object[]{"aaab", "aa[[a]b", Boolean.FALSE};
        Object[] cases = objectArray;
        int i = 0;
        while (i < cases.length) {
            Object[] c = (Object[])cases[i];
            String str = (String)c[0];
            String pattern = (String)c[1];
            Boolean expected = (Boolean)c[2];
            Object result = ScriptEvalUtil.evalConditionalExpr((Object)str, (int)13, (Object)pattern, null);
            ScriptEvalTest.assertEquals((Object)result, (Object)expected);
            ++i;
        }
    }

    public void test_MATCH() throws DataException {
        Object[] objectArray = new Object[22];
        objectArray[0] = new Object[]{"anything", "", Boolean.TRUE};
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "anything";
        objectArray2[2] = Boolean.TRUE;
        objectArray[1] = objectArray2;
        Object[] objectArray3 = new Object[3];
        objectArray3[1] = "something";
        objectArray3[2] = Boolean.FALSE;
        objectArray[2] = objectArray3;
        Object[] objectArray4 = new Object[3];
        objectArray4[1] = "";
        objectArray4[2] = Boolean.TRUE;
        objectArray[3] = objectArray4;
        Object[] objectArray5 = new Object[3];
        objectArray5[0] = "";
        objectArray5[2] = Boolean.TRUE;
        objectArray[4] = objectArray5;
        objectArray[5] = new Object[]{"", "", Boolean.TRUE};
        objectArray[6] = new Object[]{"aaab", "a", Boolean.TRUE};
        objectArray[7] = new Object[]{"bbbb", "a", Boolean.FALSE};
        objectArray[8] = new Object[]{"bbbb", "ab", Boolean.FALSE};
        objectArray[9] = new Object[]{"aaab", "^a.*b$", Boolean.TRUE};
        objectArray[10] = new Object[]{"aaab", "a.*b", Boolean.TRUE};
        objectArray[11] = new Object[]{"aaab", "^ab", Boolean.FALSE};
        objectArray[12] = new Object[]{"aaab", "aa_b", Boolean.FALSE};
        objectArray[13] = new Object[]{"aaab", "A", Boolean.FALSE};
        objectArray[14] = new Object[]{"aaab", "/a.*b/", Boolean.TRUE};
        objectArray[15] = new Object[]{"aaab", "/a.*b/mig", Boolean.TRUE};
        objectArray[16] = new Object[]{"aaab", "/a.*/b/i", Boolean.FALSE};
        objectArray[17] = new Object[]{"aaab", "/A/i", Boolean.TRUE};
        objectArray[18] = new Object[]{"aaab", "//m", Boolean.TRUE};
        objectArray[19] = new Object[]{"aaab", "/\\w*B/i", Boolean.TRUE};
        Object[] objectArray6 = new Object[3];
        objectArray6[0] = "aaab";
        objectArray6[1] = "[a";
        objectArray[20] = objectArray6;
        Object[] objectArray7 = new Object[3];
        objectArray7[0] = "aaab";
        objectArray7[1] = "/a/p";
        objectArray[21] = objectArray7;
        Object[] cases = objectArray;
        int i = 0;
        while (i < cases.length) {
            Object[] c = (Object[])cases[i];
            String str = (String)c[0];
            String pattern = (String)c[1];
            Boolean expected = (Boolean)c[2];
            try {
                Object result = ScriptEvalUtil.evalConditionalExpr((Object)str, (int)19, (Object)pattern, null);
                ScriptEvalTest.assertEquals((Object)result, (Object)expected);
            }
            catch (DataException dataException) {
                ScriptEvalTest.assertNull((Object)expected);
            }
            ++i;
        }
    }

    public void test_NOT_LIKE() throws DataException {
        Object[] objectArray = new Object[19];
        objectArray[0] = new Object[]{"anything", "", Boolean.FALSE};
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "anything";
        objectArray2[2] = Boolean.FALSE;
        objectArray[1] = objectArray2;
        Object[] objectArray3 = new Object[3];
        objectArray3[1] = "something";
        objectArray3[2] = Boolean.FALSE;
        objectArray[2] = objectArray3;
        Object[] objectArray4 = new Object[3];
        objectArray4[1] = "";
        objectArray4[2] = Boolean.TRUE;
        objectArray[3] = objectArray4;
        Object[] objectArray5 = new Object[3];
        objectArray5[0] = "";
        objectArray5[2] = Boolean.TRUE;
        objectArray[4] = objectArray5;
        objectArray[5] = new Object[]{"", "", Boolean.TRUE};
        objectArray[6] = new Object[]{"aaab", "a%b", Boolean.TRUE};
        objectArray[7] = new Object[]{"aaab", "a*b", Boolean.FALSE};
        objectArray[8] = new Object[]{"aaab", "a.*b", Boolean.FALSE};
        objectArray[9] = new Object[]{"aaab", "a\\%b", Boolean.FALSE};
        objectArray[10] = new Object[]{"aaab", "aa_b", Boolean.TRUE};
        objectArray[11] = new Object[]{"aaab", "aa\\_b", Boolean.FALSE};
        objectArray[12] = new Object[]{"aaab", "a_b", Boolean.FALSE};
        objectArray[13] = new Object[]{"aaab", "aa.b", Boolean.FALSE};
        objectArray[14] = new Object[]{"a%b", "a\\%b", Boolean.TRUE};
        objectArray[15] = new Object[]{"a%b", "a\\\\%b", Boolean.FALSE};
        objectArray[16] = new Object[]{"aaab", "aaab\\", Boolean.FALSE};
        objectArray[17] = new Object[]{"aaab", "aa[a]b", Boolean.FALSE};
        objectArray[18] = new Object[]{"aaab", "aa[[a]b", Boolean.FALSE};
        Object[] cases = objectArray;
        int i = 0;
        while (i < cases.length) {
            Object[] c = (Object[])cases[i];
            String str = (String)c[0];
            String pattern = (String)c[1];
            Boolean expected = (Boolean)c[2];
            Object result = ScriptEvalUtil.evalConditionalExpr((Object)str, (int)20, (Object)pattern, null);
            ScriptEvalTest.assertEquals((Object)result, (Object)new Boolean(expected == false));
            ++i;
        }
    }

    public void test_NOT_MATCH() throws DataException {
        Object[] objectArray = new Object[22];
        objectArray[0] = new Object[]{"anything", "", Boolean.TRUE};
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "anything";
        objectArray2[2] = Boolean.TRUE;
        objectArray[1] = objectArray2;
        Object[] objectArray3 = new Object[3];
        objectArray3[1] = "something";
        objectArray3[2] = Boolean.FALSE;
        objectArray[2] = objectArray3;
        Object[] objectArray4 = new Object[3];
        objectArray4[1] = "";
        objectArray4[2] = Boolean.TRUE;
        objectArray[3] = objectArray4;
        Object[] objectArray5 = new Object[3];
        objectArray5[0] = "";
        objectArray5[2] = Boolean.TRUE;
        objectArray[4] = objectArray5;
        objectArray[5] = new Object[]{"", "", Boolean.TRUE};
        objectArray[6] = new Object[]{"aaab", "a", Boolean.TRUE};
        objectArray[7] = new Object[]{"bbbb", "a", Boolean.FALSE};
        objectArray[8] = new Object[]{"bbbb", "ab", Boolean.FALSE};
        objectArray[9] = new Object[]{"aaab", "^a.*b$", Boolean.TRUE};
        objectArray[10] = new Object[]{"aaab", "a.*b", Boolean.TRUE};
        objectArray[11] = new Object[]{"aaab", "^ab", Boolean.FALSE};
        objectArray[12] = new Object[]{"aaab", "aa_b", Boolean.FALSE};
        objectArray[13] = new Object[]{"aaab", "A", Boolean.FALSE};
        objectArray[14] = new Object[]{"aaab", "/a.*b/", Boolean.TRUE};
        objectArray[15] = new Object[]{"aaab", "/a.*b/mig", Boolean.TRUE};
        objectArray[16] = new Object[]{"aaab", "/a.*/b/i", Boolean.FALSE};
        objectArray[17] = new Object[]{"aaab", "/A/i", Boolean.TRUE};
        objectArray[18] = new Object[]{"aaab", "//m", Boolean.TRUE};
        objectArray[19] = new Object[]{"aaab", "/\\w*B/i", Boolean.TRUE};
        Object[] objectArray6 = new Object[3];
        objectArray6[0] = "aaab";
        objectArray6[1] = "[a";
        objectArray[20] = objectArray6;
        Object[] objectArray7 = new Object[3];
        objectArray7[0] = "aaab";
        objectArray7[1] = "/a/p";
        objectArray[21] = objectArray7;
        Object[] cases = objectArray;
        int i = 0;
        while (i < cases.length) {
            Object[] c = (Object[])cases[i];
            String str = (String)c[0];
            String pattern = (String)c[1];
            Boolean expected = (Boolean)c[2];
            try {
                Object result = ScriptEvalUtil.evalConditionalExpr((Object)str, (int)21, (Object)pattern, null);
                ScriptEvalTest.assertEquals((Object)result, (Object)new Boolean(expected == false));
            }
            catch (DataException dataException) {
                ScriptEvalTest.assertNull((Object)expected);
            }
            ++i;
        }
    }

    public void test_FALSE() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)"true", (int)12, null, null, null);
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Boolean(false), (int)12, null, null, null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)"Boolean(false)", (int)12, null, null, null);
        this.assertResult(result, false);
    }

    public void test_TRUE() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)"true", (int)11, null, null, null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Boolean(false), (int)11, null, null, null);
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)"asdasd", (int)11, null, null, null);
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Boolean(true), (int)11, (Object)"Mar 18, 2003 12:00:00 AM", null);
        this.assertResult(result, true);
    }

    public void test_NOT_NULL() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)"true", (int)10, null, null, null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr(null, (int)10, null, null, null);
        this.assertResult(result, false);
    }

    public void test_NULL() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)"true", (int)9, null, null, null);
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr(null, (int)9, null, null, null);
        this.assertResult(result, true);
    }

    public void test_NOT_BETWEEN() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)new Date(new GregorianCalendar(2004, 1, 2).getTimeInMillis()), (int)8, (Object)new Timestamp(new GregorianCalendar(2004, 1, 1).getTimeInMillis()), (Object)new Timestamp(new GregorianCalendar(2004, 1, 3).getTimeInMillis()));
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Date(new GregorianCalendar(2004, 1, 2).getTimeInMillis()), (int)8, (Object)new Timestamp(new GregorianCalendar(2004, 1, 3).getTimeInMillis()), (Object)new Timestamp(new GregorianCalendar(2004, 1, 1).getTimeInMillis()));
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Date(new GregorianCalendar(2004, 1, 2).getTimeInMillis()), (int)8, (Object)"01/03/2004", (Object)"01/06/2004");
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Date(new GregorianCalendar(2004, 1, 2).getTimeInMillis()), (int)8, (Object)"01/06/2004", (Object)"01/03/2004");
        this.assertResult(result, true);
    }

    public void test_BETWEEN() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)new Integer(10), (int)7, (Object)new Double(9.9), (Object)new BigDecimal(19.9));
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Integer(10), (int)7, (Object)new Double(10.9), (Object)new BigDecimal(19.9));
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Integer(10), (int)7, (Object)new Double(20.0), (Object)new BigDecimal(9.9));
        this.assertResult(result, false);
        GregorianCalendar calendar = new GregorianCalendar(2001, 10, 1);
        result = ScriptEvalUtil.evalConditionalExpr((Object)calendar.getTime(), (int)7, (Object)"Oct 20, 2001 12:00:00 AM", (Object)"Nov 20, 2001 12:00:00 AM");
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Double(10.0), (int)7, (Object)new Double(9.0), (Object)new Integer(20));
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)"10", (int)7, (Object)new Integer(9), (Object)new Double(20.0));
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Boolean(true), (int)7, (Object)new Double(0.5), (Object)new Double(2.0));
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Boolean(true), (int)7, (Object)new Double(-1.0), (Object)new Double(0.5));
        this.assertResult(result, false);
    }

    public void test_GT() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)new Integer(10), (int)6, (Object)new Double(9.9), null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Integer(10), (int)6, (Object)new BigDecimal(19.9), null);
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new BigDecimal(10), (int)6, (Object)new Double(10.0), null);
        this.assertResult(result, false);
    }

    public void test_GE() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)new BigDecimal(10), (int)5, (Object)new Double(10.0), null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Date(new GregorianCalendar(2004, 1, 2).getTimeInMillis()), (int)5, (Object)new Timestamp(new GregorianCalendar(2004, 1, 3).getTimeInMillis()), null);
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Date(new GregorianCalendar(2004, 1, 2).getTimeInMillis()), (int)5, (Object)"01/01/2004", null);
        this.assertResult(result, true);
    }

    public void test_LE() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)new BigDecimal(10), (int)4, (Object)new Double(10.0), null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Date(new GregorianCalendar(2004, 1, 2).getTimeInMillis()), (int)4, (Object)new Timestamp(new GregorianCalendar(2004, 1, 3).getTimeInMillis()), null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Date(new GregorianCalendar(2004, 1, 2).getTimeInMillis()), (int)4, (Object)"01/01/2004", null);
        this.assertResult(result, false);
    }

    public void test_LTtest() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)new Integer(10), (int)3, (Object)new Double(9.9), null);
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new Integer(10), (int)3, (Object)new BigDecimal(19.9), null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)new BigDecimal(10), (int)3, (Object)new Double(10.0), null);
        this.assertResult(result, false);
    }

    public void test_NE() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)"aaaaab", (int)2, (Object)"aaaaab", null);
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)"aaaaab", (int)2, (Object)"s", null);
        this.assertResult(result, true);
    }

    public void test_EQ() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)"aaaaab", (int)1, (Object)"aaaaab", null);
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)"aaaaab", (int)1, (Object)"s", null);
        this.assertResult(result, false);
    }

    public void test_IN() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)"100", (int)22, (Object[])new String[]{"200", "100"});
        this.assertResult(result, true);
        result = ScriptEvalUtil.evalConditionalExpr((Object)"100", (int)22, (Object[])new String[]{"200", "400"});
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)"100", (int)22, (Object[])new String[1]);
        this.assertResult(result, false);
    }

    public void test_NOT_IN() throws DataException {
        Object result = ScriptEvalUtil.evalConditionalExpr((Object)"100", (int)23, (Object[])new String[]{"200", "100"});
        this.assertResult(result, false);
        result = ScriptEvalUtil.evalConditionalExpr((Object)"100", (int)23, (Object[])new String[]{"200", "400"});
        this.assertResult(result, true);
    }

    private void assertResult(Object result, boolean expectedResult) {
        ScriptEvalTest.assertTrue((boolean)(result instanceof Boolean));
        ScriptEvalTest.assertEquals((Object)result, (Object)new Boolean(expectedResult));
    }
}

