/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.ConfigText;

public class Util {
    public static String getMetaDadataInfo(IResultMetaData meta) throws BirtException {
        StringBuffer stringBuff = new StringBuffer();
        if (meta == null || meta.getColumnCount() == 0) {
            stringBuff.append("null");
            stringBuff.append("\n");
        } else {
            int count = meta.getColumnCount();
            stringBuff.append("Index\tName\tAlias\tLabel\tType\tTypeName");
            stringBuff.append("\n");
            int i = 1;
            while (i <= count) {
                stringBuff.append(Integer.toString(i));
                stringBuff.append(":\t");
                try {
                    stringBuff.append(meta.getColumnName(i));
                }
                catch (DataException dataException) {
                    stringBuff.append("<Exception>");
                }
                stringBuff.append(",\t");
                try {
                    stringBuff.append(meta.getColumnAlias(i));
                }
                catch (DataException dataException) {
                    stringBuff.append("<Exception>");
                }
                stringBuff.append(",\t");
                try {
                    stringBuff.append(meta.getColumnLabel(i));
                }
                catch (DataException dataException) {
                    stringBuff.append("<Exception>");
                }
                stringBuff.append(",\t");
                try {
                    stringBuff.append(Integer.toString(meta.getColumnType(i)));
                }
                catch (DataException dataException) {
                    stringBuff.append("<Exception>");
                }
                stringBuff.append(",\t");
                try {
                    stringBuff.append(meta.getColumnTypeName(i));
                }
                catch (DataException dataException) {
                    stringBuff.append("<Exception>");
                }
                stringBuff.append("");
                stringBuff.append("\n");
                ++i;
            }
        }
        return new String(stringBuff);
    }

    public static class CachedResultSetTestHelper
    extends APITestCase {
        @Override
        protected APITestCase.DataSourceInfo getDataSourceInfo() {
            return new APITestCase.DataSourceInfo(ConfigText.getString("Executor.TestData1.TableName"), ConfigText.getString("Executor.TestData1.TableSQL"), ConfigText.getString("Executor.TestData1.TestDataFileName"));
        }

        public CachedResultSet getDefaultCachedResultSet() throws Exception {
            IQueryDefinition queryDefn = this.getDefaultQueryDefn(this.dataSet.getName());
            ResultIterator resultIterator = (ResultIterator)this.executeQuery(queryDefn);
            return (CachedResultSet)resultIterator.getOdiResult();
        }

        public CachedResultSet getDefaultSubQueryCachedResultSet() throws Exception {
            ResultIterator subIterator;
            IQueryDefinition queryDefn = this.getDefaultQueryDefnWithSubQuery(this.dataSet.getName());
            ResultIterator resultIterator = (ResultIterator)this.executeQuery(queryDefn);
            resultIterator.next();
            Context cx = Context.enter();
            try {
                ScriptableObject scope = cx.initStandardObjects();
                subIterator = (ResultIterator)resultIterator.getSecondaryIterator("IAMTEST", (Scriptable)scope);
            }
            finally {
                Context.exit();
            }
            return (CachedResultSet)subIterator.getOdiResult();
        }
    }
}

