/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.rd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.JoinCondition;
import org.eclipse.birt.data.engine.api.querydefn.JointDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryLocator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.rd.RDTestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.ConfigText;

public class ReportDocumentTest
extends RDTestCase {
    private ScriptableObject subScope;
    private ScriptableObject subOfSubScope;
    private String queryResultID;
    private String[] rowExprName;
    private String[] totalExprName;
    private String subQueryName = "test";
    private String subOfSubQueryName = "test2";
    private List expectedValue;
    private List expectedStartingGroupLevelValueList;
    private List expectedEndingGroupLevelValueList;
    private String beforeExprID;
    private String dummyRowExprName;

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName1"));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.expectedValue = new ArrayList();
        this.expectedStartingGroupLevelValueList = new ArrayList();
        this.expectedEndingGroupLevelValueList = new ArrayList();
        Context context = Context.enter();
        this.subScope = context.initStandardObjects();
        this.subScope.setPrototype((Scriptable)this.scope);
        this.subOfSubScope = context.initStandardObjects();
        this.subOfSubScope.setPrototype((Scriptable)this.subScope);
        Context.exit();
    }

    public void testBasic() throws BirtException, IOException {
        this.genBasic();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasic();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testJointDataSet() throws Exception {
        OdaDataSetDesign dset1 = new OdaDataSetDesign("dset1");
        dset1.setDataSource(this.dataSource.getName());
        dset1.setQueryText("Select * FROM " + this.getTestTableName());
        dset1.setExtensionID("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        OdaDataSetDesign dset2 = new OdaDataSetDesign("dset2");
        dset2.setDataSource(this.dataSource.getName());
        dset2.setQueryText("Select * FROM " + this.getTestTableName());
        dset2.setExtensionID("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ArrayList<JoinCondition> a = new ArrayList<JoinCondition>();
        a.add(new JoinCondition((IScriptExpression)new ScriptExpression("dataSetRow.CITY"), (IScriptExpression)new ScriptExpression("dataSetRow.CITY"), 1));
        JointDataSetDesign dset3 = new JointDataSetDesign("dset3", dset1.getName(), dset2.getName(), 0, a);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)dset1);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)dset2);
        this.myGenDataEngine.defineDataSet((IBaseDataSetDesign)dset3);
        QueryDefinition query = this.newReportQuery((IBaseDataSetDesign)dset3);
        IBaseExpression[] rowBeArray = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"dset1::CITY\"]"), new ScriptExpression("dataSetRow[\"dset2::CITY\"]"), new ScriptExpression("dataSetRow[\"dset1::COUNTRY\"]"), new ScriptExpression("dataSetRow[\"dset2::COUNTRY\"]"), new ScriptExpression("dataSetRow[\"dset1::AMOUNT\"]"), new ScriptExpression("dataSetRow[\"dset2::AMOUNT\"]")};
        this.rowExprName = new String[]{"CITY1", "CITY2", "COUNTRY1", "COUNTRY2", "AMOUNT1", "AMOUNT2"};
        int i = 0;
        while (i < this.rowExprName.length) {
            query.addBinding((IBinding)new Binding(this.rowExprName[i], rowBeArray[i]));
            ++i;
        }
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)query).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i2 = 0;
            while (i2 < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i2]));
                ++i2;
            }
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasic();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasic() throws BirtException {
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        this.rowExprName = this.getRowExprName();
        this.totalExprName = this.getAggrExprName();
        this.prepareExprNameAndQuery((BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i]));
                ++i;
            }
        }
        ri.close();
        ri.close();
        qr.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void prepareExprNameAndQuery(BaseQueryDefinition qd) throws DataException {
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = new IBaseExpression[2];
        this.rowExprName = this.getRowExprName();
        totalBeArray[0] = new ScriptExpression(null);
        totalBeArray[1] = new ScriptExpression("dataSetRow.AMOUNT");
        this.totalExprName = new String[totalBeArray.length];
        this.totalExprName[0] = "TOTAL_COUNT_1";
        this.totalExprName[1] = "TOTAL_AMOUNT_1";
        Binding total1 = new Binding(this.totalExprName[0], totalBeArray[0]);
        total1.setAggrFunction("count");
        Binding total2 = new Binding(this.totalExprName[1], totalBeArray[1]);
        total2.setAggrFunction("sum");
        qd.addBinding((IBinding)total1);
        qd.addBinding((IBinding)total2);
        int i = 0;
        while (i < this.rowExprName.length) {
            qd.addBinding((IBinding)new Binding(this.rowExprName[i], rowBeArray[i]));
            ++i;
        }
    }

    private void preBasic() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult1(ri);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testBasicSkip() throws Exception {
        this.genBasicSkip();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        deContext2.setTmpdir(ReportDocumentTest.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicSkip(3);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasicSkip() throws BirtException {
        this.genBasic();
    }

    private void preBasicSkip(int skipCount) throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult3(ri, skipCount);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testBasicMove() throws Exception {
        this.genBasicMove();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        int[] destIndex = new int[]{1, 3, 4, 6, 7};
        this.preBasicMove(destIndex);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasicMove() throws BirtException {
        this.genBasic();
    }

    private void preBasicMove(int[] destIndex) throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult4(ri, destIndex, true);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testBasicMove2() throws Exception {
        this.genBasicMove2();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        int[] destIndex = new int[]{1, 3, 4, 6, 7};
        this.preBasicMove2(destIndex);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasicMove2() throws BirtException {
        this.genBasic();
    }

    private void preBasicMove2(int[] destIndex) throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult4(ri, destIndex, false);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testBasicDiskCache() throws BirtException, IOException {
        System.setProperty("birt.data.engine.test.memcachesize", "5");
        this.testBasic();
    }

    public void testGroupBeforeExpr() throws Exception {
        this.genGroupBeforeExpr();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preGroupBeforeExpr();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genGroupBeforeExpr() throws BirtException {
        QueryDefinition qd = this.newReportQuery();
        GroupDefinition groupDefn = new GroupDefinition("G1");
        groupDefn.setKeyColumn("COUNTRY");
        qd.addGroup(groupDefn);
        qd.addResultSetExpression("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY"));
        ScriptExpression rowExpr = new ScriptExpression("dataSetRow.COUNTRY");
        rowExpr.setGroupName("G1");
        this.beforeExprID = "BEFOREEXPRID";
        qd.addResultSetExpression(this.beforeExprID, (IBaseExpression)rowExpr);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            if (ri.getStartingGroupLevel() > 1) continue;
            this.expectedValue.add(ri.getValue(this.beforeExprID));
            System.out.println(ri.getValue(this.beforeExprID));
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preGroupBeforeExpr() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            if (ri.getStartingGroupLevel() > 0) continue;
            String str = "";
            Object ob1 = it.next();
            Object ob2 = ri.getValue(this.beforeExprID);
            ReportDocumentTest.assertEquals(ob1, (Object)ob2);
            str = String.valueOf(str) + " " + ob2.toString();
            this.testOut.println("row result set: " + str);
        }
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testBasicGroupLevel() throws Exception {
        this.genBasicGroupLevel();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicGroupLevel();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasicGroupLevel() throws BirtException {
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.rowExprName = this.getRowExprName();
        this.totalExprName = this.getAggrExprName();
        this.prepareExprNameAndQuery((BaseQueryDefinition)qd);
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("COUNTRY");
        qd.addGroup(groupDefn);
        groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("CITY");
        qd.addGroup(groupDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i]));
                ++i;
            }
            this.expectedStartingGroupLevelValueList.add(new Integer(ri.getStartingGroupLevel()));
            this.expectedEndingGroupLevelValueList.add(new Integer(ri.getEndingGroupLevel()));
        }
        ri.close();
        ri.close();
        qr.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preBasicGroupLevel() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult2(ri);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testBasicMoveWithGroup() throws Exception {
        this.genBasicMoveWithGroup();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicMoveWithGroup(6);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasicMoveWithGroup() throws BirtException {
        this.genBasicGroupLevel();
    }

    private void preBasicMoveWithGroup(int destIndex) throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult2(ri, destIndex);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testBasicSkipToEnd() throws Exception {
        this.genBasicSkipToEnd();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicSkipToEnd();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasicSkipToEnd() throws BirtException {
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.rowExprName = this.getRowExprName();
        this.totalExprName = this.getAggrExprName();
        this.prepareExprNameAndQuery((BaseQueryDefinition)qd);
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("COUNTRY");
        qd.addGroup(groupDefn);
        groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("CITY");
        qd.addGroup(groupDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        ri.skipToEnd(1);
        while (ri.next()) {
            int i = 0;
            while (i < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i]));
                ++i;
            }
            this.expectedStartingGroupLevelValueList.add(new Integer(ri.getStartingGroupLevel()));
            this.expectedEndingGroupLevelValueList.add(new Integer(ri.getEndingGroupLevel()));
        }
        ri.close();
        ri.close();
        qr.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preBasicSkipToEnd() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        ri.next();
        ri.skipToEnd(1);
        this.checkResult2(ri);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testBasicFooter() throws Exception {
        int countOfRow = 8;
        ArrayList<Object> genValue = null;
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.rowExprName = this.getRowExprName();
        this.totalExprName = this.getAggrExprName();
        this.prepareExprNameAndQuery((BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        int currRow = -1;
        while (ri.next()) {
            if (++currRow != countOfRow - 1) continue;
            genValue = new ArrayList<Object>();
            int i = 0;
            while (i < rowBeArray.length) {
                genValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < totalBeArray.length) {
                genValue.add(ri.getValue(this.totalExprName[i]));
                ++i;
            }
        }
        ri.close();
        ri.close();
        qr.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        ArrayList<Object> preValue = null;
        IQueryResults qr2 = this.myPreDataEngine.getQueryResults(this.queryResultID);
        IResultIterator ri2 = qr2.getResultIterator();
        ri2.moveTo(countOfRow - 1);
        preValue = new ArrayList<Object>();
        if (this.rowExprName != null) {
            int i = 0;
            while (i < this.rowExprName.length) {
                Object ob2 = ri2.getValue(this.rowExprName[i]);
                preValue.add(ob2);
                ++i;
            }
        }
        if (this.totalExprName != null) {
            int i = 0;
            while (i < this.totalExprName.length) {
                Object ob2 = ri2.getValue(this.totalExprName[i]);
                preValue.add(ob2);
                ++i;
            }
        }
        ri2.close();
        this.myPreDataEngine.shutdown();
        this.closeArchiveReader();
        Iterator it1 = genValue.iterator();
        Iterator it2 = preValue.iterator();
        String str = "";
        while (it2.hasNext()) {
            Object ob2 = it2.next();
            ReportDocumentTest.assertTrue((boolean)it1.next().equals(ob2));
            str = String.valueOf(str) + ob2.toString() + " ";
        }
        this.testOut.println("row result set: " + str);
        this.checkOutputFile();
    }

    public void testBasicGroupLevel2() throws Exception {
        this.genBasicGroupLevel2();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicGroupLevel2();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genBasicGroupLevel2() throws Exception {
        QueryDefinition qd = this.newReportQuery();
        qd.setUsesDetails(false);
        this.prepareExprNameAndQuery((BaseQueryDefinition)qd);
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("COUNTRY");
        qd.addGroup(groupDefn);
        groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("CITY");
        qd.addGroup(groupDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < this.rowExprName.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i]));
                ++i;
            }
            this.expectedStartingGroupLevelValueList.add(new Integer(ri.getStartingGroupLevel()));
            this.expectedEndingGroupLevelValueList.add(new Integer(ri.getEndingGroupLevel()));
        }
        ri.close();
        ri.close();
        qr.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preBasicGroupLevel2() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult2(ri);
        ri.close();
        System.out.println("--------move to test1--------");
        qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult2(ri, 0);
        ri.close();
        System.out.println("--------move to test2--------");
        qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        this.checkResult2(ri, 2);
        this.myPreDataEngine.shutdown();
    }

    public void testSubQuery() throws BirtException, IOException {
        this.genSubQuery();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preSubQuery();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genSubQuery() throws BirtException {
        QueryDefinition queryDefn = this.newReportQuery();
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("COUNTRY");
        queryDefn.addGroup(groupDefn);
        this.prepareExprNameAndQuery((BaseQueryDefinition)queryDefn);
        SubqueryDefinition subQueryDefn = new SubqueryDefinition(this.subQueryName, (IBaseQueryDefinition)queryDefn);
        groupDefn.addSubquery(subQueryDefn);
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setColumn("AMOUNT");
        sortDefn.setSortDirection(1);
        subQueryDefn.addSort(sortDefn);
        this.prepareExprNameAndQuery((BaseQueryDefinition)subQueryDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)queryDefn).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        int loopCount = 5;
        int i = 0;
        while (i < loopCount) {
            ri.next();
            ++i;
        }
        IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
        while (ri2.next()) {
            int i2 = 0;
            while (i2 < this.rowExprName.length) {
                this.expectedValue.add(ri2.getValue(this.rowExprName[i2]));
                ++i2;
            }
            i2 = 0;
            while (i2 < this.totalExprName.length) {
                this.expectedValue.add(ri2.getValue(this.totalExprName[i2]));
                ++i2;
            }
        }
        ri2.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preSubQuery() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        IResultIterator ri = qr.getResultIterator();
        int loopCount = 5;
        int i = 0;
        while (i < loopCount) {
            ri.next();
            ++i;
        }
        IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
        this.checkResult1(ri2);
        ri2.close();
        qr.close();
        this.myPreDataEngine.shutdown();
    }

    public void testSubQuery2() throws BirtException, IOException {
        this.genSubQuery2();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preSubQuery2();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genSubQuery2() throws BirtException {
        QueryDefinition queryDefn = this.newReportQuery();
        SubqueryDefinition subQueryDefn = new SubqueryDefinition(this.subQueryName, (IBaseQueryDefinition)queryDefn);
        queryDefn.addSubquery(subQueryDefn);
        this.prepareExprNameAndQuery((BaseQueryDefinition)subQueryDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)queryDefn).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
        }
        IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
        while (ri2.next()) {
            int i = 0;
            while (i < this.rowExprName.length) {
                this.expectedValue.add(ri2.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                this.expectedValue.add(ri2.getValue(this.totalExprName[i]));
                ++i;
            }
        }
        ri2.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preSubQuery2() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
        }
        IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
        this.checkResult1(ri2);
        ri2.close();
        qr.close();
        this.myPreDataEngine.shutdown();
    }

    public void testSubQuery3() throws BirtException, IOException {
        this.genSubQuery3();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preSubQuery3();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genSubQuery3() throws BirtException {
        QueryDefinition queryDefn = this.newReportQuery();
        SubqueryDefinition subQueryDefn = new SubqueryDefinition(this.subQueryName, (IBaseQueryDefinition)queryDefn);
        subQueryDefn.setApplyOnGroupFlag(false);
        queryDefn.addSubquery(subQueryDefn);
        this.prepareExprNameAndQuery((BaseQueryDefinition)subQueryDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)queryDefn).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
            while (ri2.next()) {
                int i = 0;
                while (i < this.rowExprName.length) {
                    this.expectedValue.add(ri2.getValue(this.rowExprName[i]));
                    ++i;
                }
                i = 0;
                while (i < this.totalExprName.length) {
                    this.expectedValue.add(ri2.getValue(this.totalExprName[i]));
                    ++i;
                }
            }
            ri2.close();
        }
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preSubQuery3() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        IResultIterator ri = qr.getResultIterator();
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
            this.checkResult1(it, ri2);
            ri2.close();
        }
        qr.close();
        this.myPreDataEngine.shutdown();
    }

    public void testSubQuery4() throws BirtException, IOException {
        this.genSubQuery4();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preSubQuery4();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genSubQuery4() throws BirtException {
        QueryDefinition queryDefn = this.newReportQuery();
        queryDefn.setUsesDetails(false);
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("COUNTRY_1");
        queryDefn.addGroup(groupDefn);
        this.rowExprName = new String[1];
        this.rowExprName[0] = "COUNTRY_1";
        IBaseExpression[] rowBeArray = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY")};
        int i = 0;
        while (i < this.rowExprName.length) {
            queryDefn.addBinding((IBinding)new Binding(this.rowExprName[i], rowBeArray[i]));
            ++i;
        }
        rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.rowExprName = this.getRowExprName();
        this.totalExprName = this.getAggrExprName();
        SubqueryDefinition subQueryDefn = new SubqueryDefinition(this.subQueryName, (IBaseQueryDefinition)queryDefn);
        GroupDefinition subGroupDefn = new GroupDefinition("group2");
        subGroupDefn.setKeyExpression("row[\"CITY\"]");
        subQueryDefn.addGroup(subGroupDefn);
        groupDefn.addSubquery(subQueryDefn);
        subQueryDefn.setUsesDetails(false);
        this.prepareExprNameAndQuery((BaseQueryDefinition)subQueryDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)queryDefn).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            System.out.println(ri.getValue("COUNTRY_1"));
            IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
            while (ri2.next()) {
                int i2 = 0;
                while (i2 < rowBeArray.length) {
                    this.expectedValue.add(ri2.getValue(this.rowExprName[i2]));
                    ++i2;
                }
                i2 = 0;
                while (i2 < totalBeArray.length) {
                    this.expectedValue.add(ri2.getValue(this.totalExprName[i2]));
                    ++i2;
                }
            }
            ri2.close();
        }
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preSubQuery4() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        IResultIterator ri = qr.getResultIterator();
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
            this.checkResult1(it, ri2);
            ri2.close();
        }
        qr.close();
        this.myPreDataEngine.shutdown();
    }

    public void testSubOfSubQuery() throws BirtException, IOException {
        this.genSubOfSubQuery();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preSubOfSubQuery();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSubOfSubQueryAsSourceQuery() throws BirtException, IOException {
        this.genSubOfSubQuery();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preSubOfSubQuery1();
        this.closeArchiveReader();
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        SubqueryLocator subqueryLocator1 = new SubqueryLocator(0, this.subQueryName, (IBaseQueryDefinition)baseQuery);
        SubqueryLocator subqueryLocator2 = new SubqueryLocator(0, this.subOfSubQueryName, (IBaseQueryDefinition)subqueryLocator1);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)subqueryLocator2);
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT>300");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.SALE_DATE");
        sd.setSortDirection(1);
        query.addSort(sd);
        this._preBasicSubIV1(query);
        query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)subqueryLocator2);
        filterExpr = new ScriptExpression("row.AMOUNT>401");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        sd = new SortDefinition();
        sd.setExpression("row.SALE_DATE");
        sd.setSortDirection(1);
        query.addSort(sd);
        this._preBasicSubIV1(query);
        this.myPreDataEngine.shutdown();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void preSubOfSubQuery1() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
        ri2.next();
        IResultIterator ri3 = ri2.getSecondaryIterator(this.subOfSubQueryName, (Scriptable)this.subOfSubScope);
        ri3.close();
        qr.close();
    }

    private void _preBasicSubIV1(QueryDefinition qd) throws BirtException {
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        IResultIterator ri = qr.getResultIterator();
        ri.moveTo(0);
        String abc = "";
        String[] subRowExprName = new String[]{"COUNTRY", "CITY", "SALE_DATE", "AMOUNT"};
        int i = 0;
        while (i < subRowExprName.length) {
            abc = String.valueOf(abc) + subRowExprName[i] + "  ";
            ++i;
        }
        this.testPrintln(abc);
        do {
            abc = "";
            i = 0;
            while (i < subRowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(subRowExprName[i]) + "  ";
                ++i;
            }
            this.testPrintln(String.valueOf(abc) + ri.getRowId());
        } while (ri.next());
        ri.close();
    }

    private void genSubOfSubQuery() throws BirtException {
        QueryDefinition queryDefn = this.newReportQuery();
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyColumn("COUNTRY");
        queryDefn.addGroup(groupDefn);
        queryDefn.addResultSetExpression("COUNTRY", (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY"));
        SubqueryDefinition subQueryDefn = new SubqueryDefinition(this.subQueryName, (IBaseQueryDefinition)queryDefn);
        groupDefn.addSubquery(subQueryDefn);
        GroupDefinition subGroupDefn = new GroupDefinition();
        subGroupDefn.setKeyColumn("CITY");
        subQueryDefn.addGroup(subGroupDefn);
        subQueryDefn.addResultSetExpression("CITY", (IBaseExpression)new ScriptExpression("dataSetRow.CITY"));
        SubqueryDefinition subOfSubQueryDefn = new SubqueryDefinition(this.subOfSubQueryName, (IBaseQueryDefinition)subQueryDefn);
        subGroupDefn.addSubquery(subOfSubQueryDefn);
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.rowExprName = this.getRowExprName();
        this.totalExprName = this.getAggrExprName();
        this.prepareExprNameAndQuery((BaseQueryDefinition)subOfSubQueryDefn);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)queryDefn).execute((Scriptable)this.subScope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.scope);
        ri2.next();
        IResultIterator ri3 = ri2.getSecondaryIterator(this.subOfSubQueryName, (Scriptable)this.subOfSubScope);
        while (ri3.next()) {
            int i = 0;
            while (i < rowBeArray.length) {
                this.expectedValue.add(ri3.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < totalBeArray.length) {
                this.expectedValue.add(ri3.getValue(this.totalExprName[i]));
                ++i;
            }
        }
        ri3.close();
        ri2.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preSubOfSubQuery() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        IResultIterator ri2 = ri.getSecondaryIterator(this.subQueryName, (Scriptable)this.subScope);
        ri2.next();
        IResultIterator ri3 = ri2.getSecondaryIterator(this.subOfSubQueryName, (Scriptable)this.subOfSubScope);
        this.checkResult1(ri3);
        ri3.close();
        qr.close();
        this.myPreDataEngine.shutdown();
    }

    public void testNestedQuery() throws BirtException, IOException {
        this.genNestedQuery();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preNestedQuery();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genNestedQuery() throws BirtException {
        QueryDefinition qd = this.newReportQuery();
        this.prepareExprNameAndQuery((BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        qr.getResultIterator().next();
        Context cx = Context.enter();
        ScriptableObject nestedScope = cx.initStandardObjects();
        nestedScope.setPrototype((Scriptable)this.scope);
        Context.exit();
        QueryDefinition nestedQD = this.newReportQuery();
        IBaseExpression[] tempArray2 = this.getRowExpr();
        int length = tempArray2.length;
        IBaseExpression[] rowBeArray2 = new IBaseExpression[length + 1];
        System.arraycopy(tempArray2, 0, rowBeArray2, 0, length);
        rowBeArray2[length] = new ScriptExpression("rows[0].AMOUNT");
        this.rowExprName = new String[rowBeArray2.length];
        int i = 0;
        while (i < this.rowExprName.length) {
            this.rowExprName[i] = "NAME_" + i;
            ++i;
        }
        IBaseExpression[] totalBeArray2 = this.getAggrExpr();
        Binding total1 = new Binding(this.totalExprName[0], totalBeArray2[0]);
        total1.setAggrFunction("count");
        Binding total2 = new Binding(this.totalExprName[1], totalBeArray2[1]);
        total2.setAggrFunction("sum");
        nestedQD.addBinding((IBinding)total1);
        nestedQD.addBinding((IBinding)total2);
        int i2 = 0;
        while (i2 < this.rowExprName.length) {
            nestedQD.addBinding((IBinding)new Binding(this.rowExprName[i2], rowBeArray2[i2]));
            ++i2;
        }
        IQueryResults qr2 = this.myGenDataEngine.prepare((IQueryDefinition)nestedQD).execute(qr, (Scriptable)nestedScope);
        IResultIterator ri = qr2.getResultIterator();
        this.saveForPresentation(qr2);
        while (ri.next()) {
            int i3 = 0;
            while (i3 < rowBeArray2.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i3]));
                ++i3;
            }
            i3 = 0;
            while (i3 < totalBeArray2.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i3]));
                ++i3;
            }
        }
        ri.close();
        qr2.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preNestedQuery() throws BirtException {
        this.preBasic();
    }

    public void testComputedColumn() throws BirtException, IOException {
        this.genComputedColumn();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preComputedColumn();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genComputedColumn() throws BirtException {
        String[] ccName = new String[]{"cc1", "cc2"};
        String[] ccExpr = new String[]{"row.COUNTRY", "row.AMOUNT*100"};
        int[] dataTypes = new int[]{5, 2};
        int i = 0;
        while (i < 2) {
            ComputedColumn computedColumn = new ComputedColumn(ccName[i], ccExpr[i], dataTypes[i]);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] tempArray = this.getRowExpr();
        int length = tempArray.length;
        IBaseExpression[] rowBeArray = new IBaseExpression[length + 2];
        System.arraycopy(tempArray, 0, rowBeArray, 0, length);
        int i2 = 0;
        while (i2 < ccName.length) {
            rowBeArray[length + i2] = new ScriptExpression("dataSetRow." + ccName[i2]);
            ++i2;
        }
        this.rowExprName = new String[rowBeArray.length];
        i2 = 0;
        while (i2 < this.rowExprName.length) {
            this.rowExprName[i2] = "NAME_" + i2;
            ++i2;
        }
        IBaseExpression[] totalBeArray = this.getAggrExpr();
        this.totalExprName = this.getAggrExprName();
        IBaseExpression[] totalBeArray2 = this.getAggrExpr();
        Binding total1 = new Binding(this.totalExprName[0], totalBeArray2[0]);
        total1.setAggrFunction("count");
        Binding total2 = new Binding(this.totalExprName[1], totalBeArray2[1]);
        total2.setAggrFunction("sum");
        qd.addBinding((IBinding)total1);
        qd.addBinding((IBinding)total2);
        int i3 = 0;
        while (i3 < this.rowExprName.length) {
            qd.addBinding((IBinding)new Binding(this.rowExprName[i3], rowBeArray[i3]));
            ++i3;
        }
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.saveForPresentation(qr);
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i4 = 0;
            while (i4 < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i4]));
                ++i4;
            }
            i4 = 0;
            while (i4 < totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i4]));
                ++i4;
            }
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preComputedColumn() throws BirtException {
        this.preBasic();
    }

    private IBaseExpression[] getRowExpr() {
        int num = 4;
        IBaseExpression[] rowBeArray = new IBaseExpression[num];
        rowBeArray[0] = new ScriptExpression("dataSetRow.COUNTRY");
        rowBeArray[1] = new ScriptExpression("dataSetRow.CITY");
        rowBeArray[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        rowBeArray[3] = new ScriptExpression("dataSetRow.AMOUNT");
        return rowBeArray;
    }

    private String[] getRowExprName() {
        int num = 4;
        String[] rowBeArray = new String[num];
        rowBeArray[0] = "COUNTRY";
        rowBeArray[1] = "CITY";
        rowBeArray[2] = "SALE_DATE";
        rowBeArray[3] = "AMOUNT";
        return rowBeArray;
    }

    private IBaseExpression[] getAggrExpr() {
        int num2 = 2;
        IBaseExpression[] totalBeArray = new IBaseExpression[num2];
        totalBeArray[0] = new ScriptExpression(null);
        totalBeArray[1] = new ScriptExpression("dataSetRow.AMOUNT");
        return totalBeArray;
    }

    private String[] getAggrExprName() {
        int num2 = 2;
        String[] totalBeArray = new String[num2];
        totalBeArray[0] = "Total.Count( )";
        totalBeArray[1] = "Total.Sum( dataSetRow.AMOUNT )";
        return totalBeArray;
    }

    private void saveForPresentation(IQueryResults qr) {
        this.queryResultID = qr.getID();
    }

    private void checkResult1(IResultIterator ri) throws BirtException {
        Iterator it = this.expectedValue.iterator();
        this.checkResult1(it, ri);
    }

    private void checkResult1(Iterator it, IResultIterator ri) throws BirtException {
        while (ri.next()) {
            Object ob2;
            Object ob1;
            int i;
            String str = "";
            if (this.rowExprName != null) {
                i = 0;
                while (i < this.rowExprName.length) {
                    ob1 = it.next();
                    ob2 = ri.getValue(this.rowExprName[i]);
                    ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                    str = String.valueOf(str) + " " + ob2.toString();
                    ++i;
                }
            }
            if (this.totalExprName != null) {
                i = 0;
                while (i < this.totalExprName.length) {
                    ob1 = it.next();
                    ob2 = ri.getValue(this.totalExprName[i]);
                    ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                    str = String.valueOf(str) + " " + ob2.toString();
                    ++i;
                }
            }
            this.testOut.println("row result set: " + str);
        }
    }

    private void checkResult2(IResultIterator ri) throws BirtException {
        Iterator it = this.expectedValue.iterator();
        Iterator it1 = this.expectedStartingGroupLevelValueList.iterator();
        Iterator it2 = this.expectedEndingGroupLevelValueList.iterator();
        while (ri.next()) {
            Object ob2;
            Object ob1;
            String str = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.rowExprName[i]);
                ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob2.toString();
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.totalExprName[i]);
                ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob2.toString();
                ++i;
            }
            System.out.println("row result set: " + str);
            str = "";
            Integer value1 = (Integer)it1.next();
            int value2 = ri.getStartingGroupLevel();
            ReportDocumentTest.assertEquals((int)value1, (int)value2);
            str = String.valueOf(str) + " staring: " + value1;
            Integer value3 = (Integer)it2.next();
            int value4 = ri.getEndingGroupLevel();
            ReportDocumentTest.assertEquals((int)value3, (int)value4);
            str = String.valueOf(str) + " ending " + value3;
            this.testOut.println("row group level value: " + str);
        }
    }

    private void checkResult2(IResultIterator ri, int destIndex) throws BirtException {
        Iterator it = this.expectedValue.iterator();
        Iterator it1 = this.expectedStartingGroupLevelValueList.iterator();
        Iterator it2 = this.expectedEndingGroupLevelValueList.iterator();
        int k = 0;
        while (k < destIndex) {
            int i = 0;
            while (i < this.rowExprName.length) {
                it.next();
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                it.next();
                ++i;
            }
            it1.next();
            it2.next();
            ++k;
        }
        if (destIndex >= 1) {
            ri.moveTo(destIndex - 1);
        }
        while (ri.next()) {
            Object ob2;
            Object ob1;
            String str = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.rowExprName[i]);
                ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob2.toString();
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.totalExprName[i]);
                ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob2.toString();
                ++i;
            }
            this.testOut.println("row result set: " + str);
            str = "";
            Integer value1 = (Integer)it1.next();
            int value2 = ri.getStartingGroupLevel();
            ReportDocumentTest.assertEquals((int)value1, (int)value2);
            str = String.valueOf(str) + " staring: " + value1;
            Integer value3 = (Integer)it2.next();
            int value4 = ri.getEndingGroupLevel();
            ReportDocumentTest.assertEquals((int)value3, (int)value4);
            str = String.valueOf(str) + " ending " + value3;
            this.testOut.println("row group level value: " + str);
        }
    }

    private void checkResult3(IResultIterator ri, int skipCount) throws BirtException {
        int i;
        Iterator it = this.expectedValue.iterator();
        int k = 0;
        while (k < skipCount) {
            i = 0;
            while (i < this.rowExprName.length) {
                it.next();
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                it.next();
                ++i;
            }
            ri.next();
            ++k;
        }
        while (ri.next()) {
            Object ob2;
            Object ob1;
            String str = "";
            i = 0;
            while (i < this.rowExprName.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.rowExprName[i]);
                ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob2.toString();
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.totalExprName[i]);
                ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob2.toString();
                ++i;
            }
            this.testOut.println("row result set: " + str);
        }
    }

    private void checkResult4(IResultIterator ri, int[] destIndex, boolean doNextFirst) throws BirtException {
        if (doNextFirst) {
            ri.next();
        }
        int offset = this.rowExprName.length + this.totalExprName.length;
        int j = 0;
        while (j < destIndex.length) {
            Object ob2;
            Object ob1;
            int index = destIndex[j];
            ri.moveTo(index);
            String str = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                ob1 = this.expectedValue.get(index * offset + i);
                ob2 = ri.getValue(this.rowExprName[i]);
                ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob1.toString();
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                ob1 = this.expectedValue.get(index * offset + this.rowExprName.length + i);
                ob2 = ri.getValue(this.totalExprName[i]);
                ReportDocumentTest.assertEquals(ob1, (Object)ob2);
                str = String.valueOf(str) + " " + ob1.toString();
                ++i;
            }
            this.testOut.println("row result set: " + str);
            ++j;
        }
    }

    public void testBasicDummy() throws Exception {
        this.genBasicDummy();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicDummy();
        this.closeArchiveReader();
    }

    private void genBasicDummy() throws BirtException {
        QueryDefinition qd = new QueryDefinition();
        qd.setDataSetName(null);
        ScriptExpression rowExpr = new ScriptExpression("new Date()");
        this.dummyRowExprName = "Date";
        qd.addResultSetExpression(this.dummyRowExprName, (IBaseExpression)rowExpr);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            this.expectedValue.add(ri.getValue(this.dummyRowExprName));
        }
        ReportDocumentTest.assertTrue((ri.getResultMetaData() != null ? 1 : 0) != 0);
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void preBasicDummy() throws BirtException {
        IQueryResults qr = this.myPreDataEngine.getQueryResults(this.queryResultID);
        assert (qr.getResultMetaData() != null);
        IResultIterator ri = qr.getResultIterator();
        assert (ri.getResultMetaData() != null);
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            String str = "";
            Object ob1 = it.next();
            Object ob2 = ri.getValue(this.dummyRowExprName);
            if (ob1 instanceof IdScriptableObject) {
                ob1 = JavascriptEvalUtil.convertJavascriptValue(ob1);
                ob2 = JavascriptEvalUtil.convertJavascriptValue((Object)ob2);
            }
            ReportDocumentTest.assertEquals(ob1, (Object)ob2);
            str = String.valueOf(str) + " " + ob2.toString();
            this.testOut.println("row result set: " + str);
        }
        ReportDocumentTest.assertTrue((ri.getResultMetaData() != null ? 1 : 0) != 0);
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    @Override
    protected boolean useFolderArchive() {
        return true;
    }
}

