/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.rd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryExecutionHints;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupInstanceInfo;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryExecutionHints;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryLocator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.rd.RDTestCase;
import org.mozilla.javascript.Scriptable;
import testutil.ConfigText;

public class ViewingTest
extends RDTestCase {
    private String queryResultID;
    private List expectedValue;
    private String[] rowExprName;
    private String[] totalExprName;
    private String[] subRowExprName;
    private IBaseExpression[] rowBeArray;
    private IBinding[] totalBeArray;
    private boolean GEN_add_filter;
    private boolean GEN_add_group;
    private boolean GEN_add_secondGroup;
    private boolean GEN_subquery_on_group;
    private boolean GEN_useDetail;
    private boolean GEN_make_empty;
    private boolean PRE_add_filter;
    private boolean PRE_add_sort;
    private boolean PRE_add_group;
    private boolean PRE_change_oldbinding;
    private boolean PRE_printGroupInfo;
    private boolean PRE_printExtraAggr;
    private FilterDefinition GEN_filterDefn;
    private boolean GEN_isSummary;

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.expectedValue = new ArrayList();
        this.GEN_add_filter = false;
        this.GEN_add_group = false;
        this.GEN_add_secondGroup = false;
        this.GEN_subquery_on_group = false;
        this.GEN_useDetail = true;
        this.GEN_make_empty = false;
        this.GEN_isSummary = false;
        this.PRE_add_filter = false;
        this.PRE_add_sort = false;
        this.PRE_change_oldbinding = false;
        this.PRE_add_group = false;
        this.PRE_printGroupInfo = false;
        this.PRE_printExtraAggr = false;
    }

    @Override
    public void tearDown() throws Exception {
        if (this.myPreDataEngine != null) {
            this.myPreDataEngine.shutdown();
            this.myPreDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
            this.myPreDataEngine = null;
        }
        if (this.myPreDataEngine2 != null) {
            this.myPreDataEngine2.shutdown();
            this.myPreDataEngine2.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
            this.myPreDataEngine2 = null;
        }
        super.tearDown();
    }

    public void testBasicIV() throws Exception {
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        deContext2.setTmpdir(ViewingTest.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.preBasicIV();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testBasicIV2() throws Exception {
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_sort = true;
        this.preBasicIV();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testBasicIV3() throws Exception {
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_sort = true;
        this.PRE_add_group = true;
        this.preBasicIV();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testBasicIV4() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_filter = true;
        this.PRE_add_sort = true;
        this.PRE_add_group = true;
        this.preBasicIV();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testBasicIV5() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_filter = true;
        this.PRE_add_sort = true;
        this.PRE_add_group = true;
        this.preBasicIV();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIV1() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        ScriptExpression filterExpr = new ScriptExpression("dataSetRow[\"AMOUNT_1\"]>350");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.SALE_NAME_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV1(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIV1withDistinct4() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        ScriptExpression filterExpr = new ScriptExpression("dataSetRow[\"AMOUNT_1\"]>350");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        Binding binding = new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow.CITY_1"));
        query.addBinding((IBinding)binding);
        query.setDistinctValue(true);
        this._preBasicIV4(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIV1withMaxRow() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        query.setStartingRow(1);
        query.setMaxRows(2);
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1>350");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.SALE_NAME_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV1(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIV1withDistinct() throws Exception {
        this.genNotDistinctBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        query.setDistinctValue(true);
        query.setStartingRow(1);
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1>0");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.COUNTRY_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        sd = new SortDefinition();
        sd.setExpression("row.CITY_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV3(query, new String[]{"COUNTRY_1", "CITY_1", "AMOUNT_1"});
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIV1withDistinct1() throws Exception {
        this.genNotDistinctBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        query.setDistinctValue(true);
        query.setMaxRows(3);
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1<500");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.CITY_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV3(query, new String[]{"COUNTRY_1", "CITY_1", "AMOUNT_1"});
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        query.setDistinctValue(false);
        query.setMaxRows(3);
        filterExpr = new ScriptExpression("row.AMOUNT_1<500");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        sd = new SortDefinition();
        sd.setExpression("row.CITY_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV3(query, new String[]{"COUNTRY_1", "CITY_1", "AMOUNT_1"});
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIV1withDistinct2() throws Exception {
        this.genNotDistinctBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        query.setDistinctValue(true);
        query.setStartingRow(1);
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1 < 710");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.CITY_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV3(query, new String[]{"COUNTRY_1", "CITY_1", "AMOUNT_1"});
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        query.setDistinctValue(true);
        query.setStartingRow(1);
        query.setMaxRows(4);
        filterExpr = new ScriptExpression("row.AMOUNT_1 < 710");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        sd = new SortDefinition();
        sd.setExpression("row.CITY_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV3(query, new String[]{"COUNTRY_1", "CITY_1", "AMOUNT_1"});
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIV1withDistinct3() throws Exception {
        this.genNotDistinctBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        Binding binding1 = new Binding("COUNTRY_11");
        binding1.setExpression((IBaseExpression)new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)"COUNTRY_1")));
        Binding binding2 = new Binding("CITY_11");
        binding2.setExpression((IBaseExpression)new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)"CITY_1")));
        query.addBinding((IBinding)binding1);
        query.addBinding((IBinding)binding2);
        query.setDistinctValue(true);
        SortDefinition sd = new SortDefinition();
        sd.setExpression(ExpressionUtil.createJSRowExpression((String)"CITY_11"));
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV3(query, new String[]{"COUNTRY_11", "CITY_11"});
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIVLikeFilter() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        ConditionalExpression filterExpr = new ConditionalExpression("row.CITY_1", 13, "\"Beijin%\"");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.SALE_NAME_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV1(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIV2() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1 + 251 > 350");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.AMOUNT_1 + 251");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV1(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceQueryIVWithGroup() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)baseQuery);
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1 + 251 > 350");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.AMOUNT_1 + 251");
        sd.setSortDirection(0);
        query.addSort(sd);
        new ScriptExpression("row.COUNTRY_1");
        GroupDefinition gd = new GroupDefinition("COUNTRY");
        gd.setKeyColumn("COUNTRY_1");
        query.addGroup(gd);
        this._preBasicIV1(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testSourceSubQueryIV() throws Exception {
        this.GEN_add_filter = false;
        this.GEN_add_group = true;
        this.GEN_subquery_on_group = true;
        this._genBasicIVWithSubQuery();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        QueryDefinition baseQuery = new QueryDefinition();
        baseQuery.setQueryResultsID(this.queryResultID);
        SubqueryLocator subqueryLocator = new SubqueryLocator(5, "IAMTEST", (IBaseQueryDefinition)baseQuery);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)subqueryLocator);
        ScriptExpression filterExpr = new ScriptExpression("row.sub2>200");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.sub2");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicSubIV1(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void _preBasicSubIV1(QueryDefinition qd) throws BirtException {
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        IResultIterator ri = qr.getResultIterator();
        ri.moveTo(0);
        String abc = "";
        this.subRowExprName = new String[3];
        this.subRowExprName[0] = "sub1";
        this.subRowExprName[1] = "sub2";
        this.subRowExprName[2] = "sub3";
        int i = 0;
        while (i < this.subRowExprName.length) {
            abc = String.valueOf(abc) + this.subRowExprName[i] + "  ";
            ++i;
        }
        this.testPrintln(abc);
        do {
            abc = "";
            i = 0;
            while (i < this.subRowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.subRowExprName[i]) + "  ";
                ++i;
            }
            this.testPrintln(String.valueOf(abc) + ri.getRowId());
        } while (ri.next());
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void testFilterByGroupInstanceIV() throws Exception {
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 2));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV1() throws Exception {
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 5));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testAggr1() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        this.PRE_add_filter = true;
        QueryDefinition query = this.newPreIVReportQuery();
        this.addExtraAggregation(query);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 5));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV2() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testAggr2() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        this.PRE_add_sort = true;
        QueryDefinition query = this.newPreIVReportQuery();
        this.addExtraAggregation(query);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV3() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 4));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testAggr3() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        this.PRE_add_sort = true;
        QueryDefinition query = this.newPreIVReportQuery();
        this.addExtraAggregation(query);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 4));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV4() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 2));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testAggr4() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        this.PRE_add_sort = true;
        this.PRE_add_filter = true;
        QueryDefinition query = this.newPreIVReportQuery();
        this.addExtraAggregation(query);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 2));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV5() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 1));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testAggr5() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        QueryDefinition query = this.newPreIVReportQuery();
        this.addExtraAggregation(query);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 1));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV6() throws Exception {
        this.GEN_add_group = true;
        this.GEN_useDetail = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        query.setUsesDetails(false);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 1));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testAggr6() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        this.GEN_useDetail = false;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        QueryDefinition query = this.newPreIVReportQuery();
        this.addExtraAggregation(query);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 1));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV7() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        this.GEN_useDetail = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        query.setUsesDetails(false);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 1));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 4));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testAggr7() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        this.GEN_useDetail = false;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        QueryDefinition query = this.newPreIVReportQuery();
        this.addExtraAggregation(query);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 1));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 4));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV8() throws Exception {
        this.GEN_add_group = true;
        this.GEN_useDetail = false;
        this.GEN_make_empty = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        query.setUsesDetails(false);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 1));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
    }

    public void testFilterByGroupInstanceIV9() throws Exception {
        this.GEN_add_group = true;
        this.GEN_useDetail = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        query.setUsesDetails(false);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 10));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
    }

    public void testSummaryTable() throws Exception {
        this.GEN_add_group = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        Binding binding1 = new Binding("Count_on_1st_group");
        binding1.setAggrFunction("COUNT");
        binding1.addAggregateOn("COUNTRY");
        genquery.addBinding((IBinding)binding1);
        genquery.setIsSummaryQuery(true);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        QueryDefinition query = this.newPreIVReportQuery();
        query.addBinding((IBinding)binding1);
        query.setIsSummaryQuery(true);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testAggr() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        this.PRE_add_sort = true;
        QueryDefinition query = this.newPreIVReportQuery();
        this.addExtraAggregation(query);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV10() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        QueryDefinition query = this.newPreIVReportQuery();
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 5));
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(2, 3));
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testDataExtr1() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        this.PRE_add_filter = true;
        QueryDefinition basequery = this.newPreIVReportQuery();
        this.addExtraAggregation(basequery);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 5));
        basequery.setQueryExecutionHints((IQueryExecutionHints)hints);
        basequery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)basequery);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testDataExtr2() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        QueryDefinition basequery = this.newPreIVReportQuery();
        this.addExtraAggregation(basequery);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 5));
        basequery.setQueryExecutionHints((IQueryExecutionHints)hints);
        basequery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)basequery);
        ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1>450");
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testFilterByGroupInstanceIV_testDataExtr3() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_secondGroup = true;
        QueryDefinition genquery = this.newGenIVReportQuery();
        this.addExtraAggregation(genquery);
        this.genBasicIV(genquery);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_group = true;
        this.PRE_printGroupInfo = true;
        this.PRE_printExtraAggr = true;
        QueryDefinition basequery = this.newPreIVReportQuery();
        this.addExtraAggregation(basequery);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.addTargetGroupInstance((IGroupInstanceInfo)new GroupInstanceInfo(1, 5));
        basequery.setQueryExecutionHints((IQueryExecutionHints)hints);
        basequery.setQueryResultsID(this.queryResultID);
        QueryDefinition query = new QueryDefinition();
        query.setSourceQuery((IBaseQueryDefinition)basequery);
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row.AMOUNT_1");
        sd.setSortDirection(0);
        query.addSort(sd);
        this._preBasicIV(query);
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void addExtraAggregation(QueryDefinition genquery) throws DataException {
        Binding binding1 = new Binding("Count_on_1st_group");
        binding1.setAggrFunction("COUNT");
        binding1.addAggregateOn("COUNTRY");
        Binding binding2 = new Binding("Count_on_2nd_group");
        binding2.setAggrFunction("COUNT");
        binding2.addAggregateOn("CITY");
        Binding binding3 = new Binding("Count_on_2nd_group_1");
        binding3.setExpression((IBaseExpression)new ScriptExpression("row.Count_on_2nd_group + 1"));
        Binding binding4 = new Binding("Count_on_2nd_group_1_2");
        binding4.setExpression((IBaseExpression)new ScriptExpression("row.Count_on_2nd_group_1+2"));
        Binding binding5 = new Binding("Count_on_1st_group_10");
        binding5.setExpression((IBaseExpression)new ScriptExpression("row.Count_on_1st_group + 10"));
        binding1.setDataType(2);
        binding2.setDataType(2);
        binding3.setDataType(3);
        binding4.setDataType(3);
        binding5.setDataType(3);
        genquery.addBinding((IBinding)binding1);
        genquery.addBinding((IBinding)binding2);
        genquery.addBinding((IBinding)binding3);
        genquery.addBinding((IBinding)binding4);
        genquery.addBinding((IBinding)binding5);
    }

    public void testBasicIV6() throws Exception {
        this.GEN_add_filter = false;
        this.GEN_add_group = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_filter = false;
        this.PRE_add_sort = false;
        this.PRE_add_group = false;
        this.preBasicIV();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_change_oldbinding = true;
        this.preBasicIV();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void genNotDistinctBasicIV(QueryDefinition qd) throws BirtException {
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            this.expectedValue.add(ri.getValue("COUNTRY_1"));
            this.expectedValue.add(ri.getValue("CITY_1"));
            this.expectedValue.add(ri.getValue("AMOUNT_1"));
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void genBasicIV(QueryDefinition qd) throws BirtException {
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(rowBeArray, totalBeArray, (BaseQueryDefinition)qd);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i = 0;
            while (i < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i]));
                ++i;
            }
            i = 0;
            while (i < totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i]));
                ++i;
            }
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    public void testSourceQueryWithDistinctAndAutoBinding() throws BirtException {
        QueryDefinition sourceQuery = this.newReportQuery();
        sourceQuery.setAutoBinding(true);
        QueryDefinition qd = new QueryDefinition();
        qd.setDistinctValue(true);
        qd.addBinding((IBinding)new Binding("CITY", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]")));
        IFilterDefinition[] filters = new IFilterDefinition[1];
        ArrayList<String> operandList = new ArrayList<String>();
        operandList.add("\"CHINA\"");
        filters[0] = new FilterDefinition((IBaseExpression)new ConditionalExpression("dataSetRow[\"COUNTRY\"]", 22, operandList));
        IFilterDefinition[] iFilterDefinitionArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterDefinition df = iFilterDefinitionArray[n2];
            qd.addFilter(df);
            ++n2;
        }
        qd.setSourceQuery((IBaseQueryDefinition)sourceQuery);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        ArrayList<String> cities = new ArrayList<String>();
        while (ri.next()) {
            cities.add(ri.getString("CITY"));
        }
        ViewingTest.assertTrue((boolean)Arrays.deepEquals(new String[]{"Beijing", "Shanghai"}, cities.toArray(new String[0])));
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void genBasicIV() throws BirtException {
        QueryDefinition qd = this.newGenIVReportQuery();
        this.genBasicIV(qd);
    }

    private void genNotDistinctBasicIV() throws BirtException {
        QueryDefinition qd = this.newGenIVReportQuery2();
        this.genNotDistinctBasicIV(qd);
    }

    private QueryDefinition newGenIVReportQuery2() {
        QueryDefinition qd = this.newReportQuery();
        qd.addResultSetExpression("COUNTRY_1", (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY"));
        qd.addResultSetExpression("CITY_1", (IBaseExpression)new ScriptExpression("dataSetRow.CITY"));
        qd.addResultSetExpression("AMOUNT_1", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        qd.setUsesDetails(this.GEN_useDetail);
        return qd;
    }

    private QueryDefinition newGenIVReportQuery() {
        GroupDefinition gd;
        ScriptExpression columnBindingExprGroup;
        String columnBindingNameGroup;
        ScriptExpression filterExpr;
        ScriptExpression columnBindingExprFilter;
        String columnBindingNameFilter;
        QueryDefinition qd = this.newReportQuery();
        if (this.GEN_add_filter) {
            columnBindingNameFilter = "AMOUNT_1";
            columnBindingExprFilter = new ScriptExpression("dataSetRow.AMOUNT");
            filterExpr = new ScriptExpression("row.AMOUNT_1>50");
            this.GEN_filterDefn = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addResultSetExpression(columnBindingNameFilter, (IBaseExpression)columnBindingExprFilter);
            qd.addFilter((IFilterDefinition)this.GEN_filterDefn);
        }
        if (this.GEN_make_empty) {
            columnBindingNameFilter = "AMOUNT_1";
            columnBindingExprFilter = new ScriptExpression("dataSetRow.AMOUNT");
            filterExpr = new ScriptExpression("row.AMOUNT_1<0");
            qd.addResultSetExpression(columnBindingNameFilter, (IBaseExpression)columnBindingExprFilter);
            qd.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        }
        String columnBindingNameSort = "CITY_1";
        ScriptExpression columnBindingExprSort = new ScriptExpression("dataSetRow.CITY");
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setColumn(columnBindingNameSort);
        qd.addResultSetExpression(columnBindingNameSort, (IBaseExpression)columnBindingExprSort);
        qd.addSort(sortDefn);
        if (this.GEN_add_group) {
            columnBindingNameGroup = "COUNTRY2";
            columnBindingExprGroup = new ScriptExpression("dataSetRow.COUNTRY");
            gd = new GroupDefinition("COUNTRY");
            gd.setKeyColumn("COUNTRY2");
            qd.addResultSetExpression(columnBindingNameGroup, (IBaseExpression)columnBindingExprGroup);
            qd.addGroup(gd);
        }
        if (this.GEN_add_secondGroup) {
            columnBindingNameGroup = "CITY2";
            columnBindingExprGroup = new ScriptExpression("dataSetRow.CITY");
            gd = new GroupDefinition("CITY");
            gd.setKeyColumn("CITY2");
            qd.addResultSetExpression(columnBindingNameGroup, (IBaseExpression)columnBindingExprGroup);
            qd.addGroup(gd);
        }
        qd.setUsesDetails(this.GEN_useDetail);
        qd.setIsSummaryQuery(this.GEN_isSummary);
        return qd;
    }

    private void preBasicIV() throws BirtException {
        QueryDefinition qd = this.newPreIVReportQuery();
        this._preBasicIV(qd);
    }

    private QueryDefinition newPreIVReportQuery() throws DataException {
        GroupDefinition gd;
        ScriptExpression columnBindingExprGroup;
        String columnBindingNameGroup;
        QueryDefinition qd = new QueryDefinition();
        if (this.GEN_add_filter) {
            qd.addFilter((IFilterDefinition)this.GEN_filterDefn);
        }
        if (this.PRE_add_filter) {
            ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1>200");
            FilterDefinition fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
        }
        if (this.PRE_add_sort) {
            SortDefinition sd = new SortDefinition();
            sd.setExpression("row.AMOUNT_1");
            sd.setSortDirection(0);
            qd.addSort(sd);
        }
        if (this.PRE_add_group) {
            columnBindingNameGroup = "COUNTRY2";
            columnBindingExprGroup = new ScriptExpression("dataSetRow.COUNTRY");
            gd = new GroupDefinition("COUNTRY");
            gd.setKeyColumn("COUNTRY2");
            qd.addResultSetExpression(columnBindingNameGroup, (IBaseExpression)columnBindingExprGroup);
            qd.addGroup(gd);
        }
        if (this.GEN_add_secondGroup) {
            columnBindingNameGroup = "CITY2";
            columnBindingExprGroup = new ScriptExpression("dataSetRow.CITY");
            gd = new GroupDefinition("CITY");
            gd.setKeyColumn("CITY2");
            qd.addResultSetExpression(columnBindingNameGroup, (IBaseExpression)columnBindingExprGroup);
            qd.addGroup(gd);
        }
        int i = 0;
        while (i < this.rowExprName.length) {
            if (this.PRE_change_oldbinding && i == this.rowExprName.length - 1) {
                qd.addResultSetExpression(this.rowExprName[i], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT+100"));
            } else {
                qd.addResultSetExpression(this.rowExprName[i], this.rowBeArray[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.totalExprName.length) {
            qd.addBinding(this.totalBeArray[i]);
            ++i;
        }
        return qd;
    }

    private void _preBasicIV(QueryDefinition qd) throws BirtException {
        qd.setQueryResultsID(this.queryResultID);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        IResultIterator ri = qr.getResultIterator();
        ri.moveTo(0);
        if (!ri.isEmpty()) {
            do {
                String abc = "";
                int i = 0;
                while (i < this.rowExprName.length) {
                    abc = String.valueOf(abc) + ri.getValue(this.rowExprName[i]) + "  ";
                    ++i;
                }
                i = 0;
                while (i < this.totalExprName.length) {
                    abc = String.valueOf(abc) + ri.getValue(this.totalExprName[i]) + "  ";
                    ++i;
                }
                if (this.PRE_printExtraAggr) {
                    abc = String.valueOf(abc) + ri.getValue("Count_on_1st_group") + "  " + ri.getValue("Count_on_2nd_group") + "  " + ri.getValue("Count_on_2nd_group_1") + "  " + ri.getValue("Count_on_2nd_group_1_2") + "  " + ri.getValue("Count_on_1st_group_10") + "  ";
                }
                if (this.PRE_printGroupInfo) {
                    this.testPrintln(String.valueOf(abc) + ri.getRowId() + " " + ri.getRowIndex() + " " + ri.getStartingGroupLevel() + " " + ri.getEndingGroupLevel());
                    continue;
                }
                this.testPrintln(String.valueOf(abc) + ri.getRowId());
            } while (ri.next());
        }
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private void _preBasicIV1(QueryDefinition qd) throws BirtException {
        HashMap<String, Integer> appContext = new HashMap<String, Integer>();
        appContext.put(DataEngine.MEMORY_BUFFER_SIZE, 10);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd, appContext).execute(null);
        IResultIterator ri = qr.getResultIterator();
        ri.moveTo(0);
        String abc = "";
        int i = 0;
        while (i < this.rowExprName.length) {
            abc = String.valueOf(abc) + this.rowExprName[i] + "  ";
            ++i;
        }
        i = 0;
        while (i < this.totalExprName.length) {
            abc = String.valueOf(abc) + this.totalExprName[i] + "  ";
            ++i;
        }
        if (qd.getGroups().size() > 0) {
            abc = String.valueOf(abc) + "starting level  ending level  ";
        }
        this.testPrintln(abc);
        do {
            abc = "";
            i = 0;
            while (i < this.rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.rowExprName[i]) + "  ";
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.totalExprName[i]) + "  ";
                ++i;
            }
            abc = String.valueOf(abc) + ri.getRowId();
            if (qd.getGroups().size() > 0) {
                abc = String.valueOf(abc) + "  " + ri.getStartingGroupLevel() + "  " + ri.getEndingGroupLevel();
            }
            this.testPrintln(abc);
        } while (ri.next());
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private void _preBasicIV2(QueryDefinition qd) throws BirtException {
        HashMap<String, Integer> appContext = new HashMap<String, Integer>();
        appContext.put(DataEngine.MEMORY_BUFFER_SIZE, 10);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd, appContext).execute(null);
        IResultIterator ri = qr.getResultIterator();
        String[] rowExprName = new String[]{"COUNTRY_1", "CITY_1", "AMOUNT_1"};
        ri.moveTo(0);
        String abc = "";
        int i = 0;
        while (i < rowExprName.length) {
            abc = String.valueOf(abc) + rowExprName[i] + "  ";
            ++i;
        }
        this.testPrintln(abc);
        do {
            abc = "";
            i = 0;
            while (i < rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(rowExprName[i]) + "  ";
                ++i;
            }
            abc = String.valueOf(abc) + ri.getRowId();
            this.testPrintln(abc);
        } while (ri.next());
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private void _preBasicIV4(QueryDefinition qd) throws BirtException {
        HashMap<String, Integer> appContext = new HashMap<String, Integer>();
        appContext.put(DataEngine.MEMORY_BUFFER_SIZE, 10);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd, appContext).execute(null);
        IResultIterator ri = qr.getResultIterator();
        String[] rowExprName = new String[]{"CITY"};
        ri.moveTo(0);
        String abc = "";
        int i = 0;
        while (i < rowExprName.length) {
            abc = String.valueOf(abc) + rowExprName[i] + "  ";
            ++i;
        }
        this.testPrintln(abc);
        do {
            abc = "";
            i = 0;
            while (i < rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(rowExprName[i]) + "  ";
                ++i;
            }
            abc = String.valueOf(abc) + ri.getRowId();
            this.testPrintln(abc);
        } while (ri.next());
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private void _preBasicIV3(QueryDefinition qd, String[] rowExprName) throws BirtException {
        HashMap<String, Integer> appContext = new HashMap<String, Integer>();
        appContext.put(DataEngine.MEMORY_BUFFER_SIZE, 10);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd, appContext).execute(null);
        IResultIterator ri = qr.getResultIterator();
        ri.moveTo(0);
        String abc = "";
        int i = 0;
        while (i < rowExprName.length) {
            abc = String.valueOf(abc) + rowExprName[i] + "  ";
            ++i;
        }
        this.testPrintln(abc);
        do {
            abc = "";
            i = 0;
            while (i < rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(rowExprName[i]) + "  ";
                ++i;
            }
            abc = String.valueOf(abc) + ri.getRowId();
            this.testPrintln(abc);
        } while (ri.next());
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    public void atestBasicIVSubQuery1() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName);
        deContext2.setTmpdir(ViewingTest.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_filter = true;
        this.PRE_add_sort = true;
        this._preBasicIVWithSubQuery();
        this.closeArchiveReader();
    }

    public void testBasicIVSubQuery() throws Exception {
        this.GEN_add_filter = false;
        this.GEN_add_group = true;
        this.GEN_subquery_on_group = true;
        this._genBasicIVWithSubQuery();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.PRE_add_filter = true;
        this.PRE_add_sort = true;
        this.PRE_add_group = true;
        this._preBasicIVWithSubQuery();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    private void _genBasicIVWithSubQuery() throws BirtException {
        QueryDefinition qd = this.newGenIVReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrExpr();
        this.prepareExprNameAndQuery(rowBeArray, totalBeArray, (BaseQueryDefinition)qd);
        SubqueryDefinition subqueryDefn = new SubqueryDefinition("IAMTEST", (IBaseQueryDefinition)qd);
        if (this.GEN_subquery_on_group) {
            ((GroupDefinition)qd.getGroups().get(0)).addSubquery(subqueryDefn);
            subqueryDefn.setApplyOnGroupFlag(true);
        } else {
            qd.addSubquery(subqueryDefn);
            subqueryDefn.setApplyOnGroupFlag(false);
        }
        this.subRowExprName = new String[3];
        this.subRowExprName[0] = "sub1";
        this.subRowExprName[1] = "sub2";
        this.subRowExprName[2] = "sub3";
        ScriptExpression[] exprs = new ScriptExpression[]{new ScriptExpression("row.__rownum"), new ScriptExpression("dataSetRow[\"AMOUNT\"]"), new ScriptExpression("dataSetRow[\"CITY\"]")};
        int i = 0;
        while (i < this.subRowExprName.length) {
            subqueryDefn.addResultSetExpression(this.subRowExprName[i], (IBaseExpression)exprs[i]);
            ++i;
        }
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            int i2 = 0;
            while (i2 < rowBeArray.length) {
                this.expectedValue.add(ri.getValue(this.rowExprName[i2]));
                ++i2;
            }
            i2 = 0;
            while (i2 < totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.totalExprName[i2]));
                ++i2;
            }
            IResultIterator subRi = ri.getSecondaryIterator("IAMTEST", (Scriptable)this.scope);
            while (subRi.next()) {
                int i3 = 0;
                while (i3 < this.subRowExprName.length) {
                    subRi.getValue(this.subRowExprName[i3]);
                    ++i3;
                }
            }
            subRi.close();
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
    }

    private void _preBasicIVWithSubQuery() throws BirtException {
        QueryDefinition qd = this.newPreIVReportQuery();
        qd.setQueryResultsID(this.queryResultID);
        SubqueryDefinition subqueryDefn = new SubqueryDefinition("IAMTEST", (IBaseQueryDefinition)qd);
        ((GroupDefinition)qd.getGroups().get(0)).addSubquery(subqueryDefn);
        this.subRowExprName = new String[3];
        this.subRowExprName[0] = "sub1";
        this.subRowExprName[1] = "sub2";
        this.subRowExprName[2] = "sub3";
        ScriptExpression[] exprs = new ScriptExpression[]{new ScriptExpression("row.__rownum"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.CITY")};
        int i = 0;
        while (i < this.subRowExprName.length) {
            subqueryDefn.addResultSetExpression(this.subRowExprName[i], (IBaseExpression)exprs[i]);
            ++i;
        }
        subqueryDefn.setApplyOnGroupFlag(true);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        IResultIterator ri = qr.getResultIterator();
        ri.moveTo(0);
        do {
            String abc = "";
            int i2 = 0;
            while (i2 < this.rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.rowExprName[i2]) + "  ";
                ++i2;
            }
            i2 = 0;
            while (i2 < this.totalExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.totalExprName[i2]) + "  ";
                ++i2;
            }
            this.testPrintln(String.valueOf(abc) + ri.getRowId());
            IResultIterator subRi = ri.getSecondaryIterator("IAMTEST", (Scriptable)this.scope);
            while (subRi.next()) {
                abc = "          [" + subRi.getValue("sub1") + "]" + "[" + subRi.getValue("sub2") + "]" + "[" + subRi.getValue("sub2") + "]" + "  " + subRi.getRowId();
                this.testPrintln(abc);
            }
        } while (ri.next());
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private IBaseExpression[] getRowExpr() {
        int num = 4;
        this.rowBeArray = new IBaseExpression[num];
        this.rowBeArray[0] = new ScriptExpression("dataSetRow.COUNTRY");
        this.rowBeArray[1] = new ScriptExpression("dataSetRow.CITY");
        this.rowBeArray[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        this.rowBeArray[3] = new ScriptExpression("dataSetRow.AMOUNT");
        this.rowExprName = new String[this.rowBeArray.length];
        this.rowExprName[0] = "COUNTRY_1";
        this.rowExprName[1] = "CITY_1";
        this.rowExprName[2] = "SALE_NAME_1";
        this.rowExprName[3] = "AMOUNT_1";
        return this.rowBeArray;
    }

    private IBinding[] getAggrExpr() throws DataException {
        int num2 = 2;
        this.totalExprName = new String[num2];
        this.totalExprName[0] = "TOTAL_COUNT_1";
        this.totalExprName[1] = "TOTAL_AMOUNT_1";
        this.totalBeArray = new IBinding[num2];
        this.totalBeArray[0] = new Binding(this.totalExprName[0]);
        this.totalBeArray[0].setAggrFunction("COUNT");
        this.totalBeArray[1] = new Binding(this.totalExprName[1], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        this.totalBeArray[1].setAggrFunction("SUM");
        return this.totalBeArray;
    }

    private void prepareExprNameAndQuery(IBaseExpression[] rowBeArray, IBinding[] totalBeArray, BaseQueryDefinition qd) throws DataException {
        int num = rowBeArray.length;
        int num2 = totalBeArray.length;
        int i = 0;
        while (i < num) {
            qd.addResultSetExpression(this.rowExprName[i], rowBeArray[i]);
            ++i;
        }
        i = 0;
        while (i < num2) {
            qd.addBinding(totalBeArray[i]);
            ++i;
        }
    }

    @Override
    protected boolean useFolderArchive() {
        return true;
    }
}

