/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.rd;

import com.ibm.icu.util.TimeZone;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.rd.RDTestCase;
import org.mozilla.javascript.Scriptable;
import testutil.ConfigText;

public class ViewingTest2
extends RDTestCase {
    private String GEN_queryResultID;
    private String UPDATE_queryResultID;
    private boolean notIncludeAggr;
    private String[] rowExprName;
    private String[] totalExprName;
    private String updateNewBindingName;
    private IBaseExpression updateNewBindingExpr;
    private boolean add_subquery_on_query;
    private boolean USE_ROW_IN_AGGREGATION;
    private boolean USE_DATE_IN_COLUMNBINDING;
    private boolean GEN_add_filter;
    private boolean GEN_add_topN_filter;
    private boolean GEN_add_group;
    private boolean GEN_add_group1 = false;
    private boolean GEN_add_subquery;
    private boolean GEN_add_sort;
    private boolean GEN_print;
    private boolean GEN_use_invalid_column;
    private boolean GEN_USE_RUNNING_AGGR;
    private int UPDATE_add_filter;
    private boolean UPDATE_add_sort;
    private boolean UPDATE_add_same_group;
    private boolean UPDATE_add_diff_group;
    private int UPDATE_add_subquery;
    private int PRE_add_filter;
    private boolean PRE_add_sort;
    private boolean PRE_execute_query;
    private boolean PRE_print_groupinfo;
    private boolean PRE_use_skipto;
    private int PRE_use_skipto_num;
    private boolean PRE_basedon_genfilter;
    private List GEN_filterDefn;
    private List UPDATE_filterDefn;
    private boolean TEST_ISEMPTY;
    private static final int UPDATE = 1;
    private static final int PRESENTATION = 2;
    private static final String subQueryName1 = "IAMTEST1";
    private String[] subRowExprName1;
    private static final String subQueryName2 = "IAMTEST2";
    private String[] subRowExprName2;
    private int PRE_add_group;
    private boolean usesDetails = true;
    private TimeZone currentTimeZone = TimeZone.getDefault();
    private boolean USE_DATE_IN_SUBQUERY;

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    @Override
    protected boolean useFolderArchive() {
        return true;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.notIncludeAggr = false;
        this.add_subquery_on_query = false;
        this.USE_ROW_IN_AGGREGATION = false;
        this.GEN_queryResultID = null;
        this.UPDATE_queryResultID = null;
        this.USE_DATE_IN_COLUMNBINDING = true;
        this.GEN_add_subquery = false;
        this.GEN_add_sort = true;
        this.GEN_add_filter = false;
        this.GEN_add_group = false;
        this.GEN_print = false;
        this.GEN_USE_RUNNING_AGGR = false;
        this.GEN_use_invalid_column = false;
        this.UPDATE_add_filter = -1;
        this.UPDATE_add_sort = false;
        this.UPDATE_add_diff_group = false;
        this.UPDATE_add_same_group = false;
        this.UPDATE_add_subquery = 0;
        this.USE_DATE_IN_SUBQUERY = false;
        this.PRE_add_filter = -1;
        this.PRE_add_sort = false;
        this.PRE_execute_query = false;
        this.PRE_print_groupinfo = false;
        this.PRE_use_skipto = false;
        this.PRE_use_skipto_num = -1;
        this.PRE_add_group = -1;
        this.PRE_basedon_genfilter = false;
        this.GEN_filterDefn = new ArrayList();
        this.UPDATE_filterDefn = new ArrayList();
        this.TEST_ISEMPTY = false;
        TimeZone.setDefault((TimeZone)TimeZone.getTimeZone((String)"GMT+0"));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.myPreDataEngine != null) {
            this.myPreDataEngine.shutdown();
            this.myPreDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
            this.myPreDataEngine = null;
        }
        if (this.myPreDataEngine2 != null) {
            this.myPreDataEngine2.shutdown();
            this.myPreDataEngine2.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
            this.myPreDataEngine2 = null;
        }
        super.tearDown();
        TimeZone.setDefault((TimeZone)this.currentTimeZone);
    }

    public void testBasic() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_print = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_add_filter = 0;
        this.PRE_add_sort = true;
        this.PRE_execute_query = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testBasic1() throws Exception {
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testNestedQuery() throws Exception {
        List ids = this.genBasicNestedQuery();
        this.preBasicNestedQuery(ids);
        this.checkOutputFile();
    }

    public void testComplexNestedQuery() throws Exception {
        List ids = this.genComplexNestedQuery();
        this.preComplexNestedQuery(ids);
        this.checkOutputFile();
    }

    public void testBasic2() throws Exception {
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_use_skipto = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testBasic3() throws Exception {
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.PRE_print_groupinfo = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testBasic4() throws Exception {
        QueryDefinition qd = this.newReportQuery();
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        ri.moveTo(3);
        ri.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        qd.setQueryResultsID(this.GEN_queryResultID);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        ri.moveTo(3);
        ri.close();
        this.myPreDataEngine.shutdown();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        qd.setQueryResultsID(this.UPDATE_queryResultID);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        ri.moveTo(3);
        ri.close();
        this.myPreDataEngine.shutdown();
        this.closeArchiveReader();
        this.closeArchiveWriter();
    }

    public void testBasic5() throws Exception {
        this.GEN_add_filter = false;
        this.GEN_print = true;
        this.GEN_add_sort = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_basedon_genfilter = true;
        this.PRE_add_filter = -1;
        this.PRE_add_sort = false;
        this.preBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        this.checkOutputFile();
    }

    public void testBasic6() throws Exception {
        this.GEN_print = true;
        this.GEN_add_filter = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.checkOutputFile();
    }

    public void testBasic7() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_group1 = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        this.checkOutputFile();
    }

    public void testBasic8() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_group1 = true;
        this.GEN_USE_RUNNING_AGGR = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        this.checkOutputFile();
    }

    public void testBasic9() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_group1 = true;
        this.GEN_USE_RUNNING_AGGR = true;
        int initialPostion1 = -1;
        QueryDefinition qd = this.newGenIVReportQuery();
        qd.setUsesDetails(true);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        initialPostion1 = ri.getRowIndex();
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.myGenDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        qd = this.newPreIVReportQuery(this.UPDATE_add_filter, this.UPDATE_add_sort, -1, 1);
        qd.setUsesDetails(true);
        qd.setQueryResultsID(this.GEN_queryResultID);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        int initialPostion2 = ri.getRowIndex();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        ViewingTest2.assertTrue((initialPostion1 == initialPostion2 && initialPostion2 == 0 ? 1 : 0) != 0);
    }

    public void testBasic31() throws Exception {
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.PRE_print_groupinfo = true;
        this.PRE_use_skipto = true;
        this.PRE_use_skipto_num = 2;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testBasicNotDetail() throws Exception {
        this.usesDetails = false;
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_use_skipto = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testBasicNotDetail2() throws Exception {
        this.usesDetails = false;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_print_groupinfo = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testBasicNotDetail3() throws Exception {
        this.usesDetails = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 5;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testBasicNotDetail4() throws Exception {
        this.GEN_add_filter = false;
        this.GEN_add_group = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = -1;
        this.UPDATE_add_sort = true;
        this.UPDATE_add_diff_group = false;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_add_sort = true;
        this.PRE_add_group = 0;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void atestUpdateGroup() throws Exception {
        this.GEN_add_group = true;
        this.GEN_add_subquery = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_diff_group = true;
        this.UPDATE_add_subquery = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.PRE_print_groupinfo = true;
        this.PRE_use_skipto = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testAggregationOnRow() throws Exception {
        this.USE_ROW_IN_AGGREGATION = true;
        this.GEN_add_filter = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_sort = false;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_add_filter = 0;
        this.PRE_execute_query = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testIsEmptyTrue() throws Exception {
        this.TEST_ISEMPTY = true;
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
    }

    public void testUpdateNewColumnBinding() throws Exception {
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.updateNewBindingExpr = new ScriptExpression("row.COUNTRY_1");
        this.updateNewBindingName = "COUNTRY_2";
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.PRE_print_groupinfo = true;
        this.PRE_use_skipto = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testUpdateNewAggrBinding() throws Exception {
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.updateNewBindingExpr = new ScriptExpression("Total.sum( row.AMOUNT_1 )");
        this.updateNewBindingName = "TOTAL_AMOUT_BINDING";
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.PRE_print_groupinfo = true;
        this.PRE_use_skipto = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testMultiUpdate() throws Exception {
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.UPDATE_add_filter = 1;
        this.UPDATE_add_same_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext4 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext4);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testMultiUpdate2() throws Exception {
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.UPDATE_add_filter = 1;
        this.UPDATE_add_same_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext4 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext4);
        this.UPDATE_add_filter = 1;
        this.UPDATE_add_same_group = false;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext5 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext5);
        this.UPDATE_add_filter = -1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext6 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext6);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testFilters1() throws Exception {
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 1;
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_add_sort = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testFilters2() throws Exception {
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_add_sort = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testFilters3() throws Exception {
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 1;
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_add_filter = 2;
        this.PRE_execute_query = true;
        this.PRE_add_sort = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testFilters4() throws Exception {
        this.GEN_add_filter = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_sort = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_add_filter = 2;
        this.PRE_execute_query = true;
        this.PRE_basedon_genfilter = true;
        this.PRE_add_sort = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testFilters5() throws Exception {
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 4;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.PRE_add_sort = true;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testFilters6() throws Exception {
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 5;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testFilters7() throws Exception {
        this.GEN_add_topN_filter = true;
        this.GEN_print = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 7;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testGroup() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_sort = true;
        this.UPDATE_add_diff_group = true;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSortGroup() throws Exception {
        this.GEN_add_filter = false;
        this.GEN_add_group = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = -1;
        this.UPDATE_add_sort = true;
        this.UPDATE_add_diff_group = false;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_add_sort = true;
        this.PRE_add_group = 0;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSubQuery() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.GEN_add_subquery = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_sort = true;
        this.UPDATE_add_same_group = true;
        this.UPDATE_add_subquery = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSubQuery2() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.GEN_add_subquery = true;
        this.GEN_print = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 3;
        this.UPDATE_add_sort = true;
        this.UPDATE_add_same_group = true;
        this.UPDATE_add_subquery = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSubQuery3() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.GEN_add_subquery = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.UPDATE_add_subquery = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_basedon_genfilter = true;
        this.PRE_add_group = 0;
        this.UPDATE_add_subquery = 1;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSubQuery4() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.GEN_add_subquery = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.UPDATE_add_subquery = 2;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_basedon_genfilter = true;
        this.PRE_add_group = 0;
        this.UPDATE_add_subquery = 2;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSubQuery5() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.GEN_add_subquery = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.UPDATE_add_subquery = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_basedon_genfilter = true;
        this.PRE_add_group = 0;
        this.UPDATE_add_subquery = 2;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSubQuery6() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.GEN_add_subquery = false;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_same_group = true;
        this.UPDATE_add_subquery = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = true;
        this.PRE_basedon_genfilter = true;
        this.PRE_add_group = 0;
        this.UPDATE_add_subquery = 2;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSubQuery7() throws Exception {
        this.GEN_add_filter = true;
        this.GEN_add_group = true;
        this.GEN_add_subquery = true;
        this.USE_DATE_IN_COLUMNBINDING = false;
        this.USE_DATE_IN_SUBQUERY = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 0;
        this.UPDATE_add_sort = true;
        this.UPDATE_add_same_group = true;
        this.UPDATE_add_subquery = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testSubQuery8() throws Exception {
        this.add_subquery_on_query = true;
        this.notIncludeAggr = true;
        this.GEN_add_sort = false;
        this.TEST_ISEMPTY = true;
        this.genBasicIV();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_filter = 6;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(2, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
    }

    public void testInvalidColumn() throws Exception {
        try {
            this.GEN_use_invalid_column = true;
            this.genBasicIV();
            ViewingTest2.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {
            this.closeArchiveWriter();
        }
    }

    public void testDiskCacheColumnBinding() throws Exception {
        String initialStr = System.getProperty("birt.data.engine.test.memcachesize");
        System.setProperty("birt.data.engine.test.memcachesize", "2");
        this.incomprehensiveColumnBinding();
        if (initialStr == null) {
            System.getProperties().remove("birt.data.engine.test.memcachesize");
        } else {
            System.setProperty("birt.data.engine.test.memcachesize", initialStr);
        }
    }

    public void testMemoryCacheColumnBinding() throws Exception {
        this.incomprehensiveColumnBinding();
    }

    private void incomprehensiveColumnBinding() throws BirtException, DataException, IOException {
        File file = new File(this.fileName);
        if (file.exists()) {
            file.delete();
        }
        this.GEN_add_group = true;
        this.GEN_add_subquery = true;
        this.GEN_print = true;
        this.USE_DATE_IN_COLUMNBINDING = false;
        this.genBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        if (this.myPreDataEngine != null) {
            this.myPreDataEngine.shutdown();
            this.myPreDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        }
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        this.UPDATE_add_same_group = true;
        this.UPDATE_add_subquery = 1;
        this.updatePreBasicIV();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        this.myPreDataEngine.shutdown();
        DataEngineContext deContext3 = this.newContext(2, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        this.PRE_execute_query = false;
        this.preBasicIV();
        this.checkOutputFile();
        this.myPreDataEngine.shutdown();
    }

    public void testEmptyResult() throws BirtException {
        try {
            QueryDefinition qd1 = this.newReportQuery();
            IBaseExpression[] rowBeArray = this.getRowExpr();
            IBinding[] totalBeArray = this.getAggrExpr();
            this.populateColumnBinding(qd1, rowBeArray, totalBeArray);
            qd1.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
            IQueryResults qr1 = this.myGenDataEngine.prepare((IQueryDefinition)qd1).execute((Scriptable)this.scope);
            this.GEN_queryResultID = qr1.getID();
            IResultIterator ri1 = qr1.getResultIterator();
            while (ri1.next()) {
                String abc = "";
                int i = 0;
                while (i < this.rowExprName.length) {
                    abc = String.valueOf(abc) + ri1.getValue(this.rowExprName[i]) + "  ";
                    ++i;
                }
                i = 0;
                while (i < this.totalExprName.length) {
                    abc = String.valueOf(abc) + ri1.getValue(this.totalExprName[i]) + "  ";
                    ++i;
                }
            }
            ri1.close();
            this.myGenDataEngine.shutdown();
            this.closeArchiveWriter();
            DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
            this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
            QueryDefinition qd2 = this.newReportQuery();
            this.populateColumnBinding(qd2, rowBeArray, totalBeArray);
            qd2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
            SortDefinition sortDefn = new SortDefinition();
            sortDefn.setColumn("CITY_1");
            qd2.addSort(sortDefn);
            qd2.setQueryResultsID(this.GEN_queryResultID);
            IQueryResults qr2 = this.myPreDataEngine.prepare((IQueryDefinition)qd2).execute((Scriptable)this.scope);
            IResultIterator ri2 = qr2.getResultIterator();
            while (ri2.next()) {
                String abc = "";
                int i = 0;
                while (i < this.rowExprName.length) {
                    abc = String.valueOf(abc) + ri2.getValue(this.rowExprName[i]) + "  ";
                    ++i;
                }
                i = 0;
                while (i < this.totalExprName.length) {
                    abc = String.valueOf(abc) + ri2.getValue(this.totalExprName[i]) + "  ";
                    ++i;
                }
            }
            ri2.close();
            this.myPreDataEngine.shutdown();
            this.closeArchiveReader();
            this.closeArchiveWriter();
        }
        catch (Exception exception) {
            ViewingTest2.fail((String)"should not arrive here");
        }
    }

    private void populateColumnBinding(QueryDefinition qd1, IBaseExpression[] rowBeArray, IBinding[] totalBeArray) throws DataException {
        int i = 0;
        while (i < rowBeArray.length) {
            qd1.addResultSetExpression(this.rowExprName[i], rowBeArray[i]);
            ++i;
        }
        i = 0;
        while (i < totalBeArray.length) {
            qd1.addBinding(totalBeArray[i]);
            ++i;
        }
    }

    private List genBasicNestedQuery() throws BirtException {
        QueryDefinition qd1 = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrExpr();
        this.populateColumnBinding(qd1, rowBeArray, totalBeArray);
        IQueryResults qr1 = this.myGenDataEngine.prepare((IQueryDefinition)qd1).execute((Scriptable)this.scope);
        QueryDefinition qd2 = this.newReportQuery();
        this.populateColumnBinding(qd2, rowBeArray, totalBeArray);
        ConditionalExpression filterExpr = new ConditionalExpression("row._outer[\"CITY_1\"]", 1, "\"Shanghai\"");
        qd2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        IPreparedQuery preparedQuery = this.myGenDataEngine.prepare((IQueryDefinition)qd2);
        this.GEN_queryResultID = qr1.getID();
        ArrayList<String> nestedQueryResultId = new ArrayList<String>();
        IResultIterator ri1 = qr1.getResultIterator();
        while (ri1.next()) {
            String abc = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                abc = String.valueOf(abc) + ri1.getValue(this.rowExprName[i]) + "  ";
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                abc = String.valueOf(abc) + ri1.getValue(this.totalExprName[i]) + "  ";
                ++i;
            }
            this.testPrintln(abc);
            IQueryResults qr = preparedQuery.execute(qr1, (Scriptable)this.scope);
            nestedQueryResultId.add(qr.getID());
            IResultIterator subRi = qr.getResultIterator();
            while (subRi.next()) {
                abc = "      ";
                int i2 = 0;
                while (i2 < this.rowExprName.length) {
                    abc = String.valueOf(abc) + subRi.getValue(this.rowExprName[i2]) + "  ";
                    ++i2;
                }
                this.testPrintln(abc);
            }
            subRi.close();
        }
        this.testPrintln("");
        ri1.close();
        qr1.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        return nestedQueryResultId;
    }

    private void preBasicNestedQuery(List ids) throws BirtException, DataException {
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrExpr();
        QueryDefinition qd = new QueryDefinition();
        this.populateColumnBinding(qd, rowBeArray, totalBeArray);
        qd.setQueryResultsID(this.GEN_queryResultID);
        QueryDefinition qd2 = this.newReportQuery();
        this.populateColumnBinding(qd2, rowBeArray, totalBeArray);
        ConditionalExpression filterExpr = new ConditionalExpression("row._outer[\"CITY_1\"]", 1, "\"Shanghai\"");
        qd2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyColumn("COUNTRY_1");
        qd2.addGroup(gd);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ViewingTest2.assertTrue((qr.getResultMetaData() != null ? 1 : 0) != 0);
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        do {
            String abc = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.rowExprName[i]) + "  ";
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.totalExprName[i]) + "  ";
                ++i;
            }
            this.testPrintln(String.valueOf(abc) + ri.getRowId());
            qd2.setQueryResultsID(ids.get(0).toString());
            ids.remove(0);
            IResultIterator subRi = this.myPreDataEngine.prepare((IQueryDefinition)qd2).execute(qr, null).getResultIterator();
            while (subRi.next()) {
                abc = "      ";
                int i2 = 0;
                while (i2 < this.rowExprName.length) {
                    abc = String.valueOf(abc) + subRi.getValue(this.rowExprName[i2]) + "  ";
                    ++i2;
                }
                this.testPrintln(abc);
            }
        } while (ri.next());
        this.testPrintln("");
        ri.close();
        this.myPreDataEngine.shutdown();
        this.closeArchiveReader();
        this.closeArchiveWriter();
    }

    public void testDummyQuery() throws Exception {
        QueryDefinition qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.addResultSetExpression("def", (IBaseExpression)new ScriptExpression("2"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            abc = String.valueOf(abc) + ri.getValue("def") + "  ";
            this.testPrintln(abc);
        }
        ri.close();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.addResultSetExpression("def", (IBaseExpression)new ScriptExpression("2"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        qd.setQueryResultsID(this.UPDATE_queryResultID);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        ri = qr.getResultIterator();
        this.UPDATE_queryResultID = qr.getID();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            abc = String.valueOf(abc) + ri.getValue("def") + "  ";
            this.testPrintln(abc);
        }
        ri.close();
        this.checkOutputFile();
    }

    public void testDummyQueryWithSubQuery1() throws Exception {
        QueryDefinition qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        SubqueryDefinition sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        qd.addSubquery(sub);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.addResultSetExpression("def", (IBaseExpression)new ScriptExpression("2"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        sub.addResultSetExpression("def1", (IBaseExpression)new ScriptExpression("2.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            abc = String.valueOf(abc) + ri.getValue("def") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                abc = String.valueOf(abc) + subRi.getValue("def1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.addResultSetExpression("def", (IBaseExpression)new ScriptExpression("2"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        qd.setQueryResultsID(this.UPDATE_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        sub.addResultSetExpression("def1", (IBaseExpression)new ScriptExpression("2.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        ri = qr.getResultIterator();
        this.UPDATE_queryResultID = qr.getID();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            abc = String.valueOf(abc) + ri.getValue("def") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                abc = String.valueOf(abc) + subRi.getValue("def1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.checkOutputFile();
    }

    public void testDummyQueryWithSubQuery2() throws Exception {
        QueryDefinition qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        SubqueryDefinition sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        qd.addSubquery(sub);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.addResultSetExpression("def", (IBaseExpression)new ScriptExpression("2"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            abc = String.valueOf(abc) + ri.getValue("def") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.addResultSetExpression("def", (IBaseExpression)new ScriptExpression("2"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        qd.setQueryResultsID(this.UPDATE_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        ri = qr.getResultIterator();
        this.UPDATE_queryResultID = qr.getID();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            abc = String.valueOf(abc) + ri.getValue("def") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.checkOutputFile();
    }

    public void testDummyQueryWithSubQuery3() throws Exception {
        QueryDefinition qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        SubqueryDefinition sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        qd.addSubquery(sub);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        sub.addResultSetExpression("def1", (IBaseExpression)new ScriptExpression("2.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                abc = String.valueOf(abc) + subRi.getValue("def1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        qd.setQueryResultsID(this.UPDATE_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        sub.addResultSetExpression("def1", (IBaseExpression)new ScriptExpression("2.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        ri = qr.getResultIterator();
        this.UPDATE_queryResultID = qr.getID();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                abc = String.valueOf(abc) + subRi.getValue("def1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.checkOutputFile();
    }

    public void testDummyQueryWithSubQuery4() throws Exception {
        QueryDefinition qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        SubqueryDefinition sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        qd.addSubquery(sub);
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        sub.addResultSetExpression("def1", (IBaseExpression)new ScriptExpression("2.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                abc = String.valueOf(abc) + subRi.getValue("def1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext3 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext3);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        sub.addResultSetExpression("def1", (IBaseExpression)new ScriptExpression("2.1"));
        sub.addResultSetExpression("ghi1", (IBaseExpression)new ScriptExpression("3.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                abc = String.valueOf(abc) + subRi.getValue("def1");
                abc = String.valueOf(abc) + subRi.getValue("ghi1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.closeArchiveReader();
        this.closeArchiveWriter();
        DataEngineContext deContext4 = this.newContext(4, this.fileName, this.fileName);
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext4);
        qd = new QueryDefinition();
        qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("1"));
        qd.setQueryResultsID(this.GEN_queryResultID);
        qd.setQueryResultsID(this.UPDATE_queryResultID);
        sub = new SubqueryDefinition("sub", (IBaseQueryDefinition)qd);
        sub.addResultSetExpression("abc1", (IBaseExpression)new ScriptExpression("1.1"));
        sub.addResultSetExpression("def1", (IBaseExpression)new ScriptExpression("2.1"));
        sub.addResultSetExpression("ghi1", (IBaseExpression)new ScriptExpression("3.1"));
        qd.addSubquery(sub);
        qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        ri = qr.getResultIterator();
        this.UPDATE_queryResultID = qr.getID();
        while (ri.next()) {
            String abc = "";
            abc = String.valueOf(abc) + ri.getValue("abc") + "  ";
            this.testPrintln(abc);
            IResultIterator subRi = ri.getSecondaryIterator("sub", (Scriptable)this.scope);
            abc = "                   ";
            while (subRi.next()) {
                abc = String.valueOf(abc) + subRi.getValue("abc1");
                abc = String.valueOf(abc) + subRi.getValue("def1");
                abc = String.valueOf(abc) + subRi.getValue("ghi1");
                this.testPrintln(abc);
            }
            subRi.close();
        }
        ri.close();
        this.checkOutputFile();
    }

    private List genComplexNestedQuery() throws BirtException {
        QueryDefinition qd1 = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrExpr();
        this.populateColumnBinding(qd1, rowBeArray, totalBeArray);
        IQueryResults qr1 = this.myGenDataEngine.prepare((IQueryDefinition)qd1).execute((Scriptable)this.scope);
        QueryDefinition qd2 = this.newReportQuery();
        this.populateColumnBinding(qd2, rowBeArray, totalBeArray);
        ConditionalExpression filterExpr = new ConditionalExpression("row._outer[\"CITY_1\"]", 1, "\"Shanghai\"");
        qd2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        IPreparedQuery preparedQuery2 = this.myGenDataEngine.prepare((IQueryDefinition)qd2);
        QueryDefinition qd3 = this.newReportQuery();
        this.populateColumnBinding(qd3, rowBeArray, totalBeArray);
        ConditionalExpression filterExpr1 = new ConditionalExpression("row._outer[\"CITY_1\"]", 1, "\"Beijing\"");
        qd3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr1));
        IPreparedQuery preparedQuery3 = this.myGenDataEngine.prepare((IQueryDefinition)qd3);
        this.GEN_queryResultID = qr1.getID();
        ArrayList<String> nestedQueryResultId = new ArrayList<String>();
        IResultIterator ri1 = qr1.getResultIterator();
        while (ri1.next()) {
            String abc = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                abc = String.valueOf(abc) + ri1.getValue(this.rowExprName[i]) + "  ";
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                abc = String.valueOf(abc) + ri1.getValue(this.totalExprName[i]) + "  ";
                ++i;
            }
            this.testPrintln(abc);
            IQueryResults qr2 = preparedQuery2.execute(qr1, (Scriptable)this.scope);
            nestedQueryResultId.add(qr2.getID());
            IResultIterator subRi1 = qr2.getResultIterator();
            while (subRi1.next()) {
                abc = "      ";
                int i2 = 0;
                while (i2 < this.rowExprName.length) {
                    abc = String.valueOf(abc) + subRi1.getValue(this.rowExprName[i2]) + "  ";
                    ++i2;
                }
                this.testPrintln(abc);
                IQueryResults qr3 = preparedQuery3.execute(qr2, (Scriptable)this.scope);
                nestedQueryResultId.add(qr3.getID());
                IResultIterator subRi2 = qr3.getResultIterator();
                while (subRi2.next()) {
                    abc = "      \t\t";
                    int i3 = 0;
                    while (i3 < this.rowExprName.length) {
                        abc = String.valueOf(abc) + subRi2.getValue(this.rowExprName[i3]) + "  ";
                        ++i3;
                    }
                    this.testPrintln(abc);
                }
                subRi2.close();
            }
            subRi1.close();
        }
        this.testPrintln("");
        ri1.close();
        qr1.close();
        this.myGenDataEngine.shutdown();
        this.closeArchiveWriter();
        return nestedQueryResultId;
    }

    private void preComplexNestedQuery(List ids) throws BirtException, DataException {
        DataEngineContext deContext2 = this.newContext(4, this.fileName, this.fileName);
        deContext2.setTmpdir(ViewingTest2.getTempDir());
        this.myPreDataEngine = DataEngine.newDataEngine((DataEngineContext)deContext2);
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrExpr();
        QueryDefinition qd = new QueryDefinition();
        this.populateColumnBinding(qd, rowBeArray, totalBeArray);
        qd.setQueryResultsID(this.GEN_queryResultID);
        QueryDefinition qd2 = this.newReportQuery();
        this.populateColumnBinding(qd2, rowBeArray, totalBeArray);
        ConditionalExpression filterExpr = new ConditionalExpression("row._outer[\"CITY_1\"]", 1, "\"Shanghai\"");
        qd2.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr));
        QueryDefinition qd3 = this.newReportQuery();
        this.populateColumnBinding(qd3, rowBeArray, totalBeArray);
        ConditionalExpression filterExpr1 = new ConditionalExpression("row._outer[\"CITY_1\"]", 1, "\"Beijing\"");
        qd3.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)filterExpr1));
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyColumn("COUNTRY_1");
        qd3.addGroup(gd);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        ViewingTest2.assertTrue((qr.getResultMetaData() != null ? 1 : 0) != 0);
        IResultIterator ri = qr.getResultIterator();
        ri.next();
        do {
            String abc = "";
            int i = 0;
            while (i < this.rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.rowExprName[i]) + "  ";
                ++i;
            }
            i = 0;
            while (i < this.totalExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.totalExprName[i]) + "  ";
                ++i;
            }
            this.testPrintln(String.valueOf(abc) + ri.getRowId());
            qd2.setQueryResultsID(ids.get(0).toString());
            ids.remove(0);
            IQueryResults qr2 = this.myPreDataEngine.prepare((IQueryDefinition)qd2).execute(qr, null);
            IResultIterator subRi1 = qr2.getResultIterator();
            while (subRi1.next()) {
                abc = "      ";
                int i2 = 0;
                while (i2 < this.rowExprName.length) {
                    abc = String.valueOf(abc) + subRi1.getValue(this.rowExprName[i2]) + "  ";
                    ++i2;
                }
                this.testPrintln(abc);
                qd3.setQueryResultsID(ids.get(0).toString());
                ids.remove(0);
                IResultIterator subRi2 = this.myPreDataEngine.prepare((IQueryDefinition)qd3).execute(qr2, null).getResultIterator();
                while (subRi2.next()) {
                    abc = "      \t\t";
                    int i3 = 0;
                    while (i3 < this.rowExprName.length) {
                        abc = String.valueOf(abc) + subRi2.getValue(this.rowExprName[i3]) + "  ";
                        ++i3;
                    }
                    this.testPrintln(abc);
                }
            }
        } while (ri.next());
        this.testPrintln("");
        ri.close();
        qr.close();
        this.myPreDataEngine.shutdown();
        this.closeArchiveReader();
        this.closeArchiveWriter();
    }

    private void genBasicIV() throws BirtException {
        int i;
        QueryDefinition qd = this.newGenIVReportQuery();
        if (!this.usesDetails) {
            qd.setUsesDetails(false);
        }
        IQueryResults qr = this.myGenDataEngine.prepare((IQueryDefinition)qd).execute((Scriptable)this.scope);
        this.GEN_queryResultID = qr.getID();
        IResultIterator ri = qr.getResultIterator();
        while (ri.next()) {
            String abc = "";
            int i2 = 0;
            while (i2 < this.rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.rowExprName[i2]) + "  ";
                ++i2;
            }
            if (!this.notIncludeAggr) {
                i2 = 0;
                while (i2 < this.totalExprName.length) {
                    abc = String.valueOf(abc) + ri.getValue(this.totalExprName[i2]) + "  ";
                    ++i2;
                }
            }
            if (this.GEN_print) {
                this.testPrintln(abc);
            }
            if (!this.GEN_add_subquery) continue;
            IResultIterator subRi = ri.getSecondaryIterator(subQueryName1, (Scriptable)this.scope);
            while (subRi.next()) {
                abc = "      ";
                i = 0;
                while (i < this.subRowExprName1.length) {
                    abc = String.valueOf(abc) + subRi.getValue(this.subRowExprName1[i]) + "  ";
                    ++i;
                }
                if (!this.USE_DATE_IN_SUBQUERY) continue;
                abc = String.valueOf(abc) + subRi.getValue("sub4");
            }
            subRi.close();
        }
        if (this.add_subquery_on_query) {
            IResultIterator subRi = ri.getSecondaryIterator(subQueryName1, (Scriptable)this.scope);
            String abc = "      ";
            i = 0;
            while (i < this.subRowExprName1.length) {
                abc = String.valueOf(abc) + subRi.getValue(this.subRowExprName1[i]) + "  ";
                ++i;
            }
            if (this.GEN_print) {
                this.testPrintln(abc);
            }
            while (subRi.next()) {
                abc = "      ";
                i = 0;
                while (i < this.subRowExprName1.length) {
                    abc = String.valueOf(abc) + subRi.getValue(this.subRowExprName1[i]) + "  ";
                    ++i;
                }
                this.testPrintln(abc);
            }
        }
        if (this.GEN_print) {
            this.testPrintln("");
        }
        ri.close();
        qr.close();
        this.myGenDataEngine.shutdown();
        this.myGenDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
    }

    private QueryDefinition newGenIVReportQuery() throws DataException {
        FilterDefinition filterDefn;
        QueryDefinition qd = this.newReportQuery();
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrExpr();
        int i = 0;
        while (i < rowBeArray.length) {
            qd.addResultSetExpression(this.rowExprName[i], rowBeArray[i]);
            ++i;
        }
        if (this.GEN_use_invalid_column) {
            qd.addResultSetExpression("abc", (IBaseExpression)new ScriptExpression("dataSetRow.def"));
        }
        if (!this.notIncludeAggr) {
            i = 0;
            while (i < totalBeArray.length) {
                qd.addBinding(totalBeArray[i]);
                ++i;
            }
        }
        if (this.GEN_add_filter) {
            ConditionalExpression filterExpr = new ConditionalExpression("row.AMOUNT_1", 6, "50");
            filterDefn = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)filterDefn);
            this.GEN_filterDefn.add(filterDefn);
        }
        if (this.GEN_add_topN_filter) {
            ConditionalExpression filterExpr = new ConditionalExpression("row.AMOUNT_1", 14, "5");
            filterDefn = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)filterDefn);
            filterDefn.setFilterTarget(IFilterDefinition.FilterTarget.DATASET);
            this.GEN_filterDefn.add(filterDefn);
        }
        if (this.TEST_ISEMPTY) {
            ConditionalExpression filterExpr = new ConditionalExpression("row.AMOUNT_1 - row.AMOUNT_1", 6, "50");
            filterDefn = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)filterDefn);
            this.GEN_filterDefn.add(filterDefn);
        }
        if (this.GEN_add_sort) {
            SortDefinition sortDefn = new SortDefinition();
            sortDefn.setColumn("CITY_1");
            qd.addSort(sortDefn);
        }
        if (this.GEN_add_group) {
            GroupDefinition gd = new GroupDefinition();
            gd.setKeyColumn("COUNTRY_1");
            qd.addGroup(gd);
            if (this.GEN_add_subquery) {
                SubqueryDefinition subqueryDefn = this.getSubQueryDefn(qd);
                gd.addSubquery(subqueryDefn);
            }
        }
        if (this.GEN_add_group1) {
            GroupDefinition gd = new GroupDefinition();
            gd.setKeyColumn("CITY_1");
            qd.addGroup(gd);
            gd = new GroupDefinition();
            gd.setKeyColumn("AMOUNT_1");
            qd.addGroup(gd);
        }
        if (this.add_subquery_on_query) {
            qd.addSubquery(this.getSubQueryDefn(qd));
        }
        return qd;
    }

    private SubqueryDefinition getSubQueryDefn(QueryDefinition qd) {
        SubqueryDefinition subqueryDefn = new SubqueryDefinition(subQueryName1, (IBaseQueryDefinition)qd);
        this.subRowExprName1 = new String[3];
        this.subRowExprName1[0] = "sub1";
        this.subRowExprName1[1] = "sub2";
        this.subRowExprName1[2] = "sub3";
        ScriptExpression[] exprs = new ScriptExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.AMOUNT")};
        int i = 0;
        while (i < this.subRowExprName1.length) {
            subqueryDefn.addResultSetExpression(this.subRowExprName1[i], (IBaseExpression)exprs[i]);
            ++i;
        }
        if (this.USE_DATE_IN_SUBQUERY) {
            subqueryDefn.addResultSetExpression("sub4", (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE"));
        }
        subqueryDefn.setApplyOnGroupFlag(true);
        return subqueryDefn;
    }

    private void updatePreBasicIV() throws BirtException {
        int groupNeeded = -1;
        if (this.UPDATE_add_diff_group) {
            groupNeeded = 1;
        } else if (this.UPDATE_add_same_group) {
            groupNeeded = 0;
        }
        QueryDefinition qd = this.newPreIVReportQuery(this.UPDATE_add_filter, this.UPDATE_add_sort, groupNeeded, 1);
        if (!this.usesDetails) {
            qd.setUsesDetails(false);
        }
        qd.setQueryResultsID(this.GEN_queryResultID);
        IQueryResults qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
        this.UPDATE_queryResultID = qr.getID();
        this.displayPreResult(qr, false, false);
    }

    private void preBasicIV() throws BirtException {
        IQueryResults qr = null;
        if (this.PRE_execute_query) {
            QueryDefinition qd = this.newPreIVReportQuery(this.PRE_add_filter, this.PRE_add_sort, this.PRE_add_group, 2);
            if (!this.usesDetails) {
                qd.setUsesDetails(false);
            }
            qd.setQueryResultsID(this.UPDATE_queryResultID);
            qr = this.myPreDataEngine.prepare((IQueryDefinition)qd).execute(null);
            this.UPDATE_queryResultID = qr.getID();
        } else {
            qr = this.myPreDataEngine.getQueryResults(this.UPDATE_queryResultID);
        }
        this.displayPreResult(qr, this.PRE_print_groupinfo, this.PRE_use_skipto);
    }

    private void displayPreResult(IQueryResults qr, boolean printGroupInfo, boolean useSkipTo) throws BirtException {
        ViewingTest2.assertTrue((qr.getResultMetaData() != null ? 1 : 0) != 0);
        IResultIterator ri = qr.getResultIterator();
        if (useSkipTo) {
            if (this.PRE_use_skipto_num == -1) {
                ri.moveTo(0);
            } else {
                ri.moveTo(this.PRE_use_skipto_num);
            }
        } else {
            ri.next();
        }
        do {
            int i;
            String abc = "";
            int i2 = 0;
            while (i2 < this.rowExprName.length) {
                abc = String.valueOf(abc) + ri.getValue(this.rowExprName[i2]) + "  ";
                ++i2;
            }
            if (!this.notIncludeAggr) {
                i2 = 0;
                while (i2 < this.totalExprName.length) {
                    abc = String.valueOf(abc) + ri.getValue(this.totalExprName[i2]) + "  ";
                    ++i2;
                }
            }
            if (this.updateNewBindingName != null && this.updateNewBindingExpr != null) {
                abc = String.valueOf(abc) + ri.getValue(this.updateNewBindingName) + " ";
            }
            if (printGroupInfo) {
                abc = String.valueOf(abc) + ri.getStartingGroupLevel() + " ";
            }
            this.testPrintln(String.valueOf(abc) + ri.getRowId() + (this.GEN_add_group1 ? " " + ri.getStartingGroupLevel() + ":" + ri.getEndingGroupLevel() : ""));
            if (this.UPDATE_add_subquery == 1) {
                IResultIterator subRi = ri.getSecondaryIterator(subQueryName1, (Scriptable)this.scope);
                while (subRi.next()) {
                    abc = "      ";
                    i = 0;
                    while (i < this.subRowExprName1.length) {
                        abc = String.valueOf(abc) + subRi.getValue(this.subRowExprName1[i]) + "  ";
                        ++i;
                    }
                    if (this.USE_DATE_IN_SUBQUERY) {
                        abc = String.valueOf(abc) + subRi.getValue("sub4");
                    }
                    this.testPrintln(abc);
                }
            }
            if (this.UPDATE_add_subquery == 2) {
                IResultIterator subRi = ri.getSecondaryIterator(subQueryName2, (Scriptable)this.scope);
                while (subRi.next()) {
                    abc = "      ";
                    i = 0;
                    while (i < this.subRowExprName2.length) {
                        abc = String.valueOf(abc) + subRi.getValue(this.subRowExprName2[i]) + "  ";
                        ++i;
                    }
                    this.testPrintln(abc);
                }
            }
            if (!this.add_subquery_on_query) continue;
            IResultIterator subRi = ri.getSecondaryIterator(subQueryName1, (Scriptable)this.scope);
            abc = "      ";
            i = 0;
            while (i < this.subRowExprName1.length) {
                abc = String.valueOf(abc) + subRi.getValue(this.subRowExprName1[i]) + "  ";
                ++i;
            }
            this.testPrintln(abc);
            while (subRi.next()) {
                abc = "      ";
                i = 0;
                while (i < this.subRowExprName1.length) {
                    abc = String.valueOf(abc) + subRi.getValue(this.subRowExprName1[i]) + "  ";
                    ++i;
                }
                this.testPrintln(abc);
            }
        } while (ri.next());
        if (this.TEST_ISEMPTY) {
            ViewingTest2.assertTrue((boolean)ri.isEmpty());
        } else {
            ViewingTest2.assertFalse((boolean)ri.isEmpty());
        }
        this.testPrintln("");
        ri.close();
        this.myPreDataEngine.shutdown();
    }

    private QueryDefinition newPreIVReportQuery(int filterNeeded, boolean sortNeeded, int groupNeeded, int mode) throws DataException {
        FilterDefinition fd;
        QueryDefinition qd = new QueryDefinition();
        qd.setDataSetName("Dummy");
        IBaseExpression[] rowBeArray = this.getRowExpr();
        IBinding[] totalBeArray = this.getAggrExpr();
        int i = 0;
        while (i < rowBeArray.length) {
            qd.addResultSetExpression(this.rowExprName[i], rowBeArray[i]);
            ++i;
        }
        i = 0;
        while (i < totalBeArray.length) {
            qd.addBinding(totalBeArray[i]);
            ++i;
        }
        if (this.updateNewBindingName != null && this.updateNewBindingName.trim().length() > 0) {
            qd.addResultSetExpression(this.updateNewBindingName, this.updateNewBindingExpr);
        }
        if (mode == 1) {
            qd.getFilters().addAll(this.GEN_filterDefn);
        } else if (mode == 2) {
            if (!this.PRE_basedon_genfilter) {
                qd.getFilters().addAll(this.UPDATE_filterDefn);
            } else {
                qd.getFilters().addAll(this.GEN_filterDefn);
            }
        }
        if (filterNeeded == 0) {
            ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1>200");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
        }
        if (filterNeeded == 1) {
            ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1>50");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
            filterExpr = new ScriptExpression("row.AMOUNT_1<7000");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
        }
        if (filterNeeded == 2) {
            ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1>50");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
            filterExpr = new ScriptExpression("row.AMOUNT_1<700");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
        }
        if (filterNeeded == 3) {
            ScriptExpression filterExpr = new ScriptExpression("row.AMOUNT_1>200");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
            filterExpr = new ScriptExpression("row.COUNTRY_1==\"US\"");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
        }
        if (filterNeeded == 4) {
            ConditionalExpression filterExpr = new ConditionalExpression("row.SALE_NAME_1", 1, "\"2004-01-01 00:00:00+" + TimeZone.getDefault().getRawOffset() / 3600000 + "\"");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
        }
        if (filterNeeded == 5) {
            ConditionalExpression filterExpr = new ConditionalExpression("row.AMOUNT_1", 14, "3");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
        }
        if (filterNeeded == 6) {
            ScriptExpression filterExpr = new ScriptExpression("row.COUNTRY_1 == \"ABC\"");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            qd.addFilter((IFilterDefinition)fd);
        }
        if (filterNeeded == 7) {
            ConditionalExpression filterExpr = new ConditionalExpression("row.AMOUNT_1", 15, "1");
            fd = new FilterDefinition((IBaseExpression)filterExpr);
            fd.setFilterTarget(IFilterDefinition.FilterTarget.RESULTSET);
            qd.addFilter((IFilterDefinition)fd);
        }
        this.UPDATE_filterDefn = qd.getFilters();
        if (sortNeeded) {
            SortDefinition sd = new SortDefinition();
            sd.setExpression("row.AMOUNT_1");
            sd.setSortDirection(0);
            qd.addSort(sd);
        }
        if (groupNeeded == 1 || groupNeeded == 0) {
            SubqueryDefinition subqueryDefn;
            GroupDefinition gd = null;
            if (groupNeeded == 1) {
                gd = new GroupDefinition("Agroup");
                gd.setKeyColumn("AMOUNT_1");
                qd.addGroup(gd);
            } else if (groupNeeded == 0) {
                gd = new GroupDefinition();
                gd.setKeyColumn("COUNTRY_1");
                qd.addGroup(gd);
            }
            if (this.UPDATE_add_subquery == 1) {
                subqueryDefn = this.getSubQueryDefn(qd);
                gd.addSubquery(subqueryDefn);
            }
            if (this.UPDATE_add_subquery == 2) {
                subqueryDefn = new SubqueryDefinition(subQueryName2, (IBaseQueryDefinition)qd);
                this.subRowExprName2 = new String[2];
                this.subRowExprName2[0] = "sub1";
                this.subRowExprName2[1] = "sub2";
                ScriptExpression[] exprs = new ScriptExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
                int i2 = 0;
                while (i2 < this.subRowExprName2.length) {
                    subqueryDefn.addResultSetExpression(this.subRowExprName2[i2], (IBaseExpression)exprs[i2]);
                    ++i2;
                }
                subqueryDefn.setApplyOnGroupFlag(true);
                gd.addSubquery(subqueryDefn);
            }
        }
        if (this.add_subquery_on_query) {
            qd.addSubquery(this.getSubQueryDefn(qd));
        }
        return qd;
    }

    private IBaseExpression[] getRowExpr() {
        IBaseExpression[] rowBeArray;
        if (this.USE_DATE_IN_COLUMNBINDING) {
            int num = 4;
            rowBeArray = new IBaseExpression[num];
            rowBeArray[0] = new ScriptExpression("dataSetRow.COUNTRY");
            rowBeArray[1] = new ScriptExpression("dataSetRow.CITY");
            rowBeArray[2] = new ScriptExpression("dataSetRow.SALE_DATE");
            rowBeArray[3] = new ScriptExpression("dataSetRow.AMOUNT");
            this.rowExprName = new String[rowBeArray.length];
            this.rowExprName[0] = "COUNTRY_1";
            this.rowExprName[1] = "CITY_1";
            this.rowExprName[2] = "SALE_NAME_1";
            this.rowExprName[3] = "AMOUNT_1";
        } else {
            int num = 3;
            rowBeArray = new IBaseExpression[num];
            rowBeArray[0] = new ScriptExpression("dataSetRow.COUNTRY");
            rowBeArray[1] = new ScriptExpression("dataSetRow.CITY");
            rowBeArray[2] = new ScriptExpression("dataSetRow.AMOUNT");
            this.rowExprName = new String[rowBeArray.length];
            this.rowExprName[0] = "COUNTRY_1";
            this.rowExprName[1] = "CITY_1";
            this.rowExprName[2] = "AMOUNT_1";
        }
        return rowBeArray;
    }

    private IBinding[] getAggrExpr() throws DataException {
        if (this.notIncludeAggr) {
            return new IBinding[0];
        }
        this.totalExprName = new String[2];
        this.totalExprName[0] = "TOTAL_COUNT_1";
        this.totalExprName[1] = "TOTAL_AMOUNT_1";
        int num2 = 2;
        IBinding[] totalBeArray = new IBinding[num2];
        totalBeArray[0] = new Binding(this.totalExprName[0], (IBaseExpression)new ScriptExpression(null));
        if (this.GEN_USE_RUNNING_AGGR) {
            totalBeArray[0].setAggrFunction("runningcount");
        } else {
            totalBeArray[0].setAggrFunction("count");
        }
        totalBeArray[1] = this.USE_ROW_IN_AGGREGATION ? new Binding(this.totalExprName[1], (IBaseExpression)new ScriptExpression("row.AMOUNT_1")) : new Binding(this.totalExprName[1], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        if (this.GEN_USE_RUNNING_AGGR) {
            totalBeArray[1].setAggrFunction("runningsum");
        } else {
            totalBeArray[1].setAggrFunction("sum");
        }
        return totalBeArray;
    }
}

