/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.testdriver.TestAdvQueryImpl;
import org.eclipse.birt.data.engine.odaconsumer.testdriver.TestConnectionImpl;
import org.eclipse.birt.data.engine.odaconsumer.testdriver.TestDriverImpl;
import org.eclipse.birt.data.engine.odaconsumer.testutil.OdaTestDriverCase;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class AppContextTest
extends OdaTestDriverCase {
    private Properties sm_appContextMap;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (this.sm_appContextMap == null) {
            this.sm_appContextMap = new Properties();
            this.sm_appContextMap.put("org.eclipse.birt.data.engine.odaconsumer.testdriver", this.getConnectionManager());
            this.sm_appContextMap.put("org.eclipse.birt.data.engine.odaconsumer.TestDriverImpl.connstate", "");
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.sm_appContextMap.put("org.eclipse.birt.data.engine.odaconsumer.TestDriverImpl.connstate", "");
    }

    public void testSetAppContext() {
        String testCase = "1";
        this.verifyDriverSetAppContext(testCase);
        Connection hostConn = null;
        PreparedStatement hostStmt = null;
        Object queryContext = null;
        try {
            hostConn = this.getConnectionManager().openConnection("org.eclipse.birt.data.engine.odaconsumer.testdriver", null, (Map)this.sm_appContextMap);
            AppContextTest.assertTrue((hostConn != null ? 1 : 0) != 0);
            hostStmt = hostConn.prepareStatement(null, testCase);
            AppContextTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            boolean execStatus = hostStmt.execute();
            AppContextTest.assertTrue((boolean)execStatus);
            queryContext = hostStmt.getParameterValue(1);
        }
        catch (DataException e1) {
            AppContextTest.fail((String)("testSetAppContext failed: " + e1.toString()));
        }
        AppContextTest.assertTrue((queryContext != null ? 1 : 0) != 0);
        AppContextTest.assertEquals((String)this.sm_appContextMap.toString(), (String)queryContext.toString());
    }

    public void testSetAppContextOpenConnection() {
        this.sm_appContextMap.put("org.eclipse.birt.data.engine.odaconsumer.TestDriverImpl.connstate", "isOpen");
        Connection hostConn = null;
        PreparedStatement hostStmt = null;
        Object queryContext = null;
        try {
            hostConn = this.getConnectionManager().openConnection("org.eclipse.birt.data.engine.odaconsumer.testdriver", null, (Map)this.sm_appContextMap);
            AppContextTest.assertTrue((hostConn != null ? 1 : 0) != 0);
            hostStmt = hostConn.prepareStatement(null, "1");
            AppContextTest.assertTrue((hostStmt != null ? 1 : 0) != 0);
            boolean execStatus = hostStmt.execute();
            AppContextTest.assertTrue((boolean)execStatus);
            queryContext = hostStmt.getParameterValue(1);
        }
        catch (DataException e1) {
            AppContextTest.fail((String)("testSetAppContextOpenConnection failed: " + e1.toString()));
        }
        AppContextTest.assertTrue((queryContext != null ? 1 : 0) != 0);
        AppContextTest.assertEquals((String)this.sm_appContextMap.toString(), (String)queryContext.toString());
    }

    private void verifyDriverSetAppContext(String testCase) {
        TestDriverImpl odaDriver = new TestDriverImpl();
        try {
            odaDriver.setAppContext(this.sm_appContextMap);
        }
        catch (OdaException odaException) {
            AppContextTest.fail((String)"The ODA driver tester is not properly setup.");
        }
        Object driverContext = odaDriver.getAppContext();
        AppContextTest.assertTrue((driverContext != null ? 1 : 0) != 0);
        AppContextTest.assertTrue((driverContext == this.sm_appContextMap ? 1 : 0) != 0);
        AppContextTest.assertEquals((String)this.sm_appContextMap.toString(), (String)driverContext.toString());
        IConnection odaConn = null;
        try {
            odaConn = odaDriver.getConnection(null);
            odaConn.setAppContext((Object)this.sm_appContextMap);
        }
        catch (OdaException odaException) {
            AppContextTest.fail((String)"The ODA driver tester is not properly setup.");
        }
        driverContext = ((TestConnectionImpl)odaConn).getAppContext();
        AppContextTest.assertTrue((driverContext != null ? 1 : 0) != 0);
        AppContextTest.assertTrue((driverContext == this.sm_appContextMap ? 1 : 0) != 0);
        AppContextTest.assertEquals((String)this.sm_appContextMap.toString(), (String)driverContext.toString());
        IQuery odaQuery = null;
        try {
            odaQuery = odaConn.newQuery(testCase);
            odaQuery.setAppContext((Object)this.sm_appContextMap);
        }
        catch (OdaException odaException) {
            AppContextTest.fail((String)"The ODA driver tester is not properly setup.");
        }
        driverContext = ((TestAdvQueryImpl)odaQuery).getAppContext();
        AppContextTest.assertTrue((driverContext != null ? 1 : 0) != 0);
        AppContextTest.assertTrue((driverContext == this.sm_appContextMap ? 1 : 0) != 0);
        AppContextTest.assertEquals((String)this.sm_appContextMap.toString(), (String)driverContext.toString());
    }
}

