/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.birt.data.engine.odaconsumer.OdaconsumerTestCase;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.connectivity.oda.util.manifest.RuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.TraceLogging;

public class ManifestExplorerTest
extends OdaconsumerTestCase {
    private final String m_jdbcId = "org.eclipse.birt.report.data.oda.jdbc";
    private final String m_expectedJdbcDataSetId = "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet";
    private final String m_testDriverId = "org.eclipse.birt.data.engine.odaconsumer.testdriver";
    private static Object[][] sm_mappings = new Object[][]{{new Integer(-7), "BIT", "Integer"}, {new Integer(-6), "TINYINT", "Integer"}, {new Integer(5), "SMALLINT", "Integer"}, {new Integer(4), "INTEGER", "Integer"}, {new Integer(-5), "BIGINT", "Decimal"}, {new Integer(6), "FLOAT", "Double"}, {new Integer(7), "REAL", "Double"}, {new Integer(8), "DOUBLE", "Double"}, {new Integer(2), "NUMERIC", "Decimal"}, {new Integer(3), "DECIMAL", "Decimal"}, {new Integer(1), "CHAR", "String"}, {new Integer(12), "VARCHAR", "String"}, {new Integer(-1), "LONGVARCHAR", "String"}, {new Integer(91), "DATE", "Date"}, {new Integer(92), "TIME", "Time"}, {new Integer(93), "TIMESTAMP", "Timestamp"}, {new Integer(-2), "BINARY", "Blob"}, {new Integer(-3), "VARBINARY", "Blob"}, {new Integer(-4), "LONGVARBINARY", "Blob"}, {new Integer(16), "BOOLEAN", "Boolean"}};

    public void testGetDataSourceNames() throws Exception {
        Properties names = ManifestExplorer.getInstance().getDataSourceIdentifiers();
        ManifestExplorerTest.assertNotNull((Object)names.getProperty("org.eclipse.birt.data.engine.odaconsumer.testdriver"));
    }

    public void testGetExtensionConfigs() throws Exception {
        ExtensionManifest[] configs = ManifestExplorer.getInstance().getExtensionManifests();
        ManifestExplorerTest.assertTrue((configs.length > 0 ? 1 : 0) != 0);
    }

    public void testGetExtensionConfig() throws Exception {
        ExtensionManifest config = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.birt.report.data.oda.jdbc");
        this.verifyExtensionConfig(config);
    }

    public void testGetExtensionConfigCompatibility() throws Exception {
        ExtensionManifest config = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.birt.report.data.oda.jdbc");
        this.verifyExtensionConfig(config);
    }

    void verifyExtensionConfig(ExtensionManifest config) throws Exception {
        ManifestExplorerTest.assertNotNull((Object)config);
        ManifestExplorerTest.assertEquals((String)"org.eclipse.birt.report.data.oda.jdbc", (String)config.getDataSourceElementID());
        ManifestExplorerTest.assertEquals((String)"JDBC Data Source", (String)config.getDataSourceDisplayName());
        ManifestExplorerTest.assertEquals((String)"3.1", (String)config.getOdaVersion());
        RuntimeInterface runtime = config.getRuntimeInterface();
        ManifestExplorerTest.assertTrue((boolean)(runtime instanceof JavaRuntimeInterface));
        JavaRuntimeInterface javaRuntime = (JavaRuntimeInterface)runtime;
        ManifestExplorerTest.assertEquals((String)"org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver", (String)javaRuntime.getDriverClass());
        ManifestExplorerTest.assertFalse((boolean)javaRuntime.needSetThreadContextClassLoader());
        ManifestExplorerTest.assertEquals((int)1, (int)javaRuntime.getInterfaceType());
        ManifestExplorerTest.assertTrue((javaRuntime.getLibraryLocation().toString().indexOf("org.eclipse.birt.report.data.oda.jdbc") > 0 ? 1 : 0) != 0);
        TraceLogging traceLogging = config.getTraceLogging();
        ManifestExplorerTest.assertNull((Object)traceLogging);
        this.myTestGetExtensionProperties(config);
        String[] dataSetTypeIds = config.getDataSetTypeIDs();
        ManifestExplorerTest.assertTrue((dataSetTypeIds.length == 2 ? 1 : 0) != 0);
        ManifestExplorerTest.assertEquals((String)"org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet", (String)dataSetTypeIds[0]);
        this.myTestGetDataSetTypes(config);
    }

    void myTestGetExtensionProperties(ExtensionManifest config) {
        Property[] dataSourceProps = config.getProperties();
        ManifestExplorerTest.assertTrue((dataSourceProps.length >= 5 ? 1 : 0) != 0);
        Hashtable<String, Property> propsList = new Hashtable<String, Property>(dataSourceProps.length);
        int i = 0;
        while (i < dataSourceProps.length) {
            Property prop = dataSourceProps[i];
            propsList.put(prop.getName(), prop);
            ++i;
        }
        String expectedGroupName = "connectionProperties";
        String expectedGroupDisplayName = "Connection Properties";
        Property aProp = (Property)propsList.get("odaDriverClass");
        this.myTestPropertyAttributes(aProp, "JDBC Driver &Class", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
        aProp = (Property)propsList.get("odaURL");
        this.myTestPropertyAttributes(aProp, "JDBC Driver U&RL", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
        aProp = (Property)propsList.get("odaDataSource");
        this.myTestPropertyAttributes(aProp, "Data Source", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
        aProp = (Property)propsList.get("odaUser");
        this.myTestPropertyAttributes(aProp, "User &Name", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
        aProp = (Property)propsList.get("odaPassword");
        this.myTestPropertyAttributes(aProp, "Pass&word", expectedGroupName, expectedGroupDisplayName, "string", true, null, true);
    }

    void myTestPropertyAttributes(Property aProp, String expectedDisplayName, String expectedGroupName, String expectedGroupDisplayName, String expectedType, boolean expectedInheritability, String expectedDefaultValue, boolean expectedIsEncryptable) {
        ManifestExplorerTest.assertNotNull((Object)aProp);
        ManifestExplorerTest.assertEquals((String)expectedDisplayName, (String)aProp.getDisplayName());
        ManifestExplorerTest.assertEquals((String)expectedGroupName, (String)aProp.getGroupName());
        ManifestExplorerTest.assertEquals((String)expectedGroupDisplayName, (String)aProp.getGroupDisplayName());
        ManifestExplorerTest.assertEquals((String)expectedType, (String)aProp.getType());
        ManifestExplorerTest.assertEquals((boolean)expectedInheritability, (boolean)aProp.canInherit());
        ManifestExplorerTest.assertEquals((String)expectedDefaultValue, (String)aProp.getDefaultValue());
        ManifestExplorerTest.assertEquals((boolean)expectedIsEncryptable, (boolean)aProp.isEncryptable());
    }

    void myTestGetDataSetTypes(ExtensionManifest config) throws Exception {
        DataSetType[] dataSetTypes = config.getDataSetTypes();
        ManifestExplorerTest.assertTrue((dataSetTypes.length == 2 ? 1 : 0) != 0);
        DataSetType dataSetType = config.getDataSetType("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ManifestExplorerTest.assertEquals((String)"org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet", (String)dataSetType.getID());
        ManifestExplorerTest.assertEquals((String)"SQL Select Query", (String)dataSetType.getDisplayName());
        int i = 0;
        int n = sm_mappings.length;
        while (i < n) {
            Integer s = (Integer)sm_mappings[i][0];
            DataTypeMapping mapping = dataSetType.getDataTypeMapping((int)s.shortValue());
            ManifestExplorerTest.assertNotNull((Object)mapping);
            ManifestExplorerTest.assertEquals((int)s, (int)mapping.getNativeTypeCode());
            ManifestExplorerTest.assertEquals((Object)sm_mappings[i][1], (Object)mapping.getNativeType());
            ManifestExplorerTest.assertEquals((Object)sm_mappings[i][2], (Object)mapping.getOdaScalarDataType());
            ManifestExplorerTest.assertTrue((mapping.getAlternativeOdaDataTypes().length == 0 ? 1 : 0) != 0);
            ++i;
        }
        Property[] dataSetProps = dataSetType.getProperties();
        ManifestExplorerTest.assertEquals((int)1, (int)dataSetProps.length);
        String expectedGroupName = "queryProperties";
        String expectedGroupDisplayName = "Query Properties";
        Property aProp = dataSetProps[0];
        ManifestExplorerTest.assertEquals((String)"queryTimeOut", (String)aProp.getName());
        this.myTestPropertyAttributes(aProp, "&Query Time Out (in seconds)", expectedGroupName, expectedGroupDisplayName, "string", true, null, false);
    }
}

