/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.sql.DriverManager;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.OdaconsumerTestCase;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class ParamAndColumnHintTest
extends OdaconsumerTestCase {
    private Connection m_connection;
    private PreparedStatement m_statement;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.m_statement != null) {
            this.m_statement.close();
        }
        if (this.m_connection != null) {
            this.m_connection.close();
        }
        super.tearDown();
    }

    public final void testSetParamValueRetryWithParamHint() throws DataException {
        String queryText = "select acInt from acdatatypes where acInt > ? ";
        this.m_statement = this.getLocalMySqlConnection().prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("param1", true, false);
        hint.setPosition(2);
        hint.setDataType(Date.class);
        hint.setNativeDataType(4);
        this.m_statement.addParameterHint(hint);
        try {
            this.m_statement.setParameterValue(2, (Object)"0");
        }
        catch (DataException ex) {
            ParamAndColumnHintTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.CannotSetIntParameter");
        }
    }

    public final void testSetParamValueRetryWithTimestampParamHint() throws DataException {
        String queryText = "select acTimestamp from acdatatypes where acTimestamp > ? ";
        this.m_statement = this.getLocalMySqlConnection().prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("param1", true, false);
        hint.setPosition(2);
        hint.setDataType(Date.class);
        hint.setNativeDataType(93);
        this.m_statement.addParameterHint(hint);
        try {
            this.m_statement.setParameterValue(2, (Object)"1999-12-31 03:13:00.001");
        }
        catch (DataException ex) {
            ParamAndColumnHintTest.assertEquals((String)ex.getErrorCode(), (String)"odaconsumer.CannotSetTimestampParameter");
        }
    }

    public final void testFetchWithTimestampHint() throws DataException {
        String queryText = "select acDate, acTimestamp from acdatatypes where acTimestamp > ? ";
        this.m_statement = this.getLocalMySqlConnection().prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("param1", true, false);
        hint.setPosition(1);
        hint.setDataType(Date.class);
        hint.setNativeDataType(93);
        this.m_statement.addParameterHint(hint);
        Timestamp ts = Timestamp.valueOf("1999-12-31 03:13:00");
        this.m_statement.setParameterValue(1, (Object)ts);
        ColumnHint columnHint = new ColumnHint("acTimestamp");
        columnHint.setDataType(Integer.class);
        columnHint.setNativeDataType(93);
        this.m_statement.addColumnHint(columnHint);
        this.m_statement.execute();
        ResultSet resultSet = this.m_statement.getResultSet();
        IResultObject resultObject = null;
        int numRows = 0;
        while ((resultObject = resultSet.fetch()) != null) {
            ++numRows;
            ParamAndColumnHintTest.assertEquals(Timestamp.class, (Object)resultObject.getResultClass().getFieldValueClass("acTimestamp"));
            Object value = resultObject.getFieldValue("acTimestamp");
            ParamAndColumnHintTest.assertTrue((boolean)(value instanceof Timestamp));
        }
        ParamAndColumnHintTest.assertEquals((int)4, (int)numRows);
    }

    public final void testFetchWithTimeHint() throws DataException {
        String queryText = "select acDate, acTime, acTimestamp from acTimeDataTypes  where acTime > ? ";
        this.m_statement = this.getLocalMySqlConnection().prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("param1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setNativeDataType(92);
        this.m_statement.addParameterHint(hint);
        Time timeValue = Time.valueOf("03:13:00");
        this.m_statement.setParameterValue(1, (Object)timeValue);
        ColumnHint columnHint = new ColumnHint("acTime");
        columnHint.setDataType(Integer.class);
        columnHint.setNativeDataType(92);
        this.m_statement.addColumnHint(columnHint);
        this.m_statement.execute();
        ResultSet resultSet = this.m_statement.getResultSet();
        IResultObject resultObject = null;
        while ((resultObject = resultSet.fetch()) != null) {
            ParamAndColumnHintTest.assertEquals(Time.class, (Object)resultObject.getResultClass().getFieldValueClass("acTime"));
            Object value = resultObject.getFieldValue("acTime");
            ParamAndColumnHintTest.assertTrue((boolean)(value instanceof Time));
        }
    }

    public final void testFetchWithDateHint() throws DataException {
        String queryText = "select acDate, acTime, acTimestamp from acTimeDataTypes  where acDate < ? ";
        this.m_statement = this.getLocalMySqlConnection().prepareStatement(queryText, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ParameterHint hint = new ParameterHint("param1", true, false);
        hint.setPosition(1);
        hint.setDataType(Integer.class);
        hint.setNativeDataType(91);
        this.m_statement.addParameterHint(hint);
        Timestamp ts = Timestamp.valueOf("2000-10-13 03:13:00");
        this.m_statement.setParameterValue(1, (Object)ts);
        ColumnHint columnHint = new ColumnHint("acDate");
        columnHint.setDataType(Integer.class);
        this.m_statement.addColumnHint(columnHint);
        this.m_statement.execute();
        ResultSet resultSet = this.m_statement.getResultSet();
        IResultObject resultObject = null;
        int numRows = 0;
        while ((resultObject = resultSet.fetch()) != null) {
            ++numRows;
            ParamAndColumnHintTest.assertEquals(java.sql.Date.class, (Object)resultObject.getResultClass().getFieldValueClass("acDate"));
            Object value = resultObject.getFieldValue("acDate");
            ParamAndColumnHintTest.assertTrue((boolean)(value instanceof java.sql.Date));
        }
        ParamAndColumnHintTest.assertEquals((int)0, (int)numRows);
    }

    private Properties getLocalMySqlConnProperties() {
        Properties connProperties = new Properties();
        connProperties.setProperty("odaURL", "jdbc:mysql://birtdb2-w2k:3306/acTestDb");
        connProperties.setProperty("odaUser", "nnTest");
        connProperties.setProperty("odaPassword", "nTest");
        connProperties.setProperty("odaDriverClass", "com.mysql.jdbc.Driver");
        return connProperties;
    }

    private Connection getLocalMySqlConnection() throws DataException {
        if (this.m_connection != null) {
            return this.m_connection;
        }
        this.m_connection = ConnectionManager.getInstance().openConnection("org.eclipse.birt.report.data.oda.jdbc", this.getLocalMySqlConnProperties(), null);
        return this.m_connection;
    }

    private void createTimeDataTypeTableData() throws Exception {
        java.sql.Connection conn = this.openMySqlConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table IF NOT EXISTS acTimeDataTypes ( acDate date, acTime time, acTimestamp timestamp )");
        stmt.execute("insert into acTimeDataTypes values( '2000-10-13' , '06:30:18', '2000-10-13 06:30:18' )");
        stmt.execute("insert into acTimeDataTypes values( '2001-11-13' , '03:30:28', '2001-11-13 03:30:28' )");
        stmt.close();
        conn.close();
    }

    private void dropTimeDataTypeTableData() throws Exception {
        java.sql.Connection conn = this.openMySqlConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("drop table acTimeDataTypes");
        stmt.close();
        conn.close();
    }

    private java.sql.Connection openMySqlConnection() throws Exception {
        Properties connProp = this.getLocalMySqlConnProperties();
        Class.forName(connProp.getProperty("odaDriverClass"));
        return DriverManager.getConnection(connProp.getProperty("odaURL"), connProp.getProperty("odaUser"), connProp.getProperty("odaPassword"));
    }
}

