/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.QueryTest;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ResultSetMetaDataTest
extends QueryTest {
    private IResultClass m_metadata;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_metadata = this.getStatement().getMetaData();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testGetColumnCount() {
        this.checkColumnCount(this.m_metadata);
    }

    public final void testGetColumnCount1() throws DataException {
        IResultClass metadata = this.getMetaDataFromResult();
        this.checkColumnCount(metadata);
    }

    public final void testGetColumnName() throws Exception {
        this.checkColumnNames(this.m_metadata);
    }

    public final void testGetColumnName1() throws Exception {
        IResultClass metadata = this.getMetaDataFromResult();
        this.checkColumnNames(metadata);
    }

    public final void testGetColumnType() throws Exception {
        this.checkColumnTypes(this.m_metadata);
    }

    public final void testGetColumnType1() throws Exception {
        IResultClass metadata = this.getMetaDataFromResult();
        this.checkColumnTypes(metadata);
    }

    private IResultClass getMetaDataFromResult() throws DataException {
        this.getStatement().execute();
        ResultSet resultset = this.getStatement().getResultSet();
        IResultClass metadata = resultset.getMetaData();
        return metadata;
    }

    private void checkColumnCount(IResultClass metadata) {
        ResultSetMetaDataTest.assertEquals((int)5, (int)metadata.getFieldCount());
    }

    private void checkColumnNames(IResultClass metadata) throws Exception {
        int i = 1;
        int n = metadata.getFieldCount();
        while (i <= n) {
            String colName = metadata.getFieldName(i);
            switch (i) {
                case 1: {
                    ResultSetMetaDataTest.assertEquals((String)"intColumn", (String)colName);
                    break;
                }
                case 2: {
                    ResultSetMetaDataTest.assertEquals((String)"doubleColumn", (String)colName);
                    break;
                }
                case 3: {
                    ResultSetMetaDataTest.assertEquals((String)"stringColumn", (String)colName);
                    break;
                }
                case 4: {
                    ResultSetMetaDataTest.assertEquals((String)"dateColumn", (String)colName);
                    break;
                }
                case 5: {
                    ResultSetMetaDataTest.assertEquals((String)"decimalColumn", (String)colName);
                    break;
                }
                default: {
                    ResultSetMetaDataTest.assertTrue((boolean)false);
                }
            }
            ++i;
        }
    }

    private void checkColumnTypes(IResultClass metadata) throws Exception {
        int i = 1;
        int n = metadata.getFieldCount();
        while (i <= n) {
            Class colType = metadata.getFieldValueClass(i);
            switch (i) {
                case 1: {
                    ResultSetMetaDataTest.assertEquals(Integer.class, (Object)colType);
                    break;
                }
                case 2: {
                    ResultSetMetaDataTest.assertEquals(Double.class, (Object)colType);
                    break;
                }
                case 3: {
                    ResultSetMetaDataTest.assertEquals(String.class, (Object)colType);
                    break;
                }
                case 4: {
                    ResultSetMetaDataTest.assertEquals(Date.class, (Object)colType);
                    break;
                }
                case 5: {
                    ResultSetMetaDataTest.assertEquals(BigDecimal.class, (Object)colType);
                    break;
                }
                default: {
                    ResultSetMetaDataTest.assertTrue((boolean)false);
                }
            }
            ++i;
        }
    }
}

