/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer.testutil;

import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;

public class OdaTestDriverCase
extends TestCase {
    protected final String TEST_DRIVER_ID = "org.eclipse.birt.data.engine.odaconsumer.testdriver";
    private ConnectionManager sm_connManager;
    private Connection m_hostConn;

    static {
        if (System.getProperty("BIRT_HOME") == null) {
            System.setProperty("BIRT_HOME", "./test");
        }
        System.setProperty("PROPERTY_RUN_UNDER_ECLIPSE", "false");
        try {
            Platform.startup(null);
        }
        catch (BirtException ex) {
            ex.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.sm_connManager == null) {
            this.sm_connManager = ConnectionManager.getInstance();
        }
    }

    protected void tearDown() throws Exception {
        try {
            if (this.m_hostConn != null) {
                this.m_hostConn.close();
            }
        }
        catch (DataException ex) {
            ex.printStackTrace();
        }
        ConnectionManager.releaseInstance();
        super.tearDown();
    }

    protected ConnectionManager getConnectionManager() {
        return this.sm_connManager;
    }

    protected Connection getOpenedConnection() {
        try {
            if (this.m_hostConn == null) {
                this.m_hostConn = this.sm_connManager.openConnection("org.eclipse.birt.data.engine.odaconsumer.testdriver", null, null);
            }
        }
        catch (DataException ex) {
            ex.printStackTrace();
        }
        OdaTestDriverCase.assertTrue((this.m_hostConn != null ? 1 : 0) != 0);
        return this.m_hostConn;
    }
}

