/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer.testutil;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class TestSetup {
    private static String url = "jdbc:derby:DtETest";
    private static String username = "sa";
    private static String password = "sa";
    private static String driverclass = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String PROCEDURE_NAME_PREFIX = "testOdaConsmr";
    public static final String PROCEDURE_PARAM_NAME_PREFIX = "paramNativeName";
    private static final String PROCEDURE_ELEMENTS = "PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA";
    private static final String PROCEDURE_SET_INPUT = " EXTERNAL NAME 'org.eclipse.birt.data.engine.api.StoredProcedureTest.selectData' ";
    private static final String PROCEDURE_SET_INOUT = " EXTERNAL NAME 'org.eclipse.birt.data.engine.odaconsumer.util.TestSetup.selectInOutParamData'";

    public static void createTestTable() throws Exception {
        Class.forName(driverclass);
        Connection connection = DriverManager.getConnection(String.valueOf(url) + ";create=true", username, password);
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop table \"testtable\"");
            statement.execute("drop table \"testtable_lob\"");
        }
        catch (SQLException sQLException) {}
        statement.execute("CREATE TABLE \"testtable\"( \"intColumn\" INT, \"doubleColumn\" FLOAT(52), \"stringColumn\" VARCHAR(50), \"dateColumn\" DATE, \"decimalColumn\" DECIMAL(18,0) )");
        statement.execute("INSERT INTO \"testtable\" VALUES( 123, 1.212312, 'blah blah blah', '2000-09-01', 600 )");
        statement.execute("INSERT INTO \"testtable\" VALUES( 14, 3.14, 'hahahahahahhahaha', '1991-10-02', 10 )");
        statement.execute("INSERT INTO \"testtable\" VALUES( 0, 1.23, 'niem', '1979-11-28', 10 )");
        statement.execute("INSERT INTO \"testtable\" VALUES( NULL, NULL, NULL, NULL, NULL )");
        statement.execute("INSERT INTO \"testtable\" VALUES( 4, 12.3636, 'seven zero six', '2004-01-01', 10000 )");
        statement.execute("CREATE TABLE \"testtable_lob\"( \"blob1\" BLOB, \"clob1\" CLOB )");
        statement.execute("INSERT INTO \"testtable_lob\" VALUES( NULL, 'abcdefg' )");
        statement.close();
        connection.close();
    }

    public static void createTestStoredProcedures() throws Exception {
        String sqlText;
        Class.forName(driverclass);
        Connection connection = DriverManager.getConnection(String.valueOf(url) + ";create=true", username, password);
        Statement statement = connection.createStatement();
        try {
            sqlText = "drop procedure testOdaConsmrIn";
            statement.execute(sqlText);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        sqlText = "CREATE PROCEDURE testOdaConsmrIn (IN paramNativeName1 INTEGER  ) PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME 'org.eclipse.birt.data.engine.api.StoredProcedureTest.selectData' ";
        try {
            statement.execute(sqlText);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        statement.close();
        connection.close();
    }

    public static void setInputParamData(int inputValue, String outputValue) {
    }

    public static void selectInOutParamData(int inputValue, String[] outputValues) {
        outputValues[0] = new Integer(inputValue).toString();
    }
}

