/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.cursor.TestFactTable1;
import org.eclipse.birt.data.engine.olap.cursor.TestFactTable2;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerReleaser;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class CubeUtility {
    public static String cubeName = "cube";
    public static String timeCube = "timeCube";

    CubeUtility() {
    }

    void createCube(DataEngineImpl engine) throws IOException, BirtException, OLAPException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager((String)engine.getSession().getTempDir(), (String)cubeName);
        DocManagerMap.getDocManagerMap().set(String.valueOf(engine.hashCode()), String.valueOf(engine.getSession().getTempDir()) + cubeName, documentManager);
        engine.addShutdownListener((IShutdownListener)new DocManagerReleaser((DataEngine)engine));
        Dimension[] dimensions = new Dimension[6];
        String[] levelNames = new String[]{"level11"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable1.DIM0_L1Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[0].getHierarchy();
        dimensions[0].getAllRows(new StopSign());
        levelNames = new String[]{"level12"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable1.DIM0_L2Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level12", new String[]{"level12"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[1].getHierarchy();
        dimensions[1].getAllRows(new StopSign());
        levelNames = new String[]{"level13"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable1.DIM0_L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[2].getHierarchy();
        dimensions[2].getAllRows(new StopSign());
        levelNames = new String[]{"level14"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable1.DIM0_L4Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level14", new String[]{"level14"}, null)};
        dimensions[3] = (Dimension)DimensionFactory.createDimension((String)"dimension4", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[3].getHierarchy();
        dimensions[3].getAllRows(new StopSign());
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable1.DIM1_L1Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[4] = (Dimension)DimensionFactory.createDimension((String)"dimension5", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[4].getHierarchy();
        dimensions[4].getAllRows(new StopSign());
        levelNames = new String[]{"level22", "attributes220"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable1.DIM1_L2Col);
        iterator.setLevelMember(1, TestFactTable1.ATTRIBUTE_Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level22", new String[]{"level22"}, new String[]{"attributes220"})};
        dimensions[5] = (Dimension)DimensionFactory.createDimension((String)"dimension6", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[5].getHierarchy();
        dimensions[5].getAllRows(new StopSign());
        TestFactTable1 factTable2 = new TestFactTable1();
        String[] measureColumnName = new String[]{"measure1"};
        Cube cube = new Cube(cubeName, documentManager);
        cube.create(CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        cube.close();
        documentManager.flush();
    }

    ICube getCube(String cubeName, DataEngineImpl engine) throws DataException, IOException {
        ICube cube = null;
        IDocumentManager documentManager = DocumentManagerFactory.loadFileDocumentManager((String)engine.getSession().getTempDir(), (String)cubeName);
        cube = CubeQueryExecutorHelper.loadCube((String)cubeName, (IDocumentManager)documentManager, (StopSign)engine.getSession().getStopSign());
        return cube;
    }

    void createCube1(DataEngineImpl engine) throws IOException, BirtException, OLAPException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager((String)engine.getSession().getTempDir(), (String)timeCube);
        DocManagerMap.getDocManagerMap().set(String.valueOf(engine.hashCode()), String.valueOf(engine.getSession().getTempDir()) + timeCube, documentManager);
        engine.addShutdownListener((IShutdownListener)new DocManagerReleaser((DataEngine)engine));
        Dimension[] dimensions = new Dimension[6];
        String[] levelNames = new String[]{"level11"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable2.DIM0_L1Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[0].getHierarchy();
        dimensions[0].getAllRows(new StopSign());
        levelNames = new String[]{"level12"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable2.DIM0_L2Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level12", new String[]{"level12"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[1].getHierarchy();
        dimensions[1].getAllRows(new StopSign());
        levelNames = new String[]{"level13"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable2.DIM0_L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[2].getHierarchy();
        dimensions[2].getAllRows(new StopSign());
        levelNames = new String[]{"level14"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable2.DIM0_L4Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level14", new String[]{"level14"}, null)};
        dimensions[3] = (Dimension)DimensionFactory.createDimension((String)"dimension4", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[3].getHierarchy();
        dimensions[3].getAllRows(new StopSign());
        levelNames = new String[]{"level21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable2.DIM1_L1Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, null)};
        dimensions[4] = (Dimension)DimensionFactory.createDimension((String)"dimension5", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[4].getHierarchy();
        dimensions[4].getAllRows(new StopSign());
        levelNames = new String[]{"level22", "attributes220"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable2.DIM1_L2Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level22", new String[]{"level22"}, new String[0])};
        dimensions[5] = (Dimension)DimensionFactory.createDimension((String)"dimension6", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        dimensions[5].getHierarchy();
        dimensions[5].getAllRows(new StopSign());
        TestFactTable2 factTable2 = new TestFactTable2();
        String[] measureColumnName = new String[]{"measure1"};
        Cube cube = new Cube(timeCube, documentManager);
        cube.create(CubeUtility.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        cube.close();
        documentManager.flush();
    }

    ICubeQueryDefinition createQueryDefinition() {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension5");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension5");
        porductLineHie1.createLevel("level21");
        IDimensionDefinition productLineDim2 = rowEdge.createDimension("dimension6");
        IHierarchyDefinition porductLineHie2 = productLineDim2.createHierarchy("dimension6");
        porductLineHie2.createLevel("level22");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition geographyDim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition geographyHier1 = geographyDim1.createHierarchy("dimension1");
        geographyHier1.createLevel("level11");
        IDimensionDefinition geographyDim2 = columnEdge.createDimension("dimension2");
        IHierarchyDefinition geographyHier2 = geographyDim2.createHierarchy("dimension2");
        geographyHier2.createLevel("level12");
        IDimensionDefinition geographyDim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition geographyHier3 = geographyDim3.createHierarchy("dimension3");
        geographyHier3.createLevel("level13");
        IDimensionDefinition geographyDim4 = columnEdge.createDimension("dimension4");
        IHierarchyDefinition geographyHier4 = geographyDim4.createHierarchy("dimension4");
        geographyHier4.createLevel("level14");
        return cqd;
    }

    ICubeQueryDefinition createMirroredQueryDefinition(String cubeName, boolean breakHierarchy) {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition productLineDim1 = columnEdge.createDimension("dimension5");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension5");
        porductLineHie1.createLevel("level21");
        IDimensionDefinition productLineDim2 = columnEdge.createDimension("dimension6");
        IHierarchyDefinition porductLineHie2 = productLineDim2.createHierarchy("dimension6");
        ILevelDefinition columnLevel2 = porductLineHie2.createLevel("level22");
        columnEdge.creatMirrorDefinition(columnLevel2, breakHierarchy);
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition geographyDim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition geographyHier1 = geographyDim1.createHierarchy("dimension1");
        geographyHier1.createLevel("level11");
        IDimensionDefinition geographyDim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition geographyHier2 = geographyDim2.createHierarchy("dimension2");
        geographyHier2.createLevel("level12");
        IDimensionDefinition geographyDim3 = rowEdge.createDimension("dimension3");
        IHierarchyDefinition geographyHier3 = geographyDim3.createHierarchy("dimension3");
        ILevelDefinition startLevel = geographyHier3.createLevel("level13");
        IDimensionDefinition geographyDim4 = rowEdge.createDimension("dimension4");
        IHierarchyDefinition geographyHier4 = geographyDim4.createHierarchy("dimension4");
        geographyHier4.createLevel("level14");
        rowEdge.creatMirrorDefinition(startLevel, breakHierarchy);
        return cqd;
    }

    ICubeQueryDefinition createMirroredQueryDefinitionWithPage() {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        IEdgeDefinition pageEdge = cqd.createEdge(3);
        IDimensionDefinition pageDim1 = pageEdge.createDimension("dimension5");
        IHierarchyDefinition pagetLineHie1 = pageDim1.createHierarchy("dimension5");
        pagetLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition productLineDim2 = columnEdge.createDimension("dimension6");
        IHierarchyDefinition porductLineHie2 = productLineDim2.createHierarchy("dimension6");
        ILevelDefinition columnLevel2 = porductLineHie2.createLevel("level22");
        columnEdge.setMirrorStartingLevel(columnLevel2);
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition geographyDim1 = rowEdge.createDimension("dimension1");
        IHierarchyDefinition geographyHier1 = geographyDim1.createHierarchy("dimension1");
        geographyHier1.createLevel("level11");
        IDimensionDefinition geographyDim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition geographyHier2 = geographyDim2.createHierarchy("dimension2");
        geographyHier2.createLevel("level12");
        IDimensionDefinition geographyDim3 = rowEdge.createDimension("dimension3");
        IHierarchyDefinition geographyHier3 = geographyDim3.createHierarchy("dimension3");
        geographyHier3.createLevel("level13");
        IDimensionDefinition geographyDim4 = rowEdge.createDimension("dimension4");
        IHierarchyDefinition geographyHier4 = geographyDim4.createHierarchy("dimension4");
        ILevelDefinition startLevel = geographyHier4.createLevel("level14");
        rowEdge.setMirrorStartingLevel(startLevel);
        return cqd;
    }

    public static void close(CubeCursor dataCursor) throws OLAPException {
        int i = 0;
        while (i < dataCursor.getOrdinateEdge().size()) {
            EdgeCursor edge = (EdgeCursor)dataCursor.getOrdinateEdge().get(i);
            edge.close();
            ++i;
        }
        dataCursor.close();
    }

    ICubeQueryDefinition createQueryDefintionWithPage1() {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension5");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension5");
        porductLineHie1.createLevel("level21");
        IDimensionDefinition productLineDim2 = rowEdge.createDimension("dimension6");
        IHierarchyDefinition porductLineHie2 = productLineDim2.createHierarchy("dimension6");
        porductLineHie2.createLevel("level22");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition geographyDim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition geographyHier1 = geographyDim1.createHierarchy("dimension1");
        geographyHier1.createLevel("level11");
        IDimensionDefinition geographyDim2 = columnEdge.createDimension("dimension2");
        IHierarchyDefinition geographyHier2 = geographyDim2.createHierarchy("dimension2");
        geographyHier2.createLevel("level12");
        IDimensionDefinition geographyDim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition geographyHier3 = geographyDim3.createHierarchy("dimension3");
        geographyHier3.createLevel("level13");
        IEdgeDefinition pageEdge = cqd.createEdge(3);
        IDimensionDefinition geographyDim4 = pageEdge.createDimension("dimension4");
        IHierarchyDefinition geographyHier4 = geographyDim4.createHierarchy("dimension4");
        geographyHier4.createLevel("level14");
        return cqd;
    }

    ICubeQueryDefinition createQueryDefintionWithPage2() {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension5");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension5");
        porductLineHie1.createLevel("level21");
        IDimensionDefinition productLineDim2 = rowEdge.createDimension("dimension6");
        IHierarchyDefinition porductLineHie2 = productLineDim2.createHierarchy("dimension6");
        porductLineHie2.createLevel("level22");
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition geographyDim2 = columnEdge.createDimension("dimension2");
        IHierarchyDefinition geographyHier2 = geographyDim2.createHierarchy("dimension2");
        geographyHier2.createLevel("level12");
        IDimensionDefinition geographyDim3 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition geographyHier3 = geographyDim3.createHierarchy("dimension3");
        geographyHier3.createLevel("level13");
        IEdgeDefinition pageEdge = cqd.createEdge(3);
        IDimensionDefinition geographyDim4 = pageEdge.createDimension("dimension4");
        IHierarchyDefinition geographyHier4 = geographyDim4.createHierarchy("dimension4");
        geographyHier4.createLevel("level14");
        IDimensionDefinition geographyDim1 = pageEdge.createDimension("dimension1");
        IHierarchyDefinition geographyHier1 = geographyDim1.createHierarchy("dimension1");
        geographyHier1.createLevel("level11");
        return cqd;
    }

    String printCubeAlongEdge(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, List measureBindingNames, List rowGrandTotal, String columnGrandTotal, String totalGrandTotal, List countryGrandTotal) throws Exception {
        EdgeCursor edge1 = null;
        EdgeCursor edge2 = null;
        if (columnEdgeBindingNames.size() > 0) {
            edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        }
        if (rowEdgeBindingNames.size() > 0) {
            edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(cursor.getOrdinateEdge().size() - 1);
        }
        String[] lines = new String[]{};
        if (edge1 != null) {
            lines = new String[edge1.getDimensionCursor().size()];
        }
        int i = 0;
        while (i < lines.length) {
            lines[i] = "\t\t";
            ++i;
        }
        if (edge1 != null) {
            while (edge1.next()) {
                i = 0;
                while (i < columnEdgeBindingNames.size()) {
                    DimensionCursor dimCursor = (DimensionCursor)edge1.getDimensionCursor().get(i);
                    int n = i;
                    lines[n] = String.valueOf(lines[n]) + dimCursor.getObject(columnEdgeBindingNames.get(i).toString()) + "   ";
                    ++i;
                }
            }
        }
        String output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = String.valueOf(output) + "\n" + lines[i2];
            ++i2;
        }
        if (edge2 != null) {
            while (edge2.next()) {
                String line = "";
                int k = 0;
                while (k < rowEdgeBindingNames.size()) {
                    DimensionCursor dimCursor = (DimensionCursor)edge2.getDimensionCursor().get(k);
                    line = String.valueOf(line) + dimCursor.getObject(rowEdgeBindingNames.get(k).toString()).toString() + "   ";
                    ++k;
                }
                if (edge1 != null) {
                    edge1.beforeFirst();
                    while (edge1.next()) {
                        DimensionCursor countryCursor = (DimensionCursor)edge1.getDimensionCursor().get(0);
                        if (measureBindingNames == null) continue;
                        int j = 0;
                        while (j < measureBindingNames.size()) {
                            line = String.valueOf(line) + cursor.getObject(OlapExpressionUtil.createMeasureCalculateMemeberName((String)measureBindingNames.get(j).toString())) + ",";
                            ++j;
                        }
                        if (countryGrandTotal != null) {
                            int k2 = 0;
                            while (k2 < countryGrandTotal.size()) {
                                if (edge1.getPosition() == countryCursor.getEdgeEnd() && countryGrandTotal != null) {
                                    line = String.valueOf(line) + cursor.getObject(countryGrandTotal.get(k2).toString());
                                }
                                ++k2;
                            }
                        }
                        line = String.valueOf(line) + "  ";
                    }
                } else if (measureBindingNames != null) {
                    int j = 0;
                    while (j < measureBindingNames.size()) {
                        line = String.valueOf(line) + cursor.getObject(OlapExpressionUtil.createMeasureCalculateMemeberName((String)measureBindingNames.get(j).toString())) + ",";
                        ++j;
                    }
                    line = String.valueOf(line) + "  ";
                }
                if (rowGrandTotal != null) {
                    int j = 0;
                    while (j < rowGrandTotal.size()) {
                        line = String.valueOf(line) + cursor.getObject(rowGrandTotal.get(j).toString()) + "&";
                        ++j;
                    }
                }
                output = String.valueOf(output) + "\n" + line;
            }
        }
        if (columnGrandTotal != null) {
            output = String.valueOf(output) + "\n" + columnGrandTotal + "  ";
            edge1.beforeFirst();
            while (edge1.next()) {
                output = String.valueOf(output) + cursor.getObject(columnGrandTotal) + "   ";
            }
        }
        if (totalGrandTotal != null) {
            output = String.valueOf(output) + cursor.getObject(totalGrandTotal);
        }
        System.out.print(output);
        return output;
    }

    String printCubeAlongDimension(CubeCursor dataCursor, DimensionCursor countryCursor, DimensionCursor cityCursor, DimensionCursor streetCursor, DimensionCursor timeCursor, DimensionCursor productCursor1, DimensionCursor productCursor2) throws OLAPException {
        String[] lines = new String[4];
        int i = 0;
        while (i < lines.length) {
            lines[i] = "\t\t";
            ++i;
        }
        if (countryCursor != null && cityCursor != null && timeCursor != null) {
            countryCursor.beforeFirst();
            while (countryCursor.next()) {
                cityCursor.beforeFirst();
                while (cityCursor.next()) {
                    streetCursor.beforeFirst();
                    while (streetCursor.next()) {
                        timeCursor.beforeFirst();
                        while (timeCursor.next()) {
                            lines[0] = String.valueOf(lines[0]) + countryCursor.getObject("level11") + "         ";
                            lines[1] = String.valueOf(lines[1]) + cityCursor.getObject("level12") + "         ";
                            lines[2] = String.valueOf(lines[2]) + streetCursor.getObject("level13") + "         ";
                            lines[3] = String.valueOf(lines[3]) + timeCursor.getObject("level14") + "         ";
                        }
                    }
                }
            }
        }
        String output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = String.valueOf(output) + "\n" + lines[i2];
            ++i2;
        }
        lines = new String[]{""};
        if (productCursor1 != null && productCursor2 != null && countryCursor != null && cityCursor != null && timeCursor != null) {
            productCursor1.beforeFirst();
            while (productCursor1.next()) {
                productCursor2.beforeFirst();
                while (productCursor2.next()) {
                    lines[0] = String.valueOf(lines[0]) + productCursor1.getObject("level21") + "   ";
                    lines[0] = String.valueOf(lines[0]) + productCursor2.getObject("level22") + "   ";
                    countryCursor.beforeFirst();
                    while (countryCursor.next()) {
                        cityCursor.beforeFirst();
                        while (cityCursor.next()) {
                            timeCursor.beforeFirst();
                            while (timeCursor.next()) {
                                lines[0] = String.valueOf(lines[0]) + dataCursor.getObject(OlapExpressionUtil.createMeasureCalculateMemeberName((String)"measure1")) + "  ";
                            }
                        }
                    }
                    lines[0] = String.valueOf(lines[0]) + "  \n";
                }
                lines[0] = String.valueOf(lines[0]) + "  \n";
            }
        } else if (countryCursor != null && cityCursor != null && timeCursor != null) {
            countryCursor.beforeFirst();
            lines[0] = String.valueOf(lines[0]) + "           ";
            while (countryCursor.next()) {
                cityCursor.beforeFirst();
                while (cityCursor.next()) {
                    timeCursor.beforeFirst();
                    while (timeCursor.next()) {
                        lines[0] = String.valueOf(lines[0]) + dataCursor.getObject(OlapExpressionUtil.createMeasureCalculateMemeberName((String)"measure1")) + "  ";
                    }
                }
            }
            lines[0] = String.valueOf(lines[0]) + "  \n";
        } else if (productCursor1 != null && productCursor2 != null) {
            productCursor1.beforeFirst();
            while (productCursor1.next()) {
                productCursor2.beforeFirst();
                while (productCursor2.next()) {
                    lines[0] = String.valueOf(lines[0]) + productCursor1.getObject("level21") + "  ";
                    lines[0] = String.valueOf(lines[0]) + productCursor2.getObject("level22") + "  ";
                    lines[0] = String.valueOf(lines[0]) + dataCursor.getObject(OlapExpressionUtil.createMeasureCalculateMemeberName((String)"measure1")) + "  ";
                    lines[0] = String.valueOf(lines[0]) + "  \n";
                }
            }
            lines[0] = String.valueOf(lines[0]) + "  \n";
        }
        output = String.valueOf(output) + "\n" + lines[0];
        System.out.print(output);
        return output;
    }

    String printCubeAlongPageEdge(CubeCursor cursor, List pageEdgeBindingName, List columnEdgeBindingNames, List rowEdgeBindingNames, List measureBindingNames, List rowGrandTotal, String columnGrandTotal, String totalGrandTotal, List countryGrandTotal) throws Exception {
        EdgeCursor pageCursor = (EdgeCursor)cursor.getPageEdge().toArray()[0];
        pageCursor.beforeFirst();
        String output = "";
        while (pageCursor.next()) {
            cursor.synchronizePages();
            int i = 0;
            while (i < pageEdgeBindingName.size()) {
                output = String.valueOf(output) + "\n" + ((DimensionCursor)pageCursor.getDimensionCursor().get(i)).getObject(pageEdgeBindingName.get(i).toString());
                ++i;
            }
            output = String.valueOf(output) + this.printCubeAlongEdge(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, rowGrandTotal, columnGrandTotal, totalGrandTotal, countryGrandTotal);
        }
        return output;
    }

    public static String[][] getKeyColNames(IDimension[] dimensions) {
        String[][] keyColumnName = new String[dimensions.length][];
        int i = 0;
        while (i < dimensions.length) {
            ILevel[] levels = dimensions[i].getHierarchy().getLevels();
            ILevel detailLevel = levels[levels.length - 1];
            keyColumnName[i] = detailLevel.getKeyNames();
            ++i;
        }
        return keyColumnName;
    }
}

