/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import testutil.BaseTestCase;

public class MirrorCursorNavigatorTest
extends BaseTestCase {
    private Scriptable scope;
    private DataEngineImpl de;
    private CubeUtility creator;
    private ICube cube;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.scope = new ImporterTopLevel();
        DataEngineContext context = DataEngineContext.newInstance((int)3, (Scriptable)this.scope, null, null);
        context.setTmpdir(MirrorCursorNavigatorTest.getTempDir());
        this.de = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.creator = new CubeUtility();
        this.creator.createCube(this.de);
        this.cube = this.creator.getCube(CubeUtility.cubeName, this.de);
    }

    @Override
    protected void tearDown() throws Exception {
        this.cube.close();
        if (this.de != null) {
            this.de.shutdown();
            this.de = null;
        }
    }

    public void testNavigator() throws DataException, OLAPException {
        ICubeQueryDefinition cqd = this.creator.createMirroredQueryDefinition("cube", true);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, cqd, this.de.getSession(), this.scope, this.de.getContext()));
        CubeCursor dataCursor = cubeView.getCubeCursor(new StopSign(), this.cube);
        EdgeCursor rowCursor = cubeView.getRowEdgeView().getEdgeCursor();
        EdgeCursor columnCursor = cubeView.getColumnEdgeView().getEdgeCursor();
        DimensionCursor countryCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(0);
        DimensionCursor cityCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(1);
        DimensionCursor streetCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(2);
        DimensionCursor yearCursor = (DimensionCursor)columnCursor.getDimensionCursor().get(3);
        DimensionCursor cfr_ignored_0 = (DimensionCursor)rowCursor.getDimensionCursor().get(0);
        DimensionCursor cfr_ignored_1 = (DimensionCursor)rowCursor.getDimensionCursor().get(1);
        columnCursor.beforeFirst();
        MirrorCursorNavigatorTest.assertTrue((boolean)columnCursor.isBeforeFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.isBeforeFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.isBeforeFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.isBeforeFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.isBeforeFirst());
        columnCursor.afterLast();
        MirrorCursorNavigatorTest.assertTrue((boolean)columnCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.isAfterLast());
        columnCursor.first();
        countryCursor.afterLast();
        cityCursor.afterLast();
        streetCursor.afterLast();
        yearCursor.afterLast();
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.isAfterLast());
        columnCursor.first();
        columnCursor.next();
        cityCursor.afterLast();
        streetCursor.afterLast();
        yearCursor.afterLast();
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.isFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.isAfterLast());
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.isAfterLast());
        columnCursor.first();
        MirrorCursorNavigatorTest.assertTrue((boolean)columnCursor.isFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.isFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.isFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.isFirst());
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.isFirst());
        columnCursor.last();
        MirrorCursorNavigatorTest.assertTrue((boolean)columnCursor.last());
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.last());
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.last());
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.last());
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.last());
        columnCursor.setPosition(5L);
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.getObject("level12").equals("BJ"));
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.setPosition(85L);
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.getObject("level11").equals("JP"));
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.getObject("level12").equals("IL"));
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.setPosition(220L);
        try {
            countryCursor.getObject("level11");
            MirrorCursorNavigatorTest.fail((String)"should never get here!!");
        }
        catch (OLAPException oLAPException) {}
        columnCursor.setPosition(225L);
        columnCursor.previous();
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.getObject("level11").equals("US"));
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.getObject("level12").equals("NY"));
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.getObject("level13").equals("A4"));
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.getObject("level14").equals("2002"));
        columnCursor.setPosition(86L);
        columnCursor.previous();
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.getObject("level11").equals("JP"));
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.getObject("level12").equals("IL"));
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.beforeFirst();
        columnCursor.relative(6);
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.getObject("level12").equals("BJ"));
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.beforeFirst();
        columnCursor.next();
        columnCursor.next();
        columnCursor.next();
        columnCursor.setPosition(1L);
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.getObject("level11").equals("CN"));
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.getObject("level12").equals("BJ"));
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.getObject("level14").equals("1999"));
        columnCursor.beforeFirst();
        columnCursor.setPosition(80L);
        streetCursor.setPosition(1L);
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.getObject("level11").equals("JP"));
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.getObject("level12").equals("IL"));
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.getObject("level13").equals("A2"));
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.getObject("level14").equals("1998"));
        columnCursor.beforeFirst();
        columnCursor.setPosition(80L);
        columnCursor.next();
        countryCursor.next();
        MirrorCursorNavigatorTest.assertTrue((boolean)countryCursor.getObject("level11").equals("UN"));
        MirrorCursorNavigatorTest.assertTrue((boolean)cityCursor.getObject("level12").equals("LD"));
        MirrorCursorNavigatorTest.assertTrue((boolean)streetCursor.getObject("level13").equals("A1"));
        MirrorCursorNavigatorTest.assertTrue((boolean)yearCursor.getObject("level14").equals("1999"));
        columnCursor.afterLast();
        try {
            streetCursor.getObject("level13");
            MirrorCursorNavigatorTest.fail((String)"should not get here");
        }
        catch (OLAPException oLAPException) {}
        columnCursor.beforeFirst();
        columnCursor.next();
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeEnd() == 79L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeEnd() == 19L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeEnd() == 4L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeEnd() == 0L ? 1 : 0) != 0);
        columnCursor.beforeFirst();
        columnCursor.setPosition(1L);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeEnd() == 79L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeEnd() == 19L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeStart() == 0L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeEnd() == 4L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeStart() == 1L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeEnd() == 1L ? 1 : 0) != 0);
        columnCursor.setPosition(81L);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeStart() == 80L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeEnd() == 119L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeStart() == 80L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeEnd() == 99L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeStart() == 80L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeEnd() == 84L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeStart() == 81L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeEnd() == 81L ? 1 : 0) != 0);
        columnCursor.setPosition(146L);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeStart() == 120L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeEnd() == 159L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeStart() == 140L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeEnd() == 159L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeStart() == 145L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeEnd() == 149L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeStart() == 146L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeEnd() == 146L ? 1 : 0) != 0);
        columnCursor.beforeFirst();
        columnCursor.setPosition(220L);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((countryCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((cityCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((streetCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeStart() == -1L ? 1 : 0) != 0);
        MirrorCursorNavigatorTest.assertTrue((yearCursor.getEdgeEnd() == -1L ? 1 : 0) != 0);
        this.close(dataCursor);
    }

    private void close(CubeCursor dataCursor) throws OLAPException {
        int i = 0;
        while (i < dataCursor.getOrdinateEdge().size()) {
            EdgeCursor edge = (EdgeCursor)dataCursor.getOrdinateEdge().get(i);
            edge.close();
            ++i;
        }
        dataCursor.close();
    }
}

