/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.olap.data.document.BlockRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.BufferedRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectAllocatedTable;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IObjectAllocTable;
import org.eclipse.birt.data.engine.olap.data.document.IRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.SimpleRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;

public class BufferedRandomAccessObjectTest
extends TestCase {
    private static final String tmpPath = System.getProperty("java.io.tmpdir");
    IDocumentManager documentManager = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.documentManager = DocumentManagerFactory.createFileDocumentManager();
    }

    protected void tearDown() throws Exception {
        this.documentManager.close();
        super.tearDown();
    }

    public void testInteger() throws IOException {
        int objectNumber = 1001;
        BufferedRandomAccessObjectTest.assertTrue((this.documentManager.createDocumentObject("testInteger") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testInteger");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeInt(i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)i);
            ++i;
        }
        documentObject.seek(400L);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)100);
        documentObject.seek(804L);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)201);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)202);
        documentObject.seek(2804L);
        documentObject.writeInt(1000001);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)702);
        documentObject.seek(2804L);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)1000001);
        documentObject.close();
    }

    public void testInteger1() throws IOException {
        int objectNumber = 1001;
        BufferedRandomDataAccessObject documentObject = new BufferedRandomDataAccessObject((IRandomAccessObject)new SimpleRandomAccessObject(new File(String.valueOf(tmpPath) + File.separatorChar + "testInteger1"), "rw"), 1024);
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeInt(i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)i);
            ++i;
        }
        documentObject.seek(400L);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)100);
        documentObject.seek(804L);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)201);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)202);
        documentObject.seek(2804L);
        documentObject.writeInt(1000001);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)702);
        documentObject.seek(2804L);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)1000001);
        documentObject.close();
    }

    public void testLong() throws IOException {
        int objectNumber = 1001;
        BufferedRandomDataAccessObject documentObject = new BufferedRandomDataAccessObject((IRandomAccessObject)new SimpleRandomAccessObject(new File(String.valueOf(tmpPath) + File.separatorChar + "testInteger1"), "rw"), 1024);
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeLong((long)i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessObjectTest.assertEquals((long)documentObject.readLong(), (long)i);
            ++i;
        }
        documentObject.seek(800L);
        BufferedRandomAccessObjectTest.assertEquals((long)documentObject.readLong(), (long)100L);
        documentObject.seek(1608L);
        BufferedRandomAccessObjectTest.assertEquals((long)documentObject.readLong(), (long)201L);
        BufferedRandomAccessObjectTest.assertEquals((long)documentObject.readLong(), (long)202L);
        documentObject.seek(5608L);
        documentObject.writeLong(1000001L);
        BufferedRandomAccessObjectTest.assertEquals((long)documentObject.readLong(), (long)702L);
        documentObject.seek(5608L);
        BufferedRandomAccessObjectTest.assertEquals((long)documentObject.readLong(), (long)1000001L);
        documentObject.close();
    }

    public void testInteger2() throws IOException {
        BlockRandomAccessObject documentObject = new BlockRandomAccessObject(new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "testInteger1"), "rw", 1024), "testInteger2", 0, 0L, (IObjectAllocTable)new DocumentObjectAllocatedTable());
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        documentObject.seek(0L);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        documentObject.write(bytes, 0, bytes.length);
        bytes = new byte[1024];
        documentObject.seek(0L);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.read(bytes, 0, bytes.length), (int)1024);
        BufferedRandomAccessObjectTest.assertEquals((int)bytes[0], (int)1);
        BufferedRandomAccessObjectTest.assertEquals((int)bytes[1], (int)2);
        documentObject.close();
    }

    public void testInteger3() throws IOException {
        BlockRandomAccessObject documentObject = new BlockRandomAccessObject(new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "testInteger1"), "rw", 1024), "testInteger2", 0, 0L, (IObjectAllocTable)new DocumentObjectAllocatedTable());
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        documentObject.seek(0L);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        documentObject.write(bytes, 0, bytes.length);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.read(bytes, 0, bytes.length), (int)-1);
        documentObject.close();
    }

    public void testByteA() throws IOException {
        BlockRandomAccessObject documentObject = new BlockRandomAccessObject(new BufferedRandomAccessFile(new File(String.valueOf(tmpPath) + File.separatorChar + "testByteA1"), "rw", 1024), "testByteA2", 0, 0L, (IObjectAllocTable)new DocumentObjectAllocatedTable());
        byte[] bytes = new byte[15978];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)(i % 128);
            ++i;
        }
        documentObject.seek(0L);
        documentObject.write(bytes, 0, bytes.length);
        documentObject.seek(0L);
        byte[] tBytes = new byte[4096];
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.read(tBytes, 0, 10), (int)10);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.read(tBytes, 10, tBytes.length - 10), (int)(tBytes.length - 10));
        System.arraycopy(tBytes, 0, bytes, 0, tBytes.length);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.read(tBytes, 0, tBytes.length), (int)tBytes.length);
        System.arraycopy(tBytes, 0, bytes, tBytes.length, tBytes.length);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.read(tBytes, 0, tBytes.length), (int)tBytes.length);
        System.arraycopy(tBytes, 0, bytes, tBytes.length * 2, tBytes.length);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.read(tBytes, 0, tBytes.length), (int)(bytes.length - 3 * tBytes.length));
        System.arraycopy(tBytes, 0, bytes, tBytes.length * 3, bytes.length - 3 * tBytes.length);
        int i2 = 0;
        while (i2 < bytes.length) {
            BufferedRandomAccessObjectTest.assertEquals((byte)bytes[i2], (byte)((byte)(i2 % 128)));
            ++i2;
        }
        documentObject.close();
    }

    public void testString() throws IOException {
        int objectNumber = 3000;
        BufferedRandomAccessObjectTest.assertTrue((this.documentManager.createDocumentObject("testString") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testString");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeString("string" + i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessObjectTest.assertEquals((String)documentObject.readString(), (String)("string" + i));
            ++i;
        }
        documentObject.close();
    }

    public void testBigDecimal() throws IOException {
        int objectNumber = 3000;
        BufferedRandomAccessObjectTest.assertTrue((this.documentManager.createDocumentObject("testBigDecimal") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testBigDecimal");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeBigDecimal(new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessObjectTest.assertEquals((Object)documentObject.readBigDecimal(), (Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        documentObject.close();
    }

    public void testDate() throws IOException {
        int objectNumber = 4101;
        BufferedRandomAccessObjectTest.assertTrue((this.documentManager.createDocumentObject("testDate") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testDate");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeDate(new Date(1900100000 + i * 1000));
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessObjectTest.assertEquals((Object)documentObject.readDate(), (Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        documentObject.close();
    }

    public void testMixed() throws IOException {
        int objectNumber = 1001;
        BufferedRandomAccessObjectTest.assertTrue((this.documentManager.createDocumentObject("testMixed") != null ? 1 : 0) != 0);
        IDocumentObject documentObject = this.documentManager.openDocumentObject("testMixed");
        int i = 0;
        while (i < objectNumber) {
            documentObject.writeInt(i);
            ++i;
        }
        documentObject.seek(0L);
        i = 0;
        while (i < objectNumber) {
            BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)i);
            ++i;
        }
        documentObject.writeBigDecimal(new BigDecimal("1010101010101"));
        documentObject.writeDate(new Date(12202000L));
        documentObject.writeString("testString");
        documentObject.writeShort(1300);
        documentObject.writeInt(30000011);
        documentObject.writeObject((Object)new StringBuffer("s1"));
        documentObject.seek(0L);
        documentObject.skipBytes(objectNumber * 4);
        BufferedRandomAccessObjectTest.assertEquals((Object)documentObject.readBigDecimal(), (Object)new BigDecimal("1010101010101"));
        BufferedRandomAccessObjectTest.assertEquals((Object)documentObject.readDate(), (Object)new Date(12202000L));
        BufferedRandomAccessObjectTest.assertEquals((String)documentObject.readString(), (String)"testString");
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readShort(), (int)1300);
        BufferedRandomAccessObjectTest.assertEquals((int)documentObject.readInt(), (int)30000011);
        Object o = documentObject.readObject();
        BufferedRandomAccessObjectTest.assertTrue((boolean)(o instanceof StringBuffer));
        BufferedRandomAccessObjectTest.assertEquals((String)o.toString(), (String)"s1");
    }
}

