/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.MonthToDateFunction;
import testutil.BaseTestCase;

public class MonthToDateTest
extends BaseTestCase {
    public void testMTD1() throws IOException {
        int[] values = new int[]{2002, 3, 21};
        String[] types = new String[]{"year", "month", "day-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = new MonthToDateFunction().getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    public void testMTD2() throws IOException {
        int[] values = new int[]{2002, 1, 3, 21};
        String[] types = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = new MonthToDateFunction().getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    public void testMTD3() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        MonthToDateFunction monthToDate = new MonthToDateFunction();
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 28));
        monthToDate.setReferenceDate(referenceDate);
        List timeMembers = monthToDate.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    public void testMTD4() throws IOException {
        int[] values = new int[]{2002, 1, 2, 4};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        MonthToDateFunction monthToDate = new MonthToDateFunction();
        ReferenceDate referenceDate = new ReferenceDate(new Date(2002, 1, 27));
        monthToDate.setReferenceDate(referenceDate);
        List timeMembers = monthToDate.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    public void testMTD5() throws IOException {
        int[] values = new int[]{2002, 100};
        String[] types = new String[]{"year", "day-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = new MonthToDateFunction().getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    public void testMTD6() throws IOException {
        int[] values = new int[]{2011, 3, 9, 4, 39, 5, 22, 265};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month", "week-of-year", "day-of-week", "day-of-month", "day-of-year"};
        TimeMember timeMember = new TimeMember(values, types);
        MonthToDateFunction monthToDate = new MonthToDateFunction();
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 8, 22));
        monthToDate.setReferenceDate(referenceDate);
        List timeMembers = monthToDate.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    public void testMTD7() throws IOException {
        int[] values = new int[]{2011, 3, 8};
        String[] types = new String[]{"year", "quarter", "month"};
        TimeMember timeMember = new TimeMember(values, types);
        List timeMembers = new MonthToDateFunction().getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    public void testMTD8() throws IOException {
        int[] values = new int[]{2011, 3, 9, 6};
        String[] types = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        MonthToDateFunction func = new MonthToDateFunction();
        func.setIsCurrent(true);
        List timeMembers = func.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    public void testMTD9() throws IOException {
        int[] values = new int[]{2011, 4, 10, 2};
        String[] types = new String[]{"year", "quarter", "month", "week-of-month"};
        TimeMember timeMember = new TimeMember(values, types);
        MonthToDateFunction func = new MonthToDateFunction();
        ReferenceDate referenceDate = new ReferenceDate(new Date(2011, 9, 12));
        func.setReferenceDate(referenceDate);
        func.setIsCurrent(true);
        List timeMembers = func.getResult(timeMember);
        this.printMembers(timeMembers);
        this.checkOutputFile();
    }

    private void printMembers(List<TimeMember> timeMembers) {
        for (TimeMember timeMember : timeMembers) {
            String[] levelTypes = timeMember.getLevelType();
            int[] memberValues = timeMember.getMemberValue();
            int i = 0;
            while (i < levelTypes.length) {
                this.testPrint(String.valueOf(levelTypes[i]) + " ");
                ++i;
            }
            this.testPrintln("");
            i = 0;
            while (i < memberValues.length) {
                this.testPrint(String.valueOf(memberValues[i]) + " ");
                ++i;
            }
            this.testPrintln("");
        }
    }
}

