/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import java.io.IOException;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.api.timefunction.IParallelPeriod;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeFunctionFactory;

public class PreviousNPeriodsFunctionTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFunctions1() throws IOException {
        int[] values = new int[]{2002, 3, 8, 7};
        String[] levels = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember member = new TimeMember(values, levels);
        TimeMember resultMember = TimeFunctionFactory.createParallelPeriodFunction((String)"year", (int)-1).getResult(member);
        int[] result = new int[]{2001, 3, 8, 7};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[2], (int)result[2]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[3], (int)result[3]);
    }

    public void testFunctions2() throws IOException {
        int[] values = new int[]{2002, 3, 8, 7};
        String[] levels = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember member = new TimeMember(values, levels);
        TimeMember resultMember = TimeFunctionFactory.createParallelPeriodFunction((String)"quarter", (int)-5).getResult(member);
        int[] result = new int[]{2001, 2, 5, 7};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[2], (int)result[2]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[3], (int)result[3]);
    }

    public void testFunctions3() throws IOException {
        int[] values = new int[]{2002, 3, 8, 7};
        String[] levels = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember member = new TimeMember(values, levels);
        TimeMember resultMember = TimeFunctionFactory.createParallelPeriodFunction((String)"month", (int)-4).getResult(member);
        int[] result = new int[]{2002, 2, 4, 7};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[2], (int)result[2]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[3], (int)result[3]);
    }

    public void testFunctions4() throws IOException {
        int[] values = new int[]{2002, 3, 8, 7};
        String[] levels = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember member = new TimeMember(values, levels);
        TimeMember resultMember = TimeFunctionFactory.createParallelPeriodFunction((String)"day-of-month", (int)-4).getResult(member);
        int[] result = new int[]{2002, 3, 8, 3};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[2], (int)result[2]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[3], (int)result[3]);
    }

    public void testFunctions5() throws IOException {
        int[] values = new int[]{2002, 3, 8, 7};
        String[] levels = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember member = new TimeMember(values, levels);
        TimeMember resultMember = TimeFunctionFactory.createParallelPeriodFunction((String)"day-of-month", (int)-10).getResult(member);
        int[] result = new int[]{2002, 3, 7, 28};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[2], (int)result[2]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[3], (int)result[3]);
    }

    public void testFunctions6() throws IOException {
        int[] values = new int[]{2002, 8, 7};
        String[] levels = new String[]{"year", "month", "day-of-month"};
        TimeMember member = new TimeMember(values, levels);
        TimeMember resultMember = TimeFunctionFactory.createParallelPeriodFunction((String)"day-of-month", (int)-10).getResult(member);
        int[] result = new int[]{2002, 7, 28};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[2], (int)result[2]);
    }

    public void testFunctions7() throws IOException {
        int[] values = new int[]{2002, 8, 3};
        String[] levels = new String[]{"year", "month", "week-of-month"};
        TimeMember member = new TimeMember(values, levels);
        IParallelPeriod parallelPeriod = TimeFunctionFactory.createParallelPeriodFunction((String)"week-of-month", (int)-5);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2002, 7, 20));
        ((AbstractMDX)parallelPeriod).setReferenceDate(referenceDate);
        TimeMember resultMember = parallelPeriod.getResult(member);
        int[] result = new int[]{2002, 7, 3};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[2], (int)result[2]);
    }

    public void testFunctions8() throws IOException {
        int[] values = new int[]{2002, 125};
        String[] levels = new String[]{"year", "day-of-year"};
        TimeMember member = new TimeMember(values, levels);
        TimeMember resultMember = TimeFunctionFactory.createParallelPeriodFunction((String)"day-of-year", (int)-25).getResult(member);
        int[] result = new int[]{2002, 100};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
    }

    public void testFunctions9() throws IOException {
        int[] values = new int[]{2002, 23};
        String[] levels = new String[]{"year", "week-of-year"};
        TimeMember member = new TimeMember(values, levels);
        IParallelPeriod parallelPeriod = TimeFunctionFactory.createParallelPeriodFunction((String)"week-of-year", (int)-10);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2002, 5, 5));
        ((AbstractMDX)parallelPeriod).setReferenceDate(referenceDate);
        TimeMember resultMember = parallelPeriod.getResult(member);
        int[] result = new int[]{2002, 13};
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[0], (int)result[0]);
        PreviousNPeriodsFunctionTest.assertEquals((int)resultMember.getMemberValue()[1], (int)result[1]);
    }
}

