/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;
import org.eclipse.birt.data.engine.olap.data.util.DiskIndex;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;

public class DiskIndexTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDiskIndexBytes() throws IOException, DataException {
        int keyNumber = 100;
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = 0;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{this.getBytes(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        int i2 = 0;
        while (i2 < keyNumber) {
            key = indexTree.findFirst(new Object[]{this.getBytes(i2)});
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)this.getBytes(i2));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)i2);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(i2 * 4));
            int iValue = (int)(Math.random() * (double)keyNumber);
            key = indexTree.findFirst(new Object[]{this.getBytes(iValue)});
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)this.getBytes(iValue));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)iValue);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(iValue * 4));
            ++i2;
        }
        DiskIndexTest.assertEquals((Object)indexTree.findFirst(new Object[]{this.getBytes(120)}), null);
        keyList.clear();
        keyList.close();
    }

    private Bytes getBytes(int i) {
        byte[] b = null;
        b = new byte[]{(byte)i, (byte)(i + 1), (byte)(i + 2)};
        return new Bytes(b);
    }

    public void testDiskIndexDate() throws IOException, DataException {
        int i = 1;
        while (i < 10) {
            this.DiskIndexDateTest(i);
            ++i;
        }
        this.DiskIndexDateTest(200);
        this.DiskIndexDateTest(2000);
    }

    private void DiskIndexDateTest(int keyNumber) throws IOException, DataException {
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = 0;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{new Date(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        int i2 = 0;
        while (i2 < keyNumber) {
            key = indexTree.findFirst(new Object[]{new Date(i2)});
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Date(i2));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)i2);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(i2 * 4));
            int iValue = (int)(Math.random() * (double)keyNumber);
            key = indexTree.findFirst(new Object[]{new Date(iValue)});
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Date(iValue));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)iValue);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(iValue * 4));
            ++i2;
        }
        DiskIndexTest.assertEquals((Object)indexTree.findFirst(new Object[]{new Date(-200L)}), null);
        DiskIndexTest.assertEquals((Object)indexTree.findFirst(new Object[]{new Date(keyNumber)}), null);
        keyList.clear();
        keyList.close();
    }

    public void testDiskIndexInteger() throws IOException, DataException {
        int keyNumber = 10000;
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = -100;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{new Integer(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        System.out.println("create index running  :" + System.currentTimeMillis() / 100L);
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        System.out.println("create index finished :" + System.currentTimeMillis() / 100L);
        System.out.println("search running    :" + System.currentTimeMillis() / 100L);
        int i2 = -100;
        while (i2 < keyNumber) {
            key = indexTree.findFirst(new Object[]{new Integer(i2)});
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(i2));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)i2);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(i2 * 4));
            int iValue = (int)(Math.random() * (double)keyNumber);
            key = indexTree.findFirst(new Object[]{new Integer(iValue)});
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(iValue));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)iValue);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(iValue * 4));
            ++i2;
        }
        DiskIndexTest.assertEquals((Object)indexTree.findFirst(new Object[]{new Integer(-200)}), null);
        DiskIndexTest.assertEquals((Object)indexTree.findFirst(new Object[]{new Integer(keyNumber + 200)}), null);
        System.out.println("search finished   :" + System.currentTimeMillis() / 100L);
        keyList.clear();
        keyList.close();
    }

    public void testDiskIndexInteger1() throws IOException, DataException {
        this.integerTestForDiskIndex(1);
        this.integerTestForDiskIndex(2);
        this.integerTestForDiskIndex(3);
        this.integerTestForDiskIndex(4);
        this.integerTestForDiskIndex(6);
        this.integerTestForDiskIndex(8);
        this.integerTestForDiskIndex(9);
        this.integerTestForDiskIndex(10);
    }

    private void integerTestForDiskIndex(int keyNumber) throws IOException, DataException {
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = 0;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{new Integer(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        int i2 = 0;
        while (i2 < keyNumber) {
            key = indexTree.findFirst(new Object[]{new Integer(i2)});
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(i2));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)i2);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(i2 * 4));
            int iValue = (int)(Math.random() * (double)keyNumber);
            key = indexTree.findFirst(new Object[]{new Integer(iValue)});
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(iValue));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)iValue);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(iValue * 4));
            ++i2;
        }
        DiskIndexTest.assertEquals((Object)indexTree.findFirst(new Object[]{new Integer(-100)}), null);
        DiskIndexTest.assertEquals((Object)indexTree.findFirst(new Object[]{new Integer(keyNumber)}), null);
        keyList.clear();
        keyList.close();
    }

    public void testDiskIndexInteger2() throws IOException, DataException {
        int keyNumber = 3000;
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = -100;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{new Integer(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        System.out.println("create index running  :" + System.currentTimeMillis() / 100L);
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        System.out.println("create index finished :" + System.currentTimeMillis() / 100L);
        System.out.println("search running    :" + System.currentTimeMillis() / 100L);
        ISelection[] selections = new ISelection[]{SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(100)}, (boolean)true, (boolean)false)};
        IDiskArray list = indexTree.find(selections);
        DiskIndexTest.assertEquals((int)list.size(), (int)99);
        int i2 = 0;
        while (i2 < list.size()) {
            key = (IndexKey)list.get(i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(i2 + 1));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)(i2 + 1));
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)((i2 + 1) * 4));
            ++i2;
        }
        selections[0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(-1000)}, (Object[])new Object[]{new Integer(100)}, (boolean)true, (boolean)false);
        list = indexTree.find(selections);
        DiskIndexTest.assertEquals((int)list.size(), (int)200);
        i2 = 0;
        while (i2 < list.size()) {
            key = (IndexKey)list.get(i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(i2 - 100));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)(i2 - 100));
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)((i2 - 100) * 4));
            ++i2;
        }
        selections[0] = SelectionFactory.createRangeSelection(null, (Object[])new Object[]{new Integer(100)}, (boolean)true, (boolean)false);
        list = indexTree.find(selections);
        DiskIndexTest.assertEquals((int)list.size(), (int)200);
        i2 = 0;
        while (i2 < list.size()) {
            key = (IndexKey)list.get(i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(i2 - 100));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)(i2 - 100));
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)((i2 - 100) * 4));
            ++i2;
        }
        selections[0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(keyNumber + 1)}, (Object[])new Object[]{new Integer(keyNumber + 10)}, (boolean)true, (boolean)false);
        list = indexTree.find(selections);
        DiskIndexTest.assertTrue((list == null ? 1 : 0) != 0);
        keyList.clear();
        keyList.close();
        System.out.println("search finished   :" + System.currentTimeMillis() / 100L);
    }

    public void testDiskIndexInteger3() throws IOException, DataException {
        int keyNumber = 3000;
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = -100;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{new Integer(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        System.out.println("create index running  :" + System.currentTimeMillis() / 100L);
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        System.out.println("create index finished :" + System.currentTimeMillis() / 100L);
        System.out.println("search running    :" + System.currentTimeMillis() / 100L);
        Object[][] selectedObjs = new Object[][]{{new Integer(-101)}, {new Integer(-100)}, {new Integer(-32)}, {new Integer(-10)}, {new Integer(0)}, {new Integer(1)}, {new Integer(81)}, {new Integer(keyNumber - 1)}, {new Integer(keyNumber)}, {new Integer(keyNumber + 1)}};
        int[] nArray = new int[7];
        nArray[0] = -100;
        nArray[1] = -32;
        nArray[2] = -10;
        nArray[4] = 1;
        nArray[5] = 81;
        nArray[6] = keyNumber - 1;
        int[] resultObjs = nArray;
        ISelection[] selections = new ISelection[]{SelectionFactory.createMutiKeySelection((Object[][])selectedObjs)};
        IDiskArray list = indexTree.find(selections);
        DiskIndexTest.assertEquals((int)list.size(), (int)resultObjs.length);
        int i2 = 0;
        while (i2 < list.size()) {
            key = (IndexKey)list.get(i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(resultObjs[i2]));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)resultObjs[i2]);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(resultObjs[i2] * 4));
            ++i2;
        }
        list.clear();
        list.close();
        keyList.clear();
        keyList.close();
        System.out.println("search finished   :" + System.currentTimeMillis() / 100L);
    }

    public void testDiskIndexInteger4() throws IOException, DataException {
        int keyNumber = 100000;
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = -100;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{new Integer(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        System.out.println("create index running  :" + System.currentTimeMillis() / 100L);
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        System.out.println("create index finished :" + System.currentTimeMillis() / 100L);
        Object[][] selectedObjs1 = new Object[][]{{new Integer(-101)}, {new Integer(-100)}, {new Integer(-32)}, {new Integer(-10)}, {new Integer(0)}, {new Integer(1)}, {new Integer(81)}};
        Object[][] selectedObjs2 = new Object[][]{{new Integer(keyNumber - 1)}, {new Integer(keyNumber)}, {new Integer(keyNumber + 1)}};
        int[] nArray = new int[6];
        nArray[0] = -100;
        nArray[1] = -32;
        nArray[2] = -10;
        nArray[4] = 1;
        nArray[5] = 81;
        int[] resultObjs1 = nArray;
        int[] resultObjs2 = new int[]{keyNumber - 1};
        ISelection[] selections = new ISelection[]{SelectionFactory.createMutiKeySelection((Object[][])selectedObjs1), SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1000)}, (Object[])new Object[]{new Integer(1100)}, (boolean)true, (boolean)true), SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1101)}, (Object[])new Object[]{new Integer(2001)}, (boolean)false, (boolean)true), SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(10000)}, (Object[])new Object[]{new Integer(12001)}, (boolean)true, (boolean)false), SelectionFactory.createMutiKeySelection((Object[][])selectedObjs2)};
        System.out.println("search running    :" + System.currentTimeMillis() / 100L);
        IDiskArray list = null;
        int i2 = 0;
        while (i2 < 1) {
            list = indexTree.find(selections);
            ++i2;
        }
        System.out.println("search finished   :" + System.currentTimeMillis() / 100L);
        DiskIndexTest.assertEquals((int)list.size(), (int)(resultObjs1.length + 101 + 900 + 2001 + resultObjs2.length));
        i2 = 0;
        while (i2 < resultObjs1.length) {
            key = (IndexKey)list.get(i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(resultObjs1[i2]));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)resultObjs1[i2]);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(resultObjs1[i2] * 4));
            ++i2;
        }
        i2 = 0;
        while (i2 < 101) {
            key = (IndexKey)list.get(resultObjs1.length + i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(1000 + i2));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)(1000 + i2));
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)((1000 + i2) * 4));
            ++i2;
        }
        i2 = 0;
        while (i2 < 900) {
            key = (IndexKey)list.get(resultObjs1.length + 101 + i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(1102 + i2));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)(1102 + i2));
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)((1102 + i2) * 4));
            ++i2;
        }
        i2 = 0;
        while (i2 < 2001) {
            key = (IndexKey)list.get(resultObjs1.length + 101 + 900 + i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(10000 + i2));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)(10000 + i2));
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)((10000 + i2) * 4));
            ++i2;
        }
        i2 = 0;
        while (i2 < resultObjs2.length) {
            key = (IndexKey)list.get(resultObjs1.length + 101 + 900 + 2001 + i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(resultObjs2[i2]));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)resultObjs2[i2]);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(resultObjs2[i2] * 4));
            ++i2;
        }
        list.clear();
        list.close();
        keyList.clear();
        keyList.close();
    }

    public void testDiskIndexInteger5() throws IOException, DataException {
        int keyNumber = 1000;
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = 0;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{new Integer(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        key = new IndexKey();
        key.setKey(new Object[]{new Integer(81)});
        key.setDimensionPos(new int[]{keyNumber});
        key.setOffset(new int[]{keyNumber * 4});
        keyList.add((Object)key);
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        System.out.println("create index finished :" + System.currentTimeMillis() / 100L);
        Object[][] selectedObjs1 = new Object[][]{{new Integer(0)}, {new Integer(81)}};
        Object[][] selectedObjs2 = new Object[][]{{new Integer(keyNumber - 1)}, {new Integer(keyNumber)}, {new Integer(keyNumber + 1)}};
        ISelection[] selections = new ISelection[]{SelectionFactory.createMutiKeySelection((Object[][])selectedObjs1), SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(81)}, (Object[])new Object[]{new Integer(90)}, (boolean)true, (boolean)true), SelectionFactory.createMutiKeySelection((Object[][])selectedObjs2)};
        System.out.println("search running    :" + System.currentTimeMillis() / 100L);
        IDiskArray list = null;
        int i2 = 0;
        while (i2 < 1) {
            list = indexTree.find(selections);
            ++i2;
        }
        key = (IndexKey)list.get(0);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(0));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)0);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(1);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(81));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)81);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(1);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(81));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[1], (int)keyNumber);
        DiskIndexTest.assertEquals((int)key.getOffset()[1], (int)(key.getDimensionPos()[1] * 4));
        list.clear();
        list.close();
        keyList.clear();
        keyList.close();
    }

    public void testDiskIndexTopBottom() throws IOException, DataException {
        int keyNumber = 1000;
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), keyNumber);
        IndexKey key = null;
        int i = 0;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{new Integer(i)});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        key = new IndexKey();
        key.setKey(new Object[]{new Integer(1001)});
        key.setDimensionPos(new int[]{1001});
        key.setOffset(new int[]{4004});
        keyList.add((Object)key);
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        IDiskArray list = null;
        list = indexTree.topN(1);
        DiskIndexTest.assertEquals((int)list.size(), (int)1);
        key = (IndexKey)list.get(0);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(1001));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)1001);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        list = indexTree.topN(3);
        DiskIndexTest.assertEquals((int)list.size(), (int)3);
        key = (IndexKey)list.get(0);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(998));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)998);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(1);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(999));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)999);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(2);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(1001));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)1001);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        list = indexTree.topPercent(0.003);
        DiskIndexTest.assertEquals((int)list.size(), (int)3);
        key = (IndexKey)list.get(0);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(998));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)998);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(1);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(999));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)999);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(2);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(1001));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)1001);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        list = indexTree.bottomN(3);
        DiskIndexTest.assertEquals((int)list.size(), (int)3);
        key = (IndexKey)list.get(0);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(0));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)0);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(1);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(1));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)1);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(2);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(2));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)2);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        list = indexTree.bottomPercent(0.003);
        DiskIndexTest.assertEquals((int)list.size(), (int)3);
        key = (IndexKey)list.get(0);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(0));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)0);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(1);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(1));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)1);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        key = (IndexKey)list.get(2);
        DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)new Integer(2));
        DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)2);
        DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(key.getDimensionPos()[0] * 4));
        list.clear();
        list.close();
        keyList.clear();
        keyList.close();
    }

    public void testDiskIndexString4() throws IOException, DataException {
        int keyNumber = 100000;
        BufferedStructureArray keyList = new BufferedStructureArray(IndexKey.getCreator(), 4000);
        IndexKey key = null;
        int i = 1;
        while (i < keyNumber) {
            key = new IndexKey();
            key.setKey(new Object[]{"abcdefghijklmno" + new Integer(i).toString()});
            key.setDimensionPos(new int[]{i});
            key.setOffset(new int[]{i * 4});
            keyList.add((Object)key);
            ++i;
        }
        System.out.println("create index running  :" + System.currentTimeMillis() / 100L);
        DiskIndex indexTree = DiskIndex.createIndex((IDocumentManager)DocumentManagerFactory.createFileDocumentManager(), (String)"student_index", (int)3, (IDiskArray)keyList, (boolean)false);
        System.out.println("create index finished :" + System.currentTimeMillis() / 100L);
        Object[][] selectedObjs1 = new Object[][]{{"abcdefghijklmno" + new Integer(0).toString()}, {"abcdefghijklmno" + new Integer(100).toString()}, {"abcdefghijklmno" + new Integer(101).toString()}, {"abcdefghijklmno" + new Integer(102).toString()}, {"abcdefghijklmno" + new Integer(110).toString()}, {"abcdefghijklmno" + new Integer(121).toString()}, {"abcdefghijklmno" + new Integer(122).toString()}, {"abcdefghijklmno" + new Integer(134).toString()}};
        Object[][] selectedObjs2 = new Object[][]{{"abcdefghijklmno" + new Integer(9999).toString()}, {"abcdefghijklmno" + new Integer(99999).toString()}, {"abcdefghijklmno" + new Integer(999999).toString()}};
        int[] resultObjs1 = new int[]{100, 101, 102, 110, 121, 122, 134};
        int[] resultObjs2 = new int[]{9999, 99999};
        ISelection[] selections = new ISelection[]{SelectionFactory.createMutiKeySelection((Object[][])selectedObjs1), SelectionFactory.createRangeSelection((Object[])new Object[]{"abcdefghijklmno" + new Integer(20000).toString()}, (Object[])new Object[]{"abcdefghijklmno" + new Integer(20100).toString()}, (boolean)true, (boolean)true), SelectionFactory.createRangeSelection((Object[])new Object[]{"abcdefghijklmno" + new Integer(30000).toString()}, (Object[])new Object[]{"abcdefghijklmno" + new Integer(30900).toString()}, (boolean)false, (boolean)true), SelectionFactory.createRangeSelection((Object[])new Object[]{"abcdefghijklmno" + new Integer(40000).toString()}, (Object[])new Object[]{"abcdefghijklmno" + new Integer(42001).toString()}, (boolean)true, (boolean)false), SelectionFactory.createMutiKeySelection((Object[][])selectedObjs2)};
        System.out.println("search running    :" + System.currentTimeMillis() / 100L);
        IDiskArray list = null;
        int i2 = 0;
        while (i2 < 1) {
            list = indexTree.find(selections);
            ++i2;
        }
        System.out.println("search finished   :" + System.currentTimeMillis() / 100L);
        DiskIndexTest.assertEquals((int)list.size(), (int)3343);
        i2 = 0;
        while (i2 < resultObjs1.length) {
            key = (IndexKey)list.get(i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)("abcdefghijklmno" + new Integer(resultObjs1[i2]).toString()));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)resultObjs1[i2]);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(resultObjs1[i2] * 4));
            ++i2;
        }
        i2 = 0;
        while (i2 < 101) {
            key = (IndexKey)list.get(resultObjs1.length + i2);
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)new Integer(key.getKey()[0].toString().substring(15)));
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(new Integer(key.getKey()[0].toString().substring(15)) * 4));
            ++i2;
        }
        i2 = 0;
        while (i2 < resultObjs2.length) {
            key = (IndexKey)list.get(list.size() - resultObjs2.length + i2);
            DiskIndexTest.assertEquals((Object)key.getKey()[0], (Object)("abcdefghijklmno" + new Integer(resultObjs2[i2]).toString()));
            DiskIndexTest.assertEquals((int)key.getDimensionPos()[0], (int)resultObjs2[i2]);
            DiskIndexTest.assertEquals((int)key.getOffset()[0], (int)(resultObjs2[i2] * 4));
            ++i2;
        }
        list.clear();
        list.close();
        keyList.clear();
        keyList.close();
    }
}

