/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.MemberForStressTest;
import org.eclipse.birt.data.engine.olap.data.util.MemberForTest2;

public class DiskSortedStackTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDistinctAsc() throws IOException {
        try {
            int objectNumber = 1001;
            DiskSortedStack stack = new DiskSortedStack(100, true, true, MemberForTest2.getMemberCreator());
            stack.push((Object)DiskSortedStackTest.createMember(200));
            stack.push((Object)DiskSortedStackTest.createMember(250));
            stack.push((Object)DiskSortedStackTest.createMember(208));
            stack.push((Object)DiskSortedStackTest.createMember(211));
            stack.push((Object)DiskSortedStackTest.createMember(211));
            stack.push((Object)DiskSortedStackTest.createMember(213));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(i));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(i));
                ++i;
            }
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testDistinctAsc1() throws IOException {
        try {
            int objectNumber = 1001;
            DiskSortedStack stack = new DiskSortedStack(100, true, true, MemberForTest2.getMemberCreator());
            stack.push((Object)DiskSortedStackTest.createMember(200));
            stack.push((Object)DiskSortedStackTest.createMember(250));
            stack.push((Object)DiskSortedStackTest.createMember(208));
            stack.push((Object)DiskSortedStackTest.createMember(211));
            stack.push((Object)DiskSortedStackTest.createMember(211));
            stack.push((Object)DiskSortedStackTest.createMember(213));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(1));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(2));
                ++i;
            }
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(1));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2));
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testDistinctAsc2() throws IOException {
        try {
            int objectNumber = 1001;
            DiskSortedStack stack = new DiskSortedStack(2000, true, true, MemberForTest2.getMemberCreator());
            stack.push((Object)DiskSortedStackTest.createMember(200));
            stack.push((Object)DiskSortedStackTest.createMember(250));
            stack.push((Object)DiskSortedStackTest.createMember(208));
            stack.push((Object)DiskSortedStackTest.createMember(211));
            stack.push((Object)DiskSortedStackTest.createMember(211));
            stack.push((Object)DiskSortedStackTest.createMember(213));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(i));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(i));
                ++i;
            }
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testStess() throws IOException {
        try {
            long startTime = System.currentTimeMillis();
            int objectNumber = 10000;
            DiskSortedStack stack = new DiskSortedStack(4000, true, true, MemberForStressTest.getMemberCreator());
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMemberForStressTest(i));
                ++i;
            }
            System.out.println("used push:" + (System.currentTimeMillis() - startTime) / 100L);
            i = 0;
            while (i < objectNumber) {
                stack.pop();
                ++i;
            }
            stack.close();
            System.out.println("used pop:" + (System.currentTimeMillis() - startTime) / 100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testDistinctDesc() throws IOException {
        try {
            int objectNumber = 1001;
            DiskSortedStack stack = new DiskSortedStack(100, false, true, MemberForTest2.getMemberCreator());
            stack.push((Object)DiskSortedStackTest.createMember(200));
            stack.push((Object)DiskSortedStackTest.createMember(250));
            stack.push((Object)DiskSortedStackTest.createMember(208));
            stack.push((Object)DiskSortedStackTest.createMember(211));
            stack.push((Object)DiskSortedStackTest.createMember(211));
            stack.push((Object)DiskSortedStackTest.createMember(213));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(i));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(objectNumber - 1 - i));
                ++i;
            }
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testDistinctDesc1() throws IOException {
        try {
            int objectNumber = 1001;
            DiskSortedStack stack = new DiskSortedStack(100, false, true, MemberForTest2.getMemberCreator());
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(10));
                ++i;
            }
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(10));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), null);
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testNotDistinctAsc() throws IOException {
        try {
            int objectNumber = 1001;
            DiskSortedStack stack = new DiskSortedStack(100, true, false, MemberForTest2.getMemberCreator());
            stack.push((Object)DiskSortedStackTest.createMember(2000));
            stack.push((Object)DiskSortedStackTest.createMember(2050));
            stack.push((Object)DiskSortedStackTest.createMember(2008));
            stack.push((Object)DiskSortedStackTest.createMember(2011));
            stack.push((Object)DiskSortedStackTest.createMember(2011));
            stack.push((Object)DiskSortedStackTest.createMember(2013));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(i));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(i));
                ++i;
            }
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2000));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2008));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2011));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2011));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2013));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2050));
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testNotDistinctDesc() throws IOException {
        try {
            int objectNumber = 1001;
            DiskSortedStack stack = new DiskSortedStack(100, false, false, MemberForTest2.getMemberCreator());
            stack.push((Object)DiskSortedStackTest.createMember(2000));
            stack.push((Object)DiskSortedStackTest.createMember(2050));
            stack.push((Object)DiskSortedStackTest.createMember(2008));
            stack.push((Object)DiskSortedStackTest.createMember(2011));
            stack.push((Object)DiskSortedStackTest.createMember(2011));
            stack.push((Object)DiskSortedStackTest.createMember(2013));
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(i));
                ++i;
            }
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2050));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2013));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2011));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2011));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2008));
            DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(2000));
            i = 0;
            while (i < objectNumber) {
                MemberForTest2 memberForTest = (MemberForTest2)stack.pop();
                DiskSortedStackTest.assertEquals((Object)memberForTest, (Object)DiskSortedStackTest.createMember(objectNumber - 1 - i));
                ++i;
            }
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testNotDistinctDesc1() throws IOException {
        try {
            int objectNumber = 1001;
            DiskSortedStack stack = new DiskSortedStack(100, false, false, MemberForTest2.getMemberCreator());
            int i = 0;
            while (i < objectNumber) {
                stack.push((Object)DiskSortedStackTest.createMember(10));
                ++i;
            }
            i = 0;
            while (i < objectNumber) {
                DiskSortedStackTest.assertEquals((Object)stack.pop(), (Object)DiskSortedStackTest.createMember(10));
                ++i;
            }
            DiskSortedStackTest.assertEquals((Object)stack.pop(), null);
            stack.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static MemberForTest2 createMember(int i) {
        int iField = i;
        Date dateField = new Date(190001000 + i * 1000);
        String stringField = "string" + i;
        double doubleField = (double)i + 10.0;
        BigDecimal bigDecimalField = new BigDecimal("1010101010100101010110" + i);
        boolean booleanField = i % 2 == 0;
        return new MemberForTest2(iField, dateField, stringField, doubleField, bigDecimalField, booleanField);
    }

    private static MemberForStressTest createMemberForStressTest(int i) {
        int iField = i;
        Date dateField = new Date(190001000 + i * 1000);
        String stringField = "string" + i;
        return new MemberForStressTest(iField, dateField, stringField);
    }
}

