/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.perf;

import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.perf.APIPerfTestUtil;
import org.eclipse.birt.data.engine.perf.QueryInfo;
import testutil.ConfigText;

public class APIPerfTest
extends APITestCase {
    private QueryDefinition queryDefn;
    private IBaseExpression[] exprArray;
    private String[] exprNames;
    private APIPerfTestUtil perfTest = APIPerfTestUtil.newInstance();

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData2.TableName"), ConfigText.getString("Api.TestData2.TableSQL"), ConfigText.getString("Api.TestData2.TestDataFileName"));
    }

    public void testQuery() throws Exception {
        QueryInfo queryInfo = new QueryInfo(){

            @Override
            public IBaseDataSourceDesign getDataSource() {
                return APIPerfTest.this.dataSource;
            }

            @Override
            public IBaseDataSetDesign getDataSet() {
                return APIPerfTest.this.dataSet;
            }

            @Override
            public QueryDefinition getQueryDefn() {
                return APIPerfTest.this.getQueryDefintion(false, false, false, false);
            }

            @Override
            public String[] getExprNames() {
                return APIPerfTest.this.getExpressionArray();
            }
        };
        System.out.println("time bench mark of raw query");
        this.perfTest.setQueryInfo(queryInfo);
        this.perfTest.runTimeBenchMark(true);
    }

    public void testQueryWithFilter() throws Exception {
        QueryInfo queryInfo = new QueryInfo(){

            @Override
            public IBaseDataSourceDesign getDataSource() {
                return APIPerfTest.this.dataSource;
            }

            @Override
            public IBaseDataSetDesign getDataSet() {
                return APIPerfTest.this.dataSet;
            }

            @Override
            public QueryDefinition getQueryDefn() {
                return APIPerfTest.this.getQueryDefintion(false, false, false, true);
            }

            @Override
            public String[] getExprNames() {
                return APIPerfTest.this.getExpressionArray();
            }
        };
        System.out.println("time bench mark of query with filter");
        this.perfTest.setQueryInfo(queryInfo);
        this.perfTest.runTimeBenchMark(true);
    }

    private QueryDefinition getQueryDefintion(boolean withGroup, boolean withSort, boolean withFilter, boolean withComputedColumn) {
        int i;
        if (this.queryDefn != null) {
            return this.queryDefn;
        }
        this.queryDefn = this.newReportQuery();
        this.exprArray = new IBaseExpression[3];
        this.exprNames = new String[3];
        ScriptExpression expr = new ScriptExpression("dataSetRow.ID");
        this.exprArray[0] = expr;
        this.exprNames[0] = "ID";
        expr = new ScriptExpression("dataSetRow.AMOUNT1");
        this.exprArray[1] = expr;
        this.exprNames[1] = "AMOUNT1";
        expr = new ScriptExpression("dataSetRow.AMOUNT2");
        this.exprArray[2] = expr;
        this.exprNames[2] = "AMOUNT2";
        int i2 = 0;
        while (i2 < this.exprArray.length) {
            this.queryDefn.addResultSetExpression(this.exprNames[i2], this.exprArray[i2]);
            ++i2;
        }
        if (withGroup) {
            GroupDefinition[] gdArray = new GroupDefinition[1];
            GroupDefinition gd = new GroupDefinition();
            gd.setKeyExpression("dataSetRow[1]");
            gdArray[0] = gd;
            i = 0;
            while (i < gdArray.length) {
                this.queryDefn.addGroup(gdArray[i]);
                ++i;
            }
        }
        if (withSort) {
            SortDefinition[] sdArray = new SortDefinition[1];
            SortDefinition sd = new SortDefinition();
            sd.setExpression("dataSetRow[1]");
            sd.setSortDirection(1);
            sdArray[0] = sd;
            i = 0;
            while (i < sdArray.length) {
                this.queryDefn.addSort(sdArray[i]);
                ++i;
            }
        }
        if (withFilter) {
            FilterDefinition exprFilter = new FilterDefinition((IBaseExpression)new ScriptExpression("row.ID>13"));
            this.queryDefn.getFilters().add(exprFilter);
        }
        if (withComputedColumn) {
            ComputedColumn computedColumn = new ComputedColumn("cc", "dataSetRow.ID*2", 0);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
        }
        return this.queryDefn;
    }

    private String[] getExpressionArray() {
        return this.exprNames;
    }
}

