/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.perf.util;

import org.eclipse.birt.data.engine.perf.util.ObjectInstance;

class SizeOf {
    private static final SizeOf instance = new SizeOf();
    private final Runtime runtime = Runtime.getRuntime();

    SizeOf() {
    }

    public static int getObjectSize(ObjectInstance objectInstance) throws Exception {
        return instance.objectSize(objectInstance);
    }

    private int objectSize(ObjectInstance objectInstance) throws Exception {
        Object[] objects = new Object[1000];
        long heapSize1 = this.getActualUsedMemory();
        int i = 0;
        while (i < 1000) {
            objects[i] = objectInstance.newInstance();
            ++i;
        }
        long heapSize2 = this.getActualUsedMemory();
        return Math.round((float)(heapSize2 - heapSize1) / 1000.0f);
    }

    public static long getUsedMemory() throws Exception {
        return instance.getActualUsedMemory();
    }

    private long getActualUsedMemory() throws Exception {
        this.runGC();
        return this.getCurrentUsedMemory();
    }

    private void runGC() throws Exception {
        int i = 0;
        while (i < 15) {
            this._runGC();
            ++i;
        }
    }

    private void _runGC() throws Exception {
        long usedMemBeforeGC = this.getCurrentUsedMemory();
        long usedMemAfterGC = Long.MAX_VALUE;
        int i = 0;
        while (usedMemBeforeGC < usedMemAfterGC && i < 1000) {
            this.runtime.runFinalization();
            this.runtime.gc();
            Thread.yield();
            usedMemAfterGC = usedMemBeforeGC;
            usedMemBeforeGC = this.getCurrentUsedMemory();
            ++i;
        }
    }

    private long getCurrentUsedMemory() {
        return this.runtime.totalMemory() - this.runtime.freeMemory();
    }
}

