/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.regre.db;

import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import testutil.ConfigText;

public class ConnectionTest
extends APITestCase {
    @Override
    protected void setUp() throws Exception {
        System.setProperty("DTETest.otherDB", "true");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("DTETest.otherDB", "false");
    }

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Regre.ConnectTest.TableName"), null, null);
    }

    public void testConnection() throws Exception {
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("dataSetRow.CLIENTID", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.EMAIL", 0)};
        this.createAndRunQuery(expressions);
    }

    private void createAndRunQuery(IBaseExpression[] expressions) throws Exception {
        String[] names = new String[]{"_CLIENTID", "_CITY", "_COUNTRY", "_EMAIL"};
        QueryDefinition queryDefn = this.newReportQuery();
        if (expressions != null) {
            int i = 0;
            while (i < expressions.length) {
                queryDefn.addResultSetExpression(names[i], expressions[i]);
                ++i;
            }
        }
        this.outputQueryResult(this.executeQuery((IQueryDefinition)queryDefn), names);
    }
}

