/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import utility.DomWriter;
import utility.EngineCase;

public abstract class BaseSmokeTest
extends EngineCase {
    private Map testStatus = new LinkedHashMap();
    private Map engineInternalErrors = new LinkedHashMap();

    protected abstract String getWorkingFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() {
    }

    public final void testSmoke() throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        String path = "TestCases/EngineSmokeTestReport.txt";
        InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while (true) {
            try {
                String content;
                while ((content = reader.readLine()) != null) {
                    resultList.add(content);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        for (String inputPath : resultList) {
            inputPath = inputPath.replace('\\', '/');
            this.copyResource(inputPath, inputPath, "TestCases");
        }
        String inputFolder = String.valueOf(this.tempFolder()) + this.getFullQualifiedClassName() + "/TestCases/input/";
        String outputFolder = String.valueOf(this.tempFolder()) + this.getFullQualifiedClassName() + "/TestCases/output/";
        File inputFile = new File(inputFolder);
        if (!inputFile.isDirectory() || !inputFile.exists()) {
            throw new Exception("Input foler: " + inputFolder + " doesn't exist.");
        }
        File[] reports = inputFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        int i = 0;
        while (i < reports.length) {
            File report = reports[i];
            String html = report.getName().replaceAll(".xml", ".html");
            try {
                List engineErrors = this.runAndRender_WithPagination(String.valueOf(inputFolder) + report.getName(), String.valueOf(outputFolder) + html);
                this.compareHTML(html, html);
                if (engineErrors != null && engineErrors.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    Iterator iter = engineErrors.iterator();
                    while (iter.hasNext()) {
                        sb.append(iter.next().toString());
                        sb.append("\n");
                    }
                    this.engineInternalErrors.put(report.getName(), sb.toString());
                }
                this.testStatus.put(report.getName(), null);
            }
            catch (Exception e) {
                this.testStatus.put(report.getName(), e.toString());
            }
            ++i;
        }
        DomWriter domwriter = new DomWriter();
        domwriter.setOutput(new FileWriter(String.valueOf(this.getBasePath()) + "TESTS-" + this.getName() + "SmokeTests.xml"));
        domwriter.setCanonical(true);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element testsuite = doc.createElement("testsuite");
        testsuite.setAttribute("name", this.getName());
        int failuresCount = 0;
        for (Map.Entry entry : this.testStatus.entrySet()) {
            String testCaseName = (String)entry.getKey();
            Object status = entry.getValue();
            Element testcase = doc.createElement("testcase");
            testcase.setAttribute("name", testCaseName);
            if (status == null) {
                testcase.setAttribute("errors", null);
            } else {
                testcase.setAttribute("errors", status.toString());
                ++failuresCount;
            }
            String internalError = (String)this.engineInternalErrors.get(testCaseName);
            if (internalError == null) {
                testcase.setAttribute("internalErrors", null);
            } else {
                testcase.setAttribute("internalErrors", internalError);
            }
            testsuite.appendChild(testcase);
        }
        testsuite.setAttribute("failures", String.valueOf(failuresCount));
        testsuite.setAttribute("tests", String.valueOf(this.testStatus.keySet().size()));
        domwriter.write(testsuite);
    }

    protected String getBasePath() {
        return String.valueOf(new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getParent()) + "/";
    }

    private List runAndRender_WithPagination(String inputFile, String outputFile) throws EngineException {
        IReportRunnable runnable = this.engine.openReportDesign(inputFile);
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
        task.setLocale(Locale.ENGLISH);
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFileName(outputFile);
        options.setHtmlPagination(true);
        HTMLRenderContext renderContext = new HTMLRenderContext();
        renderContext.setImageDirectory("image");
        HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
        appContext.put("HTML_RENDER_CONTEXT", renderContext);
        task.setAppContext(appContext);
        options.setOutputFormat("html");
        options.getOutputSetting().put("url-encoding", "UTF-8");
        task.setRenderOption((IRenderOption)options);
        task.run();
        List errors = task.getErrors();
        task.close();
        return errors;
    }

    @Override
    protected boolean compareHTML(String golden, String output) throws Exception {
        InputStreamReader readerA = null;
        InputStreamReader readerB = null;
        boolean same = true;
        StringBuffer errorText = new StringBuffer();
        try {
            try {
                golden = String.valueOf(this.tempFolder()) + this.getFullQualifiedClassName() + "/TestCases/golden/" + golden;
                String outputFile = String.valueOf(this.tempFolder()) + this.getFullQualifiedClassName() + "/TestCases/output/" + output;
                readerA = new FileReader(golden);
                readerB = new FileReader(outputFile);
                same = this.compareHTMLFile(readerA, readerB, outputFile);
            }
            catch (IOException e) {
                errorText.append(e.toString());
                errorText.append("\n");
                e.printStackTrace();
                try {
                    readerA.close();
                    readerB.close();
                }
                catch (Exception e2) {
                    readerA = null;
                    readerB = null;
                    errorText.append(e2.toString());
                    throw new Exception(errorText.toString());
                }
            }
        }
        finally {
            try {
                readerA.close();
                readerB.close();
            }
            catch (Exception e) {
                readerA = null;
                readerB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected boolean compareHTMLFile(Reader golden, Reader output, String fileName) throws Exception {
        StringBuffer errorText = new StringBuffer();
        BufferedReader lineReaderA = null;
        BufferedReader lineReaderB = null;
        boolean same = true;
        int lineNo = 1;
        try {
            lineReaderA = new BufferedReader(golden);
            lineReaderB = new BufferedReader(output);
            String strA = lineReaderA.readLine().trim();
            String strB = lineReaderB.readLine().trim();
            while (strA != null) {
                String filterA = this.filterLine(strA);
                String filterB = this.filterLine(strB);
                same = filterA.trim().equals(filterB.trim());
                if (!same) {
                    StringBuffer message = new StringBuffer();
                    message.append("line=");
                    message.append(lineNo);
                    message.append("(");
                    message.append(fileName);
                    message.append(")");
                    message.append(" is different:\n");
                    message.append(" The line from golden file: ");
                    message.append(strA);
                    message.append("\n");
                    message.append(" The line from result file: ");
                    message.append(strB);
                    message.append("\n");
                    message.append("Text after filtering: \n");
                    message.append(" golden file: ");
                    message.append(filterA);
                    message.append("\n");
                    message.append(" result file: ");
                    message.append(filterB);
                    String outputFile = fileName;
                    String diffOutputFile = fileName.replaceAll("output", "diffOutput");
                    File parent = new File(diffOutputFile).getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    this.copyFile(outputFile, diffOutputFile);
                    throw new Exception(message.toString());
                }
                strA = lineReaderA.readLine();
                strB = lineReaderB.readLine();
                ++lineNo;
            }
            same = strA == null && strB == null;
        }
        finally {
            try {
                lineReaderA.close();
                lineReaderB.close();
            }
            catch (Exception e) {
                lineReaderA = null;
                lineReaderB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }
}

