/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.birt.report.designer.tests.TestsPlugin;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.designer.testutil.PlatformUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;

public class ImageManagerTest
extends BaseTestCase {
    private Image localImage;
    private static String iconPath;
    private static final String TEST_FILE = "icon/test.jpg";
    private static final String TEST_ERROR_FILE = "icon/error.jpg";
    private static final String TEST_URL = "http://www.eclipse.org/images/Idea.jpg";
    private static final String TEST_ERROR_URL = "http://";

    static {
        try {
            iconPath = Platform.asLocalURL((URL)TestsPlugin.getDefault().getBundle().getEntry("/")).getFile();
        }
        catch (IOException iOException) {}
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.localImage = new Image(null, String.valueOf(iconPath) + TEST_FILE);
    }

    protected void tearDown() throws Exception {
        this.localImage.dispose();
        super.tearDown();
    }

    public void testGetImageByPath() throws Exception {
        Image image = ImageManager.getInstance().getImage(String.valueOf(iconPath) + TEST_FILE);
        ImageManagerTest.assertNotNull((Object)image);
        if (PlatformUtil.isWindows()) {
            ImageManagerTest.assertTrue((boolean)Arrays.equals(image.getImageData().data, this.localImage.getImageData().data));
        }
    }

    public void testGetImageByWrongPath() throws Exception {
        ImageManagerTest.assertNull((Object)ImageManager.getInstance().getImage(TEST_ERROR_FILE));
    }

    public void testGetImageByURL() throws Exception {
        Image image = ImageManager.getInstance().getImage(TEST_URL);
        ImageManagerTest.assertNotNull((Object)image);
        ImageManagerTest.assertTrue((boolean)Arrays.equals(image.getImageData().data, this.localImage.getImageData().data));
        ImageManagerTest.assertEquals((Object)image, (Object)ImageManager.getInstance().getImage(TEST_URL));
    }

    public void testGetImageByWrongURL() throws Exception {
        ImageManagerTest.assertNull((Object)ImageManager.getInstance().getImage(TEST_ERROR_URL));
    }

    public void testGetImageByEmbeddedImage() throws Exception {
        EmbeddedImage embeddedImage = new EmbeddedImage("Test");
        FileInputStream is = new FileInputStream(String.valueOf(iconPath) + TEST_FILE);
        byte[] data = new byte[is.available()];
        is.read(data);
        embeddedImage.setData(data);
        this.getReportDesign().handle().addImage(embeddedImage);
        Image image = ImageManager.getInstance().getEmbeddedImage((ModuleHandle)this.getReportDesignHandle(), embeddedImage.getName());
        ImageManagerTest.assertNotNull((Object)image);
        if (PlatformUtil.isWindows()) {
            ImageManagerTest.assertTrue((boolean)Arrays.equals(image.getImageData().data, this.localImage.getImageData().data));
        }
        ImageManagerTest.assertEquals((Object)image, (Object)ImageManager.getInstance().getEmbeddedImage((ModuleHandle)this.getReportDesignHandle(), embeddedImage.getName()));
    }

    public void testLoadImage() throws IOException {
        Image image = ImageManager.getInstance().loadImage(String.valueOf(iconPath) + TEST_FILE);
        ImageManagerTest.assertNotNull((Object)image);
        ImageManagerTest.assertEquals((Object)image, (Object)ImageManager.getInstance().loadImage(String.valueOf(iconPath) + TEST_FILE));
        ImageManagerTest.assertEquals((Object)image, (Object)ImageManager.getInstance().getImage(String.valueOf(iconPath) + TEST_FILE));
        try {
            ImageManager.getInstance().loadImage(TEST_ERROR_FILE);
        }
        catch (Exception exception) {
            return;
        }
        ImageManagerTest.fail();
    }
}

