/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveFlushTest
extends TestCase {
    public void testFlush() throws IOException {
        ArchiveFile af = new ArchiveFile("test.dat", "rw+");
        try {
            ArchiveReader reader = new ArchiveReader((IArchiveFile)af);
            ArchiveWriter writer = new ArchiveWriter((IArchiveFile)af);
            RAOutputStream out = writer.createOutputStream("test");
            RAInputStream in = reader.getInputStream("test");
            out.write(12);
            ArchiveFlushTest.assertEquals((int)0, (int)in.available());
            af.flush();
            ArchiveFlushTest.assertEquals((int)1, (int)in.available());
            int v = in.read();
            ArchiveFlushTest.assertEquals((int)12, (int)v);
            v = in.read();
            ArchiveFlushTest.assertEquals((int)-1, (int)v);
            in.close();
            out.close();
            reader.close();
            writer.finish();
        }
        finally {
            af.close();
            new File("test.dat").delete();
        }
    }

    public void testReadWrite() throws IOException {
        ArchiveFile af = new ArchiveFile("test.dat", "rw+");
        try {
            ArchiveWriter writer = new ArchiveWriter((IArchiveFile)af);
            ArchiveReader reader = new ArchiveReader((IArchiveFile)af);
            ArchiveEntry entry1 = af.createEntry("/test1");
            byte[] byArray = new byte[4];
            byArray[3] = 1;
            entry1.write(0L, byArray, 0, 4);
            ArchiveFlushTest.assertEquals((long)4L, (long)entry1.getLength());
            RAInputStream in = reader.getInputStream("/test1");
            ArchiveFlushTest.assertEquals((int)1, (int)in.readInt());
            in.close();
            entry1.close();
            RAOutputStream out = writer.createOutputStream("/test2");
            out.writeInt(2);
            in = reader.getInputStream("/test2");
            ArchiveFlushTest.assertEquals((int)0, (int)in.available());
            af.flush();
            ArchiveFlushTest.assertEquals((int)2, (int)in.readInt());
            out.writeInt(3);
            out.close();
            ArchiveFlushTest.assertEquals((int)3, (int)in.readInt());
        }
        finally {
            af.close();
            new File("test.dat").delete();
        }
    }

    public void testMultipleThread() throws IOException {
        final Boolean[] hasErrors = new Boolean[]{Boolean.FALSE, Boolean.FALSE};
        final Boolean[] hasFinished = new Boolean[]{Boolean.FALSE, Boolean.FALSE};
        final ArchiveFile af = new ArchiveFile("test.dat", "rw+");
        try {
            ArchiveWriter writer = new ArchiveWriter((IArchiveFile)af);
            int i = 0;
            while (i < 1024) {
                RAOutputStream stream = writer.createOutputStream("stream_" + i);
                try {
                    stream.writeInt(i);
                }
                finally {
                    stream.close();
                }
                ++i;
            }
            Runnable flush = new Runnable(){

                @Override
                public void run() {
                    long count = 0L;
                    try {
                        int i;
                        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)af);
                        RAOutputStream[] streams = new RAOutputStream[1024];
                        int i2 = 0;
                        while (i2 < 1024) {
                            streams[i2] = writer.getOutputStream("stream_" + i2);
                            ++i2;
                        }
                        long start = System.currentTimeMillis();
                        do {
                            i = 0;
                            while (i < 1024) {
                                streams[i].writeInt(i);
                                ++i;
                            }
                            af.flush();
                            ++count;
                        } while (System.currentTimeMillis() - start < 2048L);
                        i = 0;
                        while (i < 1024) {
                            streams[i].close();
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        hasErrors[0] = Boolean.TRUE;
                    }
                    System.out.println("flush " + count + " times");
                    hasFinished[0] = Boolean.TRUE;
                }
            };
            Runnable openClose = new Runnable(){

                @Override
                public void run() {
                    long count = 0L;
                    try {
                        ArchiveReader reader = new ArchiveReader((IArchiveFile)af);
                        long start = System.currentTimeMillis();
                        do {
                            int i = 0;
                            while (i < 1024) {
                                RAInputStream ra = reader.getInputStream("stream_" + i);
                                ra.readInt();
                                ra.close();
                                ++i;
                            }
                            ++count;
                        } while (System.currentTimeMillis() - start < 2048L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        hasErrors[1] = Boolean.TRUE;
                    }
                    hasFinished[1] = Boolean.TRUE;
                    System.out.println("read " + count + " times");
                }
            };
            new Thread(flush).start();
            new Thread(openClose).start();
            while (hasFinished[0] != Boolean.TRUE || hasFinished[1] != Boolean.TRUE) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            ArchiveFlushTest.assertEquals((Object)Boolean.FALSE, (Object)hasErrors[0]);
            ArchiveFlushTest.assertEquals((Object)Boolean.FALSE, (Object)hasErrors[1]);
        }
        finally {
            af.close();
            new File("test.dat").delete();
        }
    }
}

