/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class FolderArchiveTest
extends TestCase {
    static final String ARCHIVE_NAME = "./utest/test.archive.folder/";
    static final String STREAM_NAME = "/teststream";

    public void setUp() {
        ArchiveUtil.deleteAllFiles((File)new File(ARCHIVE_NAME));
    }

    public void tearDown() {
        ArchiveUtil.deleteAllFiles((File)new File(ARCHIVE_NAME));
    }

    public void testReaderDuringWriter() throws Exception {
        FolderArchiveWriter writer = new FolderArchiveWriter(ARCHIVE_NAME);
        writer.initialize();
        FolderArchiveReader reader = new FolderArchiveReader(ARCHIVE_NAME);
        reader.open();
        RAOutputStream ws = writer.createRandomAccessStream(STREAM_NAME);
        ws.writeInt(1);
        ws.flush();
        RAInputStream rs = reader.getStream(STREAM_NAME);
        FolderArchiveTest.assertEquals((int)1, (int)rs.readInt());
        ws.writeLong(-1L);
        ws.flush();
        rs.refresh();
        FolderArchiveTest.assertEquals((long)-1L, (long)rs.readLong());
        ws.seek(2L);
        ws.writeLong(-2L);
        ws.flush();
        rs.refresh();
        rs.seek(2L);
        FolderArchiveTest.assertEquals((long)-2L, (long)rs.readLong());
        rs.close();
        ws.close();
        reader.close();
        writer.finish();
    }

    public void testReaderAfterWriter() throws Exception {
        FolderArchiveWriter writer = new FolderArchiveWriter(ARCHIVE_NAME);
        writer.initialize();
        RAOutputStream ws = writer.createRandomAccessStream(STREAM_NAME);
        ws.writeInt(1);
        ws.flush();
        ws.writeLong(-1L);
        ws.flush();
        ws.close();
        writer.finish();
        FolderArchiveReader reader = new FolderArchiveReader(ARCHIVE_NAME);
        reader.open();
        RAInputStream rs = reader.getStream(STREAM_NAME);
        FolderArchiveTest.assertEquals((int)1, (int)rs.readInt());
        FolderArchiveTest.assertEquals((long)-1L, (long)rs.readLong());
        rs.close();
        reader.close();
    }

    public void testReaderCrossWriter() throws Exception {
        FolderArchiveWriter writer = new FolderArchiveWriter(ARCHIVE_NAME);
        writer.initialize();
        RAOutputStream ws = writer.createRandomAccessStream(STREAM_NAME);
        ws.writeInt(1);
        ws.flush();
        FolderArchiveReader reader = new FolderArchiveReader(ARCHIVE_NAME);
        reader.open();
        ws.writeLong(-1L);
        ws.flush();
        ws.close();
        writer.finish();
        RAInputStream rs = reader.getStream(STREAM_NAME);
        FolderArchiveTest.assertEquals((int)1, (int)rs.readInt());
        FolderArchiveTest.assertEquals((long)-1L, (long)rs.readLong());
        rs.close();
        reader.close();
        reader = new FolderArchiveReader(ARCHIVE_NAME);
        reader.open();
        rs = reader.getStream(STREAM_NAME);
        FolderArchiveTest.assertEquals((int)1, (int)rs.readInt());
        FolderArchiveTest.assertEquals((long)-1L, (long)rs.readLong());
        rs.close();
        reader.close();
    }

    public void testOpenEmptyFolder() {
        try {
            new File(ARCHIVE_NAME).mkdirs();
            FolderArchiveReader reader = new FolderArchiveReader(ARCHIVE_NAME);
            reader.open();
            FolderArchiveTest.assertTrue((boolean)reader.listStreams("/").isEmpty());
            reader.close();
        }
        catch (IOException iOException) {
            FolderArchiveTest.assertFalse((boolean)true);
            return;
        }
    }

    public void testOpenNoneExistFolder() {
        try {
            ArchiveUtil.deleteAllFiles((File)new File(ARCHIVE_NAME));
            FolderArchiveReader reader = new FolderArchiveReader(ARCHIVE_NAME);
            reader.open();
            reader.close();
        }
        catch (IOException iOException) {
            FolderArchiveTest.assertTrue((!new File(ARCHIVE_NAME).exists() ? 1 : 0) != 0);
            FolderArchiveTest.assertTrue((boolean)true);
            return;
        }
        FolderArchiveTest.assertTrue((boolean)false);
    }

    public void testMutipleThreadReadWrite() {
        Command wrtCmd = new Command();
        Command readCmd = new Command();
        new Thread(new WriterRunnable(wrtCmd)).start();
        new Thread(new ReaderRunnable(readCmd)).start();
        new Thread(new ReaderRunnable(readCmd)).start();
        new Thread(new ReaderRunnable(readCmd)).start();
        new Thread(new ReaderRunnable(readCmd)).start();
        new Thread(new ReaderRunnable(readCmd)).start();
        new Thread(new ReaderRunnable(readCmd)).start();
        this.sendCommand(wrtCmd, 1);
        this.sendCommand(wrtCmd, 3);
        this.sendCommand(readCmd, 1);
        this.sendCommand(readCmd, 4);
        this.sendCommand(wrtCmd, 2);
        this.sendCommand(wrtCmd, 6);
        this.sendCommand(readCmd, 2);
        this.sendCommand(readCmd, 1);
        this.sendCommand(readCmd, 4);
        this.sendCommand(readCmd, 2);
        this.sendCommand(readCmd, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void sendCommand(Command command, int code) {
        var3_3 = command;
        synchronized (var3_3) {
            command.command = code;
            command.ex = null;
            command.status = 1;
            command.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl17
        }
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception v1) {}
lbl17:
            // 3 sources

        } while (command.status != 0);
        if (command.ex != null) {
            FolderArchiveTest.fail((String)"Exception occurs");
        }
    }

    public void testOpenStream() throws Exception {
        FolderArchiveWriter writer = new FolderArchiveWriter(ARCHIVE_NAME);
        writer.initialize();
        RAOutputStream ws = writer.createRandomAccessStream(STREAM_NAME);
        ws.writeInt(1);
        FolderArchiveTest.assertEquals((long)4L, (long)ws.length());
        ws.flush();
        ws.writeLong(-1L);
        FolderArchiveTest.assertEquals((long)12L, (long)ws.length());
        ws.flush();
        ws.close();
        ws = writer.openRandomAccessStream(STREAM_NAME);
        FolderArchiveTest.assertEquals((long)12L, (long)ws.length());
        writer.finish();
    }

    static class Command {
        static final int STATUS_START = 1;
        static final int STATUS_FINISH = 0;
        static final int OPEN = 1;
        static final int CLOSE = 2;
        static final int WRITING = 3;
        static final int READING = 4;
        static final int EXIT = 6;
        int command;
        int status;
        int threads;
        Exception ex;

        Command() {
        }
    }

    class ReaderRunnable
    implements Runnable {
        Command command;
        FolderArchiveReader reader;

        ReaderRunnable(Command command) {
            this.command = command;
            ++this.command.threads;
        }

        protected void doOpen() throws Exception {
            if (this.reader == null) {
                this.reader = new FolderArchiveReader(FolderArchiveTest.ARCHIVE_NAME);
                this.reader.open();
            }
        }

        protected void doRead() throws Exception {
            if (this.reader != null) {
                RAInputStream is = this.reader.getStream("/test.txt");
                is.readInt();
                is.readInt();
                is.close();
            }
        }

        protected void doClose() throws Exception {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Command command = this.command;
                synchronized (command) {
                    try {
                        this.command.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.out.println(this.command.command);
                try {
                    switch (this.command.command) {
                        case 1: {
                            this.doOpen();
                            break;
                        }
                        case 4: {
                            this.doRead();
                            break;
                        }
                        case 2: {
                            this.doClose();
                            break;
                        }
                        case 6: {
                            this.command.status = 0;
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.command.ex = ex;
                }
                this.command.status = 0;
            }
        }
    }

    class WriterRunnable
    implements Runnable {
        Command command;
        FolderArchiveWriter writer;

        WriterRunnable(Command command) {
            this.command = command;
            ++this.command.threads;
        }

        protected void doOpen() throws Exception {
            if (this.writer == null) {
                this.writer = new FolderArchiveWriter(FolderArchiveTest.ARCHIVE_NAME);
                this.writer.initialize();
            }
        }

        protected void doWrite() throws Exception {
            if (this.writer != null) {
                RAOutputStream os = this.writer.createRandomAccessStream("/test.txt");
                os.writeInt(-1);
                os.writeInt(-1);
                os.close();
            }
        }

        protected void doClose() throws Exception {
            if (this.writer != null) {
                this.writer.finish();
                this.writer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Command command = this.command;
                synchronized (command) {
                    try {
                        this.command.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                System.out.println(this.command.command);
                try {
                    switch (this.command.command) {
                        case 1: {
                            this.doOpen();
                            break;
                        }
                        case 3: {
                            this.doWrite();
                            break;
                        }
                        case 2: {
                            this.doClose();
                            break;
                        }
                        case 6: {
                            this.command.status = 0;
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.command.ex = ex;
                }
                this.command.status = 0;
            }
        }
    }
}

