/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class TestBuffer {
    static int TEST_COUNT = 1024;
    static int LENGTH = 0x100000;
    static String ENTRY_NAME = "/test/abc.dat";
    static String ARCHIVE_NAME = "datafile.dat";
    static int[] sizes = new int[]{1, 7, 13, 31, 61, 113, 251, 509, 1021, 2039, 4091, 4093};

    public static void main(String[] args) throws IOException {
        ArchiveFile af = new ArchiveFile(ARCHIVE_NAME, "rwt");
        try {
            ArchiveWriter writer = new ArchiveWriter((IArchiveFile)af);
            ArchiveReader reader = new ArchiveReader((IArchiveFile)af);
            System.out.println("warm....");
            TestBuffer.testWriteByte(writer);
            TestBuffer.testReadByte(reader);
            TestBuffer.testWriteInteger(writer);
            TestBuffer.testReadInteger(reader);
            TestBuffer.testWriteLong(writer);
            TestBuffer.testReadLong(reader);
            TestBuffer.testWriteBytes(writer);
            TestBuffer.testReadBytes(reader);
            System.out.println();
        }
        finally {
            af.close();
            new File(ARCHIVE_NAME).delete();
        }
    }

    static void testByte(ArchiveWriter writer, ArchiveReader reader) throws IOException {
        System.out.print("byte");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < TEST_COUNT) {
            TestBuffer.testWriteByte(writer);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.print("\twrite:" + (end - start));
        start = System.currentTimeMillis();
        i = 0;
        while (i < TEST_COUNT) {
            TestBuffer.testReadByte(reader);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("\tread:" + (end - start));
    }

    static void testWriteByte(ArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createOutputStream(ENTRY_NAME);
        try {
            int i = 0;
            while (i < LENGTH) {
                out.write(i);
                ++i;
            }
        }
        finally {
            out.close();
        }
    }

    static void testReadByte(ArchiveReader reader) throws IOException {
        RAInputStream in = reader.getInputStream(ENTRY_NAME);
        try {
            int i = 0;
            while (i < LENGTH) {
                in.read();
                ++i;
            }
        }
        finally {
            in.close();
        }
    }

    static void testInteger(ArchiveWriter writer, ArchiveReader reader) throws IOException {
        System.out.print("integer");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < TEST_COUNT) {
            TestBuffer.testWriteInteger(writer);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.print("\twrite:" + (end - start));
        start = System.currentTimeMillis();
        i = 0;
        while (i < TEST_COUNT) {
            TestBuffer.testReadInteger(reader);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("\tread:" + (end - start));
    }

    static void testWriteInteger(ArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createOutputStream(ENTRY_NAME);
        try {
            int length = LENGTH / 4;
            int i = 0;
            while (i < length) {
                out.writeInt(i);
                ++i;
            }
        }
        finally {
            out.close();
        }
    }

    static void testReadInteger(ArchiveReader reader) throws IOException {
        RAInputStream in = reader.getInputStream(ENTRY_NAME);
        try {
            int count = 0;
            try {
                while (true) {
                    in.readInt();
                    ++count;
                }
            }
            catch (EOFException eOFException) {
                if (count != LENGTH / 4) {
                    System.out.print("x");
                }
            }
        }
        finally {
            in.close();
        }
    }

    static void testLong(ArchiveWriter writer, ArchiveReader reader) throws IOException {
        System.out.print("long");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < TEST_COUNT) {
            TestBuffer.testWriteLong(writer);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.print("\twrite:" + (end - start));
        start = System.currentTimeMillis();
        i = 0;
        while (i < TEST_COUNT) {
            TestBuffer.testReadLong(reader);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("\tread:" + (end - start));
    }

    static void testWriteLong(ArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createOutputStream(ENTRY_NAME);
        try {
            int length = LENGTH / 8;
            int i = 0;
            while (i < length) {
                out.writeLong((long)i);
                ++i;
            }
        }
        finally {
            out.close();
        }
    }

    static void testReadLong(ArchiveReader reader) throws IOException {
        RAInputStream in = reader.getInputStream(ENTRY_NAME);
        try {
            int count = 0;
            try {
                while (true) {
                    in.readLong();
                    ++count;
                }
            }
            catch (EOFException eOFException) {
                if (count != LENGTH / 8) {
                    System.out.print("x");
                }
            }
        }
        finally {
            in.close();
        }
    }

    protected static void testBytes(ArchiveWriter writer, ArchiveReader reader) throws IOException {
        System.out.print("bytes");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < TEST_COUNT) {
            TestBuffer.testWriteBytes(writer);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.print("\twrite:" + (end - start));
        start = System.currentTimeMillis();
        i = 0;
        while (i < TEST_COUNT) {
            TestBuffer.testReadBytes(reader);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("\tread:" + (end - start));
    }

    static void testWriteBytes(ArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createOutputStream(ENTRY_NAME);
        try {
            byte[] data = new byte[8192];
            int length = 0;
            int count = 0;
            while (length < LENGTH) {
                int size = sizes[count % sizes.length];
                out.write(data, 0, size);
                length += size;
                ++count;
            }
        }
        finally {
            out.close();
        }
    }

    static void testReadBytes(ArchiveReader reader) throws IOException {
        RAInputStream in = reader.getInputStream(ENTRY_NAME);
        try {
            byte[] data = new byte[8192];
            int length = 0;
            int count = 0;
            while (length < LENGTH) {
                int size = sizes[count % sizes.length];
                in.readFully(data, 0, size);
                ++count;
                length += size;
            }
        }
        finally {
            in.close();
        }
    }
}

