/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.cache;

import junit.framework.TestCase;
import org.eclipse.birt.core.archive.cache.Cacheable;
import org.eclipse.birt.core.archive.cache.CachedObject;
import org.eclipse.birt.core.archive.cache.FileCacheManager;

public class FileCacheManagerTest
extends TestCase {
    public void testFileCacheManager() {
        FileCacheManager cacheManager = new FileCacheManager(5);
        CachedObject o1 = new CachedObject(cacheManager, 1);
        CachedObject o2 = new CachedObject(cacheManager, 2);
        CachedObject o3 = new CachedObject(cacheManager, 3);
        CachedObject o4 = new CachedObject(cacheManager, 4);
        CachedObject o5 = new CachedObject(cacheManager, 5);
        CachedObject o6 = new CachedObject(cacheManager, 6);
        cacheManager.addCache((Cacheable)o1);
        FileCacheManagerTest.assertEquals((int)1, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)1, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)1, (int)o1.getReferenceCount().get());
        cacheManager.addCache((Cacheable)o2);
        FileCacheManagerTest.assertEquals((int)2, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)2, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)1, (int)o2.getReferenceCount().get());
        cacheManager.addCache((Cacheable)o3);
        cacheManager.addCache((Cacheable)o4);
        cacheManager.addCache((Cacheable)o5);
        cacheManager.addCache((Cacheable)o6);
        FileCacheManagerTest.assertEquals((int)6, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)6, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)1, (int)o2.getReferenceCount().get());
        Cacheable getO1 = cacheManager.getCache((Object)1);
        FileCacheManagerTest.assertEquals((Object)((Object)o1), (Object)getO1);
        FileCacheManagerTest.assertEquals((int)2, (int)o1.getReferenceCount().get());
        cacheManager.releaseCache((Cacheable)o1);
        FileCacheManagerTest.assertEquals((int)6, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)6, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)1, (int)o1.getReferenceCount().get());
        cacheManager.releaseCache((Cacheable)o1);
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)0, (int)o1.getReferenceCount().get());
        cacheManager.releaseCache((Cacheable)o3);
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)0, (int)o3.getReferenceCount().get());
        Cacheable getO3 = cacheManager.getCache((Object)3);
        FileCacheManagerTest.assertEquals((Object)((Object)o3), (Object)getO3);
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)1, (int)o3.getReferenceCount().get());
        cacheManager.releaseCache((Cacheable)o2);
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)0, (int)o2.getReferenceCount().get());
        CachedObject oldO2 = o2;
        o2 = new CachedObject(cacheManager, 2);
        cacheManager.addCache((Cacheable)o2);
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)5, (int)cacheManager.getTotalUsedCacheSize());
        FileCacheManagerTest.assertEquals((int)1, (int)o2.getReferenceCount().get());
        FileCacheManagerTest.assertEquals((int)0, (int)oldO2.getReferenceCount().get());
    }
}

