/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

public class ArchivePerformanceTest
extends TestCase {
    int STREAM_COUNT = 127;
    int STREAM_SIZE = 28679;
    int BUFFER_SIZE = 64;
    long readSize = 0L;
    long writeSize = 0L;

    public void testPerformance() throws IOException {
        int i = 0;
        while (i < 5) {
            this.removeFile(new File("./utest/"));
            long start = System.currentTimeMillis();
            this.doFileWrite();
            long end = System.currentTimeMillis();
            System.out.println("FILE WRITE:" + (end - start));
            start = System.currentTimeMillis();
            this.doArchiveWrite();
            end = System.currentTimeMillis();
            System.out.println("ARCHIVE WRITE:" + (end - start));
            this.removeFile(new File("./utest/"));
            ++i;
        }
    }

    void doFileWrite() throws IOException {
        new File("./utest/file").mkdirs();
        int i = 0;
        while (i < this.STREAM_COUNT) {
            int size;
            RandomAccessFile file = new RandomAccessFile("./utest/file/" + i, "rw");
            byte[] buffer = new byte[this.BUFFER_SIZE];
            long length = 0L;
            do {
                if (length + (long)(size = (int)Math.round(Math.random() * (double)this.BUFFER_SIZE)) > (long)this.STREAM_SIZE) {
                    size = (int)((long)this.STREAM_SIZE - length);
                }
                file.seek(length);
                file.write(buffer, 0, size);
                this.writeSize += (long)size;
            } while ((length += (long)size) < (long)this.STREAM_SIZE);
            file.close();
            ++i;
        }
    }

    void doFileRead() throws IOException {
        int i = 0;
        while (i < this.STREAM_COUNT) {
            int size;
            RandomAccessFile file = new RandomAccessFile("./utest/file/" + i, "rw");
            byte[] buffer = new byte[this.BUFFER_SIZE];
            long offset = 0L;
            do {
                if (offset + (long)(size = (int)Math.round(Math.random() * (double)this.BUFFER_SIZE)) > (long)this.STREAM_SIZE) {
                    size = (int)((long)this.STREAM_SIZE - offset);
                }
                file.seek(offset);
            } while ((offset += (long)file.read(buffer, 0, size)) < (long)this.STREAM_SIZE);
            this.readSize += offset;
            file.close();
            ++i;
        }
    }

    void doArchiveRead() throws IOException {
        new File("./utest/").mkdirs();
        ArchiveFile archive = new ArchiveFile("./utest/archive", "r");
        int i = 0;
        while (i < this.STREAM_COUNT) {
            ArchiveEntry entry = archive.openEntry("./utest/file/" + i);
            try {
                int size;
                byte[] buffer = new byte[this.BUFFER_SIZE];
                long offset = 0L;
                do {
                    if (offset + (long)(size = (int)Math.round(Math.random() * (double)this.BUFFER_SIZE)) > (long)this.STREAM_SIZE) {
                        size = (int)((long)this.STREAM_SIZE - offset);
                    }
                    entry.read(offset, buffer, 0, size);
                } while ((offset += (long)size) < (long)this.STREAM_SIZE);
            }
            finally {
                entry.close();
            }
            ++i;
        }
        archive.close();
    }

    void doArchiveWrite() throws IOException {
        new File("./utest/").mkdirs();
        ArchiveFile archive = new ArchiveFile("./utest/archive", "rw");
        int i = 0;
        while (i < this.STREAM_COUNT) {
            int size;
            ArchiveEntry entry = archive.createEntry("./utest/file/" + i);
            byte[] buffer = new byte[this.BUFFER_SIZE];
            long length = 0L;
            do {
                if (length + (long)(size = (int)Math.round(Math.random() * (double)this.BUFFER_SIZE)) > (long)this.STREAM_SIZE) {
                    size = (int)((long)this.STREAM_SIZE - length);
                }
                entry.write(length, buffer, 0, size);
            } while ((length += (long)size) < (long)this.STREAM_SIZE);
            ++i;
        }
        archive.close();
    }

    void removeFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.removeFile(files[i]);
                ++i;
            }
        }
        file.delete();
    }
}

