/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.config;

import java.io.File;
import java.io.FileOutputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.config.FileConfigVarManager;

public class FileConfigVarManagerTest
extends TestCase {
    public void tearDown() {
        File file = new File("configvartest");
        if (file.exists()) {
            file.delete();
        }
    }

    public void testFileConfigVarManager() {
        FileConfigVarManager manager = new FileConfigVarManager();
        FileConfigVarManagerTest.assertNotNull((Object)manager.getConfigVar("os.version"));
        FileConfigVarManagerTest.assertNull((Object)manager.getConfigVar("BooleanValue"));
    }

    public void testFileConfigVarManagerString() {
        File f = new File("configvartest");
        try {
            try {
                if (f.exists()) {
                    f.delete();
                }
                f.createNewFile();
                FileOutputStream ostream = new FileOutputStream(f);
                ostream.write("StrValue=string\nos.version=Windows2000\nIntValue=1234\nIntValueAsDouble=123.45\nInvalidIntValue=abcd\nBooleanValue=true\nInvalidBooleanValue=abc".getBytes());
                ostream.close();
                FileConfigVarManager manager = new FileConfigVarManager(f.getAbsolutePath());
                FileConfigVarManagerTest.assertEquals((String)manager.getConfigVar("os.version"), (String)"Windows2000");
                FileConfigVarManagerTest.assertEquals((String)manager.getConfigVar("BooleanValue"), (String)"true");
                FileConfigVarManagerTest.assertEquals((boolean)manager.getConfigBoolean("BooleanValue"), (boolean)true);
                FileConfigVarManagerTest.assertEquals((Object)manager.getConfigInteger("IntValue"), (Object)new Integer(1234));
                FileConfigVarManagerTest.assertNull((Object)manager.getConfigInteger("IntValueAsDouble"));
                FileConfigVarManagerTest.assertEquals((String)manager.getConfigVar("StrValue"), (String)"string");
                FileConfigVarManagerTest.assertNull((Object)manager.getConfigInteger("InvalidIntValue"));
                FileConfigVarManagerTest.assertNull((Object)manager.getConfigInteger("InvalidBooleanValue"));
            }
            catch (Exception exception) {
                FileConfigVarManagerTest.assertTrue((boolean)false);
                if (f.exists()) {
                    f.delete();
                }
            }
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }
}

