/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.NativeJavaMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class NativeJavaMapTest
extends TestCase {
    Context cx;
    Scriptable scope;
    boolean hasException;
    StringBuffer buffer = new StringBuffer();

    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        this.registerBeans();
    }

    public void tearDown() {
        Context.exit();
    }

    protected Object evaluate(String script) {
        try {
            this.hasException = false;
            return this.cx.evaluateString(this.scope, script, "inline", 1, null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.hasException = true;
            return null;
        }
    }

    protected void registerBeans() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("a", new Integer(123));
        values.put("b", "STRING");
        values.put("c", new Long(599L));
        values.put("d", "ABC");
        NativeJavaMap map = new NativeJavaMap(this.scope, values, NativeJavaMap.class);
        this.scope.put("params", this.scope, (Object)map);
        this.scope.put("buffer", this.scope, (Object)this.buffer);
    }

    public void testIn() {
        String script = "for (var a in params) { buffer.append(a); }";
        this.buffer.setLength(0);
        this.evaluate(script);
        NativeJavaMapTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeJavaMapTest.assertEquals((int)4, (int)this.buffer.length());
        script = "for (var a in params) { buffer.append( params[a]); }";
        this.buffer.setLength(0);
        this.evaluate(script);
        NativeJavaMapTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeJavaMapTest.assertEquals((int)19, (int)this.buffer.length());
    }

    public void testLength() {
        String script = "params.length";
        Object value = this.evaluate(script);
        NativeJavaMapTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeJavaMapTest.assertEquals((int)4, (int)((Number)value).intValue());
    }

    public void testNameAccess() {
        String script = "params['a'] + params.b";
        Object value = this.evaluate(script);
        NativeJavaMapTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeJavaMapTest.assertEquals((String)"123STRING", (String)value.toString());
    }
}

