/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import java.lang.reflect.InvocationTargetException;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class BirtMathTest
extends TestCase {
    private Context cx;
    private Scriptable scope;

    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    public void tearDown() {
        Context.exit();
    }

    public void testAdd() {
        String script1 = "BirtMath.add( null, 1 )";
        String script2 = "BirtMath.add( 1,  null)";
        String script3 = "BirtMath.add( 1,  1   )";
        BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, script1, "inline", 1, null)).doubleValue(), (double)1.0, (double)0.0);
        BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, script2, "inline", 1, null)).doubleValue(), (double)1.0, (double)0.0);
        BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, script3, "inline", 1, null)).doubleValue(), (double)2.0, (double)0.0);
    }

    public void testRound() {
        String[] scripts = new String[]{"BirtMath.round( 0 )", "BirtMath.round( 100.5999 )", "BirtMath.round( 100.5999,1 )", "BirtMath.round( 100.5999,2 )", "BirtMath.round( 100.5999,-1 )", "BirtMath.round( 100.5999,-2 )", "BirtMath.round( 100.5999,-3 )", "BirtMath.round( 999.5999,-1 )", "BirtMath.round( 999.5999,-2 )", "BirtMath.round( 999.5999,-3 )", "BirtMath.round( 999.5999,-4 )"};
        double[] values = new double[]{0.0, 101.0, 100.6, 100.6, 100.0, 100.0, 0.0, 1000.0, 1000.0, 1000.0, 0.0};
        int i = 0;
        while (i < values.length) {
            BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).doubleValue(), (double)values[i], (double)0.0);
            ++i;
        }
    }

    public void testRoundUp() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        String[] scripts = new String[]{"BirtMath.roundUp( 0 )", "BirtMath.roundUp( 100.5999 )", "BirtMath.roundUp( 100.5999,1 )", "BirtMath.roundUp( 100.5999,2 )", "BirtMath.roundUp( 100.5999,-1 )", "BirtMath.roundUp( 100.5999,-2 )", "BirtMath.roundUp( 100.5999,-3 )", "BirtMath.roundUp( 100.5999,-4 )", "BirtMath.roundUp( 100.5999,-6 )", "BirtMath.roundUp( 999.5999,-1 )", "BirtMath.roundUp( 999.5999,-2 )", "BirtMath.roundUp( 999.5999,-3 )", "BirtMath.roundUp( 999.5999,-4 )", "BirtMath.roundUp( 100.213,0 )", "BirtMath.roundUp( 100.213,1 )", "BirtMath.roundUp( 100.213,2 )", "BirtMath.roundUp( 100.213,-1 )", "BirtMath.roundUp( 100.213,-2 )", "BirtMath.roundUp( 100.213,-4 )"};
        double[] values = new double[]{0.0, 101.0, 100.6, 100.6, 110.0, 200.0, 1000.0, 10000.0, 1000000.0, 1000.0, 1000.0, 1000.0, 10000.0, 101.0, 100.3, 100.22, 110.0, 200.0, 10000.0};
        int i = 0;
        while (i < values.length) {
            BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).doubleValue(), (double)values[i], (double)0.0);
            ++i;
        }
    }

    public void testRoundDown() {
        String[] scripts = new String[]{"BirtMath.roundDown( 0 )", "BirtMath.roundDown( 100.5999 )", "BirtMath.roundDown( 100.5999,1 )", "BirtMath.roundDown( 100.5999,2 )", "BirtMath.roundDown( 100.5999,-1 )", "BirtMath.roundDown( 100.5999,-2 )", "BirtMath.roundDown( 100.5999,-3 )", "BirtMath.roundDown( 100.5999,-4 )", "BirtMath.roundDown( 100.5999,-6 )", "BirtMath.roundDown( 999.5999,-1 )", "BirtMath.roundDown( 999.5999,-2 )", "BirtMath.roundDown( 999.5999,-3 )", "BirtMath.roundDown( 999.5999,-4 )", "BirtMath.roundDown( 100.213,0 )", "BirtMath.roundDown( 100.213,1 )", "BirtMath.roundDown( 100.213,2 )", "BirtMath.roundDown( 100.213,-1 )", "BirtMath.roundDown( 100.213,-2 )", "BirtMath.roundDown( 100.213,-4 )"};
        double[] values = new double[]{0.0, 100.0, 100.5, 100.59, 100.0, 100.0, 0.0, 0.0, 0.0, 990.0, 900.0, 0.0, 0.0, 100.0, 100.2, 100.21, 100.0, 100.0, 0.0};
        int i = 0;
        while (i < values.length) {
            BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).doubleValue(), (double)values[i], (double)0.0);
            ++i;
        }
    }

    public void testCeiling() {
        String[] scripts = new String[]{"BirtMath.ceiling( 0, 0 )", "BirtMath.ceiling( 100.5999,10 )", "BirtMath.ceiling( 100.5999,20 )", "BirtMath.ceiling( 100.5999,30 )", "BirtMath.ceiling( 100.5999,5 )", "BirtMath.ceiling( -100.5999,-10 )", "BirtMath.ceiling( -100.5999,-3 )", "BirtMath.ceiling( -100.5999,-4 )", "BirtMath.ceiling( 100.5999,1000 )", "BirtMath.ceiling( 999.5999,10000 )", "BirtMath.ceiling( 999.5999,0 )", "BirtMath.ceiling( 0,100 )", "BirtMath.ceiling( 0,-100 )", "BirtMath.ceiling( 25.34, 0.1 )"};
        double[] values = new double[]{0.0, 110.0, 120.0, 120.0, 105.0, -110.0, -102.0, -104.0, 1000.0, 10000.0, 0.0, 0.0, 0.0, 25.4};
        int i = 0;
        while (i < scripts.length) {
            BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).doubleValue(), (double)values[i], (double)0.0);
            ++i;
        }
        try {
            this.cx.evaluateString(this.scope, "BirtMath.ceiling(-10,1)", "inline", 1, null);
            BirtMathTest.fail((String)"Should not arrive here");
        }
        catch (Exception exception) {}
        try {
            this.cx.evaluateString(this.scope, "BirtMath.ceiling(10,-1)", "inline", 1, null);
            BirtMathTest.fail((String)"Should not arrive here");
        }
        catch (Exception exception) {}
    }

    public void testMod() {
        String[] scripts = new String[]{"BirtMath.mod( 0, 10 )", "BirtMath.mod( 0, -10 )", "BirtMath.mod( 100.5,10 )", "BirtMath.mod( 100.5,100 )", "BirtMath.mod( 100.5,1000 )", "BirtMath.mod( 100.5,15 )", "BirtMath.mod( 100.5,-10 )", "BirtMath.mod( 100.5,-100 )", "BirtMath.mod( 100.5,-1000 )", "BirtMath.mod( 100.5,-15 )", "BirtMath.mod( -100.5,10 )", "BirtMath.mod( -100.5,100 )", "BirtMath.mod( -100.5,1000 )", "BirtMath.mod( -100.5,15 )", "BirtMath.mod( -100.5,-10 )", "BirtMath.mod( -100.5,-100 )", "BirtMath.mod( -100.5,-1000 )", "BirtMath.mod( -100.5,-15 )"};
        double[] values = new double[]{0.0, 0.0, 0.5, 0.5, 100.5, 10.5, -9.5, -99.5, -899.5, -4.5, 9.5, 99.5, 899.5, 4.5, -0.5, -0.5, -100.5, -10.5};
        int i = 0;
        while (i < values.length) {
            BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).doubleValue(), (double)values[i], (double)0.0);
            ++i;
        }
        try {
            this.cx.evaluateString(this.scope, "BirtMath.mod(0,0)", "inline", 1, null);
            BirtMathTest.fail((String)"Should not arrive here");
        }
        catch (Exception exception) {}
    }

    public void testSafeDivide() {
        String[] scripts = new String[]{"BirtMath.safeDivide( 0, 10,-1 )", "BirtMath.safeDivide( 10.5, -10,-1 )", "BirtMath.safeDivide( 100.5,10,-1 )", "BirtMath.safeDivide( 100.5,0,-1 )", "BirtMath.safeDivide( 0, 0, -2 )"};
        double[] values = new double[]{0.0, -1.05, 10.05, -1.0, -2.0};
        int i = 0;
        while (i < values.length) {
            BirtMathTest.assertEquals((double)((Number)this.cx.evaluateString(this.scope, scripts[i], "inline", 1, null)).doubleValue(), (double)values[i], (double)0.0);
            ++i;
        }
    }
}

