/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.template;

import junit.framework.TestCase;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;

public class TemplateParserTest
extends TestCase {
    public void testValueOf() {
        String input = "<value-of>script</value-of>";
        String golden = "<value-of>script</value-of>";
        TextTemplate template = new TemplateParser().parse(input);
        this.assertEquals(golden, template);
    }

    public void testViewTimeValueOf() {
        String input = "<viewtime-value-of>script</viewtime-value-of>";
        String golden = "<viewtime-value-of>script</viewtime-value-of>";
        TextTemplate template = new TemplateParser().parse(input);
        this.assertEquals(golden, template);
    }

    public void testImage() {
        String input = "<image>script</image>";
        String golden = "<image>script</image>";
        TextTemplate template = new TemplateParser().parse(input);
        this.assertEquals(golden, template);
    }

    public void testImageTag() {
        String input = "<image name=\"ABC\"/>";
        String golden = "<image name=\"ABC\"></image>";
        TextTemplate template = new TemplateParser().parse(input);
        this.assertEquals(golden, template);
    }

    public void testText() {
        String input = "text any text";
        String golden = "<text>text any text</text>";
        TextTemplate template = new TemplateParser().parse(input);
        this.assertEquals(golden, template);
    }

    protected void assertEquals(String golden, TextTemplate template) {
        StringBuffer buffer = new StringBuffer();
        TextTemplateWriter.write(template, buffer);
        TemplateParserTest.assertEquals((String)golden, (String)buffer.toString());
    }

    protected static class TextTemplateWriter
    implements TextTemplate.Visitor {
        protected TextTemplateWriter() {
        }

        static void write(TextTemplate template, StringBuffer buffer) {
            TextTemplateWriter visitor = new TextTemplateWriter();
            for (TextTemplate.Node node : template.getNodes()) {
                node.accept((TextTemplate.Visitor)visitor, (Object)buffer);
            }
        }

        public Object visitText(TextTemplate.TextNode node, Object value) {
            StringBuffer buffer = (StringBuffer)value;
            buffer.append("<text>");
            buffer.append(node.getContent());
            buffer.append("</text>");
            return buffer;
        }

        public Object visitValue(TextTemplate.ValueNode node, Object value) {
            StringBuffer buffer = (StringBuffer)value;
            buffer.append("<value-of");
            if (node.getFormat() != null) {
                buffer.append("format='");
                buffer.append(node.getFormat());
                buffer.append("'");
            }
            buffer.append(">");
            buffer.append(node.getValue());
            buffer.append("</value-of>");
            return buffer;
        }

        public Object visitImage(TextTemplate.ImageNode image, Object value) {
            StringBuffer buffer = (StringBuffer)value;
            buffer.append("<image");
            String name = image.getImageName();
            if (name != null) {
                buffer.append(" name=\"");
                buffer.append(name);
                buffer.append("\"");
            }
            buffer.append(">");
            String expr = image.getExpr();
            if (expr != null) {
                buffer.append(image.getExpr());
            }
            buffer.append("</image>");
            return buffer;
        }

        public Object visitExpressionValue(TextTemplate.ExpressionValueNode node, Object value) {
            StringBuffer buffer = (StringBuffer)value;
            buffer.append("<viewtime-value-of");
            if (node.getFormat() != null) {
                buffer.append("format='");
                buffer.append(node.getFormat());
                buffer.append("'");
            }
            buffer.append(">");
            buffer.append(node.getValue());
            buffer.append("</viewtime-value-of>");
            return buffer;
        }
    }
}

