/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.model.util.SchemaConversionUtil;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DataSetParameterAdapterTest
extends BaseTestCase {
    private void testParametersCount(OdaDataSetHandle setHandle, int expectValue) {
        int count = 0;
        Iterator iterator = setHandle.parametersIterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        DataSetParameterAdapterTest.assertEquals((int)expectValue, (int)count);
    }

    public void testMergeParamDefnFromDesignToHandle() throws Exception {
        this.openDesign("DataSetMergeTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("Data Set");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        setHandle.setProperty("parameters", null);
        ModelOdaAdapter adapter = new ModelOdaAdapter();
        adapter.updateDataSetHandle(setDesign, setHandle, false);
        this.testParametersCount(setHandle, 3);
        setHandle.setDesignerValues(null);
        PropertyHandle propHandle = setHandle.getPropertyHandle("parameters");
        OdaDataSetParameter parameter = (OdaDataSetParameter)propHandle.getAt(2).getStructure().copy();
        propHandle.removeItem(2);
        DataSetDesign setDesign2 = new ModelOdaAdapter().createDataSetDesign(setHandle);
        propHandle.addItem((IStructure)parameter);
        adapter.updateDataSetHandle(setDesign2, setHandle, false);
        this.testParametersCount(setHandle, 3);
    }

    public void testDataTypeConversion() throws Exception {
        this.openDesign("DataSetParamConvertTest_1.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        DesignValues values = ModelFactory.eINSTANCE.createDesignValues();
        values.setDataSetParameters(SchemaConversionUtil.convertToAdapterParameters((DataSetParameters)((DataSetParameters)EcoreUtil.copy((EObject)setDesign.getParameters()))));
        this.saveDesignValuesToFile(values);
        DataSetParameterAdapterTest.assertTrue((boolean)this.compareTextFile("DataSetParamConvertTest_golden_1.xml"));
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        DataSetParameterAdapterTest.assertTrue((boolean)this.compareTextFile("DataSetParamConvertTest_golden_2.xml"));
    }

    public void testValuesConversion() throws Exception {
        this.openDesign("DataSetParamConvertTest_1.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        DataSetParameters params = setDesign.getParameters();
        ParameterDefinition param = (ParameterDefinition)params.getParameterDefinitions().get(0);
        this.updateParameterDefinition1(param);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        DataSetParameterAdapterTest.assertTrue((boolean)this.compareTextFile("DataSetParamConvertTest_golden_3.xml"));
    }

    private void updateParameterDefinition1(ParameterDefinition param) {
        DataElementAttributes dataAttrs = param.getAttributes();
        dataAttrs.setNullability(ElementNullability.get((int)2));
        InputParameterAttributes paramAttrs = param.getInputAttributes();
        InputElementAttributes elementAttrs = paramAttrs.getElementAttributes();
        elementAttrs.setDefaultScalarValue("new default value for report param 1");
        elementAttrs.setOptional(true);
    }

    public void testDataSetParamNames() throws Exception {
        DataSetDesign setDesign = DataSetParameterAdapterTest.createDataSetDesignForParamNames();
        this.createDesign();
        OdaDataSetHandle setHandle = new ModelOdaAdapter().createDataSetHandle(setDesign, (ModuleHandle)this.designHandle);
        this.designHandle.getDataSets().add((DesignElementHandle)setHandle);
        this.save();
        DataSetParameterAdapterTest.assertTrue((boolean)this.compareTextFile("DataSetParameterNameTest_golden.xml"));
        setDesign = DataSetParameterAdapterTest.createDataSetDesignForParamNames1();
        setHandle = new ModelOdaAdapter().createDataSetHandle(setDesign, (ModuleHandle)this.designHandle);
        List params = (List)setHandle.getProperty("parameters");
        OdaDataSetParameter param = (OdaDataSetParameter)params.get(0);
        DataSetParameterAdapterTest.assertEquals((int)0, (int)param.getPosition());
        param = (OdaDataSetParameter)params.get(1);
        DataSetParameterAdapterTest.assertEquals((int)1, (int)param.getPosition());
        setDesign = DataSetParameterAdapterTest.createDataSetDesignForParamNames1();
        setHandle = new ModelOdaAdapter().createDataSetHandle(setDesign, (ModuleHandle)this.designHandle);
    }

    static DataSetDesign createDataSetDesignForParamNames() {
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        setDesign.setName("myDataSet1");
        setDesign.setDisplayName("data set display name");
        setDesign.setOdaExtensionDataSetId("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new public query time out");
        setDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new private query time out");
        setDesign.setPrivateProperties(props);
        DataSetParameters params = DesignFactory.eINSTANCE.createDataSetParameters();
        ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        DataElementAttributes dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("nativeName1");
        dataAttrs.setPosition(1);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setAttributes(dataAttrs);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        params.getParameterDefinitions().add((Object)paramDefn);
        paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("");
        dataAttrs.setPosition(2);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setAttributes(dataAttrs);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        params.getParameterDefinitions().add((Object)paramDefn);
        paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("nativeName1");
        dataAttrs.setPosition(3);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setAttributes(dataAttrs);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        params.getParameterDefinitions().add((Object)paramDefn);
        setDesign.setParameters(params);
        setDesign.setPrimaryResultSetName("resultset1");
        setDesign.setQueryText("new query text");
        setDesign.setDataSourceDesign(DataSetParameterAdapterTest.createDataSourceDesign());
        return setDesign;
    }

    private static DataSourceDesign createDataSourceDesign() {
        DataSourceDesign sourceDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
        sourceDesign.setName("myDataSource1");
        sourceDesign.setDisplayName("data source display name");
        sourceDesign.setOdaExtensionId("org.eclipse.birt.report.data.oda.jdbc");
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("odaDriverClass", "new drivers");
        props.setProperty("odaURL", "jdbc:sqlserver://localhost");
        props.setProperty("odaUser", "new user");
        sourceDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("odaDriverClass", "new drivers");
        props.setProperty("odaPassword", "new password");
        sourceDesign.setPrivateProperties(props);
        return sourceDesign;
    }

    static DataSetDesign createDataSetDesignForParamNames1() {
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        setDesign.setName("myDataSet1");
        setDesign.setDisplayName("data set display name");
        setDesign.setOdaExtensionDataSetId("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new public query time out");
        setDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new private query time out");
        setDesign.setPrivateProperties(props);
        DataSetParameters params = DesignFactory.eINSTANCE.createDataSetParameters();
        ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        DataElementAttributes dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("nativeName1");
        dataAttrs.setPosition(0);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setAttributes(dataAttrs);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        params.getParameterDefinitions().add((Object)paramDefn);
        paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("");
        dataAttrs.setPosition(1);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setAttributes(dataAttrs);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        params.getParameterDefinitions().add((Object)paramDefn);
        params.getParameterDefinitions().add((Object)paramDefn);
        setDesign.setParameters(params);
        setDesign.setPrimaryResultSetName("resultset1");
        setDesign.setQueryText("new query text");
        setDesign.setDataSourceDesign(DataSetParameterAdapterTest.createDataSourceDesign());
        return setDesign;
    }

    static DataSetDesign createDataSetDesignForParamNames2() {
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        setDesign.setName("myDataSet1");
        setDesign.setDisplayName("data set display name");
        setDesign.setOdaExtensionDataSetId("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new public query time out");
        setDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new private query time out");
        setDesign.setPrivateProperties(props);
        DataSetParameters params = DesignFactory.eINSTANCE.createDataSetParameters();
        ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        DataElementAttributes dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("nativeName1");
        dataAttrs.setPosition(1);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setAttributes(dataAttrs);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        params.getParameterDefinitions().add((Object)paramDefn);
        paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("");
        dataAttrs.setPosition(1);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setAttributes(dataAttrs);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        params.getParameterDefinitions().add((Object)paramDefn);
        paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("nativeName1");
        dataAttrs.setPosition(3);
        dataAttrs.setNativeDataTypeCode(1);
        paramDefn.setAttributes(dataAttrs);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        params.getParameterDefinitions().add((Object)paramDefn);
        setDesign.setParameters(params);
        setDesign.setPrimaryResultSetName("resultset1");
        setDesign.setQueryText("new query text");
        setDesign.setDataSourceDesign(DataSetParameterAdapterTest.createDataSourceDesign());
        return setDesign;
    }
}

