/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.optimize;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.executor.optimize.ExecutionOptimize;
import org.eclipse.birt.report.engine.executor.optimize.ExecutionPolicy;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ExecutionOptimizeTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/executor/optimize/test.xml";

    @Override
    public void setUp() {
        this.removeFile("design.rptdesign");
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.engine = this.createReportEngine();
    }

    public void tearDown() {
        this.engine.shutdown();
        this.removeFile("design.rptdesign");
    }

    public void testExecutionOptimize() throws Exception {
        ReportRunnable reportRunnable = (ReportRunnable)this.engine.openReportDesign("design.rptdesign");
        Report report = new ReportParser().parse((ReportDesignHandle)reportRunnable.getDesignHandle());
        ExecutionOptimize executionOpt = new ExecutionOptimize();
        ExecutionPolicy policy = executionOpt.optimize(report);
        this.validatePolicy(report, policy);
    }

    protected void validatePolicy(Report report, ExecutionPolicy policy) {
        TableItemDesign table = (TableItemDesign)report.getContent(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)table));
        TableBandDesign tableHeaderBand = (TableBandDesign)table.getHeader();
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)tableHeaderBand));
        RowDesign tableHeaderRow = tableHeaderBand.getRow(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)tableHeaderRow));
        int cellCount = tableHeaderRow.getCellCount();
        CellDesign firstCell = tableHeaderRow.getCell(0);
        ReportItemDesign firstLable = firstCell.getContent(0);
        ExecutionOptimizeTest.assertFalse((boolean)policy.needExecute((ReportItemDesign)firstCell));
        ExecutionOptimizeTest.assertFalse((boolean)policy.needExecute(firstLable));
        CellDesign lastCell = tableHeaderRow.getCell(cellCount - 1);
        ReportItemDesign lastLable = lastCell.getContent(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)lastCell));
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute(lastLable));
        TableGroupDesign group = (TableGroupDesign)table.getGroup(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)group));
        TableBandDesign groupHeaderBand = (TableBandDesign)group.getHeader();
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)groupHeaderBand));
        RowDesign groupHeaderRow = groupHeaderBand.getRow(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)groupHeaderRow));
        firstCell = groupHeaderRow.getCell(0);
        ReportItemDesign firstData = firstCell.getContent(0);
        ExecutionOptimizeTest.assertFalse((boolean)policy.needExecute((ReportItemDesign)firstCell));
        ExecutionOptimizeTest.assertFalse((boolean)policy.needExecute(firstData));
        lastCell = groupHeaderRow.getCell(cellCount - 1);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)lastCell));
        TableBandDesign detailBand = (TableBandDesign)table.getDetail();
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)detailBand));
        RowDesign detailRow = detailBand.getRow(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)detailRow));
        firstCell = detailRow.getCell(0);
        firstData = firstCell.getContent(0);
        ExecutionOptimizeTest.assertFalse((boolean)policy.needExecute((ReportItemDesign)firstCell));
        ExecutionOptimizeTest.assertFalse((boolean)policy.needExecute(firstData));
        lastCell = detailRow.getCell(cellCount - 1);
        ReportItemDesign lastData = lastCell.getContent(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)lastCell));
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute(lastData));
        TableBandDesign groupFooterBand = (TableBandDesign)group.getFooter();
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)groupFooterBand));
        RowDesign groupFooterRow = groupFooterBand.getRow(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)groupFooterRow));
        firstCell = groupFooterRow.getCell(0);
        ExecutionOptimizeTest.assertFalse((boolean)policy.needExecute((ReportItemDesign)firstCell));
        lastCell = groupFooterRow.getCell(cellCount - 1);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)lastCell));
        TableBandDesign tableFooterBand = (TableBandDesign)table.getFooter();
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)tableFooterBand));
        RowDesign tableFooterRow = tableFooterBand.getRow(0);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)tableFooterRow));
        firstCell = tableFooterRow.getCell(0);
        ExecutionOptimizeTest.assertFalse((boolean)policy.needExecute((ReportItemDesign)firstCell));
        lastCell = tableFooterRow.getCell(cellCount - 1);
        ExecutionOptimizeTest.assertTrue((boolean)policy.needExecute((ReportItemDesign)lastCell));
    }
}

