/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class APICompatibleTest
extends BaseTestCase {
    public void testDataValueExpr() throws Exception {
        this.createDesign();
        DataItemHandle data = this.designHandle.getElementFactory().newDataItem("data1");
        this.designHandle.getBody().add((DesignElementHandle)data);
        data.setValueExpr("row[\"column1\"] + row[\"column2\"]");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table1", 2);
        data = this.designHandle.getElementFactory().newDataItem("data2");
        data.setValueExpr("row[\"value1\"] + row[\"value2\"]");
        table.getCell(0, -1, 1, 1).getContent().add((DesignElementHandle)data);
        this.designHandle.getBody().add((DesignElementHandle)table);
        this.save();
        APICompatibleTest.assertTrue((boolean)this.compareFile("DataCompatibleValueExpr_golden.xml"));
    }

    public void testBoundColumnWriterExpression() throws Exception {
        this.createDesign();
        DataItemHandle data = this.designHandle.getElementFactory().newDataItem("data1");
        this.designHandle.getBody().add((DesignElementHandle)data);
        Action action = new Action();
        data.setAction(action);
        ActionHandle actionHandle = data.getActionHandle();
        actionHandle.setLinkType("bookmark-link");
        actionHandle.setTargetBookmark("row[\"actionBookMark\"]");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table1", 2);
        ImageHandle image = this.designHandle.getElementFactory().newImage("image1");
        image.setBookmark("row[\"bookmark1\"] + row[\"bookmark2\"]");
        image.setValueExpression("row[\"image1\"] + row[\"valueExpr\"]");
        table.getCell(0, -1, 1, 1).getContent().add((DesignElementHandle)image);
        TableHandle nestedTable = this.designHandle.getElementFactory().newTableItem("table2", 2);
        ParamBinding paramBinding = new ParamBinding();
        paramBinding.setParamName("binding1");
        paramBinding.setExpression("row[\"value1\"]");
        nestedTable.getPropertyHandle("paramBindings").addItem((IStructure)paramBinding);
        ColumnHandle column = (ColumnHandle)nestedTable.getColumns().get(0);
        HideRule hideRule = new HideRule();
        hideRule.setExpression("row[\"hide1Expr\"]");
        hideRule.setFormat("reportlet");
        column.getPropertyHandle("visibility").addItem((IStructure)hideRule);
        table.getCell(2, -1, 1, 2).getContent().add((DesignElementHandle)nestedTable);
        this.designHandle.getBody().add((DesignElementHandle)table);
        TextDataHandle textData = this.designHandle.getElementFactory().newTextData("textData1");
        textData.setValueExpr("row[\"textData1ValueExpr\"]");
        GridHandle grid = this.designHandle.getElementFactory().newGridItem("grid1", 2, 2);
        grid.getCell(2, 2).getContent().add((DesignElementHandle)textData);
        table.getCell(3, -1, 1, 1).getContent().add((DesignElementHandle)grid);
        table.getCell(3, -1, 1, 1).setOnCreate("row[\"onCreateValueExpr\"] + 1");
        ListHandle list = this.designHandle.getElementFactory().newList("list1");
        FilterCondition filter = new FilterCondition();
        filter.setExpr("row[\"filter1ValueExpr\"]");
        filter.setValue1("row[\"filter1Value1\"]");
        filter.setValue2("row[\"filter1Value2\"]");
        list.getPropertyHandle("filter").addItem((IStructure)filter);
        SortKey sort = new SortKey();
        sort.setKey("row[\"sort1Key\"]");
        list.getPropertyHandle("sort").addItem((IStructure)sort);
        this.designHandle.getBody().add((DesignElementHandle)list);
        ScalarParameterHandle param = this.designHandle.getElementFactory().newScalarParameter("param1");
        param.setValueExpr("row[\"param1ValueExpr\"]");
        param.setLabelExpr("row[\"param1LabelExpr\"]");
        this.designHandle.getParameters().add((DesignElementHandle)param);
        param = this.designHandle.getElementFactory().newScalarParameter("param2");
        param.setValueExpr("param2ValueExpr");
        param.setLabelExpr("param2LabelExpr");
        this.designHandle.getParameters().add((DesignElementHandle)param);
        textData = this.designHandle.getElementFactory().newTextData("textData2");
        this.designHandle.getBody().add((DesignElementHandle)textData);
        ComputedColumn boundColumn = new ComputedColumn();
        boundColumn.setName("New Column");
        boundColumn.setExpression("row[\"textData2ValueExpr\"]");
        textData.addColumnBinding(boundColumn, true);
        textData.setValueExpr("row[\"New Column\"]");
        this.save();
        APICompatibleTest.assertTrue((boolean)this.compareFile("CompatibleExpression_golden.xml"));
    }

    public void testBoundColumnWriterNoExpression() throws Exception {
        this.createDesign();
        this.design.getVersionManager().setVersion("1");
        DataItemHandle data = this.designHandle.getElementFactory().newDataItem("data1");
        data.setTocExpression("row[\"value1\"]");
        data.setValueExpr("row[\"valueExpr\"]");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table1", 2);
        table.getCell(0, -1, 1, 1).getContent().add((DesignElementHandle)data);
        this.designHandle.getBody().add((DesignElementHandle)table);
        FilterCondition filter = new FilterCondition();
        filter.setExpr("row[\"filter1ValueExpr\"]");
        filter.setValue1("row[\"filter1Value1\"]");
        filter.setValue2("row[\"filter1Value2\"]");
        table.getPropertyHandle("filter").addItem((IStructure)filter);
        this.save();
        APICompatibleTest.assertTrue((boolean)this.compareFile("CompatibleExpression_golden_1.xml"));
    }

    public void testBoundColumnWithGroup() throws Exception {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table1", 3);
        this.designHandle.getBody().add((DesignElementHandle)table);
        TableGroupHandle group = this.designHandle.getElementFactory().newTableGroup();
        group.getFooter().add((DesignElementHandle)this.designHandle.getElementFactory().newTableRow(3));
        table.getGroups().add((DesignElementHandle)group);
        group = this.designHandle.getElementFactory().newTableGroup();
        group.getFooter().add((DesignElementHandle)this.designHandle.getElementFactory().newTableRow(3));
        table.getGroups().add((DesignElementHandle)group);
        DataItemHandle data = this.designHandle.getElementFactory().newDataItem("data1");
        data.setValueExpr("row[\"valueData\"]");
        table.getCell(1, 2, 1, 1).getContent().add((DesignElementHandle)data);
        data = this.designHandle.getElementFactory().newDataItem("data1");
        data.setValueExpr("row[\"valueData\"]");
        table.getCell(1, 1, 1, 1).getContent().add((DesignElementHandle)data);
        this.save();
        this.saveOutputFile("CompatibleExpression_out_2.xml");
        APICompatibleTest.assertTrue((boolean)this.compareFile("CompatibleExpression_golden_2.xml"));
    }

    public void testScriptResultSet() throws Exception {
        this.createDesign();
        ScriptDataSetHandle ds = this.designHandle.getElementFactory().newScriptDataSet("dataSet1");
        PropertyHandle ph = ds.getPropertyHandle("resultSet");
        APICompatibleTest.assertNotNull((Object)ph);
        int i = 0;
        while (i < 2) {
            ResultSetColumn rsc = StructureFactory.createResultSetColumn();
            rsc.setPosition(new Integer(i + 1));
            rsc.setColumnName("COLUMN_" + i);
            rsc.setDataType("decimal");
            ph.addItem((IStructure)rsc);
            ++i;
        }
    }

    public void testTOCExpression() throws Exception {
        this.createDesign();
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("label1");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        labelHandle.setTocExpression("toc1");
        APICompatibleTest.assertEquals((String)"toc1", (String)labelHandle.getTocExpression());
        labelHandle.setTocExpression("toc2");
        APICompatibleTest.assertEquals((String)"toc2", (String)labelHandle.getTocExpression());
        TOC tmpTOC = (TOC)labelHandle.getProperty("toc");
        APICompatibleTest.assertEquals((String)"toc2", (String)tmpTOC.toString());
    }

    public void testCachedRowCount() throws Exception {
        this.createDesign();
        OdaDataSetHandle dsHandle = this.designHandle.getElementFactory().newOdaDataSet("dataSet", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        this.designHandle.getDataSets().add((DesignElementHandle)dsHandle);
        APICompatibleTest.assertEquals((int)0, (int)dsHandle.getCachedRowCount());
        dsHandle.setCachedRowCount(10);
        APICompatibleTest.assertEquals((int)10, (int)dsHandle.getCachedRowCount());
    }

    public void testScalarParamAllowProps() throws Exception {
        this.createDesign();
        ScalarParameterHandle param = this.designHandle.getElementFactory().newScalarParameter("param1");
        this.designHandle.getParameters().add((DesignElementHandle)param);
        param.setAllowBlank(false);
        APICompatibleTest.assertEquals((boolean)false, (boolean)param.allowBlank());
        APICompatibleTest.assertEquals((boolean)true, (boolean)param.isRequired());
        param.setAllowBlank(true);
        APICompatibleTest.assertEquals((boolean)true, (boolean)param.allowBlank());
        APICompatibleTest.assertEquals((boolean)false, (boolean)param.isRequired());
        param.setAllowNull(false);
        APICompatibleTest.assertEquals((boolean)false, (boolean)param.allowNull());
        APICompatibleTest.assertEquals((boolean)true, (boolean)param.isRequired());
        param.setAllowNull(true);
        APICompatibleTest.assertEquals((boolean)true, (boolean)param.allowNull());
        APICompatibleTest.assertEquals((boolean)false, (boolean)param.isRequired());
    }

    public void testComputedColumnAggregates() throws Exception {
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setName("column 1");
        column.setAggregateOn("aggregate on 1");
        APICompatibleTest.assertEquals((String)"aggregate on 1", (String)column.getAggregateOn());
        column.setExpression("expression1");
        this.createDesign();
        DataItemHandle data = this.designHandle.getElementFactory().newDataItem("data1");
        ComputedColumnHandle columnHandle = data.addColumnBinding(column, false);
        columnHandle.setAggregateOn("new aggregate on");
        APICompatibleTest.assertEquals((String)"new aggregate on", (String)columnHandle.getAggregateOn());
        columnHandle.setProperty("aggregateOn", (Object)"new aggregate on1");
        List values = (List)columnHandle.getProperty("aggregateOn");
        APICompatibleTest.assertTrue((boolean)"new aggregate on1".equals(values.get(0)));
    }

    public void testCompatibleIncludeResource() throws Exception {
        this.createDesign();
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("includeResource");
        propHandle.addItem((Object)"resource1");
        propHandle.addItem((Object)"resource2");
        APICompatibleTest.assertEquals((String)"resource1; resource2", (String)this.designHandle.getIncludeResource());
        this.designHandle.setIncludeResource("new_resource");
        APICompatibleTest.assertEquals((String)"new_resource", (String)this.designHandle.getIncludeResource());
    }

    public void testValue1List() throws Exception {
        this.openDesign("CompatibleValue1Test.xml");
        SharedStyleHandle tmpStyle = this.designHandle.findStyle("My-Style");
        Iterator iter1 = tmpStyle.highlightRulesIterator();
        HighlightRuleHandle tmpHighlight = (HighlightRuleHandle)iter1.next();
        List tmpValues = tmpHighlight.getValue1List();
        APICompatibleTest.assertEquals((String)"[hi_value1, hi_value2]", (String)tmpValues.toString());
        iter1 = tmpStyle.mapRulesIterator();
        MapRuleHandle tmpMap = (MapRuleHandle)iter1.next();
        tmpValues = tmpMap.getValue1List();
        APICompatibleTest.assertEquals((String)"[map_value1, map_value2]", (String)tmpValues.toString());
        ExtendedItemHandle testTable = (ExtendedItemHandle)this.designHandle.findElement("testTable");
        APICompatibleTest.assertNotNull((Object)testTable);
        List valueList = testTable.getListProperty("filter");
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        tmpValues = filter.getValue1List();
        APICompatibleTest.assertEquals((String)"[filter_value1, filter_value2]", (String)tmpValues.toString());
        TableHandle table1 = (TableHandle)this.designHandle.findElement("table1");
        FilterConditionHandle filter1 = (FilterConditionHandle)table1.filtersIterator().next();
        filter1.setValue1("ship");
        APICompatibleTest.assertEquals((String)"ship", (String)filter1.getValue1());
    }

    public void testComputedColumnFilterExpression() throws Exception {
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setName("column 1");
        column.setFilterExpression("value1");
        APICompatibleTest.assertEquals((String)"value1", (String)column.getFilterExpression());
    }

    public void testScalarParamDefaultValue() throws Exception {
        this.createDesign();
        ScalarParameterHandle param = this.designHandle.getElementFactory().newScalarParameter(null);
        param.setDefaultValue("default value 1");
        List tmpValues = param.getDefaultValueList();
        APICompatibleTest.assertTrue((boolean)(tmpValues.get(0) instanceof Expression));
    }

    public void testUserPropertyDefaultValue() throws Exception {
        UserPropertyDefn defn = new UserPropertyDefn();
        defn.setName("TestProperty");
        defn.setType(MetaDataDictionary.getInstance().getPropertyType("expression"));
        APICompatibleTest.assertTrue((boolean)defn.allowExpression());
        defn.setDefault((Object)"Test");
        APICompatibleTest.assertTrue((boolean)(defn.getDefault() instanceof Expression));
        Expression defaultValue = (Expression)defn.getDefault();
        APICompatibleTest.assertEquals((Object)"Test", (Object)defaultValue.getExpression());
        APICompatibleTest.assertEquals((String)"constant", (String)defaultValue.getType());
    }

    public void testReportItemPushDownValue() throws Exception {
        this.createDesign();
        LabelHandle label = this.designHandle.getElementFactory().newLabel(null);
        this.designHandle.getBody().add((DesignElementHandle)label);
        APICompatibleTest.assertFalse((boolean)label.pushDown());
        label.setPushDown(true);
        APICompatibleTest.assertTrue((boolean)label.pushDown());
        this.design.getVersionManager().setVersion("3.2.20");
        label.setProperty("pushDown", null);
        APICompatibleTest.assertEquals((Object)label.getPropertyDefn("pushDown").getDefault(), (Object)label.pushDown());
        label.setPushDown(false);
        APICompatibleTest.assertFalse((boolean)label.pushDown());
    }
}

