/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.birt.report.model.metadata.ColorPropertyType;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ColorUtilTest
extends BaseTestCase {
    static final String[][] COLORS = new String[][]{{"maroon", "#800000"}, {"red", "#FF0000"}, {"orange", "#ffA500"}, {"yellow", "#FFFF00"}, {"olive", "#808000"}, {"purple", "#800080"}, {"fuchsia", "#FF00FF"}, {"white", "#FFFFFF"}, {"lime", "#00FF00"}, {"green", "#008000"}, {"navy", "#000080"}, {"blue", "#0000FF"}, {"aqua", "#00FFFF"}, {"teal", "#008080"}, {"black", "#000000"}, {"silver", "#C0C0C0"}, {"gray", "#808080"}};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testConsistency() {
        ColorPropertyType type = (ColorPropertyType)MetaDataDictionary.getInstance().getPropertyType(4);
        IChoiceSet colorSet = type.getChoices();
        IChoice[] colors = colorSet.getChoices();
        int i = 0;
        while (i < colors.length) {
            int rgb = ColorUtil.parsePredefinedColor((String)colors[i].getName());
            ColorUtilTest.assertTrue((rgb != -1 ? 1 : 0) != 0);
            ++i;
        }
        String[][] colorTable = COLORS;
        int i2 = 0;
        while (i2 < colorTable.length) {
            String colorName = colorTable[i2][0];
            ColorUtilTest.assertTrue((boolean)colorSet.contains(colorName));
            ++i2;
        }
    }

    public void testFormatRGB() {
        int input = Integer.decode("#FF00FF");
        ColorUtilTest.assertEquals((String)"RGB(255,0,255)", (String)ColorUtil.format((int)input, (int)3));
        ColorUtilTest.assertEquals((String)"RGB(100.0%,0.0%,100.0%)", (String)ColorUtil.format((int)input, (int)4));
        ColorUtilTest.assertEquals((String)"#FF00FF", (String)ColorUtil.format((int)input, (int)1));
        ColorUtilTest.assertEquals((String)"0xFF00FF", (String)ColorUtil.format((int)input, (int)2));
        ColorUtilTest.assertEquals((String)"RGB(255,0,255)", (String)ColorUtil.format((int)input, (int)Integer.MAX_VALUE));
        ColorUtilTest.assertEquals((String)"#000010", (String)ColorUtil.format((int)16, (int)1));
        ColorUtilTest.assertEquals((String)"#000000", (String)ColorUtil.format((int)-1, (int)1));
        ColorUtilTest.assertEquals((String)"#FFFFFF", (String)ColorUtil.format((int)Integer.decode("#1FFFFFF"), (int)1));
        ColorUtilTest.assertEquals((String)"RGB(43.9%,0.0%,45.1%)", (String)ColorUtil.format((int)Integer.decode("#700073"), (int)4));
        ColorUtilTest.assertEquals((String)"1.5", (String)String.valueOf(ColorUtilTest.round(1.53f)));
        ColorUtilTest.assertEquals((String)"1.6", (String)String.valueOf(ColorUtilTest.round(1.55f)));
        ColorUtilTest.assertEquals((String)"1.6", (String)String.valueOf(ColorUtilTest.round(1.58f)));
    }

    private static float round(float value) {
        return (float)((int)(value * 10.0f + 0.5f)) / 10.0f;
    }

    public void testFormat() {
        ColorUtilTest.assertEquals((String)"RGB(255,0,255)", (String)ColorUtil.format((String)"#FF00FF", (int)3));
        ColorUtilTest.assertEquals((String)"0xFF00FF", (String)ColorUtil.format((String)"#FF00FF", (int)2));
        ColorUtilTest.assertEquals((String)"#FF00FF", (String)ColorUtil.format((String)"#FF00FF", (int)1));
        ColorUtilTest.assertEquals((String)"#0000FF", (String)ColorUtil.format((String)"#FF", (int)1));
        ColorUtilTest.assertEquals((String)"#FF00FF", (String)ColorUtil.format((String)"#F0F", (int)1));
        ColorUtilTest.assertEquals((String)"#FF00FF", (String)ColorUtil.format((String)"0xFF00FF", (int)1));
        ColorUtilTest.assertEquals((String)"0xFF00FF", (String)ColorUtil.format((String)"0xFF00FF", (int)2));
        ColorUtilTest.assertEquals((String)"RGB(255,0,255)", (String)ColorUtil.format((String)"0xFF00FF", (int)3));
        ColorUtilTest.assertEquals((String)"0xFF00FF", (String)ColorUtil.format((String)"RGB(255,0,255)", (int)2));
        ColorUtilTest.assertEquals((String)"#FF00FF", (String)ColorUtil.format((String)"RGB(255,0,255)", (int)1));
        ColorUtilTest.assertEquals((String)"RGB(255,0,255)", (String)ColorUtil.format((String)"RGB(255,0,255)", (int)3));
        ColorUtilTest.assertEquals((String)"RGB(255,0,0)", (String)ColorUtil.format((String)"red", (int)3));
        ColorUtilTest.assertEquals((String)"#FF0000", (String)ColorUtil.format((String)"red", (int)1));
        ColorUtilTest.assertEquals((String)"RGB(43.9%,0.0%,45.1%)", (String)ColorUtil.format((String)"#700073", (int)4));
        ColorUtilTest.assertEquals((String)"#700073", (String)ColorUtil.format((String)"RGB(43.9%,0.0%,45.1%)", (int)1));
    }

    public void testIsValidCssAbsolute() {
        ColorUtilTest.assertTrue((boolean)ColorUtil.isCssAbsolute((String)"RGB(255,0,0)"));
        ColorUtilTest.assertTrue((boolean)ColorUtil.isCssAbsolute((String)"RGB( 255 , 0 , 0 )"));
        ColorUtilTest.assertTrue((boolean)ColorUtil.isCssAbsolute((String)"RGB(300,300,300)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"   RGB(255,0,0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"RGB(255,0,0)  "));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"RGB(,0,0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"RGB(255,,0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"RGB(0,0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"RGB(0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"RGB(-1,0,0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"RGB(0,-1,0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssAbsolute((String)"RGB(0,0,-1)"));
    }

    public void testIsValidCssRelative() {
        ColorUtilTest.assertTrue((boolean)ColorUtil.isCssRelative((String)"RGB(100%,0%,0%)"));
        ColorUtilTest.assertTrue((boolean)ColorUtil.isCssRelative((String)"RGB( 255% , 0% , 0% )"));
        ColorUtilTest.assertTrue((boolean)ColorUtil.isCssRelative((String)"RGB( 300%,300%,300%)"));
        ColorUtilTest.assertTrue((boolean)ColorUtil.isCssRelative((String)"RGB(100.001%,100.001%,100.00001%)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssRelative((String)"        RGB(100,0%,0%)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssRelative((String)"RGB(100,0%,0%)          "));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssRelative((String)"RGB(100,0%,0%)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssRelative((String)"RGB(100%, 0 , 0% )"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssRelative((String)"RGB(100%,100%,0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssRelative((String)"RGB(100.001%,100%,0)"));
        ColorUtilTest.assertFalse((boolean)ColorUtil.isCssRelative((String)"RGB(-1%,100%,0)"));
    }

    public void testDecodeColor() {
        ColorUtilTest.assertEquals((int)Integer.decode("#800000"), (int)ColorUtil.parsePredefinedColor((String)"maroon"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FF0000"), (int)ColorUtil.parsePredefinedColor((String)"red"));
        ColorUtilTest.assertEquals((int)Integer.decode("#ffA500"), (int)ColorUtil.parsePredefinedColor((String)"orange"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FFFF00"), (int)ColorUtil.parsePredefinedColor((String)"yellow"));
        ColorUtilTest.assertEquals((int)Integer.decode("#808000"), (int)ColorUtil.parsePredefinedColor((String)"olive"));
        ColorUtilTest.assertEquals((int)Integer.decode("#800080"), (int)ColorUtil.parsePredefinedColor((String)"purple"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FF00FF"), (int)ColorUtil.parsePredefinedColor((String)"fuchsia"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FFFFFF"), (int)ColorUtil.parsePredefinedColor((String)"white"));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.parsePredefinedColor((String)"lime"));
        ColorUtilTest.assertEquals((int)Integer.decode("#008000"), (int)ColorUtil.parsePredefinedColor((String)"green"));
        ColorUtilTest.assertEquals((int)Integer.decode("#000080"), (int)ColorUtil.parsePredefinedColor((String)"navy"));
        ColorUtilTest.assertEquals((int)Integer.decode("#0000FF"), (int)ColorUtil.parsePredefinedColor((String)"blue"));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FFFF"), (int)ColorUtil.parsePredefinedColor((String)"aqua"));
        ColorUtilTest.assertEquals((int)Integer.decode("#008080"), (int)ColorUtil.parsePredefinedColor((String)"teal"));
        ColorUtilTest.assertEquals((int)Integer.decode("#000000"), (int)ColorUtil.parsePredefinedColor((String)"black"));
        ColorUtilTest.assertEquals((int)Integer.decode("#C0C0C0"), (int)ColorUtil.parsePredefinedColor((String)"silver"));
        ColorUtilTest.assertEquals((int)Integer.decode("#808080"), (int)ColorUtil.parsePredefinedColor((String)"gray"));
    }

    public void testParseColor() {
        ColorUtilTest.assertEquals((int)-1, (int)ColorUtil.parseColor((String)" "));
        ColorUtilTest.assertEquals((int)-1, (int)ColorUtil.parseColor(null));
        ColorUtilTest.assertEquals((int)Integer.decode("#FF00FF"), (int)ColorUtil.parseColor((String)"#FF00FF"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FF00FF"), (int)ColorUtil.parseColor((String)"0xFF00FF"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FF00FF"), (int)ColorUtil.parseColor((String)"#F0F"));
        ColorUtilTest.assertEquals((int)Integer.decode("12"), (int)ColorUtil.parseColor((String)"12"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FFFFFF"), (int)ColorUtil.parseColor((String)"16777216"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FFFFFF"), (int)ColorUtil.parseColor((String)"#1FFFFFF"));
        ColorUtilTest.assertEquals((int)Integer.decode("#FF0000"), (int)ColorUtil.parseColor((String)"red"));
        ColorUtilTest.assertEquals((int)Integer.decode("#008000"), (int)ColorUtil.parseColor((String)"green"));
        ColorUtilTest.assertEquals((int)Integer.decode("#0000FF"), (int)ColorUtil.parseColor((String)"blue"));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.parseColor((String)"rgb(0,255,0)"));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.parseColor((String)"rgb( 0 , 255 , 0 )"));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.parseColor((String)"rgb(0,300,0)"));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.parseColor((String)"rgb(0%,100.00%,0%)"));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.parseColor((String)"rgb(0%,200.001%,0%)"));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.parseColor((String)"rgb( 0 %, 100 % , 0 % )"));
        ColorUtilTest.assertEquals((int)-1, (int)ColorUtil.parseColor((String)"0!FF"));
    }

    public void tesetGetPredefinedColor() {
        ColorUtilTest.assertNull((Object)ColorUtil.getPredefinedColor((int)123));
        ColorUtilTest.assertEquals((String)"red", (String)ColorUtil.getPredefinedColor((int)Integer.valueOf("#FF0000")));
        ColorUtilTest.assertEquals((String)"black", (String)ColorUtil.getPredefinedColor((int)Integer.valueOf("#FFFFFF")));
    }

    public void testGetRGBs() {
        int[] rgb = ColorUtil.getRGBs((String)"#FF00FE");
        ColorUtilTest.assertEquals((int)255, (int)rgb[0]);
        ColorUtilTest.assertEquals((int)0, (int)rgb[1]);
        ColorUtilTest.assertEquals((int)254, (int)rgb[2]);
        rgb = ColorUtil.getRGBs((String)"0xFF00FE");
        ColorUtilTest.assertEquals((int)255, (int)rgb[0]);
        ColorUtilTest.assertEquals((int)0, (int)rgb[1]);
        ColorUtilTest.assertEquals((int)254, (int)rgb[2]);
        rgb = ColorUtil.getRGBs((String)"RGB(255,0,254)");
        ColorUtilTest.assertEquals((int)255, (int)rgb[0]);
        ColorUtilTest.assertEquals((int)0, (int)rgb[1]);
        ColorUtilTest.assertEquals((int)254, (int)rgb[2]);
        rgb = ColorUtil.getRGBs((int)15);
        ColorUtilTest.assertEquals((int)0, (int)rgb[0]);
        ColorUtilTest.assertEquals((int)0, (int)rgb[1]);
        ColorUtilTest.assertEquals((int)15, (int)rgb[2]);
    }

    public void testFormRGB() {
        ColorUtilTest.assertEquals((int)Integer.decode("#FFFFFF"), (int)ColorUtil.formRGB((int)255, (int)255, (int)255));
        ColorUtilTest.assertEquals((int)0, (int)ColorUtil.formRGB((int)0, (int)0, (int)0));
        ColorUtilTest.assertEquals((int)Integer.decode("#FF0000"), (int)ColorUtil.formRGB((int)300, (int)0, (int)0));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.formRGB((int)0, (int)300, (int)0));
        ColorUtilTest.assertEquals((int)Integer.decode("#0000FF"), (int)ColorUtil.formRGB((int)0, (int)0, (int)300));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.formRGB((int)-100, (int)255, (int)0));
        ColorUtilTest.assertEquals((int)Integer.decode("#FF0000"), (int)ColorUtil.formRGB((int)255, (int)-100, (int)0));
        ColorUtilTest.assertEquals((int)Integer.decode("#00FF00"), (int)ColorUtil.formRGB((int)0, (int)255, (int)-100));
        ColorUtilTest.assertEquals((int)Integer.decode("#000000"), (int)ColorUtil.formRGB((int)-100, (int)-100, (int)-100));
    }
}

