/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.Point;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class MasterPageHandleTest
extends BaseTestCase {
    private String fileName = "MasterPageHandleTest.xml";
    private String custom_page_fileName = "MasterPageHandleTest1.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testDefaultPage() throws Exception {
        this.openDesign(this.fileName);
        MasterPageHandle pageHandle = this.designHandle.findMasterPage("My Page");
        Point size = pageHandle.getSize();
        MasterPageHandleTest.assertEquals((double)8.5, (double)size.x, (double)1.0);
        MasterPageHandleTest.assertEquals((double)11.0, (double)size.y, (double)1.0);
        MasterPageHandleTest.assertEquals((String)"us-letter", (String)pageHandle.getPageType());
        MasterPageHandleTest.assertEquals((String)"auto", (String)pageHandle.getOrientation());
        MasterPageHandleTest.assertEquals((String)"11in", (String)pageHandle.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"8.5in", (String)pageHandle.getWidth().getStringValue());
        MasterPageHandleTest.assertEquals((String)"0.75mm", (String)pageHandle.getBottomMargin().getStringValue());
        MasterPageHandleTest.assertEquals((String)"0.9mm", (String)pageHandle.getRightMargin().getStringValue());
        MasterPageHandleTest.assertEquals((String)"0.8mm", (String)pageHandle.getLeftMargin().getStringValue());
        MasterPageHandleTest.assertEquals((String)"0.95mm", (String)pageHandle.getTopMargin().getStringValue());
        MasterPageHandleTest.assertEquals((String)"us-letter", (String)pageHandle.getPageType());
        DimensionValue value = pageHandle.getPageHeight();
        MasterPageHandleTest.assertEquals((String)"in", (String)value.getUnits());
        MasterPageHandleTest.assertEquals((double)11.0, (double)value.getMeasure(), (double)0.0);
        value = pageHandle.getPageWidth();
        MasterPageHandleTest.assertEquals((String)"in", (String)value.getUnits());
        MasterPageHandleTest.assertEquals((double)8.5, (double)value.getMeasure(), (double)0.0);
        pageHandle.setPageType("us-legal");
        value = pageHandle.getPageHeight();
        MasterPageHandleTest.assertEquals((String)"in", (String)value.getUnits());
        MasterPageHandleTest.assertEquals((double)14.0, (double)value.getMeasure(), (double)0.0);
        value = pageHandle.getPageWidth();
        MasterPageHandleTest.assertEquals((String)"in", (String)value.getUnits());
        MasterPageHandleTest.assertEquals((double)8.5, (double)value.getMeasure(), (double)0.0);
        pageHandle.setPageType("a4");
        value = pageHandle.getPageHeight();
        MasterPageHandleTest.assertEquals((String)"mm", (String)value.getUnits());
        MasterPageHandleTest.assertEquals((double)297.0, (double)value.getMeasure(), (double)0.0);
        value = pageHandle.getPageWidth();
        MasterPageHandleTest.assertEquals((String)"mm", (String)value.getUnits());
        MasterPageHandleTest.assertEquals((double)210.0, (double)value.getMeasure(), (double)0.0);
    }

    public void testCustomPage() throws Exception {
        this.openDesign(this.custom_page_fileName);
        MasterPageHandle pageHandle = this.designHandle.findMasterPage("My Page1");
        Point size = pageHandle.getSize();
        double CM_PER_INCH = 2.54;
        MasterPageHandleTest.assertEquals((double)(8.3 / CM_PER_INCH), (double)size.x, (double)0.1);
        MasterPageHandleTest.assertEquals((double)(13.3 / CM_PER_INCH), (double)size.y, (double)0.1);
        pageHandle = this.designHandle.findMasterPage("My Page1");
        MasterPageHandleTest.assertEquals((String)"13.3cm", (String)pageHandle.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"8.3cm", (String)pageHandle.getWidth().getStringValue());
        GraphicMasterPageHandle graphicHandle = (GraphicMasterPageHandle)pageHandle;
        MasterPageHandleTest.assertEquals((int)2, (int)graphicHandle.getColumnCount());
        MasterPageHandleTest.assertEquals((String)"0.25mm", (String)graphicHandle.getColumnSpacing().getStringValue());
        MasterPageHandleTest.assertEquals((String)"13.3cm", (String)pageHandle.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"8.3cm", (String)pageHandle.getWidth().getStringValue());
        DimensionValue value = pageHandle.getPageHeight();
        MasterPageHandleTest.assertEquals((String)"cm", (String)value.getUnits());
        MasterPageHandleTest.assertEquals((double)13.3, (double)value.getMeasure(), (double)0.0);
        value = pageHandle.getPageWidth();
        MasterPageHandleTest.assertEquals((String)"cm", (String)value.getUnits());
        MasterPageHandleTest.assertEquals((double)8.3, (double)value.getMeasure(), (double)0.0);
    }

    public void testSetProperty() throws Exception {
        this.openDesign(this.fileName);
        MasterPageHandle page = this.designHandle.findMasterPage("My Page");
        page.setPageType("custom");
        page.setStringProperty("height", "12.0in");
        page.setStringProperty("width", "10.0in");
        MasterPageHandleTest.assertEquals((String)"12in", (String)page.getStringProperty("height"));
        MasterPageHandleTest.assertEquals((String)"10in", (String)page.getStringProperty("width"));
        page.setPageType("a4");
        MasterPageHandleTest.assertEquals((String)"a4", (String)page.getStringProperty("type"));
        MasterPageHandleTest.assertEquals((String)"297mm", (String)page.getStringProperty("height"));
        MasterPageHandleTest.assertEquals((String)"210mm", (String)page.getStringProperty("width"));
        MasterPageHandleTest.assertEquals((String)"297mm", (String)((DimensionValue)page.getHeight().getValue()).toString());
        this.design.getActivityStack().undo();
        MasterPageHandleTest.assertEquals((String)"custom", (String)page.getStringProperty("type"));
        MasterPageHandleTest.assertEquals((String)"12in", (String)page.getStringProperty("height"));
        MasterPageHandleTest.assertEquals((String)"10in", (String)page.getStringProperty("width"));
        page.setPageType("us-legal");
        MasterPageHandleTest.assertEquals((String)"us-legal", (String)page.getStringProperty("type"));
        MasterPageHandleTest.assertEquals((String)"14in", (String)page.getStringProperty("height"));
        MasterPageHandleTest.assertEquals((String)"8.5in", (String)page.getStringProperty("width"));
    }

    public void testLandscape() throws DesignFileException, SemanticException {
        this.openDesign(this.fileName);
        MasterPageHandle page = this.designHandle.findMasterPage("My Page");
        page.setOrientation("landscape");
        page.setPageType("custom");
        page.setStringProperty("height", "12.0in");
        page.setStringProperty("width", "10.0in");
        MasterPageHandleTest.assertEquals((String)"12in", (String)page.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"10in", (String)page.getWidth().getStringValue());
        page.setPageType("a4");
        page.setOrientation("landscape");
        MasterPageHandleTest.assertEquals((String)"210mm", (String)page.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"297mm", (String)page.getWidth().getStringValue());
        page.setOrientation("portrait");
        MasterPageHandleTest.assertEquals((String)"297mm", (String)page.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"210mm", (String)page.getWidth().getStringValue());
        page.setPageType("us-legal");
        page.setOrientation("landscape");
        MasterPageHandleTest.assertEquals((String)"8.5in", (String)page.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"14in", (String)page.getWidth().getStringValue());
        page.setOrientation("portrait");
        MasterPageHandleTest.assertEquals((String)"14in", (String)page.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"8.5in", (String)page.getWidth().getStringValue());
        page.setPageType("us-letter");
        page.setOrientation("landscape");
        MasterPageHandleTest.assertEquals((String)"8.5in", (String)page.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"11in", (String)page.getWidth().getStringValue());
        page.setOrientation("portrait");
        MasterPageHandleTest.assertEquals((String)"11in", (String)page.getHeight().getStringValue());
        MasterPageHandleTest.assertEquals((String)"8.5in", (String)page.getWidth().getStringValue());
    }

    public void testPredefinedType() throws DesignFileException, SemanticException {
        this.openDesign(this.fileName);
        MasterPageHandle page = this.designHandle.findMasterPage("My Page");
        page.setPageType("us-letter");
        this.assertSizeUnsettable(page, "height");
        this.assertSizeUnsettable(page, "width");
        page.setPageType("a4");
        this.assertSizeUnsettable(page, "height");
        this.assertSizeUnsettable(page, "width");
        page.setPageType("us-legal");
        this.assertSizeUnsettable(page, "height");
        this.assertSizeUnsettable(page, "width");
    }

    private void assertSizeUnsettable(MasterPageHandle page, String property) throws SemanticException {
        try {
            page.setProperty(property, (Object)"10in");
            MasterPageHandleTest.fail();
        }
        catch (SemanticException expected) {
            MasterPageHandleTest.assertEquals((String)"Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE", (String)expected.getErrorCode());
        }
    }
}

