/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PropertyHandleTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("PropertyHandleTest.xml");
    }

    public void testOtherOperations() {
        StyleElement myStyle = this.design.findStyle("My-Style");
        PropertyHandle propHandle = myStyle.getHandle((Module)this.design).getPropertyHandle("fontFamily");
        PropertyHandleTest.assertNotNull((Object)propHandle.getChoices());
        propHandle = myStyle.getHandle((Module)this.design).getPropertyHandle("fontWeight");
        PropertyHandleTest.assertNotNull((Object)propHandle.getChoices());
        ElementPropertyDefn propDefn = (ElementPropertyDefn)propHandle.getDefn();
        PropertyHandleTest.assertEquals((String)"fontWeight", (String)propDefn.getName());
        PropertyHandleTest.assertNull((Object)propHandle.getAt(0));
        propHandle = myStyle.getHandle((Module)this.design).getPropertyHandle("mapRules");
        PropertyHandleTest.assertNull((Object)propHandle.getAt(0));
        StructureContext memberRef = propHandle.getContext();
        propDefn = memberRef.getElementProp();
        PropertyHandleTest.assertEquals((String)"mapRules", (String)propDefn.getName());
        Label label = (Label)this.design.findElement("base");
        propHandle = label.getHandle((Module)this.design).getPropertyHandle("text");
        PropertyHandleTest.assertNull((Object)propHandle.getChoices());
        propDefn = (ElementPropertyDefn)propHandle.getPropertyDefn();
        PropertyHandleTest.assertEquals((String)"text", (String)propDefn.getName());
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("child1");
        propHandle = labelHandle.getPropertyHandle("color");
        PropertyHandleTest.assertTrue((boolean)propHandle.isSet());
        PropertyHandleTest.assertFalse((boolean)propHandle.isLocal());
        propHandle = labelHandle.getPropertyHandle("text");
        PropertyHandleTest.assertTrue((boolean)propHandle.isSet());
        PropertyHandleTest.assertFalse((boolean)propHandle.isLocal());
        propHandle = labelHandle.getPropertyHandle("name");
        PropertyHandleTest.assertTrue((boolean)propHandle.isSet());
        PropertyHandleTest.assertTrue((boolean)propHandle.isLocal());
    }

    public void testGetDisplayValue() throws SemanticException {
        this.createDesign(ULocale.GERMANY);
        SimpleMasterPageHandle masterPage = this.designHandle.getElementFactory().newSimpleMasterPage("page");
        this.designHandle.getMasterPages().add((DesignElementHandle)masterPage);
        masterPage.setProperty("headerHeight", (Object)"500.0,000");
        PropertyHandle propertyHandle = masterPage.getPropertyHandle("headerHeight");
        PropertyHandleTest.assertEquals((String)"5.000in", (String)propertyHandle.getDisplayValue());
        PropertyHandleTest.assertEquals((String)"5000in", (String)propertyHandle.getStringValue());
    }

    public void testItemOperations() throws Exception {
        SharedStyleHandle myStyleHandle = (SharedStyleHandle)this.design.findStyle("My-Style").getHandle((Module)this.design);
        MapRule rule = new MapRule();
        rule.setProperty("display", (Object)"addItem1");
        PropertyHandle propHandle = myStyleHandle.getPropertyHandle("mapRules");
        propHandle.addItem((IStructure)rule);
        rule = new MapRule();
        rule.setProperty("display", (Object)"insert1");
        rule.setProperty((PropertyDefn)rule.getDefn().findProperty("operator"), (Object)"like");
        propHandle.insertItem((IStructure)rule, 1);
        rule = new MapRule();
        rule.setProperty("display", (Object)"insert2");
        rule.setProperty((PropertyDefn)rule.getDefn().findProperty("operator"), (Object)"ge");
        propHandle.insertItem((IStructure)rule, 2);
        MapRule replaceRule = new MapRule();
        replaceRule.setProperty("display", (Object)"replace1");
        replaceRule.setProperty((PropertyDefn)rule.getDefn().findProperty("operator"), (Object)"like");
        propHandle.replaceItem((IStructure)rule, (IStructure)replaceRule);
        propHandle.moveItem(0, 2);
        propHandle.moveItem(2, 1);
        StructureHandle structHandle = propHandle.getAt(2);
        PropertyHandleTest.assertNotNull((Object)structHandle);
        MemberHandle memberHandle = structHandle.getMember("operator");
        memberHandle.setValue((Object)"is-false");
        myStyleHandle = (SharedStyleHandle)this.design.findStyle("Style1").getHandle((Module)this.design);
        propHandle = myStyleHandle.getPropertyHandle("mapRules");
        PropertyHandleTest.assertEquals((int)3, (int)propHandle.getListValue().size());
        try {
            propHandle.removeItem(5);
            PropertyHandleTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        propHandle.removeItem(2);
        propHandle.removeItem(0);
        List rules = (List)myStyleHandle.getProperty("mapRules");
        PropertyHandleTest.assertEquals((int)1, (int)rules.size());
        this.save();
        PropertyHandleTest.assertTrue((boolean)this.compareFile("PropertyHandleTest_golden.xml"));
        propHandle.clearValue();
        MapRule newRule = new MapRule();
        newRule.setValue1("value1");
        propHandle.addItem((IStructure)newRule);
        propHandle.addItem((IStructure)newRule);
        PropertyHandleTest.assertEquals((int)2, (int)propHandle.getListValue().size());
        MapRuleHandle mapRuleHandle0 = (MapRuleHandle)propHandle.getAt(0);
        PropertyHandleTest.assertEquals((String)"value1", (String)mapRuleHandle0.getValue1());
        MapRuleHandle mapRuleHandle1 = (MapRuleHandle)propHandle.getAt(1);
        PropertyHandleTest.assertEquals((String)"value1", (String)mapRuleHandle1.getValue1());
        mapRuleHandle0.setValue1("new value");
        PropertyHandleTest.assertEquals((String)"new value", (String)mapRuleHandle0.getValue1());
        propHandle.removeItem((Object)newRule);
        PropertyHandleTest.assertEquals((int)1, (int)propHandle.getListValue().size());
    }

    public void testSetGetValues() throws Exception {
        StyleElement myStyle = this.design.findStyle("Style1");
        PropertyHandle propHandle = myStyle.getHandle((Module)this.design).getPropertyHandle("mapRules");
        List rules = (List)myStyle.getProperty((Module)this.design, "mapRules");
        MapRule rule = new MapRule();
        rule.setProperty("display", (Object)"set map rules");
        rules.add(rule);
        try {
            propHandle.setValue((Object)rules);
            PropertyHandleTest.fail();
        }
        catch (PropertyValueException e) {
            PropertyHandleTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        propHandle = myStyle.getHandle((Module)this.design).getPropertyHandle("color");
        propHandle.setValue((Object)"yellow");
        PropertyHandleTest.assertEquals((String)"yellow", (String)propHandle.getStringValue());
        propHandle = myStyle.getHandle((Module)this.design).getPropertyHandle("borderBottomWidth");
        propHandle.setValue((Object)"thin");
        PropertyHandleTest.assertEquals((String)"thin", (String)propHandle.getStringValue());
        Label label = (Label)this.design.findElement("base");
        propHandle = label.getHandle((Module)this.design).getPropertyHandle("text");
        propHandle.setStringValue("new label text");
        PropertyHandleTest.assertEquals((Object)"new label text", (Object)propHandle.getValue());
        propHandle = label.getHandle((Module)this.design).getPropertyHandle("height");
        propHandle.setStringValue("1.23mm");
        PropertyHandleTest.assertEquals((int)3, (int)propHandle.getTypeCode());
        PropertyHandleTest.assertEquals((String)"1.23mm", (String)propHandle.getStringValue());
        int widows = myStyle.getHandle((Module)this.design).getPropertyHandle("widows").getIntValue();
        PropertyHandleTest.assertEquals((int)2, (int)widows);
        myStyle.getHandle((Module)this.design).getPropertyHandle("widows").setIntValue(6);
        widows = myStyle.getHandle((Module)this.design).getPropertyHandle("widows").getIntValue();
        PropertyHandleTest.assertEquals((int)6, (int)widows);
        myStyle.getHandle((Module)this.design).getPropertyHandle("widows").clearValue();
        this.save();
        PropertyHandleTest.assertTrue((boolean)this.compareFile("PropertyHandleTest_golden_1.xml"));
    }

    public void testEqual() {
        StyleElement myStyle = this.design.findStyle("My-Style");
        PropertyHandle propHandle = myStyle.getHandle((Module)this.design).getPropertyHandle("fontFamily");
        PropertyHandle propHandle1 = myStyle.getHandle((Module)this.design).getPropertyHandle("fontFamily");
        PropertyHandleTest.assertTrue((boolean)propHandle.equals((Object)propHandle1));
        PropertyHandleTest.assertFalse((boolean)propHandle.equals(null));
        propHandle1 = myStyle.getHandle((Module)this.design).getPropertyHandle("backgroundAttachment");
        PropertyHandleTest.assertFalse((boolean)propHandle.equals((Object)propHandle1));
        StyleElement style = this.design.findStyle("Style1");
        propHandle1 = style.getHandle((Module)this.design).getPropertyHandle("fontFamily");
        PropertyHandleTest.assertFalse((boolean)propHandle.equals((Object)propHandle1));
    }

    public void testgetReferenceElementValueList() throws Exception {
        this.openDesign("PropertyHandleTest_1.xml");
        LabelHandle label2 = (LabelHandle)this.designHandle.getComponents().get(1);
        PropertyHandle propertyHandle = label2.getPropertyHandle("dataSet");
        List list = propertyHandle.getReferenceableElementList();
        PropertyHandleTest.assertEquals((int)3, (int)list.size());
        propertyHandle = label2.getPropertyHandle("style");
        list = propertyHandle.getReferenceableElementList();
        PropertyHandleTest.assertEquals((int)2, (int)list.size());
        DataSetHandle dataSet = (DataSetHandle)this.designHandle.getDataSets().get(0);
        propertyHandle = dataSet.getPropertyHandle("dataSource");
        PropertyHandleTest.assertEquals((int)2, (int)propertyHandle.getReferenceableElementList().size());
        propertyHandle = label2.getPropertyHandle("cube");
        PropertyHandleTest.assertEquals((int)0, (int)propertyHandle.getReferenceableElementList().size());
        TabularCubeHandle cubeHandle = this.designHandle.getElementFactory().newTabularCube(null);
        this.designHandle.getCubes().add((DesignElementHandle)cubeHandle);
        PropertyHandleTest.assertEquals((int)1, (int)propertyHandle.getReferenceableElementList().size());
    }

    public void testPropertyVisibilities() throws Exception {
        this.createDesign();
        ElementFactory elemFactory = new ElementFactory((Module)this.design);
        LabelHandle label = elemFactory.newLabel("label1");
        PropertyHandle propHandle = label.getPropertyHandle("dataSet");
        PropertyHandleTest.assertFalse((boolean)propHandle.isVisible());
        PropertyHandleTest.assertFalse((boolean)propHandle.isReadOnly());
        propHandle = label.getPropertyHandle("height");
        PropertyHandleTest.assertTrue((boolean)propHandle.isVisible());
        PropertyHandleTest.assertFalse((boolean)propHandle.isReadOnly());
        CellHandle cell = elemFactory.newCell();
        propHandle = cell.getPropertyHandle("column");
        PropertyHandleTest.assertFalse((boolean)propHandle.isVisible());
        PropertyHandleTest.assertFalse((boolean)propHandle.isReadOnly());
        TextItemHandle text = elemFactory.newTextItem("text1");
        propHandle = text.getPropertyHandle("dataSet");
        PropertyHandleTest.assertTrue((boolean)propHandle.isVisible());
        PropertyHandleTest.assertFalse((boolean)propHandle.isReadOnly());
        TabularCubeHandle cube = elemFactory.newTabularCube("cube1");
        propHandle = cube.getPropertyHandle("dimensions");
        PropertyHandleTest.assertFalse((boolean)propHandle.isVisible());
        propHandle = cube.getPropertyHandle("filter");
        PropertyHandleTest.assertFalse((boolean)propHandle.isVisible());
        TableHandle table = elemFactory.newTableItem("table", 3);
        SlotHandle headerSlot = table.getHeader();
        RowHandle rowHandle = (RowHandle)headerSlot.get(0);
        propHandle = rowHandle.getPropertyHandle("repeatable");
        PropertyHandleTest.assertTrue((boolean)propHandle.isVisible());
        PropertyHandleTest.assertFalse((boolean)propHandle.isReadOnly());
        SlotHandle footerSlot = table.getFooter();
        rowHandle = (RowHandle)footerSlot.get(0);
        propHandle = rowHandle.getPropertyHandle("repeatable");
        PropertyHandleTest.assertTrue((boolean)propHandle.isVisible());
        PropertyHandleTest.assertFalse((boolean)propHandle.isReadOnly());
        SlotHandle detailSlot = table.getDetail();
        rowHandle = (RowHandle)detailSlot.get(0);
        propHandle = rowHandle.getPropertyHandle("repeatable");
        PropertyHandleTest.assertFalse((boolean)propHandle.isVisible());
        PropertyHandleTest.assertTrue((boolean)propHandle.isReadOnly());
        SlotHandle groupSlot = table.getGroups();
        TableGroupHandle group = elemFactory.newTableGroup();
        groupSlot.add((DesignElementHandle)group);
        SlotHandle groupFooterSlot = group.getFooter();
        rowHandle = elemFactory.newTableRow();
        groupFooterSlot.add((DesignElementHandle)rowHandle);
        propHandle = rowHandle.getPropertyHandle("repeatable");
        PropertyHandleTest.assertTrue((boolean)propHandle.isVisible());
        PropertyHandleTest.assertFalse((boolean)propHandle.isReadOnly());
        SlotHandle groupHeaderSlot = group.getHeader();
        rowHandle = elemFactory.newTableRow();
        groupHeaderSlot.add((DesignElementHandle)rowHandle);
        propHandle = rowHandle.getPropertyHandle("repeatable");
        PropertyHandleTest.assertTrue((boolean)propHandle.isVisible());
        PropertyHandleTest.assertFalse((boolean)propHandle.isReadOnly());
        GridHandle grid = elemFactory.newGridItem("grid", 2, 2);
        SlotHandle rowSlot = grid.getRows();
        rowHandle = (RowHandle)rowSlot.get(0);
        propHandle = rowHandle.getPropertyHandle("repeatable");
        PropertyHandleTest.assertFalse((boolean)propHandle.isVisible());
        PropertyHandleTest.assertTrue((boolean)propHandle.isReadOnly());
        ExtendedItemHandle extendedItem = elemFactory.newExtendedItem(null, "TestingMatrix");
        propHandle = extendedItem.getPropertyHandle("bookmark");
        PropertyHandleTest.assertFalse((boolean)propHandle.isVisible());
        PropertyHandleTest.assertTrue((boolean)propHandle.isReadOnly());
    }

    public void testCachedMemberRef() throws Exception {
        SharedStyleHandle style = this.designHandle.findStyle("Style1");
        PropertyHandle propHandle = style.getPropertyHandle("mapRules");
        ArrayList<StructureHandle> list = new ArrayList<StructureHandle>();
        for (StructureHandle structHandle : propHandle) {
            list.add(structHandle);
        }
        PropertyHandleTest.assertEquals((Object)"like", (Object)((StructureHandle)list.get(0)).getProperty("operator"));
        PropertyHandleTest.assertEquals((Object)"eq", (Object)((StructureHandle)list.get(1)).getProperty("operator"));
        PropertyHandleTest.assertEquals((Object)"ge", (Object)((StructureHandle)list.get(2)).getProperty("operator"));
        MapRule ruleToDropped = (MapRule)((StructureHandle)list.get(1)).getStructure();
        propHandle.removeItem(1);
        PropertyDefn memberDefn = (PropertyDefn)((StructureHandle)list.get(2)).getDefn().getMember("operator");
        MapRuleHandle rule = (MapRuleHandle)list.get(0);
        PropertyHandleTest.assertEquals((Object)"like", (Object)rule.getStructure().getProperty((Module)this.design, memberDefn));
        PropertyHandleTest.assertEquals((Object)"like", (Object)rule.getProperty("operator"));
        MapRuleHandle ruleDropped = (MapRuleHandle)list.get(1);
        PropertyHandleTest.assertEquals(null, (Object)ruleDropped.getStructure());
        PropertyHandleTest.assertFalse((boolean)ruleDropped.iterator().hasNext());
        PropertyHandleTest.assertNull(ruleDropped.iterator().next());
        try {
            ruleDropped.getProperty("operator");
            PropertyHandleTest.fail();
        }
        catch (Exception e) {
            PropertyHandleTest.assertTrue((boolean)(e instanceof RuntimeException));
        }
        try {
            ruleDropped.getMember("operator");
            PropertyHandleTest.fail();
        }
        catch (Exception e) {
            PropertyHandleTest.assertTrue((boolean)(e instanceof RuntimeException));
        }
        try {
            ruleDropped.getOperator();
            PropertyHandleTest.fail();
        }
        catch (Exception e) {
            PropertyHandleTest.assertTrue((boolean)(e instanceof RuntimeException));
        }
        try {
            ruleDropped.setProperty("operator", (Object)"le");
            PropertyHandleTest.fail();
        }
        catch (Exception e) {
            PropertyHandleTest.assertTrue((boolean)(e instanceof RuntimeException));
        }
        rule = (MapRuleHandle)list.get(2);
        PropertyHandleTest.assertEquals((Object)"ge", (Object)rule.getStructure().getProperty((Module)this.design, memberDefn));
        PropertyHandleTest.assertEquals((Object)"ge", (Object)rule.getProperty("operator"));
        MapRuleHandle ruleAdded = (MapRuleHandle)propHandle.addItem((IStructure)ruleToDropped);
        PropertyHandleTest.assertEquals((Object)"eq", (Object)ruleDropped.getStructure().getProperty((Module)this.design, memberDefn));
        PropertyHandleTest.assertEquals((Object)"eq", (Object)ruleDropped.getProperty("operator"));
        PropertyHandleTest.assertEquals((Object)"eq", (Object)ruleAdded.getStructure().getProperty((Module)this.design, memberDefn));
        PropertyHandleTest.assertEquals((Object)"eq", (Object)ruleAdded.getProperty("operator"));
    }

    public void testCompoundExtendsOperations() throws Exception {
        this.openDesign("PropertyHandleTest_2.xml");
        GridHandle grid1 = (GridHandle)this.designHandle.findElement("Grid1");
        RowHandle row1 = (RowHandle)grid1.getRows().get(0);
        CellHandle cell1 = (CellHandle)row1.getCells().get(0);
        LabelHandle label1 = (LabelHandle)cell1.getContent().get(0);
        try {
            cell1.setRowSpan(2);
            PropertyHandleTest.fail();
        }
        catch (SemanticException e) {
            PropertyHandleTest.assertEquals((String)"Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            cell1.setColumn(2);
            PropertyHandleTest.fail();
        }
        catch (SemanticException e) {
            PropertyHandleTest.assertEquals((String)"Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        grid1.setWidth("31.2mm");
        grid1.setStyleName("style1");
        PropertyHandleTest.assertEquals((String)"larger", (String)grid1.getStringProperty("fontSize"));
        row1.setStringProperty("height", "13pt");
        row1.setStyleName("style2");
        label1.setName("New label");
        cell1.setStringProperty("width", "20pt");
        cell1.setStyleName("style2");
        PropertyHandleTest.assertEquals((String)"bold", (String)cell1.getStringProperty("fontWeight"));
        this.save();
        PropertyHandleTest.assertTrue((boolean)this.compareFile("PropertyHandleTest_golden2.xml"));
    }

    public void testGetIntValue() throws Exception {
        this.createDesign();
        ElementFactory factory = this.designHandle.getElementFactory();
        LabelHandle label = factory.newLabel("aaa");
        label.setProperty("color", (Object)"red");
        PropertyHandleTest.assertEquals((int)0xFF0000, (int)label.getIntProperty("color"));
        PropertyHandleTest.assertEquals((int)0xFF0000, (int)label.getPropertyHandle("color").getIntValue());
        PropertyHandleTest.assertEquals((String)"red", (String)label.getPropertyHandle("color").getStringValue());
        PropertyHandleTest.assertEquals((String)"red", (String)label.getStringProperty("color"));
    }

    public void testSetValue() throws Exception {
        this.openDesign("PropertyHandleTest_setValue.xml");
        OdaDataSetHandle odaHandle = (OdaDataSetHandle)this.designHandle.getElementByID(35L);
        PropertyHandleTest.assertNotNull((Object)odaHandle);
        PropertyHandle propHandle = odaHandle.getPropertyHandle("resultSet");
        propHandle.setValue(new ArrayList());
        PropertyHandleTest.assertFalse((boolean)propHandle.iterator().hasNext());
        super.compareFile("PropertyHandleTest_setValue_golden.xml");
    }
}

