/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PropertySortingTest
extends BaseTestCase {
    public void test_EN() throws Exception {
        this.openDesign("PropertySortingTest.xml", ULocale.ENGLISH);
        this.dump("propertyIterator_EN.out");
    }

    public void test_zh_CN() throws Exception {
        this.openDesign("PropertySortingTest.xml", ULocale.CHINA);
        this.dump("propertyIterator_zh_CN.out");
    }

    private void dump(String fileName) throws Exception {
        PrintWriter pw = null;
        String outputFolder = String.valueOf(this.getTempFolder()) + "/output/";
        File f = new File(outputFolder);
        if (!f.exists() && !f.mkdir()) {
            throw new Exception("Can not create the output folder!");
        }
        pw = new PrintWriter(new FileOutputStream(new File(String.valueOf(outputFolder) + fileName)));
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style1");
        Iterator iterator = styleHandle.getPropertyIterator();
        while (iterator.hasNext()) {
            PropertyHandle propertyHandle = (PropertyHandle)iterator.next();
            IElementPropertyDefn propDefn = propertyHandle.getPropertyDefn();
            pw.println(propDefn.getDisplayName());
            IStructureDefn structDefn = propDefn.getStructDefn();
            if (structDefn == null) continue;
            for (StructureHandle structHandle : propertyHandle) {
                for (MemberHandle memHandle : structHandle) {
                    pw.println("    " + memHandle.getDefn().getDisplayName());
                }
                pw.println();
            }
        }
        pw.close();
    }
}

