/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportItemHandleTest
extends BaseTestCase {
    private DesignElement element;
    private InnerReportItemHandle innerHandle;
    private String fileName = "ReportItemHandleTest.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testDataSet() throws Exception {
        this.openDesign(this.fileName);
        this.element = this.design.findElement("free form");
        ReportItemHandleTest.assertNotNull((Object)this.element);
        this.innerHandle = new InnerReportItemHandle(this.design, this.element);
        DataSetHandle itemHandle = this.innerHandle.getDataSet();
        ReportItemHandleTest.assertNotNull((Object)itemHandle);
        String name = this.innerHandle.getDataSet().getElement().getName();
        ReportItemHandleTest.assertEquals((String)"myDataSet", (String)name);
        this.element = this.design.findElement("my list");
        ReportItemHandleTest.assertNotNull((Object)this.element);
        this.innerHandle = new InnerReportItemHandle(this.design, this.element);
        itemHandle = this.innerHandle.getDataSet();
        ReportItemHandleTest.assertNotNull((Object)itemHandle);
        DataSetHandle handle = this.designHandle.findDataSet("myDataSet");
        ListHandle list = (ListHandle)this.element.getHandle((Module)this.design);
        list.setDataSet(handle);
        ReportItemHandleTest.assertEquals((Object)handle, (Object)list.getDataSet());
        list.setDataSet(null);
        ReportItemHandleTest.assertNull((Object)list.getDataSet());
    }

    public void testTOC() throws Exception {
        this.openDesign(this.fileName);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        TOC toc = StructureFactory.createTOC((String)"toc");
        TOCHandle tocHandle = labelHandle.addTOC(toc);
        ReportItemHandleTest.assertNotNull((Object)tocHandle);
        ReportItemHandleTest.assertEquals((String)"toc", (String)tocHandle.getExpression());
        tocHandle.setProperty("fontWeight", (Object)"bold");
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        style.setCanShrink(true);
        style.setFontWeight("normal");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        ReportItemHandleTest.assertEquals((String)"toc", (String)labelHandle.getStringProperty("toc"));
        tocHandle.setStyleName(style.getName());
        ReportItemHandleTest.assertEquals((String)"style", (String)tocHandle.getStyleName());
    }

    public void testSetTOCProperty() throws Exception {
        this.openDesign(this.fileName);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        labelHandle.setStringProperty("toc", "toc");
        ReportItemHandleTest.assertEquals((String)"toc", (String)labelHandle.getStringProperty("toc"));
    }

    public void testColumnBinding() throws SemanticException {
        this.createDesign();
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem("new table");
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        tableHandle = (TableHandle)this.designHandle.findElement("new table");
        ComputedColumn col = StructureFactory.createComputedColumn();
        col.setName(null);
        col.setExpression("dataSetRow[\"CUSTOMERNUMBER\"]");
        ReportItemHandleTest.assertNull((Object)tableHandle.addColumnBinding(null, true));
        try {
            tableHandle.addColumnBinding(col, true);
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
        col.setName("CUSTOMERNUMBER");
        tableHandle.addColumnBinding(col, true);
        ComputedColumn col2 = StructureFactory.createComputedColumn();
        col2.setName("CUSTOMERNUMBER");
        col2.setExpression("dataSetRow[\"CUSTOMERNUMBER\"]");
        try {
            tableHandle.addColumnBinding(col2, true);
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        col = StructureFactory.createComputedColumn();
        col.setName("CUSTOMERNUMBER");
        col.setExpression("dataSetRow[\"CUSTOMERNUMBER_TEST\"]");
        try {
            tableHandle.addColumnBinding(col, true);
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        col = StructureFactory.createComputedColumn();
        col.setName("CUSTOMERNUMBER_TEST");
        col.setExpression("dataSetRow[\"CUSTOMERNUMBER\"]");
        tableHandle.addColumnBinding(col, true);
        col = (ComputedColumn)((ComputedColumnHandle)tableHandle.columnBindingsIterator().next()).getStructure();
        PropertyHandle propertyHandle = tableHandle.getPropertyHandle("boundDataColumns");
        ComputedColumn newCol = StructureFactory.createComputedColumn();
        newCol.setName(null);
        newCol.setExpression("dataSetRow[\"CUSTOMER\"]");
        try {
            propertyHandle.replaceItem((IStructure)col, (IStructure)newCol);
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertTrue((boolean)(e instanceof PropertyValueException));
        }
        newCol.setName("CUSTOMERNUMBER");
        try {
            propertyHandle.replaceItem((IStructure)col, (IStructure)newCol);
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        newCol.setName("Number");
        propertyHandle.replaceItem((IStructure)col, (IStructure)newCol);
        tableHandle.clearProperty("boundDataColumns");
        ReportItemHandleTest.assertNull((Object)tableHandle.getListProperty("boundDataColumns"));
        TableGroupHandle groupHandle = this.designHandle.getElementFactory().newTableGroup();
        groupHandle.setName("NewGroup");
        tableHandle.getGroups().add((DesignElementHandle)groupHandle);
        ComputedColumn groupCol = StructureFactory.createComputedColumn();
        groupCol.setName("data item1");
        groupCol.setExpression("Total.sum(row[\"CUSTOMERNUMBER\"] , null , null )");
        groupCol.setAggregateOn("NewGroup");
        groupCol.setDataType("string");
        tableHandle.addColumnBinding(groupCol, false);
        ComputedColumn tableCol = StructureFactory.createComputedColumn();
        tableCol.setName("data item2");
        tableCol.setExpression("Total.sum(row[\"CUSTOMERNUMBER\"] , null , null )");
        tableCol.setAggregateOn("All");
        tableCol.setDataType("string");
        tableHandle.addColumnBinding(tableCol, false);
        List boundList = tableHandle.getListProperty("boundDataColumns");
        ReportItemHandleTest.assertEquals((int)2, (int)boundList.size());
        ReportItemHandleTest.assertEquals((String)"data item1", (String)((ComputedColumn)boundList.get(0)).getName());
        ReportItemHandleTest.assertEquals((String)"NewGroup", (String)((ComputedColumn)boundList.get(0)).getAggregateOn());
        ReportItemHandleTest.assertEquals((String)"data item2", (String)((ComputedColumn)boundList.get(1)).getName());
        ReportItemHandleTest.assertEquals((String)"All", (String)((ComputedColumn)boundList.get(1)).getAggregateOn());
    }

    public void testReadVisibilityRules() throws Exception {
        this.openDesign(this.fileName);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        Iterator rules = labelHandle.visibilityRulesIterator();
        StructureHandle structHandle = (StructureHandle)rules.next();
        ReportItemHandleTest.assertNotNull((Object)structHandle);
        MemberHandle memberHandle = structHandle.getMember("format");
        ReportItemHandleTest.assertEquals((String)"pdf", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("valueExpr");
        ReportItemHandleTest.assertEquals((String)"pdf, 10 people", (String)memberHandle.getStringValue());
        structHandle = (StructureHandle)rules.next();
        ReportItemHandleTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("format");
        ReportItemHandleTest.assertEquals((String)"all", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("valueExpr");
        ReportItemHandleTest.assertEquals((String)"excel, 10 people", (String)memberHandle.getStringValue());
        structHandle = (StructureHandle)rules.next();
        ReportItemHandleTest.assertNull((Object)structHandle);
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("bodyData");
        rules = dataHandle.visibilityRulesIterator();
        structHandle = (StructureHandle)rules.next();
        ReportItemHandleTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("format");
        ReportItemHandleTest.assertEquals((String)"all", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("valueExpr");
        ReportItemHandleTest.assertNull((Object)memberHandle.getStringValue());
        structHandle = (StructureHandle)rules.next();
        ReportItemHandleTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("format");
        ReportItemHandleTest.assertEquals((String)"pdf", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("valueExpr");
        ReportItemHandleTest.assertNull((Object)memberHandle.getStringValue());
    }

    public void testWriteVisibilityRules() throws Exception {
        this.openDesign(this.fileName);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        Iterator rules = labelHandle.visibilityRulesIterator();
        StructureHandle structHandle = (StructureHandle)rules.next();
        ReportItemHandleTest.assertNotNull((Object)structHandle);
        MemberHandle memberHandle = structHandle.getMember("format");
        memberHandle.setValue((Object)"reportlet");
        try {
            memberHandle.setValue((Object)"noformat");
        }
        catch (PropertyValueException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        memberHandle = structHandle.getMember("valueExpr");
        memberHandle.setValue((Object)"10*20");
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.findElement("bodyData");
        rules = dataHandle.visibilityRulesIterator();
        structHandle = (StructureHandle)rules.next();
        structHandle = (StructureHandle)rules.next();
        ReportItemHandleTest.assertNotNull((Object)structHandle);
        memberHandle = structHandle.getMember("format");
        memberHandle.setValue((Object)"reportlet");
        memberHandle = structHandle.getMember("valueExpr");
        memberHandle.setValue((Object)"bodyData 2nd rule.");
        structHandle = (StructureHandle)rules.next();
        ReportItemHandleTest.assertNull((Object)structHandle);
    }

    public void testProperties() throws Exception {
        this.openDesign(this.fileName);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel");
        labelHandle.setWidth("15in");
        ReportItemHandleTest.assertEquals((String)"15in", (String)labelHandle.getWidth().getStringValue());
        try {
            labelHandle.setWidth(-15.0);
            labelHandle.setProperty("marginTop", (Object)"-10pt");
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertTrue((boolean)(e instanceof PropertyValueException));
        }
        labelHandle.setHeight("5in");
        ReportItemHandleTest.assertEquals((String)"5in", (String)labelHandle.getHeight().getStringValue());
        labelHandle.setX(".5in");
        ReportItemHandleTest.assertEquals((String)"0.5in", (String)labelHandle.getX().getStringValue());
        labelHandle.setY("5.38in");
        ReportItemHandleTest.assertEquals((String)"5.38in", (String)labelHandle.getY().getStringValue());
    }

    public void testUndoInvalidStyle() throws Exception {
        this.openDesign(this.fileName);
        TextItemHandle textHandle = (TextItemHandle)this.designHandle.findElement("myText");
        textHandle.setStyleName("My-Style");
        this.designHandle.getCommandStack().undo();
        ReportItemHandleTest.assertEquals((String)"unknownStyle", (String)textHandle.getStringProperty("style"));
        ReportItemHandleTest.assertEquals(null, (Object)textHandle.getElementProperty("style"));
        ReportItemHandleTest.assertEquals(null, (Object)textHandle.getStyle());
    }

    public void testUndoInvalidDataSet() throws Exception {
        this.openDesign(this.fileName);
        TextItemHandle textHandle = (TextItemHandle)this.designHandle.findElement("myText");
        textHandle.setProperty("dataSet", (Object)"myDataSet");
        this.designHandle.getCommandStack().undo();
        ReportItemHandleTest.assertEquals((String)"unknownDataSet", (String)textHandle.getStringProperty("dataSet"));
        ReportItemHandleTest.assertEquals(null, (Object)textHandle.getElementProperty("dataSet"));
        ReportItemHandleTest.assertEquals(null, (Object)textHandle.getDataSet());
    }

    public void testBoundDataColumns() throws Exception {
        this.openDesign(this.fileName);
        TextItemHandle textHandle = (TextItemHandle)this.designHandle.findElement("myText");
        ComputedColumn tmpComputedColumn = new ComputedColumn();
        tmpComputedColumn.setName("new column1");
        tmpComputedColumn.setExpression("new column1 expr");
        textHandle.addColumnBinding(tmpComputedColumn, false);
        ReportItemHandleTest.assertEquals((int)1, (int)textHandle.getListProperty("boundDataColumns").size());
        tmpComputedColumn = new ComputedColumn();
        tmpComputedColumn.setName("new column1");
        tmpComputedColumn.setExpression("new column expr");
        try {
            textHandle.addColumnBinding(tmpComputedColumn, false);
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        try {
            textHandle.addColumnBinding(tmpComputedColumn, true);
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        tmpComputedColumn.setExpression("new column1 expr");
        try {
            textHandle.addColumnBinding(tmpComputedColumn, true);
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        textHandle.addColumnBinding(tmpComputedColumn, false);
        ReportItemHandleTest.assertEquals((int)1, (int)textHandle.getListProperty("boundDataColumns").size());
        tmpComputedColumn.setName("new column2");
        textHandle.addColumnBinding(tmpComputedColumn, false);
        ReportItemHandleTest.assertEquals((int)1, (int)textHandle.getListProperty("boundDataColumns").size());
        textHandle.addColumnBinding(tmpComputedColumn, true);
        ReportItemHandleTest.assertEquals((int)2, (int)textHandle.getListProperty("boundDataColumns").size());
        Iterator iter1 = textHandle.columnBindingsIterator();
        ComputedColumnHandle columnHandle1 = (ComputedColumnHandle)iter1.next();
        ReportItemHandleTest.assertEquals((String)"new column1", (String)columnHandle1.getName());
        ComputedColumnHandle columnHandle2 = (ComputedColumnHandle)iter1.next();
        ReportItemHandleTest.assertEquals((String)"new column2", (String)columnHandle2.getName());
        try {
            columnHandle2.setName("new column1");
            ReportItemHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportItemHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_EXISTS", (String)e.getErrorCode());
        }
        columnHandle2.setName("new column3");
        ReportItemHandleTest.assertEquals((String)"new column3", (String)columnHandle2.getName());
        columnHandle2.setName("table1.column3");
        ReportItemHandleTest.assertEquals((String)"table1.column3", (String)columnHandle2.getName());
    }

    public void testRemovedColumnBindings() throws Exception {
        this.openDesign("ReportItemHandleTest_2.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("myTable1");
        ReportItemHandleTest.assertEquals((int)14, (int)table.getColumnBindings().getListValue().size());
        ArrayList<String> bindingNameList = new ArrayList<String>(2);
        bindingNameList.add("CITY");
        bindingNameList.add("nobindingitem");
        table.removedColumnBindings(bindingNameList);
        ReportItemHandleTest.assertEquals((int)12, (int)table.getColumnBindings().getListValue().size());
    }

    public void testGetAvailableBindings() throws DesignFileException {
        this.openDesign("ReportItemHandleTest_3.xml");
        TableHandle tableone = (TableHandle)this.designHandle.findElement("tableone");
        ReportItemHandleTest.assertNotNull((Object)tableone);
        HashMap<String, String> one = new HashMap<String, String>();
        one.put("TableOneCol1", "\"TableOneCol1\"");
        one.put("TableOneCol2", "\"TableOneCol2\"");
        ArrayList tableOneBindings = new ArrayList();
        Iterator itr = tableone.getAvailableBindings();
        while (itr.hasNext()) {
            tableOneBindings.add(itr.next());
        }
        ReportItemHandleTest.assertTrue((tableOneBindings.size() == 2 ? 1 : 0) != 0);
        int i = 0;
        while (i < tableOneBindings.size()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)tableOneBindings.get(i);
            ReportItemHandleTest.assertTrue((boolean)one.containsKey(binding.getName()));
            ReportItemHandleTest.assertEquals(one.get(binding.getName()), (Object)binding.getExpression());
            ++i;
        }
        TableHandle tableTwo = (TableHandle)this.designHandle.findElement("tabletwo");
        ReportItemHandleTest.assertNotNull((Object)tableone);
        HashMap<String, String> two = new HashMap<String, String>();
        two.putAll(one);
        ArrayList tableTwoBindings = new ArrayList();
        Iterator itr2 = tableTwo.getAvailableBindings();
        while (itr2.hasNext()) {
            tableTwoBindings.add(itr2.next());
        }
        ReportItemHandleTest.assertTrue((tableTwoBindings.size() == 2 ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < tableTwoBindings.size()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)tableOneBindings.get(i2);
            ReportItemHandleTest.assertTrue((boolean)two.containsKey(binding.getName()));
            ReportItemHandleTest.assertEquals(two.get(binding.getName()), (Object)binding.getExpression());
            ++i2;
        }
        TableHandle tableThree = (TableHandle)this.designHandle.findElement("tablethree");
        ReportItemHandleTest.assertNotNull((Object)tableone);
        HashMap<String, String> three = new HashMap<String, String>();
        three.putAll(one);
        three.put("TableThreeCol1", "\"TableThreeCol1\"");
        ArrayList tableThreeBindings = new ArrayList();
        Iterator itr3 = tableThree.getAvailableBindings();
        while (itr3.hasNext()) {
            tableThreeBindings.add(itr3.next());
        }
        ReportItemHandleTest.assertTrue((tableThreeBindings.size() == 3 ? 1 : 0) != 0);
        int i3 = 0;
        while (i3 < tableThreeBindings.size()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)tableThreeBindings.get(i3);
            ReportItemHandleTest.assertTrue((boolean)three.containsKey(binding.getName()));
            ReportItemHandleTest.assertEquals(three.get(binding.getName()), (Object)binding.getExpression());
            ++i3;
        }
        ExtendedItemHandle newchart = (ExtendedItemHandle)this.designHandle.findElement("NewChart");
        ReportItemHandleTest.assertNotNull((Object)newchart);
        HashMap<String, String> chart = new HashMap<String, String>();
        chart.putAll(one);
        chart.put("ChartCol1", "\"ChartCol1\"");
        chart.put("ChartCol2", "\"ChartCol2\"");
        ArrayList chartBindingList = new ArrayList();
        Iterator itr4 = newchart.getAvailableBindings();
        while (itr4.hasNext()) {
            chartBindingList.add(itr4.next());
        }
        ReportItemHandleTest.assertTrue((chartBindingList.size() == 4 ? 1 : 0) != 0);
        int i4 = 0;
        while (i4 < chartBindingList.size()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)chartBindingList.get(i4);
            ReportItemHandleTest.assertTrue((boolean)chart.containsKey(binding.getName()));
            ReportItemHandleTest.assertEquals(chart.get(binding.getName()), (Object)binding.getExpression());
            ++i4;
        }
    }

    class InnerReportItemHandle
    extends ReportItemHandle {
        InnerReportItemHandle(ReportDesign design, DesignElement element) {
            super((Module)design, element);
        }
    }
}

