/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class SlotHandleTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        this.createDesign();
    }

    public void testPaste() throws SemanticException {
        ElementFactory factory = new ElementFactory((Module)this.design);
        SharedStyleHandle style = factory.newStyle("style");
        style.getColor().setValue((Object)"aqua");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        this.designHandle.getDataSources().add((DesignElementHandle)factory.newOdaDataSource("DataSource1"));
        OdaDataSetHandle dataset = factory.newOdaDataSet("DataSet1");
        this.designHandle.getDataSets().add((DesignElementHandle)dataset);
        dataset.setDataSource("DataSource1");
        TextItemHandle text = factory.newTextItem("text");
        text.setStyle(style);
        ReportDesignHandle newDesignHandle = this.sessionHandle.createDesign();
        ReportDesign newDesign = (ReportDesign)newDesignHandle.getModule();
        OdaDataSetHandle newDataSet = (OdaDataSetHandle)dataset.copy().getHandle((Module)newDesign);
        List errors = newDesignHandle.getDataSets().paste((DesignElementHandle)newDataSet);
        SlotHandleTest.assertEquals((int)1, (int)errors.size());
        SlotHandleTest.assertEquals((String)"Error.SemanticError.INVALID_ELEMENT_REF", (String)((ErrorDetail)errors.get(0)).getErrorCode());
        SlotHandleTest.assertNull((Object)newDataSet.getDataSource());
        newDataSet = (OdaDataSetHandle)dataset.copy().getHandle((Module)this.design);
        this.designHandle.rename((DesignElementHandle)newDataSet);
        errors = this.designHandle.getDataSets().paste((DesignElementHandle)newDataSet);
        SlotHandleTest.assertEquals((int)0, (int)errors.size());
        SlotHandleTest.assertNotNull((Object)newDataSet.getDataSource());
        Iterator iter = this.designHandle.findDataSource("DataSource1").clientsIterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        SlotHandleTest.assertEquals((int)2, (int)count);
        TextItemHandle newText = (TextItemHandle)text.copy().getHandle((Module)newDesign);
        errors = newDesignHandle.getBody().paste((DesignElementHandle)newText);
        SlotHandleTest.assertEquals((int)1, (int)errors.size());
        SlotHandleTest.assertEquals((String)"Error.StyleException.NOT_FOUND", (String)((ErrorDetail)errors.get(0)).getErrorCode());
        SlotHandleTest.assertEquals((Object)"black", (Object)newText.getProperty("color"));
        newText = (TextItemHandle)text.copy().getHandle((Module)this.design);
        this.designHandle.rename((DesignElementHandle)newText);
        errors = this.designHandle.getBody().paste((DesignElementHandle)newText);
        SlotHandleTest.assertEquals((int)0, (int)errors.size());
        SlotHandleTest.assertEquals((Object)"aqua", (Object)newText.getProperty("color"));
        iter = style.clientsIterator();
        count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        SlotHandleTest.assertEquals((int)2, (int)count);
        TableHandle table = factory.newTableItem("table1", 3);
        ColumnHandle column = (ColumnHandle)table.getColumns().get(0);
        IDesignElement tocopy = column.copy();
        table.getColumns().paste(tocopy, 1);
    }

    public void testPasteCompoundElements() throws Exception {
        ParameterGroupHandle paramGroup1 = this.designHandle.getElementFactory().newParameterGroup("group1");
        ScalarParameterHandle param1 = this.designHandle.getElementFactory().newScalarParameter("param1");
        paramGroup1.getParameters().add((DesignElementHandle)param1);
        this.designHandle.getParameters().add((DesignElementHandle)paramGroup1);
        ParameterGroupHandle paramGroup2 = (ParameterGroupHandle)paramGroup1.copy().getHandle((Module)this.design);
        this.designHandle.rename((DesignElementHandle)paramGroup2);
        List errors = this.designHandle.getParameters().paste((DesignElementHandle)paramGroup2);
        SlotHandleTest.assertEquals((int)0, (int)errors.size());
    }

    public void testCompoundExtendsOperations() throws NameException, DesignFileException {
        this.openDesign("SlotHandleTest.xml");
        ElementFactory factory = new ElementFactory((Module)this.design);
        GridHandle grid1Handle = (GridHandle)this.designHandle.findElement("Grid1");
        SlotHandleTest.assertNotNull((Object)grid1Handle.getExtends());
        GridHandle grid2Handle = (GridHandle)this.designHandle.findElement("Grid2");
        try {
            grid2Handle.drop();
        }
        catch (SemanticException semanticException) {
            SlotHandleTest.fail();
        }
        RowHandle newRow = factory.newTableRow();
        RowHandle firstRowHandle = (RowHandle)grid1Handle.getRows().get(0);
        SlotHandleTest.assertFalse((boolean)firstRowHandle.canDrop());
        SlotHandleTest.assertFalse((boolean)grid1Handle.getRows().canContain((DesignElementHandle)newRow));
        SlotHandleTest.assertFalse((boolean)grid1Handle.getRows().canContain("Cell"));
        try {
            grid1Handle.addElement((DesignElementHandle)newRow, 1);
            SlotHandleTest.fail();
        }
        catch (ContentException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            grid1Handle.getSlot(1).drop(0);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            grid1Handle.getSlot(1).drop((DesignElementHandle)firstRowHandle);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            grid1Handle.getSlot(1).dropAndClear((DesignElementHandle)firstRowHandle);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            grid1Handle.getSlot(1).dropAndClear(0);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            grid1Handle.getSlot(1).shift((DesignElementHandle)firstRowHandle, 1);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            grid1Handle.getSlot(1).paste((DesignElementHandle)newRow);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            grid1Handle.getSlot(1).paste((DesignElementHandle)newRow, 1);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        SlotHandleTest.assertTrue((boolean)firstRowHandle.getElement().isVirtualElement());
        CellHandle newCell = factory.newCell();
        SlotHandleTest.assertFalse((boolean)firstRowHandle.canContain(0, (DesignElementHandle)newCell));
        SlotHandleTest.assertFalse((boolean)firstRowHandle.canContain(0, "Cell"));
        SlotHandleTest.assertFalse((boolean)firstRowHandle.canDrop());
        SlotHandleTest.assertFalse((boolean)firstRowHandle.getCells().canContain("Cell"));
        try {
            firstRowHandle.drop();
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            firstRowHandle.getCells().add((DesignElementHandle)newCell);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            firstRowHandle.getCells().add((DesignElementHandle)newCell, 1);
            SlotHandleTest.fail();
        }
        catch (SemanticException e) {
            SlotHandleTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
    }

    public void testOtherMethods() throws Exception {
        this.createDesign();
        ISlotDefn bodyDefn = this.designHandle.getBody().getDefn();
        SlotHandleTest.assertEquals((String)"body", (String)bodyDefn.getName());
        SlotHandleTest.assertTrue((boolean)bodyDefn.isMultipleCardinality());
    }
}

