/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyleHandleTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("StyleHandleTest.xml");
    }

    public void testStyleProperties() throws SemanticException {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        ColorHandle colorHandle = styleHandle.getColor();
        colorHandle.setRGB(0xFF0088);
        StyleHandleTest.assertEquals((int)0xFF0088, (int)colorHandle.getRGB());
        colorHandle = styleHandle.getBackgroundColor();
        StyleHandleTest.assertNotNull((Object)colorHandle);
        colorHandle.setStringValue("red");
        StyleHandleTest.assertEquals((Object)"red", (Object)colorHandle.getValue());
        styleHandle.setBackgroundImage("image1");
        StyleHandleTest.assertEquals((String)"image1", (String)styleHandle.getBackgroundImage());
        styleHandle.setBackgroundImageType("url");
        StyleHandleTest.assertEquals((String)"url", (String)styleHandle.getBackgroundImageType());
        try {
            styleHandle.setBackgroundImageType("NonDefindedType");
            StyleHandleTest.fail();
        }
        catch (SemanticException e) {
            StyleHandleTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        StyleHandleTest.assertEquals((String)"url", (String)styleHandle.getBackgroundImageType());
        styleHandle.setBackgroundRepeat("no-repeat");
        StyleHandleTest.assertEquals((String)"no-repeat", (String)styleHandle.getBackgroundRepeat());
        styleHandle.setBackgroundAttachment("fixed");
        StyleHandleTest.assertEquals((String)"fixed", (String)styleHandle.getBackgroundAttachment());
        DimensionHandle dimensionHandle = styleHandle.getBackGroundPositionX();
        dimensionHandle = styleHandle.getBackGroundPositionY();
        colorHandle = styleHandle.getBorderBottomColor();
        try {
            colorHandle.setStringValue("nocolor");
            StyleHandleTest.fail();
        }
        catch (PropertyValueException e) {
            StyleHandleTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        colorHandle = styleHandle.getBorderLeftColor();
        colorHandle.setRGB(1193046);
        colorHandle = styleHandle.getBorderRightColor();
        colorHandle.setRGB(6636321);
        colorHandle = styleHandle.getBorderTopColor();
        colorHandle.setStringValue("yellow");
        styleHandle.setBorderLeftStyle("dotted");
        StyleHandleTest.assertEquals((String)"dotted", (String)styleHandle.getBorderLeftStyle());
        styleHandle.setBorderRightStyle("none");
        StyleHandleTest.assertEquals((String)"none", (String)styleHandle.getBorderRightStyle());
        styleHandle.setBorderTopStyle("ridge");
        StyleHandleTest.assertEquals((String)"ridge", (String)styleHandle.getBorderTopStyle());
        styleHandle.setBorderBottomStyle("groove");
        StyleHandleTest.assertEquals((String)"groove", (String)styleHandle.getBorderBottomStyle());
        try {
            styleHandle.setTextAlign("nochoice");
            StyleHandleTest.fail();
        }
        catch (PropertyValueException e) {
            StyleHandleTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.CHOICE_NOT_FOUND");
        }
        dimensionHandle = styleHandle.getBorderBottomWidth();
        dimensionHandle.setStringValue("medium");
        dimensionHandle = styleHandle.getBorderTopWidth();
        dimensionHandle.setStringValue("12pt");
        dimensionHandle = styleHandle.getBorderLeftWidth();
        dimensionHandle.setStringValue("12mm");
        dimensionHandle = styleHandle.getBorderRightWidth();
        dimensionHandle.setStringValue("thick");
        dimensionHandle = styleHandle.getTextIndent();
        dimensionHandle.setStringValue("2pc");
        FontHandle fontHandle = styleHandle.getFontFamilyHandle();
        fontHandle.setStringValue("song");
        dimensionHandle = styleHandle.getFontSize();
        dimensionHandle.setStringValue("18pc");
        styleHandle.setFontStyle("oblique");
        StyleHandleTest.assertEquals((String)"oblique", (String)styleHandle.getFontStyle());
        styleHandle.setFontVariant("small-caps");
        StyleHandleTest.assertEquals((String)"small-caps", (String)styleHandle.getFontVariant());
        styleHandle.setFontWeight("900");
        StyleHandleTest.assertEquals((String)"900", (String)styleHandle.getFontWeight());
        dimensionHandle = styleHandle.getWordSpacing();
        dimensionHandle.setStringValue("normal");
        dimensionHandle = styleHandle.getLetterSpacing();
        dimensionHandle.setStringValue("12pt");
        styleHandle.setTextUnderline("none");
        StyleHandleTest.assertEquals((String)"none", (String)styleHandle.getTextUnderline());
        styleHandle.setTextOverline("overline");
        StyleHandleTest.assertEquals((String)"overline", (String)styleHandle.getTextOverline());
        styleHandle.setTextLineThrough("none");
        StyleHandleTest.assertEquals((String)"none", (String)styleHandle.getTextLineThrough());
        styleHandle.setVerticalAlign("super");
        StyleHandleTest.assertEquals((String)"super", (String)styleHandle.getVerticalAlign());
        styleHandle.setTextTransform("capitalize");
        StyleHandleTest.assertEquals((String)"capitalize", (String)styleHandle.getTextTransform());
        styleHandle.setTextAlign("right");
        StyleHandleTest.assertEquals((String)"right", (String)styleHandle.getTextAlign());
        styleHandle.setWhiteSpace("nowrap");
        StyleHandleTest.assertEquals((String)"nowrap", (String)styleHandle.getWhiteSpace());
        dimensionHandle = styleHandle.getMarginTop();
        String marginTop = dimensionHandle.getStringValue();
        StyleHandleTest.assertEquals((String)marginTop, (String)"-1pt");
        dimensionHandle.setStringValue("-9pt");
        StyleHandleTest.assertEquals((String)"-9pt", (String)dimensionHandle.getStringValue());
        dimensionHandle = styleHandle.getMarginBottom();
        dimensionHandle.setStringValue("-9pt");
        StyleHandleTest.assertEquals((String)"-9pt", (String)dimensionHandle.getStringValue());
        dimensionHandle = styleHandle.getMarginLeft();
        dimensionHandle.setStringValue("-9pt");
        StyleHandleTest.assertEquals((String)"-9pt", (String)dimensionHandle.getStringValue());
        dimensionHandle = styleHandle.getMarginRight();
        dimensionHandle.setStringValue("-9pt");
        StyleHandleTest.assertEquals((String)"-9pt", (String)dimensionHandle.getStringValue());
        try {
            styleHandle.setNumberFormatCategory("#,###,###.##");
            StyleHandleTest.fail();
        }
        catch (PropertyValueException e) {
            StyleHandleTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        styleHandle.setNumberFormatCategory("Currency");
        styleHandle.setNumberFormat("$##,##");
        StyleHandleTest.assertEquals((String)"$##,##", (String)styleHandle.getNumberFormat());
        styleHandle.setStringFormatCategory("<");
        styleHandle.setStringFormat("***");
        StyleHandleTest.assertEquals((String)"***", (String)styleHandle.getStringFormat());
        styleHandle.setDateTimeFormatCategory("Short Date");
        styleHandle.setDateTimeFormat("MM/DD/YYYY");
        StyleHandleTest.assertEquals((String)"MM/DD/YYYY", (String)styleHandle.getDateTimeFormat());
        styleHandle.setDisplay("block");
        StyleHandleTest.assertEquals((String)"block", (String)styleHandle.getDisplay());
        styleHandle.setOrphans("inherit");
        StyleHandleTest.assertEquals((String)"inherit", (String)styleHandle.getOrphans());
        styleHandle.setWidows("15");
        StyleHandleTest.assertEquals((String)"15", (String)styleHandle.getWidows());
        styleHandle.setPageBreakAfter("always");
        StyleHandleTest.assertEquals((String)"always", (String)styleHandle.getPageBreakAfter());
        styleHandle.setPageBreakBefore("always");
        StyleHandleTest.assertEquals((String)"always", (String)styleHandle.getPageBreakBefore());
        styleHandle.setPageBreakInside("auto");
        StyleHandleTest.assertEquals((String)"auto", (String)styleHandle.getPageBreakInside());
        styleHandle.setCanShrink(false);
        StyleHandleTest.assertEquals((boolean)false, (boolean)styleHandle.canShrink());
        styleHandle.setShowIfBlank(false);
        StyleHandleTest.assertEquals((boolean)false, (boolean)styleHandle.showIfBlank());
        styleHandle.setMapTestExpr("new map rule test expr");
        styleHandle.setHighlightTestExpr("new highlight rule test expr");
        styleHandle.setMasterPage("new master page");
        StyleHandleTest.assertEquals((String)"new master page", (String)styleHandle.getMasterPage());
        styleHandle.setStringFormat("new string format");
        StyleHandleTest.assertEquals((String)"new string format", (String)styleHandle.getStringFormat());
        styleHandle.setBackgroundImage("new background image");
        StyleHandleTest.assertEquals((String)"new background image", (String)styleHandle.getBackgroundImage());
        styleHandle.setOverflow("hidden");
        StyleHandleTest.assertEquals((String)"hidden", (String)styleHandle.getOverflow());
    }

    public void testSetOperator() throws SemanticException, DesignFileException {
        this.openDesign("HighlightRuleHandleText.xml");
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.getElementByID(4L);
        PropertyHandle propHandle = dataHandle.getPropertyHandle("highlightRules");
        Iterator propIterator = propHandle.iterator();
        HighlightRuleHandle handle = (HighlightRuleHandle)propIterator.next();
        handle.setOperator("between");
        StyleHandleTest.assertEquals((String)"1", (String)handle.getValue1());
        StyleHandleTest.assertEquals((String)"3", (String)handle.getValue2());
        handle.setOperator("eq");
        StyleHandleTest.assertEquals((String)"1", (String)handle.getValue1());
        StyleHandleTest.assertNull((Object)handle.getValue2());
        handle.setOperator("is-null");
        StyleHandleTest.assertNull((Object)handle.getValue1());
        StyleHandleTest.assertNull((Object)handle.getValue2());
    }

    public void testHighlightProperties() throws SemanticException {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        StyleHandleTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        ColorHandle colorHandle = highlightHandle.getColor();
        colorHandle.setRGB(0xFF0088);
        colorHandle = highlightHandle.getBackgroundColor();
        StyleHandleTest.assertNotNull((Object)colorHandle);
        colorHandle.setStringValue("red");
        colorHandle = highlightHandle.getBorderBottomColor();
        try {
            colorHandle.setStringValue("nocolor");
            StyleHandleTest.fail();
        }
        catch (PropertyValueException e) {
            StyleHandleTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.INVALID_VALUE");
        }
        colorHandle = highlightHandle.getBorderLeftColor();
        colorHandle.setRGB(1193046);
        colorHandle = highlightHandle.getBorderRightColor();
        colorHandle.setRGB(6636321);
        colorHandle = highlightHandle.getBorderTopColor();
        colorHandle.setStringValue("yellow");
        highlightHandle.setBorderLeftStyle("dotted");
        highlightHandle.setBorderRightStyle("none");
        highlightHandle.setBorderTopStyle("ridge");
        highlightHandle.setBorderBottomStyle("groove");
        highlightHandle.setOperator("eq");
        highlightHandle.setOperator("ne");
        highlightHandle.setValue1("   dataSet.name  ");
        StyleHandleTest.assertEquals((String)"   dataSet.name  ", (String)highlightHandle.getValue1());
        try {
            highlightHandle.setTextAlign("nochoice");
            StyleHandleTest.fail();
        }
        catch (PropertyValueException e) {
            StyleHandleTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.CHOICE_NOT_FOUND");
        }
        highlightHandle.setTextAlign("justify");
        highlightHandle.setTextLineThrough("none");
        highlightHandle.setTextOverline("none");
        highlightHandle.setTextUnderline("none");
        highlightHandle.setTextTransform("capitalize");
        highlightHandle.setNumberFormatCategory("Currency");
        highlightHandle.setNumberFormat("$000,000");
        highlightHandle.setDateTimeFormatCategory("Medium Date");
        highlightHandle.setDateTimeFormat("mm dd, yyyy");
        highlightHandle.setStringFormatCategory(">");
        highlightHandle.setStringFormat("no format");
        try {
            highlightHandle.setStringFormatCategory("no format");
            StyleHandleTest.fail();
        }
        catch (SemanticException e) {
            StyleHandleTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        DimensionHandle dimensionHandle = highlightHandle.getBorderBottomWidth();
        dimensionHandle.setStringValue("medium");
        dimensionHandle = highlightHandle.getBorderTopWidth();
        dimensionHandle.setStringValue("12pt");
        dimensionHandle = highlightHandle.getBorderLeftWidth();
        dimensionHandle.setStringValue("12mm");
        dimensionHandle = highlightHandle.getBorderRightWidth();
        dimensionHandle.setStringValue("thick");
        dimensionHandle = highlightHandle.getTextIndent();
        dimensionHandle.setStringValue("2pc");
        FontHandle fontHandle = highlightHandle.getFontFamilyHandle();
        fontHandle.setStringValue("song");
        dimensionHandle = highlightHandle.getFontSize();
        dimensionHandle.setStringValue("18pc");
        highlightHandle.setFontStyle("oblique");
        highlightHandle.setFontVariant("small-caps");
        highlightHandle.setFontWeight("900");
    }

    public void testMapRules() throws SemanticException {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        Iterator iter = styleHandle.mapRulesIterator();
        MapRuleHandle ruleHandle = (MapRuleHandle)iter.next();
        StyleHandleTest.assertEquals((String)"Closed", (String)ruleHandle.getDisplay());
        StyleHandleTest.assertNull((Object)ruleHandle.getDisplayKey());
        StyleHandleTest.assertEquals((String)"like", (String)ruleHandle.getOperator());
        StyleHandleTest.assertEquals((String)"X", (String)ruleHandle.getValue1());
        StyleHandleTest.assertEquals((String)"Y", (String)ruleHandle.getValue2());
        ruleHandle.setDisplay("new closed");
        StyleHandleTest.assertEquals((String)"new closed", (String)ruleHandle.getDisplay());
        ruleHandle.setDisplayKey("new closed display id");
        StyleHandleTest.assertEquals((String)"new closed display id", (String)ruleHandle.getDisplayKey());
        ruleHandle.setOperator("le");
        StyleHandleTest.assertEquals((String)"le", (String)ruleHandle.getOperator());
        ruleHandle.setValue1("new x");
        ruleHandle.setValue2("new y");
        StyleHandleTest.assertEquals((String)"new x", (String)ruleHandle.getValue1());
        StyleHandleTest.assertEquals((String)"new y", (String)ruleHandle.getValue2());
        ruleHandle = (MapRuleHandle)iter.next();
        StyleHandleTest.assertEquals((String)"id for open", (String)ruleHandle.getDisplayKey());
    }

    public void testSetStyleFormat() throws Exception {
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        SharedStyleHandle style1 = factory.newStyle("style1");
        try {
            style1.setNumberFormatCategory("no format");
            StyleHandleTest.fail();
        }
        catch (SemanticException e) {
            StyleHandleTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        style1.setNumberFormat("****");
        style1.setNumberFormatCategory("Fixed");
        FactoryPropertyHandle factoryHandle = style1.getFactoryPropertyHandle("numberFormat");
        StyleHandleTest.assertEquals((String)"****", (String)factoryHandle.getStringValue());
        style1.setDateFormatCategory("Short Date");
        style1.setDateFormat("MM/DD/YYYY");
        StyleHandleTest.assertEquals((String)"MM/DD/YYYY", (String)style1.getDateFormat());
        StyleHandleTest.assertEquals((String)"Short Date", (String)style1.getDateFormatCategory());
        style1.setTimeFormatCategory("Short Time");
        style1.setTimeFormat("hh/mm");
        StyleHandleTest.assertEquals((String)"hh/mm", (String)style1.getTimeFormat());
        StyleHandleTest.assertEquals((String)"Short Time", (String)style1.getTimeFormatCategory());
    }

    public void testIsPredefinedStyle() {
        this.createDesign();
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("myStyle");
        StyleHandleTest.assertFalse((boolean)style.isPredefined());
        style = this.designHandle.getElementFactory().newStyle("grid");
        StyleHandleTest.assertTrue((boolean)style.isPredefined());
        style = this.designHandle.getElementFactory().newStyle("myStyle1");
        StyleHandleTest.assertFalse((boolean)style.isPredefined());
        style = this.designHandle.getElementFactory().newStyle("table-group-footer-cell");
        StyleHandleTest.assertTrue((boolean)style.isPredefined());
    }

    public void testPropertyMask() {
        this.createDesign();
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("myStyle");
        StyleHandleTest.assertFalse((boolean)style.isPredefined());
        try {
            style.setPropertyMask("backgroundImage", "lock");
            style.setBackgroundImage("new url");
            StyleHandleTest.fail();
        }
        catch (SemanticException e) {
            StyleHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_LOCKED", (String)e.getErrorCode());
        }
    }

    public void testHightlightRules() {
        TableHandle table = (TableHandle)this.designHandle.findElement("My Table");
        Iterator highlightRules = table.getPropertyHandle("highlightRules").iterator();
        HighlightRuleHandle highLight = (HighlightRuleHandle)highlightRules.next();
        StyleHandleTest.assertNotNull((Object)highLight);
        StyleHandleTest.assertEquals((String)"#C0C0C0", (String)highLight.getBackgroundColor().getStringValue());
        RowHandle row = (RowHandle)table.getDetail().get(0);
        highlightRules = row.getPropertyHandle("highlightRules").iterator();
        highLight = (HighlightRuleHandle)highlightRules.next();
        StyleHandleTest.assertNotNull((Object)highLight);
        StyleHandleTest.assertEquals((String)"red", (String)highLight.getBackgroundColor().getStringValue());
        CellHandle cell = (CellHandle)row.getCells().get(0);
        highlightRules = cell.getPropertyHandle("highlightRules").iterator();
        StyleHandleTest.assertFalse((boolean)highlightRules.hasNext());
    }

    public void testSetNullStyle() throws Exception {
        this.designHandle.getStyles().drop(0);
        DesignElementHandle handle = this.designHandle.findElement("My Label1");
        handle.setProperty("style", null);
        StyleHandleTest.assertNull((Object)handle.getProperty("style"));
    }

    public void testGetCellSelectorProperty() throws Exception {
        this.openDesign("CellSelectorTest.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("table1");
        GroupHandle group = (GroupHandle)table.getGroups().get(0);
        RowHandle row = (RowHandle)group.getHeader().get(0);
        CellHandle cell = (CellHandle)row.getCells().get(0);
        StyleHandleTest.assertEquals((Object)"double", (Object)cell.getProperty("borderLeftStyle"));
    }

    public void testBackgroundSize() throws Exception {
        this.openDesign("BackgroundSizeTest.xml");
        SharedStyleHandle styleHandle = this.designHandle.findStyle("style1");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "contain", "contain", "contain");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "contain", "contain", "contain");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "80%", "80%", "60%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "80%", "30%", "80%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "auto", "auto", "60%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "auto", "30%", "auto");
        styleHandle = this.designHandle.findStyle("style2");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "contain", "contain", "contain");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "contain", "contain", "contain");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "80%", "80%", "80%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "80%", "80%", "80%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "auto", "auto", "auto");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "auto", "auto", "auto");
        styleHandle = this.designHandle.findStyle("style3");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "contain", "contain", "30%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "contain", "contain", "contain");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "60%", "60%", "30%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "60%", "60%", "60%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "auto", "auto", "30%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "auto", "auto", "auto");
        styleHandle = this.designHandle.findStyle("style4");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "contain", "contain", "auto");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "contain", "contain", "contain");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "60%", "60%", "auto");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "60%", "60%", "60%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "auto", "auto", "auto");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "auto", "contain", "auto");
        styleHandle = this.designHandle.findStyle("style5");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "30%", "30%", "auto");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "30%", "auto", "30%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "auto", "auto", "auto");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "auto", "auto", "auto");
        styleHandle = this.designHandle.findStyle("style6");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "cover", "cover", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "cover", "contain", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "contain", "contain", "cover");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "contain", "contain", "contain");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "auto", "auto", "auto");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "auto", "auto", "auto");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeWidth", "80%", "80%", "80%");
        this.comparedBackgroundSize((StyleHandle)styleHandle, "backgroundSizeHeight", "80%", "80%", "80%");
    }

    private void comparedBackgroundSize(StyleHandle styleHandle, String propName, String value, String expectedWidth, String expectedHeight) throws Exception {
        DimensionHandle width = styleHandle.getBackgroundSizeWidth();
        DimensionHandle height = styleHandle.getBackgroundSizeHeight();
        String oldWidth = width.getStringValue();
        String oldHeight = height.getStringValue();
        if ("backgroundSizeWidth".equals(propName)) {
            width.setValue((Object)value);
        } else {
            height.setValue((Object)value);
        }
        StyleHandleTest.assertEquals((String)expectedWidth, (String)width.getStringValue());
        StyleHandleTest.assertEquals((String)expectedHeight, (String)height.getStringValue());
        ActivityStack stack = this.design.getActivityStack();
        if (stack.canUndo()) {
            this.design.getActivityStack().undo();
            StyleHandleTest.assertEquals((String)oldWidth, (String)width.getStringValue());
            StyleHandleTest.assertEquals((String)oldHeight, (String)height.getStringValue());
        } else if ((!"style3".equals(styleHandle.getName()) || !"backgroundSizeWidth".equals(propName) || !"contain".equals(value)) && (!"style4".equals(styleHandle.getName()) || !"backgroundSizeWidth".equals(propName) || !"contain".equals(value)) && (!"style4".equals(styleHandle.getName()) || !"backgroundSizeHeight".equals(propName) || !"auto".equals(value)) && (!"style5".equals(styleHandle.getName()) || !"backgroundSizeHeight".equals(propName) || !"auto".equals(value)) && (!"style5".equals(styleHandle.getName()) || !"backgroundSizeWidth".equals(propName) || !"auto".equals(value)) && (!"style6".equals(styleHandle.getName()) || !"backgroundSizeHeight".equals(propName) || !"cover".equals(value)) && (!"style6".equals(styleHandle.getName()) || !"backgroundSizeWidth".equals(propName) || !"contain".equals(value))) assert (false);
    }
}

