/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.command.CustomMsgException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CustomMsgExceptionTest
extends BaseTestCase {
    public void testErrorMessages() throws Exception {
        SessionHandle session = new DesignEngine(new DesignConfig()).newSessionHandle(TEST_LOCALE);
        ReportDesign report = session.createDesign().getDesign();
        this.os = new ByteArrayOutputStream();
        CustomMsgException error = new CustomMsgException((DesignElement)report, "Error.CustomMsgException.RESOURCE_KEY_REQUIRED");
        this.print(error);
        error = new CustomMsgException((DesignElement)report, "ResourceKey.ReportDesign.Title", "en", "Error.CustomMsgException.DUPLICATE_LOCALE");
        this.print(error);
        error = new CustomMsgException((DesignElement)report, null, "abc", "Error.CustomMsgException.INVALID_LOCALE");
        this.print(error);
        error = new CustomMsgException((DesignElement)report, "ResourceKey.ReportDesign.Title", "en", "Error.CustomMsgException.TRANSLATION_NOT_FOUND");
        this.print(error);
        this.os.close();
        CustomMsgExceptionTest.assertTrue((boolean)this.compareFile("CustomMsgExceptionError.golden.txt"));
    }

    private void print(CustomMsgException error) {
        block3: {
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

