/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ExtendsEvent;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ExtendsCommandTest
extends BaseTestCase {
    private DesignElement element;
    private ListGroup lg;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ExtendsCommandTest.xml");
        ExtendsCommandTest.assertNotNull((Object)this.design);
        this.element = new Label("Happy");
        NameSpace ns = this.design.getNameHelper().getNameSpace(((ElementDefn)this.element.getDefn()).getNameSpaceID());
        ns.insert(this.element);
        this.lg = new ListGroup();
    }

    public void testSetExtendsName() throws ExtendsException {
        ExtendsCommandTest.assertNull((Object)this.element.getExtendsElement());
        this.element.getHandle((Module)this.design).setExtendsName(null);
        ExtendsCommandTest.assertNull((Object)this.element.getExtendsElement());
        this.element.getHandle((Module)this.design).setExtendsName(" ");
        ExtendsCommandTest.assertNull((Object)this.element.getExtendsElement());
        DesignElement parent = this.design.findElement("base");
        this.element.getHandle((Module)this.design).setExtendsName(parent.getName());
        ExtendsCommandTest.assertEquals((String)"base", (String)this.element.getHandle((Module)this.design).getExtends().getName());
        CommandStack cs = this.designHandle.getCommandStack();
        ExtendsCommandTest.assertFalse((boolean)cs.canRedo());
        ExtendsCommandTest.assertTrue((boolean)cs.canUndo());
        cs.undo();
        ExtendsCommandTest.assertNull((Object)this.element.getExtendsElement());
        ExtendsCommandTest.assertFalse((boolean)cs.canUndo());
        ExtendsCommandTest.assertTrue((boolean)cs.canRedo());
        cs.redo();
        ExtendsCommandTest.assertFalse((boolean)cs.canRedo());
        ExtendsCommandTest.assertEquals((String)"base", (String)this.element.getHandle((Module)this.design).getExtends().getName());
        cs.undo();
        ExtendsCommandTest.assertNull((Object)this.element.getExtendsElement());
    }

    public void testSetExtendsExceptions() {
        try {
            this.element.getHandle((Module)this.design).setExtendsName("hello");
            ExtendsCommandTest.fail();
        }
        catch (ExtendsException e) {
            ExtendsCommandTest.assertEquals((String)e.getErrorCode(), (String)"Error.InvalidParentException.PARENT_NOT_FOUND");
        }
        Style parent = new Style();
        parent.setName("parent_label");
        NameSpace ns = this.design.getNameHelper().getNameSpace(((ElementDefn)this.element.getDefn()).getNameSpaceID());
        ns.insert((DesignElement)parent);
        try {
            this.element.getHandle((Module)this.design).setExtendsName(parent.getName());
            ExtendsCommandTest.fail();
        }
        catch (ExtendsException e1) {
            ExtendsCommandTest.assertEquals((String)e1.getErrorCode(), (String)"Error.WrongTypeException.WRONG_TYPE");
        }
        try {
            this.element.getHandle((Module)this.design).setExtendsName(this.element.getName());
            ExtendsCommandTest.fail();
        }
        catch (ExtendsException e2) {
            ExtendsCommandTest.assertEquals((String)e2.getErrorCode(), (String)"Error.CircularExtendsException.SELF_EXTEND");
        }
        try {
            this.lg.getHandle((Module)this.design).setExtendsName("hello");
            ExtendsCommandTest.fail();
        }
        catch (ExtendsException e) {
            ExtendsCommandTest.assertEquals((String)e.getErrorCode(), (String)"Error.ExtendsForbiddenException.CANT_EXTEND");
        }
    }

    public void testCirclarExtends() {
        Label parent = (Label)this.design.findElement("base");
        ExtendsCommandTest.assertNotNull((Object)parent);
        Label superParent = (Label)this.design.findElement("child1");
        ExtendsCommandTest.assertNotNull((Object)superParent);
        Label me = (Label)this.design.findElement("child2");
        ExtendsCommandTest.assertNotNull((Object)me);
        try {
            me.getHandle((Module)this.design).setExtendsName(parent.getName());
            parent.getHandle((Module)this.design).setExtendsName(me.getName());
        }
        catch (ExtendsException e1) {
            ExtendsCommandTest.assertEquals((String)e1.getErrorCode(), (String)"Error.CircularExtendsException.CIRCULAR");
        }
        try {
            me.getHandle((Module)this.design).setExtendsElement((DesignElement)parent);
            parent.getHandle((Module)this.design).setExtendsElement((DesignElement)superParent);
            superParent.getHandle((Module)this.design).setExtendsElement((DesignElement)me);
            ExtendsCommandTest.fail();
        }
        catch (ExtendsException e1) {
            ExtendsCommandTest.assertEquals((String)e1.getErrorCode(), (String)"Error.CircularExtendsException.CIRCULAR");
        }
    }

    public void testSetExtendsElement() throws ExtendsException {
        Style parent;
        this.element.getHandle((Module)this.design).setExtendsElement(null);
        ExtendsCommandTest.assertNull((Object)this.element.getExtendsElement());
        try {
            parent = new Style();
            this.element.getHandle((Module)this.design).setExtendsElement((DesignElement)parent);
            ExtendsCommandTest.fail();
        }
        catch (ExtendsException e) {
            ExtendsCommandTest.assertEquals((String)e.getErrorCode(), (String)"Error.InvalidParentException.UNNAMED_PARENT");
        }
        ExtendsCommandTest.assertNull((Object)this.element.getExtendsElement());
        parent = (Label)this.design.findElement("base");
        this.element.getHandle((Module)this.design).setExtendsElement((DesignElement)parent);
        CommandStack cs = this.designHandle.getCommandStack();
        ExtendsCommandTest.assertFalse((boolean)cs.canRedo());
        ExtendsCommandTest.assertTrue((boolean)cs.canUndo());
        ExtendsCommandTest.assertEquals((String)"base", (String)this.element.getHandle((Module)this.design).getExtends().getName());
        cs.undo();
        ExtendsCommandTest.assertNull((Object)this.element.getExtendsElement());
        cs.redo();
        ExtendsCommandTest.assertEquals((String)"base", (String)this.element.getHandle((Module)this.design).getExtends().getName());
        ExtendsCommandTest.assertFalse((boolean)cs.canRedo());
        GridHandle grid1 = (GridHandle)this.designHandle.findElement("grid1");
        LabelHandle label = (LabelHandle)((CellHandle)((RowHandle)grid1.getRows().get(0)).getCells().get(0)).getContent().get(0);
        try {
            ExtendsCommandTest.assertTrue((boolean)label.getElement().isVirtualElement());
            label.setExtends(parent.getHandle((Module)this.design));
        }
        catch (ExtendsException e) {
            ExtendsCommandTest.assertEquals((String)"Error.ExtendsForbiddenException.EXTENDS_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            grid1.setExtends(null);
        }
        catch (ExtendsException e) {
            ExtendsCommandTest.assertEquals((String)"Error.ExtendsForbiddenException.EXTENDS_FORBIDDEN", (String)e.getErrorCode());
        }
    }

    public void testLocalizeElement() throws DesignFileException, IOException, SemanticException {
        this.openDesign("ExtendsCommandTest2.xml");
        Module module = this.designHandle.getModule();
        LabelHandle label1Handle = (LabelHandle)this.designHandle.findElement("Label1");
        Label label1 = (Label)label1Handle.getElement();
        ExtendsCommandTest.assertEquals((String)"baseLabel", (String)label1Handle.getExtends().getName());
        ExtendsCommandTest.assertEquals((String)"8pt", (String)label1.getLocalProperty(module, "width").toString());
        ExtendsCommandTest.assertEquals(null, (Object)label1.getLocalProperty(module, "text"));
        ExtendsCommandTest.assertEquals(null, (Object)label1.getLocalProperty(module, "fontSize"));
        ExtendsCommandTest.assertEquals(null, (Object)label1.getLocalProperty(module, "borderLeftColor"));
        ExtendsCommandTest.assertEquals(null, (Object)label1.getLocalProperty(module, "backgroundColor"));
        ExtendsCommandTest.assertEquals((String)"left", (String)label1.getStringProperty(module, "textAlign"));
        label1Handle.localize();
        ExtendsCommandTest.assertNull((Object)label1Handle.getExtends());
        ExtendsCommandTest.assertEquals((String)"8pt", (String)label1.getLocalProperty(module, "width").toString());
        ExtendsCommandTest.assertEquals((Object)"First Page", (Object)label1.getLocalProperty(module, "text"));
        ExtendsCommandTest.assertEquals((String)"x-small", (String)label1.getLocalProperty(module, "fontSize").toString());
        ExtendsCommandTest.assertEquals(null, (Object)label1.getLocalProperty(module, "borderLeftColor"));
        ExtendsCommandTest.assertEquals(null, (Object)label1.getLocalProperty(module, "backgroundColor"));
        ExtendsCommandTest.assertEquals((Object)"left", (Object)label1.getLocalProperty(module, "textAlign"));
        GridHandle grid1Handle = (GridHandle)this.designHandle.findElement("Grid1");
        GridItem grid1 = (GridItem)grid1Handle.getElement();
        ExtendsCommandTest.assertEquals((String)"baseGrid", (String)grid1.getExtendsName());
        ExtendsCommandTest.assertEquals((String)"24pt", (String)grid1.getLocalProperty(module, "height").toString());
        ExtendsCommandTest.assertEquals((String)"40mm", (String)grid1.getProperty(module, "width").toString());
        RowHandle innerRow1 = (RowHandle)grid1Handle.getRows().get(0);
        CellHandle innerCell1 = (CellHandle)innerRow1.getCells().get(0);
        LabelHandle innerLabel1 = (LabelHandle)innerCell1.getContent().get(0);
        GridHandle innerGrid1 = (GridHandle)innerCell1.getContent().get(2);
        ExtendsCommandTest.assertTrue((boolean)innerRow1.getElement().isVirtualElement());
        ExtendsCommandTest.assertTrue((boolean)innerLabel1.getElement().isVirtualElement());
        ExtendsCommandTest.assertEquals((long)9L, (long)innerLabel1.getElement().getBaseId());
        ExtendsCommandTest.assertEquals((String)"New Address", (String)innerLabel1.getElement().getLocalProperty(module, "text").toString());
        ExtendsCommandTest.assertEquals(null, (Object)innerLabel1.getElement().getLocalProperty(module, "color"));
        ExtendsCommandTest.assertEquals(null, (Object)innerLabel1.getElement().getLocalProperty(module, "fontSize"));
        ExtendsCommandTest.assertEquals(null, (Object)innerGrid1.getElement().getLocalProperty(module, "mapRules"));
        List mapRules = (List)innerGrid1.getProperty("mapRules");
        ExtendsCommandTest.assertEquals((int)1, (int)mapRules.size());
        grid1Handle.localize();
        ExtendsCommandTest.assertNull((Object)grid1.getExtendsElement());
        ExtendsCommandTest.assertEquals((String)"24pt", (String)grid1.getLocalProperty(module, "height").toString());
        ExtendsCommandTest.assertEquals((String)"40mm", (String)grid1.getLocalProperty(module, "width").toString());
        List localMapRules = (List)grid1.getLocalProperty(module, "mapRules");
        ExtendsCommandTest.assertEquals((int)2, (int)localMapRules.size());
        Structure numberFormat = (Structure)grid1.getLocalProperty(module, "numberFormat");
        ExtendsCommandTest.assertEquals((Object)"Currency", (Object)numberFormat.getProperty(module, "category"));
        this.save();
        this.design.getActivityStack().undo();
        this.design.getActivityStack().undo();
        this.save();
    }

    public void testSendNotifications() throws Exception {
        this.element = (Label)this.design.findElement("base");
        Label tmp = (Label)this.design.findElement("tmp");
        ExtendsCommandTest.assertNotNull((Object)this.element);
        ExtendsCommandTest.assertNotNull((Object)tmp);
        Label child1 = (Label)this.design.findElement("child1");
        Label child2 = (Label)this.design.findElement("child2");
        Label grandchild1 = (Label)this.design.findElement("grandchild1");
        Label grandchild2 = (Label)this.design.findElement("grandchild2");
        Label grandchild3 = (Label)this.design.findElement("grandchild3");
        ExtendsCommandTest.assertNotNull((Object)child1);
        ExtendsCommandTest.assertNotNull((Object)child2);
        ExtendsCommandTest.assertNotNull((Object)grandchild1);
        ExtendsCommandTest.assertNotNull((Object)grandchild2);
        ExtendsCommandTest.assertNotNull((Object)grandchild3);
        MyExtendsListener listener = new MyExtendsListener();
        MyExtendsListener listener1 = new MyExtendsListener();
        MyExtendsListener listener2 = new MyExtendsListener();
        MyExtendsListener grandListener1 = new MyExtendsListener();
        MyExtendsListener grandListener2 = new MyExtendsListener();
        MyExtendsListener grandListener3 = new MyExtendsListener();
        this.element.addListener((Listener)listener);
        child1.addListener((Listener)listener1);
        child2.addListener((Listener)listener2);
        grandchild1.addListener((Listener)grandListener1);
        grandchild2.addListener((Listener)grandListener2);
        grandchild3.addListener((Listener)grandListener3);
        this.element.getHandle((Module)this.design).setExtendsName(tmp.getName());
        ExtendsCommandTest.assertEquals((int)1, (int)listener.action);
        ExtendsCommandTest.assertEquals((int)0, (int)listener.path);
        ExtendsCommandTest.assertEquals((int)1, (int)listener1.action);
        ExtendsCommandTest.assertEquals((int)1, (int)listener1.path);
        ExtendsCommandTest.assertEquals((int)1, (int)listener2.action);
        ExtendsCommandTest.assertEquals((int)1, (int)listener2.path);
        ExtendsCommandTest.assertEquals((int)1, (int)grandListener1.action);
        ExtendsCommandTest.assertEquals((int)1, (int)grandListener1.path);
        ExtendsCommandTest.assertEquals((int)1, (int)grandListener2.action);
        ExtendsCommandTest.assertEquals((int)1, (int)grandListener2.path);
        ExtendsCommandTest.assertEquals((int)1, (int)grandListener3.action);
        ExtendsCommandTest.assertEquals((int)1, (int)grandListener3.path);
    }

    class MyExtendsListener
    implements Listener {
        static final int NA = 0;
        static final int EXTENDED = 1;
        int action = 0;
        int path = 0;

        MyExtendsListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            ExtendsEvent event = (ExtendsEvent)ev;
            this.action = 1;
            this.path = event.getDeliveryPath();
        }
    }
}

