/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.NameSpaceEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class NameCommandTest
extends BaseTestCase {
    DesignElementHandle styleHandle;
    static final String fileName = "StyleCommandTest.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(fileName);
        NameCommandTest.assertNotNull((Object)this.design);
        NameCommandTest.assertNotNull((Object)this.designHandle);
        this.styleHandle = this.designHandle.getElementFactory().newStyle("myStyle");
        this.designHandle.getStyles().add(this.styleHandle);
    }

    public void testNameSpace() throws Exception {
        Style newStyle = new Style();
        newStyle.getHandle((Module)this.design).setName("newStyle");
        NameCommandTest.assertEquals((String)"newStyle", (String)newStyle.getName());
        newStyle.getHandle((Module)this.design).setName("changeStyle");
        NameCommandTest.assertEquals((String)"changeStyle", (String)newStyle.getName());
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(0).contains("newStyle"));
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(0).contains("changeStyle"));
        GraphicMasterPage masterPage = new GraphicMasterPage();
        masterPage.getHandle((Module)this.design).setName("page");
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(5).contains("page"));
        masterPage.getHandle((Module)this.design).setName("newPage");
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(5).contains("page"));
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(5).contains("newPage"));
        Label label = new Label();
        label.getHandle((Module)this.design).setName("label");
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(1).contains("label"));
        label.getHandle((Module)this.design).setName("newLabel");
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(1).contains("label"));
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(1).contains("newLabel"));
    }

    public void testSetName() {
        Style testStyle = new Style();
        testStyle.setName("testStyle");
        this.design.getNameHelper().getNameSpace(0).insert((DesignElement)testStyle);
        try {
            this.styleHandle.setName("testStyle");
            NameCommandTest.fail((String)"testSetName1 method cann't throw out NameException !");
        }
        catch (NameException e) {
            NameCommandTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
        Cell cell = new Cell();
        try {
            cell.getHandle((Module)this.design).setName("testStyle");
            NameCommandTest.fail((String)"testSetName2 method cann't throw out NameException! ");
        }
        catch (NameException e) {
            NameCommandTest.assertEquals((String)"Error.NameException.NAME_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            this.styleHandle.setName(null);
            NameCommandTest.fail((String)"testSetName3 method cann't throw out NameException! ");
        }
        catch (NameException e) {
            NameCommandTest.assertEquals((String)"Error.NameException.NAME_REQUIRED", (String)e.getErrorCode());
        }
    }

    public void testSetNameUndoRedo() throws Exception {
        Style newStyle = new Style();
        ActivityStack as = this.design.getActivityStack();
        newStyle.getHandle((Module)this.design).setName("style");
        NameCommandTest.assertEquals((String)"style", (String)newStyle.getName());
        NameCommandTest.assertTrue((boolean)as.canUndo());
        as.undo();
        NameCommandTest.assertNull((Object)newStyle.getName());
        NameCommandTest.assertTrue((boolean)as.canRedo());
        NameCommandTest.assertTrue((boolean)as.canUndo());
        as.redo();
        NameCommandTest.assertEquals((String)"style", (String)newStyle.getName());
        newStyle.getHandle((Module)this.design).setName("newStyleName");
        as.undo();
        NameCommandTest.assertEquals((String)"style", (String)newStyle.getName());
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(0).contains("style"));
        as.redo();
        NameCommandTest.assertEquals((String)"newStyleName", (String)newStyle.getName());
        NameCommandTest.assertFalse((boolean)this.design.getNameHelper().getNameSpace(0).contains("newStyleName"));
    }

    public void testNotification() throws Exception {
        StyleElement myStyle = this.design.findStyle("My-Style");
        MyNameListener nameListener = new MyNameListener();
        myStyle.addListener((Listener)nameListener);
        MyNameListener labelListener = new MyNameListener();
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("myLabel");
        labelHandle.addListener((Listener)labelListener);
        DataSetHandle dataSetHandle = this.designHandle.findDataSet("firstDataSet");
        dataSetHandle.setName("New DataSet Name");
        NameCommandTest.assertFalse((boolean)labelListener.nameChanged);
        MyNameSpaceListener nameSpaceListener = new MyNameSpaceListener();
        this.design.addListener((Listener)nameSpaceListener);
        myStyle.getHandle((Module)this.design).setName("hello");
        NameCommandTest.assertTrue((boolean)nameListener.nameChanged);
        myStyle.removeListener((Listener)nameListener);
    }

    class MyNameListener
    implements Listener {
        boolean nameChanged = false;

        MyNameListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.nameChanged = true;
        }
    }

    class MyNameSpaceListener
    implements Listener {
        static final int NA = 0;
        static final int ADDED = 1;
        static final int REMOVED = 2;
        static final int RENAMED = 3;
        NameSpaceEvent event = null;
        int action = 0;

        MyNameSpaceListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 4) {
                this.event = (NameSpaceEvent)ev;
                if (this.action == 2 && this.event.getAction() == 1) {
                    this.action = 3;
                } else {
                    switch (this.event.getAction()) {
                        case 1: {
                            this.action = 1;
                            break;
                        }
                        case 2: {
                            this.action = 2;
                        }
                    }
                }
            }
        }
    }
}

