/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class NameExceptionTest
extends BaseTestCase {
    public void testErrorMessages() throws Exception {
        TableItem table = new TableItem();
        this.os = new ByteArrayOutputStream();
        table.setName("customerTable");
        NameException error = new NameException((DesignElement)table, "", "Error.NameException.NAME_REQUIRED");
        this.print(error);
        error = new NameException((DesignElement)table, table.getName(), "Error.NameException.NAME_FORBIDDEN");
        this.print(error);
        error = new NameException((DesignElement)table, table.getName(), "Error.NameException.DUPLICATE");
        this.print(error);
        error = new NameException((DesignElement)table, table.getName(), "Error.NameException.HAS_REFERENCES");
        this.print(error);
        this.os.close();
        NameExceptionTest.assertTrue((boolean)this.compareFile("NameExceptionError.golden.txt"));
    }

    private void print(NameException error) {
        block3: {
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

