/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.elements.structures.SearchKey;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PropertyCommandTest
extends BaseTestCase {
    MasterPage page;
    ActionHandle actionHandle = null;
    ImageHandle imageHandle = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("PropertyCommandTest.xml");
        this.page = new GraphicMasterPage();
        this.page.getHandle((Module)this.design).setName("Page");
        this.page.setProperty("type", (Object)"custom");
        this.imageHandle = (ImageHandle)this.designHandle.findElement("Image1");
        this.actionHandle = this.imageHandle.getActionHandle();
    }

    public void testSetProperty() throws SemanticException {
        this.propertyOperate("hello", "HelloWorld", false);
        this.propertyOperate("displayName", "SampleSection", true);
        PropertyCommand commond = new PropertyCommand((Module)this.design, (DesignElement)this.page);
        commond.setProperty("name", (Object)"hello");
        Object o = this.page.getHandle((Module)this.design).getPropertyHandle("name").getValue();
        PropertyCommandTest.assertEquals((String)"hello", (String)o.toString());
        String propName = "displayName";
        ElementPropertyDefn prop = this.page.getPropertyDefn(propName);
        String value = "blue he";
        this.PropertyDefnOperate(prop, value);
        propName = "hello";
        prop = this.page.getPropertyDefn(propName);
        PropertyCommandTest.assertNull((Object)prop);
        propName = "name";
        prop = this.page.getPropertyDefn(propName);
        value = "hello blue";
        this.PropertyDefnOperate(prop, value);
    }

    public void testSetProperty_1() throws Exception {
        Action action = (Action)this.actionHandle.getStructure();
        PropertyCommandTest.assertEquals((Object)this.actionHandle.getStructure(), ((List)this.imageHandle.getProperty("action")).get(0));
        StructureContext context = action.getContext();
        PropertyCommandTest.assertNotNull((Object)context);
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel(null);
        ActionHandle labelActionHandle = labelHandle.setAction(action);
        PropertyCommandTest.assertNotSame((Object)action, (Object)labelActionHandle.getStructure());
        PropertyCommandTest.assertEquals((Object)context, (Object)action.getContext());
    }

    public void testBackwardTOCSetProperty() throws SemanticException {
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("lable1");
        labelHandle.setStringProperty("toc", "exp1");
        PropertyCommandTest.assertEquals((String)"exp1", (String)labelHandle.getTOC().getExpression());
        labelHandle.setStringProperty("toc", "exp2");
        PropertyCommandTest.assertEquals((String)"exp2", (String)labelHandle.getTOC().getExpression());
        this.designHandle.getModule().getActivityStack().undo();
        PropertyCommandTest.assertEquals((String)"exp1", (String)labelHandle.getTOC().getExpression());
    }

    public void testSetandClearProperty() throws SemanticException {
        this.propertyOperate("height", "2mm", true);
        this.propertyOperate("height", null, true);
        this.propertyOperate("displayName", "world", true);
        this.propertyOperate("displayName", null, true);
    }

    private void PropertyDefnOperate(ElementPropertyDefn prop, Object value) {
        try {
            this.page.getHandle((Module)this.design).getPropertyHandle(prop.getName()).setValue(value);
            PropertyCommandTest.assertEquals((Object)value, (Object)this.page.getHandle((Module)this.design).getPropertyHandle(prop.getName()).getValue());
        }
        catch (SemanticException e) {
            PropertyCommandTest.fail((String)e.toString());
        }
    }

    private void propertyOperate(String name, String value, boolean type) throws SemanticException {
        if (type) {
            if (value == null) {
                PropertyCommand commond = new PropertyCommand((Module)this.design, (DesignElement)this.page);
                commond.clearProperty(name);
                Object o = this.page.getHandle((Module)this.design).getPropertyHandle(name).getValue();
                PropertyCommandTest.assertNull((Object)o);
            } else {
                this.page.getHandle((Module)this.design).getPropertyHandle(name).setValue((Object)value);
                Object o = this.page.getHandle((Module)this.design).getPropertyHandle(name).getValue();
                PropertyCommandTest.assertEquals((String)value, (String)o.toString());
            }
        } else {
            try {
                this.page.getHandle((Module)this.design).setProperty(name, (Object)value);
                PropertyCommandTest.fail((String)"must throw out PropertyNameException");
            }
            catch (SemanticException e) {
                PropertyCommandTest.assertTrue((boolean)(e instanceof PropertyNameException));
            }
            Object o = this.page.getHandle((Module)this.design).getProperty(name);
            PropertyCommandTest.assertNull((Object)o);
        }
    }

    public void testAddItem() throws Exception {
        StyleElement style = this.design.findStyle("Style1");
        this.AddItemRule(style, false);
        this.saveOperate("PropertyCommandTest_golden_4.xml");
        this.DeleteRule(style);
        style = this.design.findStyle("Style2");
        this.AddItemRule(style, true);
        this.saveOperate("PropertyCommandTest_golden_5.xml");
        this.DeleteRule(style);
        style = this.design.findStyle("Style3");
        this.AddItemRule(style, false);
        this.saveOperate("PropertyCommandTest_golden_6.xml");
        PropertyHandle propHandle = style.getHandle((Module)this.design).getPropertyHandle("mapRules");
        MapRuleHandle rule = (MapRuleHandle)propHandle.iterator().next();
        propHandle.addItem(rule.getStructure());
        PropertyCommandTest.assertEquals((int)2, (int)propHandle.getListValue().size());
        MapRule rule1 = (MapRule)propHandle.getListValue().get(0);
        MapRule rule2 = (MapRule)propHandle.getListValue().get(1);
        PropertyCommandTest.assertTrue((rule1 != rule2 ? 1 : 0) != 0);
        PropertyCommandTest.assertTrue((boolean)rule1.equals((Object)rule2));
    }

    public void testAddItem2() throws Exception {
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table = factory.newTableItem("newTable", 3);
        this.designHandle.getBody().add((DesignElementHandle)table);
        HighlightRule highlightRule = StructureFactory.createHighlightRule();
        highlightRule.setTestExpression("row[\"Company\"]");
        highlightRule.setOperator("eq");
        highlightRule.setValue1("Eclipse");
        highlightRule.setProperty("color", (Object)"red");
        table.getPrivateStyle().getPropertyHandle("highlightRules").addItem((IStructure)highlightRule);
        RowHandle row = (RowHandle)table.getDetail().getContents().get(0);
        List inheritedRules = (List)row.getProperty("highlightRules");
        PropertyCommandTest.assertNull((Object)inheritedRules);
        HighlightRule highlightRule2 = StructureFactory.createHighlightRule();
        highlightRule.setTestExpression("row[\"CustomID\"]");
        highlightRule.setOperator("eq");
        highlightRule.setValue1("Momo");
        highlightRule.setProperty("color", (Object)"blue");
        PropertyHandle rulesHandle = row.getPropertyHandle("highlightRules");
        rulesHandle.addItem((IStructure)highlightRule2);
        PropertyCommandTest.assertEquals((int)1, (int)rulesHandle.getListValue().size());
        PropertyCommandTest.assertEquals((int)1, (int)table.getPropertyHandle("highlightRules").getListValue().size());
        LabelHandle label1 = factory.newLabel("label1");
        LabelHandle label2 = factory.newLabel("label2");
        this.designHandle.getComponents().add((DesignElementHandle)label1);
        this.designHandle.getBody().add((DesignElementHandle)label2);
        label2.setExtendsName("label1");
        Action action = StructureFactory.createAction();
        ActionHandle actionHandle = label1.setAction(action);
        actionHandle.setLinkType("drill-through");
        ParamBinding param = StructureFactory.createParamBinding();
        param.setParamName("p1");
        param.setExpression("A+B");
        actionHandle.addParamBinding(param);
        ActionHandle inheritedAction = label2.getActionHandle();
        PropertyCommandTest.assertNotNull((Object)inheritedAction);
        PropertyCommandTest.assertEquals((String)"drill-through", (String)inheritedAction.getLinkType());
        ParamBinding param2 = StructureFactory.createParamBinding();
        param2.setParamName("p2");
        param2.setExpression("B+C");
        inheritedAction.getParamBindings().addItem((IStructure)param2);
        PropertyCommandTest.assertEquals((int)1, (int)actionHandle.getParamBindings().getListValue().size());
        PropertyCommandTest.assertEquals((int)2, (int)inheritedAction.getParamBindings().getListValue().size());
    }

    private void DeleteRule(StyleElement style) throws PropertyValueException {
        PropertyHandle propHandle = style.getHandle((Module)this.design).getPropertyHandle("mapRules");
        List rules = (List)style.getProperty((Module)this.design, "mapRules");
        propHandle.removeItem(rules.size() - 1);
    }

    public void testSetMember() throws Exception {
        SharedStyleHandle shareHandle = this.designHandle.findStyle("Style2");
        PropertyHandle propHandle = shareHandle.getPropertyHandle("mapRules");
        PropertyCommandTest.assertNotNull((Object)propHandle);
        StructureHandle strHandle = propHandle.getAt(0);
        PropertyCommandTest.assertNotNull((Object)strHandle);
        MemberHandle memberHandle = strHandle.getMember("display");
        PropertyCommandTest.assertEquals((Object)"Open", (Object)memberHandle.getValue());
        memberHandle.setValue(null);
        PropertyCommandTest.assertNull((Object)memberHandle.getValue());
        memberHandle.setValue((Object)"hello world");
        PropertyCommandTest.assertEquals((Object)"hello world", (Object)memberHandle.getValue());
        memberHandle.setValue((Object)"hello world");
        PropertyCommandTest.assertEquals((Object)"hello world", (Object)memberHandle.getValue());
        memberHandle = strHandle.getMember("value2");
        memberHandle.setValue((Object)"");
        PropertyCommandTest.assertNull((Object)memberHandle.getValue());
    }

    public void testSetMember2() throws SemanticException {
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table = factory.newTableItem("newTable", 3);
        this.designHandle.getBody().add((DesignElementHandle)table);
        HighlightRule highlightRule = StructureFactory.createHighlightRule();
        highlightRule.setTestExpression("row[\"Company\"]");
        highlightRule.setOperator("eq");
        highlightRule.setValue1("Eclipse");
        highlightRule.setProperty("color", (Object)"red");
        table.getPrivateStyle().getPropertyHandle("highlightRules").addItem((IStructure)highlightRule);
        RowHandle row = (RowHandle)table.getDetail().getContents().get(0);
        List inheritedRules = (List)row.getProperty("highlightRules");
        PropertyCommandTest.assertNull((Object)inheritedRules);
        HighlightRuleHandle rule1 = (HighlightRuleHandle)table.getPropertyHandle("highlightRules").getAt(0);
        PropertyCommandTest.assertNotNull((Object)rule1);
        PropertyCommandTest.assertEquals((String)"row[\"Company\"]", (String)rule1.getTestExpression());
        PropertyCommandTest.assertEquals((String)"eq", (String)rule1.getOperator());
        PropertyCommandTest.assertEquals((String)"Eclipse", (String)rule1.getValue1());
        PropertyCommandTest.assertEquals((String)"red", (String)((String)rule1.getColor().getValue()));
        rule1.getColor().setValue((Object)"blue");
        PropertyCommandTest.assertEquals((String)"blue", (String)rule1.getMember("color").getStringValue());
        PropertyCommandTest.assertEquals((String)"blue", (String)table.getPropertyHandle("highlightRules").getAt(0).getMember("color").getStringValue());
        LabelHandle label1 = factory.newLabel("label1");
        LabelHandle label2 = factory.newLabel("label2");
        this.designHandle.getComponents().add((DesignElementHandle)label1);
        this.designHandle.getBody().add((DesignElementHandle)label2);
        label2.setExtendsName("label1");
        Action action = StructureFactory.createAction();
        ActionHandle actionHandle = label1.setAction(action);
        actionHandle.setLinkType("bookmark-link");
        actionHandle.setTargetBookmark("BK1");
        ActionHandle inheritedAction = label2.getActionHandle();
        PropertyCommandTest.assertNotNull((Object)inheritedAction);
        PropertyCommandTest.assertEquals((String)"BK1", (String)inheritedAction.getTargetBookmark());
        inheritedAction.setLinkType("hyperlink");
        inheritedAction.setURI("/statistics.html");
        PropertyCommandTest.assertEquals((String)"bookmark-link", (String)label1.getActionHandle().getLinkType());
        PropertyCommandTest.assertEquals((String)"BK1", (String)label1.getActionHandle().getTargetBookmark());
    }

    public void testSetMemberForSortAndFilter() throws SemanticException {
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle tableHandle = factory.newTableItem("newTable", 3);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        SortKey sortKey = StructureFactory.createSortKey();
        sortKey.setKey("Key");
        PropertyHandle propertyHandle = tableHandle.getPropertyHandle("sort");
        SortKeyHandle sortHandle = (SortKeyHandle)propertyHandle.addItem((IStructure)sortKey);
        try {
            MemberHandle memberHandle = sortHandle.getMember("key");
            memberHandle.setStringValue("");
            PropertyCommandTest.fail((String)"throw out semanticException");
        }
        catch (SemanticException e) {
            PropertyCommandTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
        PropertyCommandTest.assertEquals((String)"Key", (String)sortHandle.getKey());
        try {
            sortHandle.setKey("");
            PropertyCommandTest.fail((String)"throw out semanticException");
        }
        catch (SemanticException e) {
            PropertyCommandTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
        PropertyCommandTest.assertEquals((String)"Key", (String)sortHandle.getKey());
        FilterCondition filterCondition = StructureFactory.createFilterCond();
        filterCondition.setExpr("row[\"column\"]");
        filterCondition.setOperator("between");
        filterCondition.setValue1("1");
        filterCondition.setValue2("100");
        propertyHandle = tableHandle.getPropertyHandle("filter");
        FilterConditionHandle conditionHandle = (FilterConditionHandle)propertyHandle.addItem((IStructure)filterCondition);
        try {
            MemberHandle memberHandle = conditionHandle.getMember("expr");
            memberHandle.setStringValue("");
            PropertyCommandTest.fail((String)"throw out semanticException");
        }
        catch (SemanticException e) {
            PropertyCommandTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
        PropertyCommandTest.assertEquals((String)"row[\"column\"]", (String)conditionHandle.getExpr());
        try {
            conditionHandle.setExpr("");
            PropertyCommandTest.fail((String)"throw out semanticException");
        }
        catch (SemanticException e) {
            PropertyCommandTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
        PropertyCommandTest.assertEquals((String)"row[\"column\"]", (String)conditionHandle.getExpr());
    }

    public void testRemoveAllItems() throws SemanticException {
        SharedStyleHandle shareHandle = this.designHandle.findStyle("Style2");
        PropertyHandle propHandle = shareHandle.getPropertyHandle("mapRules");
        PropertyCommandTest.assertNotNull((Object)propHandle);
        ComplexPropertyCommand command = new ComplexPropertyCommand((Module)this.design, shareHandle.getElement());
        command.removeAllItems(propHandle.getContext());
        PropertyCommandTest.assertNull((Object)shareHandle.getProperty("mapRules"));
        MemberHandle memberHandle = this.actionHandle.getMember("search");
        PropertyCommandTest.assertEquals((int)2, (int)memberHandle.getListValue().size());
        command = new ComplexPropertyCommand((Module)this.design, this.imageHandle.getElement());
        command.removeAllItems(memberHandle.getContext());
        PropertyCommandTest.assertNull((Object)memberHandle.getListValue());
    }

    public void testRemoveItemWithPositino() throws SemanticException {
        SharedStyleHandle shareHandle = this.designHandle.findStyle("Style2");
        PropertyHandle propHandle = shareHandle.getPropertyHandle("mapRules");
        PropertyCommandTest.assertNotNull((Object)propHandle);
        ArrayList list = propHandle.getListValue();
        PropertyCommandTest.assertEquals((int)2, (int)list.size());
        PropertyCommandTest.assertEquals((String)"Open", (String)((MapRule)list.get(0)).getDisplay());
        PropertyCommandTest.assertEquals((String)"Design", (String)((MapRule)list.get(1)).getDisplay());
        ComplexPropertyCommand command = new ComplexPropertyCommand((Module)this.design, shareHandle.getElement());
        command.removeItem(new StructureContext(shareHandle.getElement(), (ElementPropertyDefn)propHandle.getPropertyDefn(), null), 1);
        list = propHandle.getListValue();
        PropertyCommandTest.assertEquals((int)1, (int)list.size());
        PropertyCommandTest.assertEquals((String)"Open", (String)((MapRule)list.get(0)).getDisplay());
        command = new ComplexPropertyCommand((Module)this.design, shareHandle.getElement());
        command.removeItem(new StructureContext(shareHandle.getElement(), (ElementPropertyDefn)propHandle.getPropertyDefn(), null), 0);
        list = propHandle.getListValue();
        PropertyCommandTest.assertNull((Object)list);
        try {
            command = new ComplexPropertyCommand((Module)this.design, shareHandle.getElement());
            command.removeItem(new StructureContext(shareHandle.getElement(), (ElementPropertyDefn)propHandle.getPropertyDefn(), null), 4);
            PropertyCommandTest.fail();
        }
        catch (PropertyValueException e) {
            PropertyCommandTest.assertEquals((String)"Error.PropertyValueException.ITEM_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testRemoveItemWithItem() throws PropertyValueException {
        SharedStyleHandle shareHandle = this.designHandle.findStyle("Style2");
        PropertyHandle propHandle = shareHandle.getPropertyHandle("mapRules");
        PropertyCommandTest.assertNotNull((Object)propHandle);
        ArrayList list = propHandle.getListValue();
        PropertyCommandTest.assertEquals((int)2, (int)list.size());
        PropertyCommandTest.assertEquals((String)"Open", (String)((MapRule)list.get(0)).getDisplay());
        PropertyCommandTest.assertEquals((String)"Design", (String)((MapRule)list.get(1)).getDisplay());
        ComplexPropertyCommand command = new ComplexPropertyCommand((Module)this.design, shareHandle.getElement());
        command.removeItem(new StructureContext(shareHandle.getElement(), (ElementPropertyDefn)propHandle.getPropertyDefn(), null), (IStructure)((MapRule)list.get(1)));
        list = propHandle.getListValue();
        PropertyCommandTest.assertEquals((int)1, (int)list.size());
        PropertyCommandTest.assertEquals((String)"Open", (String)((MapRule)list.get(0)).getDisplay());
        command = new ComplexPropertyCommand((Module)this.design, shareHandle.getElement());
        command.removeItem(new StructureContext(shareHandle.getElement(), (ElementPropertyDefn)propHandle.getPropertyDefn(), null), (IStructure)((MapRule)list.get(0)));
        list = propHandle.getListValue();
        PropertyCommandTest.assertNull((Object)list);
        try {
            command = new ComplexPropertyCommand((Module)this.design, shareHandle.getElement());
            command.removeItem(new StructureContext(shareHandle.getElement(), (ElementPropertyDefn)propHandle.getPropertyDefn(), null), (IStructure)new MapRule());
            PropertyCommandTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
    }

    private void AddItemRule(StyleElement style, boolean type) throws SemanticException {
        MapRule rule = new MapRule();
        PropertyDefn propDefn = (PropertyDefn)rule.getDefn().findProperty("display");
        rule.setProperty(propDefn, (Object)"Rule1");
        PropertyHandle propHandle = style.getHandle((Module)this.design).getPropertyHandle("mapRules");
        propHandle.addItem((IStructure)rule);
        List rules = (List)style.getProperty((Module)this.design, "mapRules");
        PropertyCommandTest.assertTrue((rules.size() == this.judgeType(type) ? 1 : 0) != 0);
        this.design.getActivityStack().undo();
        rules = (List)style.getProperty((Module)this.design, "mapRules");
        if (type) {
            PropertyCommandTest.assertTrue((rules.size() == 2 ? 1 : 0) != 0);
        } else {
            PropertyCommandTest.assertNull((Object)rules);
        }
        this.design.getActivityStack().redo();
        rules = (List)style.getProperty((Module)this.design, "mapRules");
        PropertyCommandTest.assertTrue((rules.size() == this.judgeType(type) ? 1 : 0) != 0);
    }

    private int judgeType(boolean type) {
        if (type) {
            return 3;
        }
        return 1;
    }

    public void testReplaceItemOne() throws Exception {
        StyleElement style = this.design.findStyle("Style2");
        MapRule rule = new MapRule();
        PropertyHandle propHandle = style.getHandle((Module)this.design).getPropertyHandle("mapRules");
        PropertyDefn propDefn = (PropertyDefn)rule.getDefn().findProperty("display");
        rule.setProperty(propDefn, (Object)"RuleReplace");
        propHandle.addItem((IStructure)rule);
        this.saveOperate("PropertyCommandTest_golden.xml");
        MapRule ruleNew = new MapRule();
        propDefn = (PropertyDefn)rule.getDefn().findProperty("display");
        ruleNew.setProperty(propDefn, (Object)"NewItem");
        propHandle.replaceItem((IStructure)rule, (IStructure)ruleNew);
        this.saveOperate("PropertyCommandTest_golden_1.xml");
        this.design.getActivityStack().undo();
        this.saveOperate("PropertyCommandTest_golden_2.xml");
        this.design.getActivityStack().redo();
        this.saveOperate("PropertyCommandTest_golden_1.xml");
    }

    public void testReplaceItemTwo() throws Exception {
        SharedStyleHandle styleHandle1 = this.designHandle.findStyle("My-Style");
        SharedStyleHandle styleHandle2 = this.designHandle.findStyle("Style2");
        ComplexPropertyCommand command1 = new ComplexPropertyCommand((Module)this.design, styleHandle1.getElement());
        ComplexPropertyCommand command2 = new ComplexPropertyCommand((Module)this.design, styleHandle2.getElement());
        CommandStack cs = this.designHandle.getCommandStack();
        Iterator maprules1 = styleHandle1.mapRulesIterator();
        Iterator maprules2 = styleHandle2.mapRulesIterator();
        MapRuleHandle rule1 = (MapRuleHandle)maprules1.next();
        MapRuleHandle rule2 = (MapRuleHandle)maprules2.next();
        StructureContext mem1 = styleHandle1.getPropertyHandle("mapRules").getContext();
        StructureContext mem2 = styleHandle2.getPropertyHandle("mapRules").getContext();
        command2.replaceItem(mem2, rule2.getStructure(), rule1.getStructure());
        PropertyHandle propHandle = styleHandle2.getPropertyHandle("mapRules");
        rule2 = (MapRuleHandle)propHandle.getAt(0);
        PropertyCommandTest.assertEquals((String)"Closed", (String)rule2.getDisplay());
        PropertyCommandTest.assertTrue((boolean)cs.canUndo());
        cs.undo();
        rule2 = (MapRuleHandle)propHandle.getAt(0);
        PropertyCommandTest.assertEquals((String)"Open", (String)rule2.getDisplay());
        command1.replaceItem(mem1, rule1.getStructure(), rule2.getStructure());
        propHandle = styleHandle1.getPropertyHandle("mapRules");
        rule1 = (MapRuleHandle)propHandle.getAt(0);
        PropertyCommandTest.assertEquals((String)"Open", (String)rule1.getDisplay());
        try {
            command1.replaceItem(mem1, (IStructure)new CustomColor(), rule2.getStructure());
            PropertyCommandTest.fail();
        }
        catch (PropertyValueException e) {
            PropertyCommandTest.assertEquals((String)"Error.PropertyValueException.ITEM_NOT_FOUND", (String)e.getErrorCode());
        }
        MemberHandle memberHandle = this.actionHandle.getMember("search");
        PropertyCommandTest.assertEquals((String)"searchKey1", (String)((SearchKeyHandle)memberHandle.getAt(0)).getExpression());
        SearchKey key = StructureFactory.createSearchKey();
        key.setExpression("SearchKey3");
        command1 = new ComplexPropertyCommand((Module)this.design, this.imageHandle.getElement());
        command1.replaceItem(memberHandle.getContext(), memberHandle.getAt(0).getStructure(), (IStructure)key);
        PropertyCommandTest.assertEquals((String)"SearchKey3", (String)((SearchKeyHandle)memberHandle.getAt(0)).getExpression());
    }

    private void saveOperate(String compareFile) throws Exception {
        this.save();
        PropertyCommandTest.assertTrue((boolean)this.compareFile(compareFile));
    }

    public void testInsertAndRemoveItem() throws Exception {
        StyleElement style = this.design.findStyle("Style2");
        List rules = (List)style.getProperty((Module)this.design, "mapRules");
        PropertyCommandTest.assertTrue((rules.size() == 2 ? 1 : 0) != 0);
        MapRule rule = new MapRule();
        PropertyDefn propDefn = (PropertyDefn)rule.getDefn().findProperty("display");
        rule.setProperty(propDefn, (Object)"InsertAndRemove");
        PropertyHandle propHandle = style.getHandle((Module)this.design).getPropertyHandle("mapRules");
        propHandle.insertItem((IStructure)rule, rules.size());
        propHandle.addItem(null);
        CustomColor color = new CustomColor();
        try {
            propHandle.insertItem((IStructure)color, rules.size());
            PropertyCommandTest.fail();
        }
        catch (PropertyValueException e) {
            PropertyCommandTest.assertEquals((String)"Error.PropertyValueException.WRONG_ITEM_TYPE", (String)e.getErrorCode());
        }
        this.saveOperate("PropertyCommandTest_golden_7.xml");
        propHandle.removeItem(rules.size() - 1);
        rules = (List)style.getProperty((Module)this.design, "mapRules");
        PropertyCommandTest.assertTrue((rules.size() == 2 ? 1 : 0) != 0);
        this.AddItemRule(style, true);
        style = this.design.findStyle("Style1");
        propHandle = style.getHandle((Module)this.design).getPropertyHandle("mapRules");
        rules = (List)style.getProperty((Module)this.design, "mapRules");
        PropertyCommandTest.assertNull((Object)rules);
        try {
            propHandle.removeItem(0);
            PropertyCommandTest.fail((String)" remove null list should throw out PropertyValueException !");
        }
        catch (Exception e) {
            PropertyCommandTest.assertTrue((boolean)(e instanceof PropertyValueException));
        }
        MemberHandle memberHandle = this.actionHandle.getMember("paramBindings");
        PropertyCommandTest.assertNull((Object)memberHandle.getListValue());
        ParamBinding paramBinding = StructureFactory.createParamBinding();
        paramBinding.setParamName("param1");
        paramBinding.setExpression("expr1");
        ComplexPropertyCommand command = new ComplexPropertyCommand((Module)this.design, this.imageHandle.getElement());
        command.addItem(memberHandle.getContext(), (Object)paramBinding);
        PropertyCommandTest.assertEquals((int)1, (int)memberHandle.getListValue().size());
        memberHandle = this.actionHandle.getMember("search");
        PropertyCommandTest.assertEquals((int)2, (int)memberHandle.getListValue().size());
        command = new ComplexPropertyCommand((Module)this.design, this.imageHandle.getElement());
        command.removeItem(memberHandle.getContext(), 1);
        PropertyCommandTest.assertEquals((int)1, (int)memberHandle.getListValue().size());
        this.saveOperate("PropertyCommandTest_golden_11.xml");
    }

    public void testMoveItem() throws Exception {
        SharedStyleHandle styleHandle = this.designHandle.findStyle("Style2");
        ActivityStack as = this.design.getActivityStack();
        List rules = (List)styleHandle.getProperty("mapRules");
        PropertyCommandTest.assertTrue((rules.size() == 2 ? 1 : 0) != 0);
        PropertyHandle propHandle = styleHandle.getPropertyHandle("mapRules");
        propHandle.moveItem(0, 2);
        this.saveOperate("PropertyCommandTest_golden_9.xml");
        as.undo();
        this.saveOperate("PropertyCommandTest_golden_10.xml");
        as.redo();
        this.saveOperate("PropertyCommandTest_golden_9.xml");
        propHandle.moveItem(0, rules.size());
        this.saveOperate("PropertyCommandTest_golden_10.xml");
        styleHandle = this.designHandle.findStyle("Style1");
        propHandle = styleHandle.getPropertyHandle("mapRules");
        try {
            propHandle.moveItem(0, 6);
            PropertyCommandTest.fail();
        }
        catch (Exception e) {
            PropertyCommandTest.assertTrue((boolean)(e instanceof PropertyValueException));
        }
        styleHandle = this.designHandle.findStyle("My-Style");
        propHandle = styleHandle.getPropertyHandle("mapRules");
        as.startTrans(null);
        rules = (List)styleHandle.getProperty("mapRules");
        propHandle.moveItem(0, 1);
        propHandle.clearValue();
        propHandle.addItem(rules.get(0));
        propHandle.addItem(rules.get(1));
        as.commit();
        as.undo();
        MemberHandle memberHandle = this.actionHandle.getMember("search");
        PropertyCommandTest.assertEquals((int)2, (int)memberHandle.getListValue().size());
        ComplexPropertyCommand command = new ComplexPropertyCommand((Module)this.design, this.imageHandle.getElement());
        command.moveItem(memberHandle.getContext(), 0, 2);
        PropertyCommandTest.assertEquals((String)"searchKey1", (String)((SearchKeyHandle)memberHandle.getAt(1)).getExpression());
        PropertyCommandTest.assertEquals((String)"searchKey2", (String)((SearchKeyHandle)memberHandle.getAt(0)).getExpression());
    }

    public void testRemoveItem() throws SemanticException {
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table = factory.newTableItem("newTable", 3);
        this.designHandle.getBody().add((DesignElementHandle)table);
        HighlightRule highlightRule = StructureFactory.createHighlightRule();
        highlightRule.setTestExpression("row[\"Company\"]");
        highlightRule.setOperator("eq");
        highlightRule.setValue1("Eclipse");
        highlightRule.setProperty("color", (Object)"red");
        table.getPrivateStyle().getPropertyHandle("highlightRules").addItem((IStructure)highlightRule);
        RowHandle row = (RowHandle)table.getDetail().getContents().get(0);
        List inheritedRules = (List)row.getProperty("highlightRules");
        PropertyCommandTest.assertNull((Object)inheritedRules);
        PropertyHandle rulesHandle = row.getPropertyHandle("highlightRules");
        PropertyCommandTest.assertFalse((boolean)rulesHandle.iterator().hasNext());
        PropertyCommandTest.assertEquals((int)1, (int)table.getPropertyHandle("highlightRules").getListValue().size());
        LabelHandle label1 = factory.newLabel("label1");
        LabelHandle label2 = factory.newLabel("label2");
        this.designHandle.getComponents().add((DesignElementHandle)label1);
        this.designHandle.getBody().add((DesignElementHandle)label2);
        label2.setExtendsName("label1");
        Action action = StructureFactory.createAction();
        ActionHandle actionHandle = label1.setAction(action);
        actionHandle.setLinkType("drill-through");
        ParamBinding param = StructureFactory.createParamBinding();
        param.setParamName("p1");
        param.setExpression("A+B");
        actionHandle.addParamBinding(param);
        ActionHandle inheritedAction = label2.getActionHandle();
        PropertyCommandTest.assertNotNull((Object)inheritedAction);
        PropertyCommandTest.assertEquals((String)"drill-through", (String)inheritedAction.getLinkType());
        inheritedAction.getParamBindings().removeItem(0);
        PropertyCommandTest.assertEquals((int)1, (int)actionHandle.getParamBindings().getListValue().size());
    }

    public void testElementTypePropertyCommand() throws Exception {
        TabularCubeHandle cubeHandle = this.designHandle.getElementFactory().newTabularCube(null);
        this.designHandle.getCubes().add((DesignElementHandle)cubeHandle);
        TabularMeasureGroupHandle measureGroupHandle = this.designHandle.getElementFactory().newTabularMeasureGroup("testMeasureGroup");
        cubeHandle.setProperty("measureGroups", (Object)measureGroupHandle);
        PropertyCommandTest.assertEquals((Object)cubeHandle, (Object)measureGroupHandle.getContainer());
        PropertyCommandTest.assertEquals((Object)measureGroupHandle.getElement(), (Object)this.design.getNameHelper().getNameSpace(8).getElement(measureGroupHandle.getName()));
    }

    public void testProeprtyRecordForListValue() throws Exception {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table");
        this.designHandle.getBody().add((DesignElementHandle)table);
        ActivityStack stack = (ActivityStack)this.designHandle.getCommandStack();
        stack.flush();
        ComputedColumn column = new ComputedColumn();
        column.setDataType("string");
        column.setExpression("expression");
        column.setName("name");
        table.addColumnBinding(column, true);
        stack = (ActivityStack)this.designHandle.getCommandStack();
        PropertyCommandTest.assertTrue((boolean)stack.canUndo());
        table.getPropertyHandle("boundDataColumns").clearValue();
        PropertyCommandTest.assertTrue((boolean)stack.canUndo());
        stack.undo();
        PropertyCommandTest.assertTrue((boolean)stack.canUndo());
        PropertyCommandTest.assertTrue((boolean)table.columnBindingsIterator().hasNext());
        stack.undo();
        PropertyCommandTest.assertFalse((boolean)stack.canUndo());
        PropertyCommandTest.assertFalse((boolean)table.columnBindingsIterator().hasNext());
    }

    public void testPropertyEvent() throws Exception {
        StyleElement style = this.design.findStyle("Style2");
        PropertyEvent event = new PropertyEvent((DesignElement)style, "Blue He");
        PropertyCommandTest.assertEquals((String)"Blue He", (String)event.getPropertyName());
        event.setPropertyName("Blue");
        PropertyCommandTest.assertEquals((String)"Blue", (String)event.getPropertyName());
    }

    public void testNotification() throws Exception {
        SharedStyleHandle myStyle = this.designHandle.findStyle("My-Style");
        MyPropertyListener listener = new MyPropertyListener();
        myStyle.addListener((Listener)listener);
        listener.propertyChanged = false;
        myStyle.setProperty("displayName", (Object)"hello");
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
        listener.propertyChanged = false;
        myStyle.setProperty("displayName", null);
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
        listener.propertyChanged = false;
        PropertyHandle mapRulesHandle = myStyle.getPropertyHandle("mapRules");
        StructureHandle mapRuleHandle = mapRulesHandle.getAt(0);
        MemberHandle operatorHandle = mapRuleHandle.getMember("operator");
        operatorHandle.setValue((Object)"between");
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
        listener.propertyChanged = false;
        MapRule newMapRule = new MapRule();
        newMapRule.setProperty("operator", (Object)"like");
        mapRulesHandle.addItem((IStructure)newMapRule);
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
        listener.propertyChanged = false;
        MapRule anotherNewMapRule = new MapRule();
        anotherNewMapRule.setProperty("operator", (Object)"ge");
        mapRulesHandle.replaceItem((IStructure)newMapRule, (IStructure)anotherNewMapRule);
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
        listener.propertyChanged = false;
        mapRulesHandle.moveItem(0, 2);
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
        listener.propertyChanged = false;
        mapRulesHandle.removeItem(0);
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
    }

    public void testVariableElementPropertyNotification() throws Exception {
        this.openDesign("VariableElementPropertyNotificationTest.xml");
        MyPropertyListener listener = new MyPropertyListener();
        this.designHandle.addListener((Listener)listener);
        List list = this.designHandle.getPageVariables();
        VariableElementHandle variableElementHandle = (VariableElementHandle)list.get(0);
        variableElementHandle.setName("test");
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
        listener.propertyChanged = false;
        variableElementHandle = (VariableElementHandle)list.get(1);
        variableElementHandle.setType("report");
        PropertyCommandTest.assertTrue((boolean)listener.propertyChanged);
    }

    public void testBackRefWhenDropStructure() throws Exception {
        this.openDesign("PropertyCommandTest_TOC.xml");
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("label1");
        SharedStyleHandle style = this.designHandle.findStyle("NewStyle");
        Iterator iter1 = style.clientsIterator();
        PropertyCommandTest.assertTrue((boolean)iter1.hasNext());
        TOC toc = StructureFactory.createTOC((String)"test1 toc");
        label1.addTOC(toc);
        iter1 = style.clientsIterator();
        PropertyCommandTest.assertFalse((boolean)iter1.hasNext());
    }

    class MyPropertyListener
    implements Listener {
        boolean propertyChanged = false;

        MyPropertyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.propertyChanged = true;
        }
    }
}

