/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TemplateCommandTest
extends BaseTestCase {
    private DesignElement templateItem = null;
    private DesignElement designElement = null;
    private static final String INPUT_FILE = "TemplateCommandTest.xml";
    private static final String GOLEAN_FILE = "TemplateCommandTest_golden.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getParam();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.templateItem = null;
        this.designElement = null;
    }

    private void getParam() throws Exception {
        this.openDesign(INPUT_FILE);
        List list = this.designHandle.getBody().getContents();
        this.designElement = (DesignElement)((DesignElementHandle)list.get(0)).getElement().clone();
        this.templateItem = (DesignElement)((DesignElementHandle)list.get(1)).getElement().clone();
        this.designHandle.close();
    }

    public void testCheckAdd() throws Exception {
        this.createDesign();
        this.design.getVersionManager().setVersion("3.2.23");
        ContentCommand command = new ContentCommand((Module)this.design, new ContainerContext((DesignElement)this.design, 6));
        command.add(this.designElement);
        command.add(this.templateItem);
        this.save();
        TemplateCommandTest.assertTrue((boolean)this.compareFile(GOLEAN_FILE));
    }

    public void testClearRefTemplateParameterProp() throws Exception {
        this.createDesign();
        LabelHandle label = this.designHandle.getElementFactory().newLabel("aaa");
        this.designHandle.getBody().add((DesignElementHandle)label);
        TemplateElementHandle templateElement = null;
        templateElement = label.createTemplateElement("Def1");
        TemplateCommandTest.assertNotNull((Object)templateElement);
        TemplateParameterDefinition definition = this.design.findTemplateParameterDefinition("NewTemplateParameterDefinition");
        TemplateCommandTest.assertNotNull((Object)definition);
        ((TemplateReportItemHandle)templateElement).transformToReportItem((ReportItemHandle)label);
        templateElement = label.createTemplateElement("Def2");
        TemplateCommandTest.assertNotNull((Object)templateElement);
        definition = this.design.findTemplateParameterDefinition("NewTemplateParameterDefinition");
        TemplateCommandTest.assertNull((Object)definition);
        definition = this.design.findTemplateParameterDefinition("NewTemplateParameterDefinition1");
        TemplateCommandTest.assertNotNull((Object)definition);
        ((TemplateReportItemHandle)templateElement).transformToReportItem((ReportItemHandle)label);
        label.revertToReportItem();
        definition = this.design.findTemplateParameterDefinition("NewTemplateParameterDefinition");
        TemplateCommandTest.assertNull((Object)definition);
        definition = this.design.findTemplateParameterDefinition("NewTemplateParameterDefinition1");
        TemplateCommandTest.assertNull((Object)definition);
    }
}

