/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.core.CoreTestUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignElementCloneTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCloneLabel() throws Exception {
        this.openDesign("DesignElementTest_1.xml");
        Label label = (Label)this.design.findElement("label1");
        DesignElementCloneTest.assertNotNull((Object)label);
        DesignElement element = (DesignElement)label.clone();
        DesignElementCloneTest.assertNotNull((Object)element);
    }

    public void testCloneGrid() throws Exception {
        this.openDesign("DesignElementTest_3.xml");
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("hexingjie");
        DesignElementCloneTest.assertNotNull((Object)gridHandle);
        DesignElementCloneTest.assertEquals((String)"hexingjie", (String)gridHandle.getName());
        GridHandle grid = (GridHandle)gridHandle.copy().getHandle((Module)this.design);
        DesignElementCloneTest.assertNotNull((Object)grid);
        DesignElementCloneTest.assertEquals((String)"hexingjie", (String)grid.getName());
        RowHandle row = (RowHandle)grid.getRows().get(0);
        DesignElementCloneTest.assertEquals((Object)grid, (Object)row.getContainer());
        this.designHandle.rename((DesignElementHandle)grid);
        this.designHandle.getBody().paste((DesignElementHandle)grid);
        this.save();
        DesignElementCloneTest.assertTrue((boolean)this.compareFile("DeisgnElementCloneTest_gridClone_golden.xml"));
    }

    public void testCloneImage() throws Exception {
        this.openDesign("DesignElementCloneTest_ImageClone.xml");
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("Image1");
        DesignElementCloneTest.assertNotNull((Object)imageHandle);
        DesignElementCloneTest.assertEquals((String)"Image1", (String)imageHandle.getName());
        ImageHandle image = (ImageHandle)imageHandle.copy().getHandle((Module)this.design);
        DesignElementCloneTest.assertNotNull((Object)image);
        this.designHandle.rename((DesignElementHandle)image);
        this.designHandle.findMasterPage("My Page").getSlot(0).add((DesignElementHandle)image);
        imageHandle = (ImageHandle)this.designHandle.findElement("Image3");
        DesignElementCloneTest.assertNotNull((Object)imageHandle);
        DesignElementCloneTest.assertEquals((String)"Image3", (String)imageHandle.getName());
        image = (ImageHandle)imageHandle.copy().getHandle((Module)this.design);
        DesignElementCloneTest.assertNotNull((Object)image);
        this.designHandle.rename((DesignElementHandle)image);
        this.designHandle.findMasterPage("My Page").getSlot(0).paste((DesignElementHandle)image);
        this.save();
        DesignElementCloneTest.assertTrue((boolean)this.compareFile("DesignElementCloneTest_ImageClone_golden.xml"));
    }

    public void testCloneExtendedLabel() throws Exception {
        this.openDesign("DesignElementCloneTest.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("Base Label");
        DesignElementCloneTest.assertNotNull((Object)labelHandle);
        DesignElementCloneTest.assertEquals((int)1, (int)labelHandle.getElement().getDerived().size());
        LabelHandle label = (LabelHandle)labelHandle.copy().getHandle((Module)this.design);
        DesignElementCloneTest.assertNotNull((Object)label);
        DesignElementCloneTest.assertEquals((int)0, (int)label.getElement().getDerived().size());
        this.design.makeUniqueName(label.getElement());
        this.designHandle.getComponents().paste((DesignElementHandle)label);
        labelHandle = (LabelHandle)this.designHandle.findElement(label.getName());
        label = (LabelHandle)labelHandle.copy().getHandle((Module)this.design);
        this.design.makeUniqueName(label.getElement());
        this.designHandle.getComponents().paste((DesignElementHandle)label);
    }

    public void testTheReferencesAfterClone() throws Exception {
        DataSetHandle newDataSet;
        this.openDesign("DesignElementCloneTest.xml");
        GraphicMasterPageHandle pageHandle = (GraphicMasterPageHandle)this.designHandle.findMasterPage("My Page");
        DesignElementCloneTest.assertNotNull((Object)pageHandle);
        pageHandle.addListener((Listener)new MyListener("listener1"));
        pageHandle.addListener((Listener)new MyListener("listener2"));
        DesignElementCloneTest.assertEquals((int)2, (int)CoreTestUtil.getListeners((DesignElement)pageHandle.getElement()).size());
        DesignElementCloneTest.assertEquals((Object)this.design, (Object)pageHandle.getContainer());
        GraphicMasterPageHandle masterPage = (GraphicMasterPageHandle)pageHandle.copy().getHandle((Module)this.design);
        DesignElementCloneTest.assertNull((Object)CoreTestUtil.getListeners((DesignElement)masterPage.getElement()));
        DesignElementCloneTest.assertNull((Object)masterPage.getContainer());
        DataSetHandle dataset = this.designHandle.findDataSet("firstDataSet");
        dataset = newDataSet = (DataSetHandle)dataset.copy().getHandle((Module)this.design);
        SessionHandle sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle newDesignHandle = sessionHandle.createDesign();
        newDesignHandle.getDataSets().paste((DesignElementHandle)dataset);
        this.designHandle.checkReport();
        List list = this.designHandle.getErrorList();
        DesignElementCloneTest.assertEquals((int)3, (int)list.size());
        DesignElementCloneTest.assertEquals((String)"Error.SemanticError.INVALID_ELEMENT_REF", (String)((ErrorDetail)list.get(0)).getErrorCode());
        DesignElementCloneTest.assertEquals((String)"Error.SemanticError.INVALID_STRUCTURE_REF", (String)((ErrorDetail)list.get(1)).getErrorCode());
        DesignElementCloneTest.assertEquals((String)"Error.SemanticError.INVALID_STRUCTURE_REF", (String)((ErrorDetail)list.get(2)).getErrorCode());
        DesignElementCloneTest.assertEquals((int)1, (int)this.designHandle.getWarningList().size());
    }

    public void testStyleAfterClone() throws Exception {
        this.openDesign("DesignElementCloneTest.xml");
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        DesignElementCloneTest.assertNotNull((Object)styleHandle);
        DesignElementCloneTest.assertNotNull((Object)CoreTestUtil.getCachedElementDefn((DesignElement)styleHandle.getElement()));
        List client = ((Style)styleHandle.getElement()).getClientList();
        DesignElementCloneTest.assertEquals((int)3, (int)client.size());
        StyleHandle style = (StyleHandle)styleHandle.copy().getHandle((Module)this.design);
        DesignElementCloneTest.assertNotNull((Object)style);
        DesignElementCloneTest.assertEquals((int)0, (int)((Style)style.getElement()).getClientList().size());
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("Base Label");
        DesignElementCloneTest.assertNotNull((Object)labelHandle);
        DesignElementCloneTest.assertNotNull((Object)labelHandle.getStyle());
        LabelHandle page = (LabelHandle)labelHandle.copy().getHandle((Module)this.design);
        this.designHandle.rename((DesignElementHandle)page);
        labelHandle = page;
        this.designHandle.getBody().paste((DesignElementHandle)labelHandle);
        DesignElementCloneTest.assertEquals((Object)styleHandle, (Object)labelHandle.getStyle());
        DesignElementCloneTest.assertEquals((String)"My-Style", (String)page.getStyle().getName());
    }

    public void testCloneTableAndGrid() throws Exception {
        this.openDesign("DesignElementCloneTest_Container.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("my table1");
        DesignElementCloneTest.assertEquals((int)1, (int)tableHandle.getDetail().getCount());
        TableHandle newTable = (TableHandle)tableHandle.copy().getHandle((Module)this.design);
        newTable.setName("new table 1");
        this.designHandle.getSlot(6).paste((DesignElementHandle)newTable);
        tableHandle.dropAndClear();
        TableHandle newTableHandle = newTable;
        DesignElementCloneTest.assertEquals((Object)newTableHandle, (Object)newTableHandle.getDetail().get(0).getContainer());
        DesignElementCloneTest.assertEquals((int)1, (int)newTableHandle.getDetail().getCount());
        GridHandle grid = (GridHandle)this.designHandle.findElement("my grid1");
        GridHandle newGrid = (GridHandle)grid.copy().getHandle((Module)this.design);
        newGrid.setName("new grid 1");
        this.designHandle.rename((DesignElementHandle)newGrid);
        this.designHandle.getSlot(6).paste((DesignElementHandle)newGrid);
        grid.dropAndClear();
        GridHandle newGridHandle = newGrid;
        DesignElementCloneTest.assertEquals((int)2, (int)newGridHandle.getRows().getCount());
        tableHandle = this.designHandle.getElementFactory().newTableItem("table3");
        tableHandle.copy();
    }

    public void testElementId() throws DesignFileException, ContentException, NameException, IOException {
        MetaDataDictionary.getInstance().enableElementID();
        this.openDesign("DesignElementCloneTest.xml");
        StyleHandle myStyle = (StyleHandle)this.designHandle.getStyles().get(0);
        StyleHandle newStyle = (StyleHandle)myStyle.copy().getHandle((Module)this.design);
        DesignElementCloneTest.assertEquals((long)myStyle.getID(), (long)newStyle.getID());
        DesignElementCloneTest.assertEquals((long)4L, (long)newStyle.getID());
        this.designHandle.rename((DesignElementHandle)newStyle);
        this.designHandle.getStyles().paste((DesignElementHandle)newStyle);
        DesignElementCloneTest.assertFalse((newStyle.getID() == myStyle.getID() ? 1 : 0) != 0);
    }

    public void testDesignWithIncludeLibrary() throws Exception {
        this.openDesign("DesignElementCloneTest_Module.xml");
        DesignElementCloneTest.assertNotNull((Object)this.designHandle);
        DesignElementCloneTest.assertNotNull((Object)this.design);
        ReportDesign clonedDesign = (ReportDesign)this.design.clone();
        DesignElementCloneTest.assertNotNull((Object)clonedDesign);
        DesignElementCloneTest.assertNotSame((Object)this.design, (Object)clonedDesign);
        DesignElementCloneTest.assertNotSame((Object)this.design.getActivityStack(), (Object)clonedDesign.getActivityStack());
        DesignElementCloneTest.assertNotNull((Object)clonedDesign.getActivityStack());
        DesignElementCloneTest.assertEquals((int)3, (int)clonedDesign.getAllExceptions().size());
        DesignElementCloneTest.assertNull((Object)clonedDesign.getFatalException());
        ElementRefValue theme = (ElementRefValue)clonedDesign.getProperty((Module)clonedDesign, "theme");
        DesignElementCloneTest.assertNotNull((Object)theme);
        DesignElementCloneTest.assertEquals((String)"theme1", (String)theme.getName());
        DesignElementCloneTest.assertNull((Object)theme.getElement());
        DesignElementCloneTest.assertEquals((Object)clonedDesign, (Object)clonedDesign.getElementByID(1L));
        this.testID((Module)this.design, (Module)clonedDesign, 2L, "GraphicMasterPage");
        this.testID((Module)this.design, (Module)clonedDesign, 3L, "FreeForm");
        this.testID((Module)this.design, (Module)clonedDesign, 4L, "Label");
        DesignElementCloneTest.assertEquals((float)5.0f, (float)this.design.getNextID(), (float)clonedDesign.getNextID());
        this.testNameSpace((Module)this.design, (Module)clonedDesign, 5, "page", "GraphicMasterPage");
        this.testNameSpace((Module)this.design, (Module)clonedDesign, 1, "freeForm", "FreeForm");
        this.testNameSpace((Module)this.design, (Module)clonedDesign, 1, "label", "Label");
        List libraries = clonedDesign.getAllLibraries();
        DesignElementCloneTest.assertEquals((float)1.0f, (float)this.design.getAllLibraries().size(), (float)libraries.size());
        DesignElementCloneTest.assertNotSame(this.design.getAllLibraries().get(0), clonedDesign.getAllLibraries().get(0));
        DesignElementCloneTest.assertEquals((Object)clonedDesign, (Object)((Library)clonedDesign.getAllLibraries().get(0)).getHost());
    }

    public void testElementResolveAfterClone() throws DesignFileException {
        this.openDesign("TestElementResolveAfterClone.xml");
        TableHandle table = (TableHandle)this.designHandle.findElement("myTable");
        DesignElementCloneTest.assertEquals((Object)"red", (Object)table.getProperty("color"));
        DesignElementCloneTest.assertEquals((Object)"red", (Object)table.getFactoryPropertyHandle("color").getValue());
        ReportDesignHandle myDesignHandle = (ReportDesignHandle)this.designHandle.copy().getHandle(null);
        table = (TableHandle)myDesignHandle.findElement("myTable");
        DesignElementCloneTest.assertEquals((Object)"red", (Object)table.getProperty("color"));
        DesignElementCloneTest.assertEquals((Object)"red", (Object)table.getFactoryPropertyHandle("color").getValue());
    }

    private void testID(Module module, Module clonedModule, long id, String elementName) {
        assert (module != null);
        assert (clonedModule != null);
        DesignElementCloneTest.assertNotNull((Object)clonedModule.getElementByID(id));
        DesignElementCloneTest.assertNotSame((Object)module.getElementByID(id), (Object)clonedModule.getElementByID(id));
        DesignElementCloneTest.assertEquals((String)elementName, (String)module.getElementByID(id).getElementName(), (String)clonedModule.getElementByID(id).getElementName());
    }

    private void testNameSpace(Module module, Module clonedModule, int id, String name, String elementName) {
        assert (module != null);
        assert (clonedModule != null);
        NameSpace ns = module.getNameHelper().getNameSpace(id);
        NameSpace clonedNs = clonedModule.getNameHelper().getNameSpace(id);
        DesignElementCloneTest.assertNotSame((Object)ns, (Object)clonedNs);
        DesignElementCloneTest.assertNotNull((Object)ns.getElement(name));
        DesignElementCloneTest.assertNotNull((Object)clonedNs.getElement(name));
        DesignElementCloneTest.assertNotSame((Object)ns.getElement(name), (Object)clonedNs.getElement(name));
        DesignElementCloneTest.assertEquals((String)elementName, (String)ns.getElement(name).getElementName(), (String)clonedNs.getElement(name).getElementName());
    }

    public void testDisplayNameAfterClone() throws Exception {
        String name = "DesignElementCloneTest_DisplayName.xml";
        this.openDesign(name);
        DataSet ds = (DataSet)this.design.findDataSet("Data Set");
        DataSet copyDs = (DataSet)ds.clone();
        DesignElementCloneTest.assertNull((Object)copyDs.getProperty(this.design.getRoot(), "displayName"));
        DesignElementCloneTest.assertNull((Object)copyDs.getProperty(this.design.getRoot(), "displayNameID"));
        DataSource source = (DataSource)this.design.findDataSource("Data Source");
        DataSource copySource = (DataSource)source.clone();
        DesignElementCloneTest.assertNull((Object)copySource.getProperty(this.design.getRoot(), "displayName"));
        DesignElementCloneTest.assertNull((Object)copySource.getProperty(this.design.getRoot(), "displayNameID"));
    }

    public void testExtensionPropertyAfterClone() throws Exception {
        String name = "DesignElementCloneTest_ExtensionProperty.xml";
        this.openDesign(name);
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        List valueList = testTable.getListProperty("filter");
        FilterConditionElementHandle filterElementHandle = (FilterConditionElementHandle)valueList.get(0);
        DesignElement element = filterElementHandle.getElement();
        DesignElementCloneTest.assertNotNull((Object)element.getContainer());
        ExtendedItemHandle copyExtendedItemHandle = (ExtendedItemHandle)testTable.copy().getHandle((Module)this.design);
        List copyvalueList = copyExtendedItemHandle.getListProperty("filter");
        FilterConditionElementHandle copyFilterElementHandle = (FilterConditionElementHandle)copyvalueList.get(0);
        DesignElement copyFilterElement = copyFilterElementHandle.getElement();
        DesignElementCloneTest.assertNotNull((Object)copyFilterElement.getContainer());
    }

    class MyListener
    implements Listener {
        String name = null;
        ContentEvent event = null;

        MyListener(String name) {
            this.name = name;
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        }
    }
}

