/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.olap.TabularLevel;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class NameHelperTest
extends BaseTestCase {
    private static final String FILE_NAME = "NameHelperTest.xml";
    private static final String VARIABLE_ELEMENT_FILE_NAME = "VariableElementNameHelperTest.xml";
    private static final String ADD_ELEMENT_TEST_FILE = "AddVariableElementNameTest.xml";

    public void testParser() throws Exception {
        this.openDesign(FILE_NAME);
        INameHelper nameHelper = this.design.getNameHelper();
        Cube cube = (Cube)nameHelper.getNameSpace(8).getElement("testCube");
        NameHelperTest.assertNotNull((Object)cube);
        Dimension dimension = (Dimension)nameHelper.getNameSpace(10).getElement("testDimension");
        NameHelperTest.assertNotNull((Object)dimension);
        Level level = (Level)dimension.getNameHelper().getNameSpace(0).getElement("testLevel");
        NameHelperTest.assertNotNull((Object)level);
        NameHelperTest.assertNull((Object)nameHelper.getNameSpace(8).getElement(level.getName()));
        NameHelperTest.assertEquals((int)2, (int)dimension.getNameHelper().getNameSpace(0).getCount());
    }

    public void testMakeUniqueName() throws Exception {
        this.openDesign(FILE_NAME);
        Dimension dimension = this.design.findDimension("testDimension");
        TabularLevel level = new TabularLevel(null);
        dimension.makeUniqueName((DesignElement)level);
        NameHelperTest.assertNotNull((Object)level.getName());
        level = new TabularLevel("testLevel");
        dimension.makeUniqueName((DesignElement)level);
        NameHelperTest.assertEquals((String)"testLevel1", (String)level.getName());
        level = new TabularLevel(null);
        this.design.makeUniqueName((DesignElement)level);
        NameHelperTest.assertNull((Object)level.getName());
        DesignElement hierarchy = this.design.findOLAPElement("testHierarchy");
        level = new TabularLevel(null);
        hierarchy.add((Module)this.design, (DesignElement)level, "levels");
        this.design.makeUniqueName((DesignElement)level);
        NameHelperTest.assertNotNull((Object)level.getName());
        level = new TabularLevel(null);
        hierarchy.add((Module)this.design, (DesignElement)level, "levels");
        NameExecutor executor = new NameExecutor((Module)this.design, (DesignElement)level);
        NameHelperTest.assertTrue((boolean)executor.hasNamespace());
        String name = executor.getUniqueName("testLevel");
        NameHelperTest.assertEquals((String)"testLevel2", (String)name);
        level.setName(name);
        NameHelperTest.assertEquals((String)name, (String)executor.getUniqueName("NewTestLevel"));
    }

    public void testResolve() throws Exception {
        this.openDesign(FILE_NAME);
        String propName = "level";
        DesignElementHandle testExtended = this.designHandle.findElement("testTable");
        ElementRefValue refValue = (ElementRefValue)testExtended.getElement().getProperty((Module)this.design, propName);
        NameHelperTest.assertTrue((boolean)refValue.isResolved());
        NameHelperTest.assertEquals((Object)refValue, (Object)this.design.getNameHelper().resolve(testExtended.getElement(), refValue.getName(), (PropertyDefn)testExtended.getPropertyDefn(propName), null));
        Dimension dimension = this.design.findDimension("testDimension");
        NameHelperTest.assertEquals((Object)refValue, (Object)dimension.getNameHelper().resolve(testExtended.getElement(), refValue.getName(), (PropertyDefn)testExtended.getPropertyDefn(propName), null));
    }

    public void testClear() throws Exception {
        this.openDesign(FILE_NAME);
        ElementFactory factory = this.designHandle.getElementFactory();
        ActivityStack stack = this.design.getActivityStack();
        String labelName = "labelName";
        String paramName = "paramName";
        LabelHandle labelHandle = factory.newLabel(labelName);
        stack.startTrans(null);
        ScalarParameterHandle paramHandle = factory.newScalarParameter(paramName);
        paramHandle.setHelpText("helpTest");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        stack.commit();
        labelHandle = factory.newLabel(labelName);
        NameHelperTest.assertEquals((String)(String.valueOf(labelName) + "1"), (String)labelHandle.getName());
        paramHandle = factory.newScalarParameter(paramName);
        NameHelperTest.assertEquals((String)paramName, (String)paramHandle.getName());
    }

    public void testMakeUniqueNameOnVariableElement() throws Exception {
        this.openDesign(VARIABLE_ELEMENT_FILE_NAME);
        ElementFactory factory = this.designHandle.getElementFactory();
        VariableElementHandle handle = factory.newVariableElement(null);
        this.design.makeUniqueName(handle.getElement());
        NameHelperTest.assertEquals((String)"NewVariableElement", (String)handle.getName());
        NameHelperTest.assertEquals((String)"NewVariableElement", (String)handle.getVariableName());
        handle = factory.newVariableElement("testVariable");
        this.design.makeUniqueName(handle.getElement());
        NameHelperTest.assertEquals((String)"testVariable1", (String)handle.getName());
        NameHelperTest.assertEquals((String)"testVariable1", (String)handle.getVariableName());
    }

    public void testAddVariableElementName() throws Exception {
        this.openDesign(ADD_ELEMENT_TEST_FILE);
        ElementFactory factory = this.designHandle.getElementFactory();
        VariableElementHandle handle = factory.newVariableElement(null);
        handle.setName("testVariable");
        try {
            this.designHandle.add("pageVariables", (DesignElementHandle)handle);
            NameHelperTest.fail();
        }
        catch (NameException e) {
            NameHelperTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
        handle = this.designHandle.getPageVariable("testVariable1");
        try {
            handle.setName("testVariable");
            NameHelperTest.fail();
        }
        catch (NameException e) {
            NameHelperTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
        handle = factory.newVariableElement(null);
        handle.setName("testExtendedItemVariable");
        DesignElementHandle extendedItem = this.designHandle.findElement("action1");
        extendedItem.add("variables", (DesignElementHandle)handle);
        NameHelperTest.assertEquals((String)"testExtendedItemVariable", (String)handle.getName());
        NameHelperTest.assertEquals((String)"testExtendedItemVariable", (String)handle.getVariableName());
        List list = extendedItem.getListProperty("variables");
        NameHelperTest.assertEquals((int)3, (int)list.size());
        handle = (VariableElementHandle)list.get(1);
        NameHelperTest.assertEquals((String)"testExtendedItemVariable1", (String)handle.getName());
        handle.setName("testExtendedItemVariable");
        NameHelperTest.assertEquals((String)"testExtendedItemVariable", (String)handle.getName());
        NameHelperTest.assertEquals((String)"testExtendedItemVariable", (String)handle.getVariableName());
        handle.setName("testVariable");
        NameHelperTest.assertEquals((String)"testVariable", (String)handle.getName());
        NameHelperTest.assertEquals((String)"testVariable", (String)handle.getVariableName());
    }

    public void testDeleteVariableElement() throws Exception {
        this.openDesign(ADD_ELEMENT_TEST_FILE);
        VariableElementHandle handle = this.designHandle.getPageVariable("testVariable");
        handle.drop();
        handle = this.designHandle.getPageVariable("testVariable");
        NameHelperTest.assertNull((Object)handle);
    }
}

